/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.projectView.solutionExplorer;

import com.intellij.ide.SelectInTarget;
import com.intellij.ide.dnd.DnDManager;
import com.intellij.ide.dnd.DnDSource;
import com.intellij.ide.dnd.DnDTarget;
import com.intellij.ide.projectView.BaseProjectTreeBuilder;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.AbstractProjectViewPSIPane;
import com.intellij.ide.projectView.impl.ProjectAbstractTreeStructureBase;
import com.intellij.ide.projectView.impl.ProjectTreeBuilder;
import com.intellij.ide.projectView.impl.ProjectTreeStructure;
import com.intellij.ide.projectView.impl.ProjectViewTree;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.AbstractTreeUpdater;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AsyncResult;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.stripe.ErrorStripe;
import com.intellij.util.OpenSourceUtil;
import com.jetbrains.resharper.projectView.ProjectModelViewHost;
import com.jetbrains.resharper.projectView.ideaInterop.RiderProjectOpenProcessor;
import com.jetbrains.resharper.projectView.moveProviders.Impl.CutCopyPasteBuffer;
import com.jetbrains.resharper.projectView.moveProviders.RiderCopyProvider;
import com.jetbrains.resharper.projectView.moveProviders.RiderCutProvider;
import com.jetbrains.resharper.projectView.moveProviders.RiderDeleteProvider;
import com.jetbrains.resharper.projectView.moveProviders.RiderDragSource;
import com.jetbrains.resharper.projectView.moveProviders.RiderDropTarget;
import com.jetbrains.resharper.projectView.moveProviders.RiderPasteProvider;
import com.jetbrains.resharper.projectView.nodes.ProjectModelNode;
import com.jetbrains.resharper.projectView.nodes.ProjectModelNodeExtensionKt;
import com.jetbrains.resharper.projectView.solutionExplorer.ISolutionExplorerNode;
import com.jetbrains.resharper.projectView.solutionExplorer.SolutionExplorerContextMenu;
import com.jetbrains.resharper.projectView.solutionExplorer.SolutionExplorerExtensionsKt;
import com.jetbrains.resharper.projectView.solutionExplorer.SolutionExplorerNodeBase;
import com.jetbrains.resharper.projectView.solutionExplorer.SolutionExplorerNodeRider;
import com.jetbrains.resharper.projectView.solutionExplorer.SolutionExplorerSelectInTarget;
import com.jetbrains.resharper.projectView.solutionExplorer.SolutionExplorerSettings;
import com.jetbrains.resharper.util.idea.ApplicationKt;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 G2\u00020\u0001:\u0005GHIJKB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\u0012\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0014J\b\u0010!\u001a\u00020\"H\u0016J\n\u0010#\u001a\u0004\u0018\u00010$H\u0016J\n\u0010%\u001a\u0004\u0018\u00010&H\u0014J\u0014\u0010'\u001a\u0004\u0018\u00010(2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0014J\u0014\u0010)\u001a\u0004\u0018\u00010*2\b\u0010+\u001a\u0004\u0018\u00010,H\u0014J\b\u0010-\u001a\u00020\u001aH\u0014J\n\u0010.\u001a\u0004\u0018\u00010/H\u0016J\b\u00100\u001a\u000201H\u0016J\u0015\u00102\u001a\n\u0012\u0006\b\u0001\u0012\u00020403H\u0016\u00a2\u0006\u0002\u00105J\u001c\u00106\u001a\u0004\u0018\u0001072\b\u00108\u001a\u0004\u0018\u0001092\u0006\u0010:\u001a\u00020\u0006H\u0014J\n\u0010;\u001a\u0004\u0018\u000101H\u0016J\b\u0010<\u001a\u00020=H\u0016J\u0010\u0010>\u001a\u00020\u001a2\u0006\u0010?\u001a\u00020@H\u0016J\u0011\u0010A\u001a\b\u0012\u0004\u0012\u00020B03\u00a2\u0006\u0002\u0010CJ\b\u0010D\u001a\u00020\u0006H\u0016J\b\u0010E\u001a\u00020\u0006H\u0016J\u0010\u0010F\u001a\u00020\u001a2\u0006\u0010?\u001a\u00020@H\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\b\"\u0004\b\u0013\u0010\nR\u001a\u0010\u0014\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\b\"\u0004\b\u0016\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006L"}, d2={"Lcom/jetbrains/resharper/projectView/solutionExplorer/SolutionExplorerViewPane;", "Lcom/intellij/ide/projectView/impl/AbstractProjectViewPSIPane;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "myDiagnosticMode", "", "getMyDiagnosticMode", "()Z", "setMyDiagnosticMode", "(Z)V", "myDndManager", "Lcom/intellij/ide/dnd/DnDManager;", "myDragSource", "Lcom/intellij/ide/dnd/DnDSource;", "myDropTarget", "Lcom/intellij/ide/dnd/DnDTarget;", "myShowAllItems", "getMyShowAllItems", "setMyShowAllItems", "myShowFileSystem", "getMyShowFileSystem", "setMyShowFileSystem", "getProject", "()Lcom/intellij/openapi/project/Project;", "addToolbarActions", "", "actionGroup", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "createBuilder", "Lcom/intellij/ide/projectView/BaseProjectTreeBuilder;", "treeModel", "Ljavax/swing/tree/DefaultTreeModel;", "createComponent", "Ljavax/swing/JComponent;", "createSelectInTarget", "Lcom/intellij/ide/SelectInTarget;", "createStructure", "Lcom/intellij/ide/projectView/impl/ProjectAbstractTreeStructureBase;", "createTree", "Lcom/intellij/ide/projectView/impl/ProjectViewTree;", "createTreeUpdater", "Lcom/intellij/ide/util/treeView/AbstractTreeUpdater;", "treeBuilder", "Lcom/intellij/ide/util/treeView/AbstractTreeBuilder;", "enableDnD", "getIcon", "Ljavax/swing/Icon;", "getId", "", "getSelectedDirectories", "", "Lcom/intellij/psi/PsiDirectory;", "()[Lcom/intellij/psi/PsiDirectory;", "getStripe", "Lcom/intellij/ui/stripe/ErrorStripe;", "data", "", "expanded", "getTitle", "getWeight", "", "readExternal", "element", "Lorg/jdom/Element;", "selectedNodes", "Lcom/jetbrains/resharper/projectView/solutionExplorer/ISolutionExplorerNode;", "()[Lcom/jetbrains/resharper/projectView/solutionExplorer/ISolutionExplorerNode;", "supportsFoldersAlwaysOnTop", "supportsSortByType", "writeExternal", "Companion", "DiagnosticModeAction", "ProjectViewPaneTreeStructure", "ShowAllItemsAction", "ShowFileSystemAction", "rider"})
public final class SolutionExplorerViewPane
extends AbstractProjectViewPSIPane {
    private boolean myShowFileSystem;
    private boolean myShowAllItems;
    private boolean myDiagnosticMode;
    private DnDTarget myDropTarget;
    private DnDSource myDragSource;
    private DnDManager myDndManager;
    @NotNull
    private final Project project;
    private static final Logger logger;
    @NotNull
    private static final String ID = "SolutionExplorer";
    @NotNull
    private static final String Title = "Solution Explorer";
    @NotNull
    private static final Icon Icon;
    @NotNull
    private static final String SHOW_FILE_SYSTEM_OPTION = "show-file-system";
    @NotNull
    private static final String SHOW_ALL_ITEMS_OPTION = "show-all-items";
    private static boolean ShowFileSystemDefault;
    private static boolean ShowAllItemsDefault;
    private static boolean DiagnosticModeDefault;
    private static final DataKey<SolutionExplorerViewPane> DATA_KEY;
    private static final DataKey<ProjectModelNode> PROJECT_MODEL_NODE_KEY;
    public static final Companion Companion;

    public final boolean getMyShowFileSystem() {
        return this.myShowFileSystem;
    }

    public final void setMyShowFileSystem(boolean bl) {
        this.myShowFileSystem = bl;
    }

    public final boolean getMyShowAllItems() {
        return this.myShowAllItems;
    }

    public final void setMyShowAllItems(boolean bl) {
        this.myShowAllItems = bl;
    }

    public final boolean getMyDiagnosticMode() {
        return this.myDiagnosticMode;
    }

    public final void setMyDiagnosticMode(boolean bl) {
        this.myDiagnosticMode = bl;
    }

    @Override
    @NotNull
    protected BaseProjectTreeBuilder createBuilder(@Nullable DefaultTreeModel treeModel) {
        JTree jTree = (JTree)((Object)this.myTree);
        DefaultTreeModel defaultTreeModel = treeModel;
        if (defaultTreeModel == null) {
            Intrinsics.throwNpe();
        }
        AbstractTreeStructure abstractTreeStructure = this.myTreeStructure;
        if (abstractTreeStructure == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.ide.projectView.impl.ProjectAbstractTreeStructureBase");
        }
        return new ProjectTreeBuilder(this, treeModel, this.myProject, jTree, defaultTreeModel, null, (ProjectAbstractTreeStructureBase)abstractTreeStructure){
            final /* synthetic */ SolutionExplorerViewPane this$0;
            final /* synthetic */ DefaultTreeModel $treeModel;

            @Nullable
            protected AbstractTreeUpdater createUpdater() {
                return this.this$0.createTreeUpdater(this);
            }

            @NotNull
            public AsyncResult<Object> revalidateElement(@Nullable Object element) {
                ISolutionExplorerNode solutionExplorerNode;
                Object object = element;
                if (!(object instanceof ISolutionExplorerNode)) {
                    object = null;
                }
                if ((solutionExplorerNode = (ISolutionExplorerNode)object) != null && !solutionExplorerNode.isValid()) {
                    AsyncResult result2 = new AsyncResult();
                    result2.setDone();
                    return result2;
                }
                AsyncResult<Object> asyncResult = super.revalidateElement(element);
                Intrinsics.checkExpressionValueIsNotNull(asyncResult, (String)"super.revalidateElement(element)");
                return asyncResult;
            }

            protected boolean canExpandPathTo(@NotNull AbstractTreeNode<?> root, @Nullable Object element) {
                SolutionExplorerNodeRider solutionExplorerNode;
                Intrinsics.checkParameterIsNotNull(root, (String)"root");
                AbstractTreeNode<?> abstractTreeNode = root;
                if (!(abstractTreeNode instanceof SolutionExplorerNodeRider)) {
                    abstractTreeNode = null;
                }
                if ((solutionExplorerNode = (SolutionExplorerNodeRider)abstractTreeNode) != null) {
                    return !solutionExplorerNode.getNode().expandApplicable();
                }
                return super.canExpandPathTo(root, element);
            }
            {
                this.this$0 = $outer;
                this.$treeModel = $captured_local_variable$1;
                super($super_call_param$2, $super_call_param$3, $super_call_param$4, $super_call_param$5, $super_call_param$6);
            }
        };
    }

    @Override
    @Nullable
    protected ProjectAbstractTreeStructureBase createStructure() {
        return new ProjectViewPaneTreeStructure(this.project);
    }

    @Override
    @Nullable
    protected AbstractTreeUpdater createTreeUpdater(@Nullable AbstractTreeBuilder treeBuilder) {
        if (treeBuilder == null) {
            return null;
        }
        return new AbstractTreeUpdater(treeBuilder);
    }

    @Override
    public void readExternal(@NotNull Element element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        super.readExternal(element);
        String showFileSystemOption = JDOMExternalizerUtil.readField((Element)element, (String)Companion.getSHOW_FILE_SYSTEM_OPTION());
        this.myShowFileSystem = showFileSystemOption == null || Boolean.parseBoolean(showFileSystemOption);
        String showAllItemsOption = JDOMExternalizerUtil.readField((Element)element, (String)Companion.getSHOW_ALL_ITEMS_OPTION());
        this.myShowAllItems = showAllItemsOption == null || Boolean.parseBoolean(showAllItemsOption);
    }

    @Override
    public void writeExternal(@NotNull Element element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        super.writeExternal(element);
        if (!this.myShowFileSystem) {
            JDOMExternalizerUtil.writeField((Element)element, (String)Companion.getSHOW_FILE_SYSTEM_OPTION(), (String)String.valueOf(false));
        }
        if (!this.myShowAllItems) {
            JDOMExternalizerUtil.writeField((Element)element, (String)Companion.getSHOW_ALL_ITEMS_OPTION(), (String)String.valueOf(false));
        }
    }

    @Override
    @NotNull
    public JComponent createComponent() {
        JComponent result2 = super.createComponent();
        for (MouseListener l2 : ArraysKt.toList((Object[])this.myTree.getMouseListeners())) {
            if (!(l2 instanceof PopupHandler)) continue;
            this.myTree.removeMouseListener(l2);
        }
        this.myTree.addMouseListener((MouseListener)((Object)new SolutionExplorerContextMenu()));
        JComponent jComponent = result2;
        Intrinsics.checkExpressionValueIsNotNull((Object)jComponent, (String)"result");
        return jComponent;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public PsiDirectory[] getSelectedDirectories() {
        void $receiver$iv$iv;
        VirtualFile virtualFile;
        Collection collection;
        ISolutionExplorerNode it;
        Object $receiver$iv$iv2;
        Object $receiver$iv = this.selectedNodes();
        Object[] objectArray = $receiver$iv;
        Iterable destination$iv$iv = new ArrayList();
        for (int i2 = 0; i2 < ((void)$receiver$iv$iv2).length; ++i2) {
            void element$iv$iv = $receiver$iv$iv2[i2];
            it = (ISolutionExplorerNode)element$iv$iv;
            if (!(!(it instanceof SolutionExplorerNodeRider) || ProjectModelNodeExtensionKt.isSolutionFolder(((SolutionExplorerNodeRider)it).getNode()) || ProjectModelNodeExtensionKt.isProject(((SolutionExplorerNodeRider)it).getNode()) || ProjectModelNodeExtensionKt.isProjectFolder(((SolutionExplorerNodeRider)it).getNode()) || ProjectModelNodeExtensionKt.isProjectFile(((SolutionExplorerNodeRider)it).getNode()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv2 = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        Iterator iterator2 = $receiver$iv$iv2.iterator();
        while (iterator2.hasNext()) {
            Object item$iv$iv = iterator2.next();
            it = (ISolutionExplorerNode)item$iv$iv;
            collection = destination$iv$iv;
            virtualFile = it.getVirtualFile();
            collection.add(virtualFile);
        }
        List virtualFiles = CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv));
        if (virtualFiles.isEmpty()) {
            PsiDirectory[] elements$iv = new PsiDirectory[]{};
            return (PsiDirectory[])((Object[])elements$iv);
        }
        PsiManager psiManager = PsiManager.getInstance((Project)this.project);
        Iterable $receiver$iv2 = virtualFiles;
        destination$iv$iv = $receiver$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it2;
            VirtualFile $i$a$2$map = (VirtualFile)item$iv$iv;
            collection = destination$iv$iv2;
            virtualFile = it2.isDirectory() ? psiManager.findDirectory((VirtualFile)it2) : psiManager.findDirectory(it2.getParent());
            collection.add(virtualFile);
        }
        $receiver$iv2 = CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv2));
        Iterable iterable = $receiver$iv2;
        if (iterable == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Collection thisCollection$iv = (Collection)iterable;
        PsiDirectory[] psiDirectoryArray = thisCollection$iv.toArray(new PsiDirectory[thisCollection$iv.size()]);
        if (psiDirectoryArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return (PsiDirectory[])((Object[])psiDirectoryArray);
    }

    @Override
    @Nullable
    protected ProjectViewTree createTree(@Nullable DefaultTreeModel treeModel) {
        ProjectViewTree tree2 = new ProjectViewTree(this, treeModel, this.myProject, treeModel){
            final /* synthetic */ SolutionExplorerViewPane this$0;
            final /* synthetic */ DefaultTreeModel $treeModel;

            @NotNull
            public String toString() {
                return this.this$0.getTitle() + " " + super.toString();
            }

            @Nullable
            public Color getFileColorFor(@Nullable Object element) {
                Object object = element;
                if (!(object instanceof ISolutionExplorerNode)) {
                    object = null;
                }
                ISolutionExplorerNode iSolutionExplorerNode = (ISolutionExplorerNode)object;
                if (iSolutionExplorerNode == null) {
                    return null;
                }
                ISolutionExplorerNode node = iSolutionExplorerNode;
                return node.getBackgroundColor();
            }

            public void setFont(@NotNull Font font) {
                Intrinsics.checkParameterIsNotNull((Object)font, (String)"font");
                Font resultFont = Registry.is((String)"bigger.font.in.project.view") ? font.deriveFont((float)font.getSize() + 1.0f) : font;
                super.setFont(resultFont);
            }

            @NotNull
            public DefaultMutableTreeNode getSelectedNode() {
                DefaultMutableTreeNode defaultMutableTreeNode = this.this$0.getSelectedNode();
                Intrinsics.checkExpressionValueIsNotNull((Object)defaultMutableTreeNode, (String)"this@SolutionExplorerViewPane.selectedNode");
                return defaultMutableTreeNode;
            }
            {
                this.this$0 = $outer;
                this.$treeModel = $captured_local_variable$1;
                super($super_call_param$2, $super_call_param$3);
            }
        };
        DumbAwareAction escapeHandler2 = new DumbAwareAction(this){
            final /* synthetic */ SolutionExplorerViewPane this$0;

            public void actionPerformed(@Nullable AnActionEvent e2) {
                CutCopyPasteBuffer.INSTANCE.clear();
                this.this$0.updateFromRoot(false);
            }

            public void update(@Nullable AnActionEvent e2) {
                block0: {
                    AnActionEvent anActionEvent = e2;
                    if (anActionEvent == null || (anActionEvent = anActionEvent.getPresentation()) == null) break block0;
                    anActionEvent.setEnabled(CutCopyPasteBuffer.INSTANCE.getCachedBufferedAction() != null);
                }
            }
            {
                this.this$0 = $outer;
            }
        };
        escapeHandler2.registerCustomShortcutSet(CommonShortcuts.ESCAPE, (JComponent)((Object)tree2));
        DumbAwareAction enterHandler2 = new DumbAwareAction(){

            public void actionPerformed(@Nullable AnActionEvent e2) {
                AnActionEvent anActionEvent = e2;
                if (anActionEvent == null || (anActionEvent = anActionEvent.getDataContext()) == null) {
                    return;
                }
                AnActionEvent context2 = anActionEvent;
                OpenSourceUtil.openSourcesFrom((DataContext)context2, (boolean)false);
            }

            public void update(@Nullable AnActionEvent e2) {
                block0: {
                    AnActionEvent anActionEvent = e2;
                    if (anActionEvent == null || (anActionEvent = anActionEvent.getPresentation()) == null) break block0;
                    anActionEvent.setEnabled(this.isEnabled(e2));
                }
            }

            private final boolean isEnabled(AnActionEvent e2) {
                AnActionEvent anActionEvent = e2;
                if (anActionEvent == null || (anActionEvent = anActionEvent.getDataContext()) == null) {
                    return false;
                }
                AnActionEvent context2 = anActionEvent;
                ISolutionExplorerNode[] items2 = SolutionExplorerExtensionsKt.getSolutionExplorerNodes((DataContext)context2);
                Object[] objectArray = items2;
                if (objectArray.length != 1) {
                    return false;
                }
                return SolutionExplorerExtensionsKt.alwaysOpenNodeInsteadOfExpand((ISolutionExplorerNode)ArraysKt.single((Object[])items2));
            }
        };
        enterHandler2.registerCustomShortcutSet(CommonShortcuts.ENTER, (JComponent)((Object)tree2));
        return tree2;
    }

    @Override
    public void addToolbarActions(@Nullable DefaultActionGroup actionGroup) {
        block2: {
            DefaultActionGroup defaultActionGroup;
            DefaultActionGroup defaultActionGroup2;
            DefaultActionGroup defaultActionGroup3 = actionGroup;
            if (defaultActionGroup3 != null && (defaultActionGroup3 = defaultActionGroup3.addAction((AnAction)new ShowFileSystemAction())) != null) {
                defaultActionGroup3.setAsSecondary(true);
            }
            if ((defaultActionGroup2 = actionGroup) != null && (defaultActionGroup2 = defaultActionGroup2.addAction((AnAction)new ShowAllItemsAction())) != null) {
                defaultActionGroup2.setAsSecondary(true);
            }
            if (!ApplicationKt.getApplication().isInternal() || (defaultActionGroup = actionGroup) == null || (defaultActionGroup = defaultActionGroup.addAction((AnAction)new DiagnosticModeAction())) == null) break block2;
            defaultActionGroup.setAsSecondary(true);
        }
    }

    @Override
    @Nullable
    protected ErrorStripe getStripe(@Nullable Object data, boolean expanded) {
        if (expanded) {
            SolutionExplorerNodeRider node;
            Object object = data;
            if (!(object instanceof SolutionExplorerNodeRider)) {
                object = null;
            }
            if ((node = (SolutionExplorerNodeRider)object) != null && !node.getNode().getErrorMark()) {
                return null;
            }
        }
        return super.getStripe(data, expanded);
    }

    @Override
    @Nullable
    public Icon getIcon() {
        return Companion.getIcon();
    }

    @Override
    @NotNull
    public String getId() {
        return Companion.getID();
    }

    @Override
    public int getWeight() {
        return 0;
    }

    @Override
    @Nullable
    public String getTitle() {
        return Companion.getTitle();
    }

    @Override
    protected void enableDnD() {
        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
            this.myDropTarget = (DnDTarget)new RiderDropTarget(this);
            this.myDragSource = new RiderDragSource(this);
            DnDManager manager = DnDManager.getInstance();
            manager.registerSource(this.myDragSource, (JComponent)((Object)this.myTree));
            manager.registerTarget(this.myDropTarget, (JComponent)((Object)this.myTree));
            this.myDndManager = manager;
        }
    }

    @Override
    @Nullable
    public SelectInTarget createSelectInTarget() {
        return new SolutionExplorerSelectInTarget(this.project);
    }

    @NotNull
    public final ISolutionExplorerNode[] selectedNodes() {
        Collection $receiver$iv;
        Collection collection = $receiver$iv = (Collection)super.getSelectedNodes(SolutionExplorerNodeBase.class);
        if (collection == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Collection thisCollection$iv = collection;
        ISolutionExplorerNode[] iSolutionExplorerNodeArray = thisCollection$iv.toArray(new ISolutionExplorerNode[thisCollection$iv.size()]);
        if (iSolutionExplorerNodeArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return (ISolutionExplorerNode[])((Object[])iSolutionExplorerNodeArray);
    }

    @Override
    public boolean supportsFoldersAlwaysOnTop() {
        return false;
    }

    @Override
    public boolean supportsSortByType() {
        return false;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public SolutionExplorerViewPane(@NotNull Project project2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        super(project2);
        this.project = project2;
        this.myShowFileSystem = Companion.getShowFileSystemDefault();
        this.myShowAllItems = Companion.getShowAllItemsDefault();
        this.myDiagnosticMode = Companion.getDiagnosticModeDefault();
        VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)new VirtualFileAdapter(){
            @NotNull
            private final ProjectModelViewHost host;

            @NotNull
            public final ProjectModelViewHost getHost() {
                return this.host;
            }

            public void fileCreated(@NotNull VirtualFileEvent event) {
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                this.nodeChanged(event.getFile());
                this.childrenChanged(event.getFile().getParent());
            }

            public void fileDeleted(@NotNull VirtualFileEvent event) {
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                this.nodeChanged(event.getFile());
                this.childrenChanged(event.getFile().getParent());
            }

            public void fileMoved(@NotNull VirtualFileMoveEvent event) {
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                this.nodeChanged(event.getFile());
                this.childrenChanged(event.getNewParent());
                this.childrenChanged(event.getOldParent());
            }

            public void fileCopied(@NotNull VirtualFileCopyEvent event) {
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                this.nodeChanged(event.getFile());
                this.childrenChanged(event.getFile().getParent());
            }

            private final void nodeChanged(VirtualFile virtualFile) {
                if (virtualFile == null) {
                    return;
                }
                ProjectModelNode[] nodes = this.host.getItemsByVirtualFile(virtualFile);
                for (int i2 = 0; i2 < nodes.length; ++i2) {
                    ProjectModelNode node = nodes[i2];
                    node.refresh();
                }
            }

            private final void childrenChanged(VirtualFile virtualFile) {
                if (virtualFile == null) {
                    return;
                }
                AbstractTreeBuilder abstractTreeBuilder = this.getTreeBuilder();
                if (abstractTreeBuilder == null) {
                    return;
                }
                AbstractTreeBuilder treeBuilder = abstractTreeBuilder;
                ProjectModelNode[] nodes = this.host.getItemsByVirtualFile(virtualFile);
                for (int i2 = 0; i2 < nodes.length; ++i2) {
                    ProjectModelNode node = nodes[i2];
                    SolutionExplorerExtensionsKt.updateSolutionExplorerNode(treeBuilder, node, true);
                }
                SolutionExplorerExtensionsKt.updateSolutionExplorerNode(treeBuilder, virtualFile);
            }
            {
                void $receiver$iv;
                ComponentManager componentManager = (ComponentManager)$outer.getProject();
                1 var4_3 = this;
                Object object = $receiver$iv.getComponent(ProjectModelViewHost.class);
                if (object == null) {
                    throw (Throwable)new IllegalStateException("Component " + ProjectModelViewHost.class + " not found in container " + $receiver$iv);
                }
                Object object2 = object;
                var4_3.host = (ProjectModelViewHost)object2;
            }
        }, (Disposable)this);
        SolutionExplorerViewPane.Companion.getLogger().info("SolutionExplorerViewPane was created");
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(SolutionExplorerViewPane.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
        SolutionExplorerViewPane.logger = logger;
        ID = ID;
        Title = Title;
        Icon icon = IconLoader.getIcon((String)"/rider/toolwindows/toolWindowSolutionExplorer.png");
        Intrinsics.checkExpressionValueIsNotNull((Object)icon, (String)"IconLoader.getIcon(\"/rid\u2026dowSolutionExplorer.png\")");
        Icon = icon;
        SHOW_FILE_SYSTEM_OPTION = SHOW_FILE_SYSTEM_OPTION;
        SHOW_ALL_ITEMS_OPTION = SHOW_ALL_ITEMS_OPTION;
        DATA_KEY = DataKey.create((String)" com.jetbrains.resharper.projectView.solutionExplorer.SolutionExplorerViewPane");
        PROJECT_MODEL_NODE_KEY = DataKey.create((String)"ProjectModelNode");
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0014J(\u0010\u000f\u001a\u0004\u0018\u00010\f2\u0012\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\"\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0012\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\u0011H\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0018H\u0016J\b\u0010\u001a\u001a\u00020\u0018H\u0016R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/resharper/projectView/solutionExplorer/SolutionExplorerViewPane$ProjectViewPaneTreeStructure;", "Lcom/intellij/ide/projectView/impl/ProjectTreeStructure;", "Lcom/jetbrains/resharper/projectView/solutionExplorer/SolutionExplorerSettings;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/jetbrains/resharper/projectView/solutionExplorer/SolutionExplorerViewPane;Lcom/intellij/openapi/project/Project;)V", "host", "Lcom/jetbrains/resharper/projectView/ProjectModelViewHost;", "getHost", "()Lcom/jetbrains/resharper/projectView/ProjectModelViewHost;", "createRoot", "Lcom/intellij/ide/util/treeView/AbstractTreeNode;", "", "settings", "Lcom/intellij/ide/projectView/ViewSettings;", "getDataFromProviders", "selected", "", "dataId", "", "getVirtualFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "isDiagnosticMode", "", "isShowAllItems", "isShowFileSystem", "rider"})
    private final class ProjectViewPaneTreeStructure
    extends ProjectTreeStructure
    implements SolutionExplorerSettings {
        @NotNull
        public final ProjectModelViewHost getHost() {
            ComponentManager $receiver$iv = (ComponentManager)SolutionExplorerViewPane.this.getProject();
            Object object = $receiver$iv.getComponent(ProjectModelViewHost.class);
            if (object == null) {
                throw (Throwable)new IllegalStateException("Component " + ProjectModelViewHost.class + " not found in container " + $receiver$iv);
            }
            return (ProjectModelViewHost)object;
        }

        @Override
        public boolean isShowFileSystem() {
            return SolutionExplorerViewPane.this.getMyShowFileSystem();
        }

        @Override
        public boolean isShowAllItems() {
            return SolutionExplorerViewPane.this.getMyShowAllItems();
        }

        @Override
        public boolean isDiagnosticMode() {
            return SolutionExplorerViewPane.this.getMyDiagnosticMode();
        }

        @NotNull
        protected AbstractTreeNode<Object> createRoot(@NotNull Project project2, @NotNull ViewSettings settings) {
            Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
            SolutionExplorerNodeRider solutionNode = new SolutionExplorerNodeRider(project2, this.getHost().getSolutionNode(), (SolutionExplorerSettings)this);
            return (AbstractTreeNode)new AbstractTreeNode<Object>(solutionNode, project2, project2, (Object)"Project"){
                final /* synthetic */ SolutionExplorerNodeRider $solutionNode;
                final /* synthetic */ Project $project;

                @NotNull
                public ArrayList<SolutionExplorerNodeRider> getChildren() {
                    return CollectionsKt.arrayListOf((Object[])new SolutionExplorerNodeRider[]{this.$solutionNode});
                }

                protected void update(@Nullable PresentationData presentation) {
                }
                {
                    this.$solutionNode = $captured_local_variable$0;
                    this.$project = $captured_local_variable$1;
                    super($super_call_param$2, $super_call_param$3);
                }
            };
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public Object getDataFromProviders(@NotNull List<AbstractTreeNode<Object>> selected, @Nullable String dataId) {
            Intrinsics.checkParameterIsNotNull(selected, (String)"selected");
            if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId)) {
                return RiderDeleteProvider.INSTANCE;
            }
            if (PlatformDataKeys.COPY_PROVIDER.is(dataId)) {
                return RiderCopyProvider.INSTANCE;
            }
            if (PlatformDataKeys.CUT_PROVIDER.is(dataId)) {
                return RiderCutProvider.INSTANCE;
            }
            if (PlatformDataKeys.PASTE_PROVIDER.is(dataId)) {
                return RiderPasteProvider.INSTANCE;
            }
            if (PlatformDataKeys.SELECTED_ITEM.is(dataId)) {
                void $receiver$iv$iv;
                Iterable $receiver$iv;
                Iterable iterable = $receiver$iv = (Iterable)selected;
                Collection destination$iv$iv = new ArrayList();
                for (Object element$iv$iv : $receiver$iv$iv) {
                    if (!(element$iv$iv instanceof ISolutionExplorerNode)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List nodes = CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv));
                return CollectionsKt.singleOrNull((List)nodes);
            }
            if (PlatformDataKeys.SELECTED_ITEMS.is(dataId)) {
                Iterable $receiver$iv;
                Iterable $receiver$iv$iv = $receiver$iv = (Iterable)selected;
                Collection destination$iv$iv = new ArrayList();
                for (Object element$iv$iv : $receiver$iv$iv) {
                    if (!(element$iv$iv instanceof ISolutionExplorerNode)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List nodes = CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv));
                Iterable iterable = $receiver$iv = (Collection)nodes;
                if (iterable == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
                }
                Collection thisCollection$iv = (Collection)iterable;
                ISolutionExplorerNode[] iSolutionExplorerNodeArray = thisCollection$iv.toArray(new ISolutionExplorerNode[thisCollection$iv.size()]);
                if (iSolutionExplorerNodeArray == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                return iSolutionExplorerNodeArray;
            }
            if (Companion.getPROJECT_MODEL_NODE_KEY().is(dataId)) {
                Iterable $receiver$iv$iv;
                Iterable $receiver$iv;
                Iterable thisCollection$iv = $receiver$iv = (Iterable)selected;
                Collection destination$iv$iv = new ArrayList();
                for (Object element$iv$iv : $receiver$iv$iv) {
                    if (!(element$iv$iv instanceof SolutionExplorerNodeRider)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $receiver$iv = (List)destination$iv$iv;
                $receiver$iv$iv = $receiver$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (Object item$iv$iv : $receiver$iv$iv) {
                    void it;
                    SolutionExplorerNodeRider $i$f$filterIsInstanceTo = (SolutionExplorerNodeRider)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    ProjectModelNode projectModelNode = it.getNode();
                    collection.add(projectModelNode);
                }
                ProjectModelNode projectModelNode = (ProjectModelNode)CollectionsKt.singleOrNull((List)((List)destination$iv$iv));
                if (projectModelNode == null) {
                    return null;
                }
                ProjectModelNode node = projectModelNode;
                return ProjectModelNodeExtensionKt.getDotnetProjectNode(node);
            }
            if (CommonDataKeys.VIRTUAL_FILE.is(dataId)) {
                List<VirtualFile> virtualFiles = this.getVirtualFiles(selected);
                return CollectionsKt.singleOrNull(virtualFiles);
            }
            if (CommonDataKeys.VIRTUAL_FILE_ARRAY.is(dataId)) {
                Collection $receiver$iv;
                List<VirtualFile> virtualFiles = this.getVirtualFiles(selected);
                Collection collection = $receiver$iv = (Collection)CollectionsKt.filterNotNull((Iterable)virtualFiles);
                if (collection == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
                }
                Collection thisCollection$iv = collection;
                VirtualFile[] virtualFileArray = thisCollection$iv.toArray(new VirtualFile[thisCollection$iv.size()]);
                if (virtualFileArray == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                return virtualFileArray;
            }
            if (LangDataKeys.MODULE.is(dataId)) {
                ModuleManager moduleManager = ModuleManager.getInstance((Project)SolutionExplorerViewPane.this.getProject());
                return moduleManager.findModuleByName(RiderProjectOpenProcessor.Companion.getModuleName());
            }
            if (PlatformDataKeys.PROJECT_CONTEXT.is(dataId)) {
                return SolutionExplorerViewPane.this.getProject();
            }
            if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
                List<VirtualFile> virtualFiles = this.getVirtualFiles(selected);
                return virtualFiles.size() == 1 ? PsiManager.getInstance((Project)SolutionExplorerViewPane.this.getProject()).findFile((VirtualFile)CollectionsKt.first(virtualFiles)) : null;
            }
            if (LangDataKeys.PSI_ELEMENT_ARRAY.is(dataId)) {
                void $receiver$iv$iv;
                Iterable $receiver$iv;
                List<VirtualFile> virtualFiles = this.getVirtualFiles(selected);
                Iterable $i$f$toTypedArray = $receiver$iv = (Iterable)virtualFiles;
                Collection destination$iv$iv = new ArrayList();
                void $receiver$iv$iv$iv = $receiver$iv$iv;
                Iterator iterator2 = $receiver$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    PsiFile psiFile;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                    VirtualFile it = (VirtualFile)element$iv$iv;
                    if (PsiManager.getInstance((Project)SolutionExplorerViewPane.this.getProject()).findFile(it) == null) continue;
                    PsiFile it$iv$iv = psiFile;
                    destination$iv$iv.add(it$iv$iv);
                }
                $receiver$iv = (List)destination$iv$iv;
                Collection thisCollection$iv = (Collection)$receiver$iv;
                PsiFile[] psiFileArray = thisCollection$iv.toArray(new PsiFile[thisCollection$iv.size()]);
                if (psiFileArray == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                PsiFile[] elements = (PsiFile[])((Object[])psiFileArray);
                Object[] objectArray = elements;
                return objectArray.length == 0 ? null : elements;
            }
            if (Companion.getDATA_KEY().is(dataId)) {
                return SolutionExplorerViewPane.this;
            }
            return super.getDataFromProviders(selected, dataId);
        }

        private final List<VirtualFile> getVirtualFiles(List<AbstractTreeNode<Object>> selected) {
            Iterable $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)selected;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                if (!(element$iv$iv instanceof ISolutionExplorerNode)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList();
            Iterable $receiver$iv$iv$iv = $receiver$iv$iv;
            for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
                VirtualFile virtualFile;
                Object element$iv$iv = element$iv$iv$iv;
                ISolutionExplorerNode it = (ISolutionExplorerNode)element$iv$iv;
                if (it.getVirtualFile() == null) continue;
                VirtualFile it$iv$iv = virtualFile;
                destination$iv$iv.add(it$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                VirtualFile it = (VirtualFile)element$iv$iv;
                if (!it.isValid()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        public ProjectViewPaneTreeStructure(Project project2) {
            Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
            super(project2, Companion.getID());
        }
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0005H\u0016J\u0010\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0007H\u0016\u00a8\u0006\r"}, d2={"Lcom/jetbrains/resharper/projectView/solutionExplorer/SolutionExplorerViewPane$ShowFileSystemAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "Lcom/intellij/openapi/project/DumbAware;", "(Lcom/jetbrains/resharper/projectView/solutionExplorer/SolutionExplorerViewPane;)V", "isSelected", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "flag", "update", "e", "rider"})
    private final class ShowFileSystemAction
    extends ToggleAction
    implements DumbAware {
        public boolean isSelected(@NotNull AnActionEvent event) {
            Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
            return SolutionExplorerViewPane.this.getMyShowFileSystem();
        }

        public void setSelected(@NotNull AnActionEvent event, boolean flag) {
            Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
            if (SolutionExplorerViewPane.this.getMyShowFileSystem() != flag) {
                SolutionExplorerViewPane.this.setMyShowFileSystem(flag);
                SolutionExplorerViewPane.this.updateFromRoot(false);
            }
        }

        public void update(@NotNull AnActionEvent e2) {
            Intrinsics.checkParameterIsNotNull((Object)e2, (String)"e");
            super.update(e2);
            Presentation presentation = e2.getPresentation();
            ProjectView projectView = ProjectView.getInstance(SolutionExplorerViewPane.this.myProject);
            presentation.setEnabledAndVisible(projectView.getCurrentProjectViewPane() == SolutionExplorerViewPane.this);
        }

        public ShowFileSystemAction() {
            super("Show All Files");
        }
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0005H\u0016J\u0010\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0007H\u0016\u00a8\u0006\r"}, d2={"Lcom/jetbrains/resharper/projectView/solutionExplorer/SolutionExplorerViewPane$ShowAllItemsAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "Lcom/intellij/openapi/project/DumbAware;", "(Lcom/jetbrains/resharper/projectView/solutionExplorer/SolutionExplorerViewPane;)V", "isSelected", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "flag", "update", "e", "rider"})
    private final class ShowAllItemsAction
    extends ToggleAction
    implements DumbAware {
        public boolean isSelected(@NotNull AnActionEvent event) {
            Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
            return SolutionExplorerViewPane.this.getMyShowAllItems();
        }

        public void setSelected(@NotNull AnActionEvent event, boolean flag) {
            Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
            if (SolutionExplorerViewPane.this.getMyShowAllItems() != flag) {
                SolutionExplorerViewPane.this.setMyShowAllItems(flag);
                SolutionExplorerViewPane.this.updateFromRoot(false);
            }
        }

        public void update(@NotNull AnActionEvent e2) {
            Intrinsics.checkParameterIsNotNull((Object)e2, (String)"e");
            super.update(e2);
            Presentation presentation = e2.getPresentation();
            ProjectView projectView = ProjectView.getInstance(SolutionExplorerViewPane.this.myProject);
            presentation.setEnabledAndVisible(projectView.getCurrentProjectViewPane() == SolutionExplorerViewPane.this);
        }

        public ShowAllItemsAction() {
            super("Show All Project Items");
        }
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0005H\u0016J\u0010\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0007H\u0016\u00a8\u0006\r"}, d2={"Lcom/jetbrains/resharper/projectView/solutionExplorer/SolutionExplorerViewPane$DiagnosticModeAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "Lcom/intellij/openapi/project/DumbAware;", "(Lcom/jetbrains/resharper/projectView/solutionExplorer/SolutionExplorerViewPane;)V", "isSelected", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "flag", "update", "e", "rider"})
    private final class DiagnosticModeAction
    extends ToggleAction
    implements DumbAware {
        public boolean isSelected(@NotNull AnActionEvent event) {
            Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
            return SolutionExplorerViewPane.this.getMyDiagnosticMode();
        }

        public void setSelected(@NotNull AnActionEvent event, boolean flag) {
            Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
            if (SolutionExplorerViewPane.this.getMyDiagnosticMode() != flag) {
                SolutionExplorerViewPane.this.setMyDiagnosticMode(flag);
                SolutionExplorerViewPane.this.updateFromRoot(false);
            }
        }

        public void update(@NotNull AnActionEvent e2) {
            Intrinsics.checkParameterIsNotNull((Object)e2, (String)"e");
            super.update(e2);
            Presentation presentation = e2.getPresentation();
            ProjectView projectView = ProjectView.getInstance(SolutionExplorerViewPane.this.myProject);
            presentation.setEnabledAndVisible(projectView.getCurrentProjectViewPane() == SolutionExplorerViewPane.this);
        }

        public DiagnosticModeAction() {
            super("Diagnostic Mode");
        }
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R5\u0010\u0003\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R5\u0010\u0017\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00180\u0018 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00180\u0018\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\bR\u0014\u0010\u001a\u001a\u00020\u0010X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0012R\u0014\u0010\u001c\u001a\u00020\u0010X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0012R\u001a\u0010\u001e\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\f\"\u0004\b \u0010\u000eR\u001a\u0010!\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\f\"\u0004\b#\u0010\u000eR\u0014\u0010$\u001a\u00020\u0010X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u0012R\u0014\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)\u00a8\u0006*"}, d2={"Lcom/jetbrains/resharper/projectView/solutionExplorer/SolutionExplorerViewPane$Companion;", "", "()V", "DATA_KEY", "Lcom/intellij/openapi/actionSystem/DataKey;", "Lcom/jetbrains/resharper/projectView/solutionExplorer/SolutionExplorerViewPane;", "kotlin.jvm.PlatformType", "getDATA_KEY", "()Lcom/intellij/openapi/actionSystem/DataKey;", "DiagnosticModeDefault", "", "getDiagnosticModeDefault", "()Z", "setDiagnosticModeDefault", "(Z)V", "ID", "", "getID", "()Ljava/lang/String;", "Icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "PROJECT_MODEL_NODE_KEY", "Lcom/jetbrains/resharper/projectView/nodes/ProjectModelNode;", "getPROJECT_MODEL_NODE_KEY", "SHOW_ALL_ITEMS_OPTION", "getSHOW_ALL_ITEMS_OPTION", "SHOW_FILE_SYSTEM_OPTION", "getSHOW_FILE_SYSTEM_OPTION", "ShowAllItemsDefault", "getShowAllItemsDefault", "setShowAllItemsDefault", "ShowFileSystemDefault", "getShowFileSystemDefault", "setShowFileSystemDefault", "Title", "getTitle", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "rider"})
    public static final class Companion {
        private final Logger getLogger() {
            return logger;
        }

        @NotNull
        public final String getID() {
            return ID;
        }

        @NotNull
        public final String getTitle() {
            return Title;
        }

        @NotNull
        public final Icon getIcon() {
            return Icon;
        }

        @NotNull
        public final String getSHOW_FILE_SYSTEM_OPTION() {
            return SHOW_FILE_SYSTEM_OPTION;
        }

        @NotNull
        public final String getSHOW_ALL_ITEMS_OPTION() {
            return SHOW_ALL_ITEMS_OPTION;
        }

        public final boolean getShowFileSystemDefault() {
            return ShowFileSystemDefault;
        }

        public final void setShowFileSystemDefault(boolean bl) {
            ShowFileSystemDefault = bl;
        }

        public final boolean getShowAllItemsDefault() {
            return ShowAllItemsDefault;
        }

        public final void setShowAllItemsDefault(boolean bl) {
            ShowAllItemsDefault = bl;
        }

        public final boolean getDiagnosticModeDefault() {
            return DiagnosticModeDefault;
        }

        public final void setDiagnosticModeDefault(boolean bl) {
            DiagnosticModeDefault = bl;
        }

        public final DataKey<SolutionExplorerViewPane> getDATA_KEY() {
            return DATA_KEY;
        }

        public final DataKey<ProjectModelNode> getPROJECT_MODEL_NODE_KEY() {
            return PROJECT_MODEL_NODE_KEY;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

