/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.protocol;

import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.resharper.protocol.IProtocolHost;
import com.jetbrains.resharper.protocol.IRdDispatcher;
import com.jetbrains.resharper.protocol.ProtocolComponent;
import com.jetbrains.resharper.protocol.ProtocolHost;
import com.jetbrains.resharper.protocol.ProtocolKeys;
import com.jetbrains.resharper.protocol.ProtocolManager;
import com.jetbrains.resharper.protocol.ReSharperProcess;
import com.jetbrains.resharper.protocol.components.ShellHost;
import com.jetbrains.resharper.util.idea.ApplicationKt;
import com.jetbrains.rider.framework.IProtocol;
import com.jetbrains.rider.framework.IWire;
import com.jetbrains.rider.framework.IdKind;
import com.jetbrains.rider.framework.Identities;
import com.jetbrains.rider.framework.Protocol;
import com.jetbrains.rider.framework.Serializers;
import com.jetbrains.rider.framework.SocketWire;
import com.jetbrains.rider.framework.WireExKt;
import com.jetbrains.rider.util.CollectionExKt;
import com.jetbrains.rider.util.lifetime.Lifetime;
import com.jetbrains.rider.util.lifetime.LifetimeDefinition;
import com.jetbrains.rider.util.reactive.ViewableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003H\u0002J\u0006\u0010\u0013\u001a\u00020\u000fJ\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u000bJ\u000e\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u000bJ\b\u0010\u0019\u001a\u00020\u000fH\u0002J\u0016\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u0006R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/resharper/protocol/ProtocolManager;", "", "componentLifetime", "Lcom/jetbrains/rider/util/lifetime/Lifetime;", "(Lcom/jetbrains/rider/util/lifetime/Lifetime;)V", "initialized", "", "nextId", "", "protocolHosts", "Lcom/jetbrains/rider/util/reactive/ViewableSet;", "Lcom/jetbrains/resharper/protocol/IProtocolHost;", "getProtocolHosts", "()Lcom/jetbrains/rider/util/reactive/ViewableSet;", "create", "Lcom/jetbrains/resharper/protocol/ProtocolHost;", "createProtocol", "Lcom/jetbrains/rider/framework/IProtocol;", "lifetime", "getOrCreate", "init", "", "release", "protocolHost", "requestShutdown", "runReSharperProcess", "shutdown", "async", "Companion", "rider"})
public final class ProtocolManager {
    private boolean initialized;
    private int nextId;
    @NotNull
    private final ViewableSet<IProtocolHost> protocolHosts;
    private final Lifetime componentLifetime;
    @NotNull
    private static final Logger logger;
    private static boolean onlyOneProcess;
    public static final Companion Companion;

    @NotNull
    public final ViewableSet<IProtocolHost> getProtocolHosts() {
        return this.protocolHosts;
    }

    private final ProtocolHost runReSharperProcess() {
        LifetimeDefinition lifetimeDefinition = this.componentLifetime.createNestedDef();
        Lifetime lifetime = lifetimeDefinition.getLifetime();
        Companion.getLogger().info("Create protocol...");
        IProtocol protocol2 = this.createProtocol(lifetime);
        Companion.getLogger().info("Run ReSharper process...");
        ReSharperProcess process2 = new ReSharperProcess(lifetime, WireExKt.getServerPort(protocol2.getWire()));
        Companion.getLogger().info("Create protocol host...");
        int n2 = this.nextId;
        this.nextId = n2 + 1;
        String id = "ReSharper Process " + n2;
        ProtocolHost host = new ProtocolHost(id, lifetimeDefinition, protocol2, process2);
        if (this.initialized) {
            host.init();
        }
        CollectionExKt.addUnique(this.protocolHosts, lifetime, host);
        return host;
    }

    private final IProtocol createProtocol(Lifetime lifetime) {
        Function1 function1 = (Function1)ApplicationKt.getApplication().getUserData(ProtocolKeys.Companion.getProtocolDispatcherFactoryKey());
        if (function1 == null) {
            function1 = createProtocol.dispatcherFactory.1.INSTANCE;
        }
        Function1 dispatcherFactory2 = function1;
        IRdDispatcher dispatcher = (IRdDispatcher)dispatcherFactory2.invoke((Object)lifetime);
        Serializers serializers = new Serializers();
        Identities identity = new Identities(IdKind.DynamicClient);
        Protocol protocol2 = new Protocol(serializers, identity, dispatcher, (Function1<? super Protocol, ? extends IWire>)((Function1)new Function1<Protocol, SocketWire.Server>(lifetime){
            final /* synthetic */ Lifetime $lifetime;

            @NotNull
            public final SocketWire.Server invoke(@NotNull Protocol protocol2) {
                Intrinsics.checkParameterIsNotNull((Object)protocol2, (String)"protocol");
                return new SocketWire.Server(this.$lifetime, protocol2, null, "FrontendToBackend");
            }
            {
                this.$lifetime = lifetime;
                super(1);
            }
        }));
        return protocol2;
    }

    public final void release(@NotNull IProtocolHost protocolHost) {
        Intrinsics.checkParameterIsNotNull((Object)protocolHost, (String)"protocolHost");
        ApplicationKt.getApplication().assertIsDispatchThread();
        Companion.getLogger().info("Release protocolHost...");
        IProtocolHost iProtocolHost = protocolHost;
        if (iProtocolHost == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.jetbrains.resharper.protocol.ProtocolHost");
        }
        ProtocolHost protocolHostComponent = (ProtocolHost)iProtocolHost;
        protocolHostComponent.release();
        Collection collection = this.protocolHosts;
        if (collection.size() > 1) {
            Companion.getLogger().info("Kill protocolHost...");
            this.requestShutdown(protocolHost);
            this.shutdown(protocolHost, true);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void requestShutdown(@NotNull IProtocolHost protocolHost) {
        void $receiver$iv$iv$iv;
        Iterable $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)protocolHost, (String)"protocolHost");
        ApplicationKt.getApplication().assertIsDispatchThread();
        IProtocolHost iProtocolHost = protocolHost;
        if (iProtocolHost == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.jetbrains.resharper.protocol.ProtocolHost");
        }
        ((ProtocolHost)iProtocolHost).getResharperProcess().requestShutdown();
        IProtocolHost $receiver$iv = protocolHost;
        Iterable iterable = $receiver$iv$iv = (Iterable)$receiver$iv.getComponents();
        Collection destination$iv$iv$iv = new ArrayList();
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            if (!(element$iv$iv$iv instanceof ShellHost)) continue;
            destination$iv$iv$iv.add(element$iv$iv$iv);
        }
        ((ShellHost)((ProtocolComponent)CollectionsKt.single((List)((List)destination$iv$iv$iv)))).requestShutdown();
    }

    public final void shutdown(@NotNull IProtocolHost protocolHost, boolean async) {
        Intrinsics.checkParameterIsNotNull((Object)protocolHost, (String)"protocolHost");
        ApplicationKt.getApplication().assertIsDispatchThread();
        IProtocolHost iProtocolHost = protocolHost;
        if (iProtocolHost == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.jetbrains.resharper.protocol.ProtocolHost");
        }
        ((ProtocolHost)iProtocolHost).getResharperProcess().setAsyncShutdown(async);
        ((ProtocolHost)protocolHost).getLifetimeDefinition().terminate();
    }

    @NotNull
    public final ProtocolHost getOrCreate() {
        IProtocolHost protocolHost;
        IProtocolHost freeProtocolHost;
        IProtocolHost iProtocolHost;
        Object v0;
        block3: {
            ApplicationKt.getApplication().assertIsDispatchThread();
            Companion.getLogger().info("GetOrCreate protocolHost...");
            Iterable $receiver$iv = this.protocolHosts;
            for (Object element$iv : $receiver$iv) {
                IProtocolHost it = (IProtocolHost)element$iv;
                if (!(!it.isProjectAttached())) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        if ((iProtocolHost = (freeProtocolHost = (IProtocolHost)v0)) == null) {
            iProtocolHost = this.create();
        }
        IProtocolHost iProtocolHost2 = protocolHost = iProtocolHost;
        if (iProtocolHost2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.jetbrains.resharper.protocol.ProtocolHost");
        }
        return (ProtocolHost)iProtocolHost2;
    }

    private final ProtocolHost create() {
        if (Companion.getOnlyOneProcess()) {
            String string2 = "Several ReSharper processes execution is prohibited";
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return this.runReSharperProcess();
    }

    /*
     * WARNING - void declaration
     */
    public final void init() {
        void $receiver$iv$iv;
        ApplicationKt.getApplication().assertIsDispatchThread();
        Companion.getLogger().info("Initialize protocol manager");
        this.initialized = true;
        Companion.getLogger().info("Initialize " + this.protocolHosts.size() + " hosts");
        Iterable $receiver$iv = this.protocolHosts;
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            if (!(element$iv$iv instanceof ProtocolHost)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        for (Object element$iv : $receiver$iv) {
            ProtocolHost it = (ProtocolHost)element$iv;
            it.init();
        }
    }

    public ProtocolManager(@NotNull Lifetime componentLifetime) {
        Intrinsics.checkParameterIsNotNull((Object)componentLifetime, (String)"componentLifetime");
        this.componentLifetime = componentLifetime;
        this.protocolHosts = new ViewableSet();
        this.runReSharperProcess();
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(ProtocolManager.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
        ProtocolManager.logger = logger;
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/jetbrains/resharper/protocol/ProtocolManager$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "onlyOneProcess", "", "getOnlyOneProcess", "()Z", "setOnlyOneProcess", "(Z)V", "rider"})
    public static final class Companion {
        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        public final boolean getOnlyOneProcess() {
            return onlyOneProcess;
        }

        public final void setOnlyOneProcess(boolean bl) {
            onlyOneProcess = bl;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

