/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.protocol;

import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.ex.MessagesEx;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.jetbrains.resharper.RiderEnvironment;
import com.jetbrains.resharper.protocol.ReSharperProcess;
import com.jetbrains.resharper.util.idea.ApplicationKt;
import com.jetbrains.resharper.util.idea.ComponentContainerUtilKt;
import com.jetbrains.resharper.util.idea.DocumentUtilKt;
import com.jetbrains.resharper.utils.RiderProcessUtil;
import com.jetbrains.resharper.utils.XMLStreamHelpers;
import com.jetbrains.rider.util.lifetime.Lifetime;
import java.io.File;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 \u001f2\u00020\u0001:\u0002\u001e\u001fB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001aH\u0002J\u0006\u0010\u000f\u001a\u00020\u0018R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006 "}, d2={"Lcom/jetbrains/resharper/protocol/ReSharperProcess;", "", "lifetime", "Lcom/jetbrains/rider/util/lifetime/Lifetime;", "serverPort", "", "(Lcom/jetbrains/rider/util/lifetime/Lifetime;I)V", "asyncShutdown", "", "getAsyncShutdown", "()Z", "setAsyncShutdown", "(Z)V", "getLifetime", "()Lcom/jetbrains/rider/util/lifetime/Lifetime;", "requestShutdown", "Ljava/util/concurrent/atomic/AtomicBoolean;", "resharperHostConfigDir", "Ljava/io/File;", "resharperProcessHandler", "Lcom/intellij/execution/process/OSProcessHandler;", "getResharperProcessHandler", "()Lcom/intellij/execution/process/OSProcessHandler;", "copyReSharperSettings", "", "getAdditionalDotNetPlugins", "Lcom/jetbrains/resharper/protocol/ReSharperProcess$AdditionalPlugins;", "getDotNetPluginsXmlDescriptor", "", "plugins", "AdditionalPlugins", "Companion", "rider"})
public final class ReSharperProcess {
    @NotNull
    private final OSProcessHandler resharperProcessHandler;
    private boolean asyncShutdown;
    private final AtomicBoolean requestShutdown;
    private final File resharperHostConfigDir;
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private static final Logger logger;
    private static final long shutdownTimeout = 50000L;
    private static int processIdIncrement;
    public static final Companion Companion;

    @NotNull
    public final OSProcessHandler getResharperProcessHandler() {
        return this.resharperProcessHandler;
    }

    public final boolean getAsyncShutdown() {
        return this.asyncShutdown;
    }

    public final void setAsyncShutdown(boolean bl) {
        this.asyncShutdown = bl;
    }

    private final AdditionalPlugins getAdditionalDotNetPlugins() {
        List files2 = new ArrayList();
        List dirs = new ArrayList();
        IdeaPluginDescriptor[] ideaPluginDescriptorArray = PluginManager.getPlugins();
        for (int i2 = 0; i2 < ideaPluginDescriptorArray.length; ++i2) {
            File[] fileArray;
            IdeaPluginDescriptor plugin = ideaPluginDescriptorArray[i2];
            File path = plugin.getPath();
            Companion.getLogger().info("Idea Plugin: " + path);
            if (!plugin.isEnabled()) {
                Companion.getLogger().info("- " + path + " is disabled, skiping");
                continue;
            }
            File dotnetDirectoryPart = new File(path, "dotnet");
            if (dotnetDirectoryPart.isDirectory()) {
                Companion.getLogger().info("* adding ReSharper plugin directory: " + dotnetDirectoryPart);
                dirs.add(dotnetDirectoryPart);
            }
            if ((fileArray = path.listFiles(getAdditionalDotNetPlugins.dotnetNugets.1.INSTANCE)) == null) {
                fileArray = (File[])((Object[])new File[0]);
            }
            File[] dotnetNugets2 = fileArray;
            for (int i3 = 0; i3 < dotnetNugets2.length; ++i3) {
                File nuget = dotnetNugets2[i3];
                Companion.getLogger().info("* adding ReSharper plugin nuget: " + nuget);
                File file2 = nuget;
                Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"nuget");
                files2.add(file2);
            }
        }
        return new AdditionalPlugins(files2, dirs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final String getDotNetPluginsXmlDescriptor(AdditionalPlugins plugins2) {
        StringWriter sw = new StringWriter();
        XMLStreamWriter xMLStreamWriter = XMLOutputFactory.newInstance().createXMLStreamWriter(sw);
        Intrinsics.checkExpressionValueIsNotNull((Object)xMLStreamWriter, (String)"XMLOutputFactory.newInst\u2026createXMLStreamWriter(sw)");
        XMLStreamWriter xml = xMLStreamWriter;
        try {
            XMLStreamWriter $receiver;
            XMLStreamWriter $receiver$iv;
            String name$iv;
            XMLStreamHelpers xMLStreamHelpers;
            File it;
            void $receiver$iv2;
            XMLStreamWriter $receiver2;
            XMLStreamHelpers this_$iv = XMLStreamHelpers.INSTANCE;
            XMLStreamWriter xMLStreamWriter2 = $receiver2 = xml;
            XMLStreamHelpers xMLStreamHelpers2 = XMLStreamHelpers.INSTANCE;
            String name$iv2 = "Packages";
            $receiver$iv2.writeStartElement(name$iv2);
            XMLStreamWriter $receiver3 = (XMLStreamWriter)$receiver$iv2;
            Iterable $receiver$iv3 = plugins2.getFolders();
            for (Object element$iv : $receiver$iv3) {
                it = (File)element$iv;
                XMLStreamWriter xMLStreamWriter3 = $receiver3;
                xMLStreamHelpers = XMLStreamHelpers.INSTANCE;
                name$iv = "Folder";
                $receiver$iv.writeStartElement(name$iv);
                $receiver = $receiver$iv;
                String string2 = it.getPath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"it.path");
                XMLStreamHelpers.INSTANCE.attribute($receiver, "Path", string2);
                $receiver$iv.writeEndElement();
            }
            $receiver$iv3 = plugins2.getNuggets();
            for (Object element$iv : $receiver$iv3) {
                it = (File)element$iv;
                $receiver$iv = $receiver3;
                xMLStreamHelpers = XMLStreamHelpers.INSTANCE;
                name$iv = "File";
                $receiver$iv.writeStartElement(name$iv);
                $receiver = $receiver$iv;
                String string3 = it.getPath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"it.path");
                XMLStreamHelpers.INSTANCE.attribute($receiver, "Path", string3);
                $receiver$iv.writeEndElement();
            }
            $receiver$iv2.writeEndElement();
        }
        finally {
            xml.close();
        }
        Companion.getLogger().info("Additional packages: " + sw);
        String string4 = sw.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"sw.toString()");
        return string4;
    }

    private final void copyReSharperSettings() {
        if (!SystemInfo.isWindows) {
            return;
        }
        String globalSettingsStorageFile = "GlobalSettingsStorage.DotSettings";
        File riderGlobalSettingsStorage = DocumentUtilKt.join(this.resharperHostConfigDir, globalSettingsStorageFile);
        if (riderGlobalSettingsStorage.exists()) {
            Companion.getLogger().debug("Global settings file already exists for Rider => skipping copying resharper settings");
            return;
        }
        String appdata = System.getenv("APPDATA");
        if (appdata == null) {
            Companion.getLogger().error("%APPDATA% is not defined => skipping copying resharper settings");
            return;
        }
        File resharperGlobalSettingsStorage = ComponentContainerUtilKt.toIOFile(FileUtil.join((String[])new String[]{appdata, "JetBrains", "Shared", "vAny", globalSettingsStorageFile}));
        if (!resharperGlobalSettingsStorage.exists()) {
            Companion.getLogger().debug("Global settings file (for ReSharper and .NET products) is not found at " + resharperGlobalSettingsStorage + " => skipping copying resharper settings");
            return;
        }
        try {
            FilesKt.copyTo$default((File)resharperGlobalSettingsStorage, (File)riderGlobalSettingsStorage, (boolean)false, (int)0, (int)4, null);
        }
        catch (Throwable t2) {
            Companion.getLogger().error("Unable to copy resharper settings from " + resharperGlobalSettingsStorage + " to " + riderGlobalSettingsStorage, t2);
        }
    }

    public final void requestShutdown() {
        this.requestShutdown.set(true);
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    public ReSharperProcess(@NotNull Lifetime lifetime, int serverPort) {
        AdditionalPlugins additionalPlugins;
        Intrinsics.checkParameterIsNotNull((Object)lifetime, (String)"lifetime");
        this.lifetime = lifetime;
        this.requestShutdown = new AtomicBoolean(false);
        this.resharperHostConfigDir = new File(PathManager.getConfigPath(), "resharper-host");
        this.copyReSharperSettings();
        File executable = RiderEnvironment.INSTANCE.getReSharperHostExecutable();
        String string2 = executable.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"executable.path");
        ProcessBuilder processBuilder = RiderEnvironment.INSTANCE.createProcessBuilderForAssembly(string2, "--Port=" + serverPort);
        if (ApplicationKt.getApplication().isUnitTestMode()) {
            processBuilder.command().add("--UnitTests");
        }
        if (ApplicationKt.getApplication().isInternal()) {
            processBuilder.command().add("--Internal");
        }
        if ((additionalPlugins = this.getAdditionalDotNetPlugins()).isEmpty()) {
            Companion.getLogger().info("No ReSharper plugins discovered");
        } else {
            String xml = this.getDotNetPluginsXmlDescriptor(additionalPlugins);
            processBuilder.environment().put("JET_ADDITIONAL_DEPLOYED_PACKAGES", xml);
        }
        processBuilder.environment().put("RESHARPER_LOG_CONF", RiderEnvironment.INSTANCE.getLogBackendConf());
        processBuilder.environment().put("RESHARPER_HOST_CONFIG_DIR", this.resharperHostConfigDir.getAbsolutePath());
        processBuilder.environment().put("RESHARPER_HOST_LOG_DIR", RiderEnvironment.INSTANCE.getLogDirectory().getAbsolutePath());
        processBuilder.environment().put("RESHARPER_HOST_PARENT_PROCESS_PID", String.valueOf(RiderProcessUtil.INSTANCE.getCurrentPid()));
        Companion companion = Companion;
        int n2 = companion.getProcessIdIncrement();
        companion.setProcessIdIncrement(n2 + 1);
        int processId = n2;
        boolean $receiver$iv22 = processId > 0;
        String logFilesPrefix = $receiver$iv22 ? "host" + processId + "." : "";
        CharSequence $receiver$iv22 = logFilesPrefix;
        if (!StringsKt.isBlank((CharSequence)$receiver$iv22)) {
            processBuilder.environment().put("RESHARPER_HOST_PROCESS_PREFIX", logFilesPrefix);
        }
        File outFile = new File(RiderEnvironment.INSTANCE.getLogDirectory(), logFilesPrefix + "backend-out.log");
        File errFile = new File(RiderEnvironment.INSTANCE.getLogDirectory(), logFilesPrefix + "backend-err.log");
        processBuilder.redirectOutput(ProcessBuilder.Redirect.to(outFile));
        processBuilder.redirectError(ProcessBuilder.Redirect.to(errFile));
        String commandLine = CollectionsKt.joinToString$default((Iterable)processBuilder.command(), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
        Companion.getLogger().info("Start " + commandLine);
        Process process2 = processBuilder.start();
        this.resharperProcessHandler = new OSProcessHandler(process2, commandLine, null);
        ProcessAdapter processListener2 = new ProcessAdapter(this, errFile){
            final /* synthetic */ ReSharperProcess this$0;
            final /* synthetic */ File $errFile;

            public void processTerminated(@Nullable ProcessEvent event) {
                int exitCode;
                this.this$0.getResharperProcessHandler().removeProcessListener((ProcessListener)this);
                ProcessEvent processEvent = event;
                int n2 = exitCode = processEvent != null ? processEvent.getExitCode() : 0;
                if (ReSharperProcess.access$getRequestShutdown$p(this.this$0).get() || this.this$0.getLifetime().isTerminated()) {
                    if (exitCode == 0) {
                        ReSharperProcess.Companion.getLogger().debug("Rider host process has exited by request with exit code " + exitCode);
                    } else {
                        ReSharperProcess.Companion.getLogger().error("Rider host process has exited by request with exit code " + exitCode);
                    }
                    return;
                }
                ReSharperProcess.Companion.getLogger().error("Rider host has unexpectedly exited with exit code " + exitCode + ". See " + this.$errFile + " for output. Please send it to the support too");
                Object object = event;
                if (object == null || (object = object.getText()) == null) {
                    ProcessEvent processEvent2 = event;
                    object = "Oops, Rider host has unexpectedly exited with exit code " + (processEvent2 != null ? Integer.valueOf(processEvent2.getExitCode()) : "?") + "." + "\n" + "See " + this.$errFile + ". Please send it to the support too";
                }
                Object text2 = object;
                ApplicationKt.getApplication().invokeLater(new Runnable((String)text2){
                    final /* synthetic */ String $text;

                    public final void run() {
                        MessagesEx.showErrorDialog((String)this.$text, (String)"Rider");
                    }
                    {
                        this.$text = string2;
                    }
                });
            }
            {
                this.this$0 = $outer;
                this.$errFile = $captured_local_variable$1;
            }
        };
        this.resharperProcessHandler.addProcessListener((ProcessListener)processListener2);
        this.resharperProcessHandler.startNotify();
        RiderEnvironment.INSTANCE.addRiderProcess((BaseOSProcessHandler)this.resharperProcessHandler);
        if (this.resharperProcessHandler.isProcessTerminated()) {
            throw (Throwable)new RuntimeException("Rider host exited while initializing. See " + errFile);
        }
        this.lifetime.add((Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                final Function0 shutdownAction2 = (Function0)new Function0<Unit>(this){
                    final /* synthetic */ 1 this$0;

                    public final void invoke() {
                        if (!this.this$0.this.getResharperProcessHandler().isProcessTerminated() && !this.this$0.this.getResharperProcessHandler().waitFor(ReSharperProcess.Companion.getShutdownTimeout())) {
                            ReSharperProcess.Companion.getLogger().error("Rider host process has not gracefully exited within " + ReSharperProcess.Companion.getShutdownTimeout() + " ms and will be killed");
                            this.this$0.this.getResharperProcessHandler().destroyProcess();
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                };
                if (this.getAsyncShutdown()) {
                    Intrinsics.checkExpressionValueIsNotNull((Object)ApplicationKt.getApplication().executeOnPooledThread(new Runnable(){

                        @Override
                        public final void run() {
                            shutdownAction2.invoke();
                        }
                    }), (String)"application.executeOnPoo\u2026read { shutdownAction() }");
                } else {
                    shutdownAction2.invoke();
                }
            }
        }));
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(ReSharperProcess.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
        ReSharperProcess.logger = logger;
        shutdownTimeout = 50000L;
    }

    @NotNull
    public static final /* synthetic */ AtomicBoolean access$getRequestShutdown$p(ReSharperProcess $this) {
        return $this.requestShutdown;
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0006J\u000f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J)\u0010\f\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\u0006\u0010\u0012\u001a\u00020\u000eJ\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/resharper/protocol/ReSharperProcess$AdditionalPlugins;", "", "nuggets", "", "Ljava/io/File;", "folders", "(Ljava/util/List;Ljava/util/List;)V", "getFolders", "()Ljava/util/List;", "getNuggets", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "isEmpty", "toString", "", "rider"})
    private static final class AdditionalPlugins {
        @NotNull
        private final List<File> nuggets;
        @NotNull
        private final List<File> folders;

        public final boolean isEmpty() {
            return this.nuggets.isEmpty() && this.folders.isEmpty();
        }

        @NotNull
        public final List<File> getNuggets() {
            return this.nuggets;
        }

        @NotNull
        public final List<File> getFolders() {
            return this.folders;
        }

        public AdditionalPlugins(@NotNull List<? extends File> nuggets, @NotNull List<? extends File> folders) {
            Intrinsics.checkParameterIsNotNull(nuggets, (String)"nuggets");
            Intrinsics.checkParameterIsNotNull(folders, (String)"folders");
            this.nuggets = nuggets;
            this.folders = folders;
        }

        @NotNull
        public final List<File> component1() {
            return this.nuggets;
        }

        @NotNull
        public final List<File> component2() {
            return this.folders;
        }

        @NotNull
        public final AdditionalPlugins copy(@NotNull List<? extends File> nuggets, @NotNull List<? extends File> folders) {
            Intrinsics.checkParameterIsNotNull(nuggets, (String)"nuggets");
            Intrinsics.checkParameterIsNotNull(folders, (String)"folders");
            return new AdditionalPlugins(nuggets, folders);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ AdditionalPlugins copy$default(AdditionalPlugins additionalPlugins, List list2, List list3, int n2, Object object) {
            if ((n2 & 1) != 0) {
                list2 = additionalPlugins.nuggets;
            }
            if ((n2 & 2) != 0) {
                list3 = additionalPlugins.folders;
            }
            return additionalPlugins.copy(list2, list3);
        }

        public String toString() {
            return "AdditionalPlugins(nuggets=" + this.nuggets + ", folders=" + this.folders + ")";
        }

        public int hashCode() {
            List<File> list2 = this.nuggets;
            List<File> list3 = this.folders;
            return (list2 != null ? ((Object)list2).hashCode() : 0) * 31 + (list3 != null ? ((Object)list3).hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof AdditionalPlugins)) break block3;
                    AdditionalPlugins additionalPlugins = (AdditionalPlugins)object;
                    if (!Intrinsics.areEqual(this.nuggets, additionalPlugins.nuggets) || !Intrinsics.areEqual(this.folders, additionalPlugins.folders)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/resharper/protocol/ReSharperProcess$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "processIdIncrement", "", "getProcessIdIncrement", "()I", "setProcessIdIncrement", "(I)V", "shutdownTimeout", "", "getShutdownTimeout", "()J", "rider"})
    public static final class Companion {
        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        public final long getShutdownTimeout() {
            return shutdownTimeout;
        }

        public final int getProcessIdIncrement() {
            return processIdIncrement;
        }

        public final void setProcessIdIncrement(int n2) {
            processIdIncrement = n2;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

