/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.protocol.components;

import com.intellij.ide.ui.LafManager;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.resharper.protocol.IProtocolHost;
import com.jetbrains.resharper.protocol.ProtocolComponent;
import com.jetbrains.resharper.util.idea.ApplicationKt;
import com.jetbrains.rider.model.LookAndFeelTheme;
import com.jetbrains.rider.model.RdShellModel;
import com.jetbrains.rider.util.lifetime.Lifetime;
import com.jetbrains.rider.util.reactive.PropertyExKt;
import javax.swing.UIManager;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\t\u001a\u00020\nJ\f\u0010\u000b\u001a\u00020\f*\u00020\rH\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/resharper/protocol/components/ShellHost;", "Lcom/jetbrains/resharper/protocol/ProtocolComponent;", "protocolHost", "Lcom/jetbrains/resharper/protocol/IProtocolHost;", "(Lcom/jetbrains/resharper/protocol/IProtocolHost;)V", "model", "Lcom/jetbrains/rider/model/RdShellModel;", "getModel", "()Lcom/jetbrains/rider/model/RdShellModel;", "requestShutdown", "", "toLookAndFeelTheme", "Lcom/jetbrains/rider/model/LookAndFeelTheme;", "Lcom/intellij/ide/ui/LafManager;", "Companion", "rider"})
public final class ShellHost
extends ProtocolComponent {
    @NotNull
    private final RdShellModel model;
    @NotNull
    private static final Logger logger;
    public static final Companion Companion;

    @NotNull
    public final RdShellModel getModel() {
        return this.model;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final LookAndFeelTheme toLookAndFeelTheme(@NotNull LafManager $receiver) {
        String string2;
        UIManager.LookAndFeelInfo lookAndFeelInfo = $receiver.getCurrentLookAndFeel();
        if (lookAndFeelInfo == null) {
            return LookAndFeelTheme.IntelliJ;
        }
        UIManager.LookAndFeelInfo currentLookAndFeel = lookAndFeelInfo;
        String string3 = string2 = currentLookAndFeel.getName();
        if (string3 == null) return LookAndFeelTheme.IntelliJ;
        switch (string3.hashCode()) {
            case 634874359: {
                if (!string2.equals("IntelliJ")) return LookAndFeelTheme.IntelliJ;
                return LookAndFeelTheme.IntelliJ;
            }
            case -1280820637: {
                if (!string2.equals("Windows")) return LookAndFeelTheme.IntelliJ;
                return LookAndFeelTheme.Windows;
            }
            case -1188884900: {
                if (!string2.equals("Darcula")) return LookAndFeelTheme.IntelliJ;
                return LookAndFeelTheme.Darcula;
            }
        }
        return LookAndFeelTheme.IntelliJ;
    }

    public final void requestShutdown() {
        Companion.getLogger().debug("Request to shutdown host process " + this.getProtocolHost().getId());
        this.model.getShutdown().fire();
    }

    public ShellHost(@NotNull IProtocolHost protocolHost) {
        Intrinsics.checkParameterIsNotNull((Object)protocolHost, (String)"protocolHost");
        super(protocolHost);
        this.model = RdShellModel.Companion.create(this.getLifetime(), this.getProtocol());
        ApplicationKt.getApplication().invokeLater(new Runnable(){

            @Override
            public final void run() {
                LafManager lafManager = LafManager.getInstance();
                PropertyExKt.set(this.getModel().getLookAndFeelTheme(), this.toLookAndFeelTheme(lafManager));
                this.getModel().getRiderInternalProcesses().view(this.getLifetime(), (Function3<Lifetime, Integer, Integer, Unit>)((Function3)1.INSTANCE));
            }
        });
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(ShellHost.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
        ShellHost.logger = logger;
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/resharper/protocol/components/ShellHost$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "rider"})
    public static final class Companion {
        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

