/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.protocol.components;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.jetbrains.resharper.projectView.SolutionHostExtensionsKt;
import com.jetbrains.resharper.protocol.IProtocolHost;
import com.jetbrains.resharper.protocol.ProtocolComponent;
import com.jetbrains.rider.model.Solution;
import com.jetbrains.rider.model.SolutionModel;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\fJ\u000e\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/resharper/protocol/components/SolutionHost;", "Lcom/jetbrains/resharper/protocol/ProtocolComponent;", "protocolHost", "Lcom/jetbrains/resharper/protocol/IProtocolHost;", "(Lcom/jetbrains/resharper/protocol/IProtocolHost;)V", "idFactory", "Ljava/util/concurrent/atomic/AtomicInteger;", "model", "Lcom/jetbrains/rider/model/SolutionModel;", "getModel", "()Lcom/jetbrains/rider/model/SolutionModel;", "assertReadyForSolution", "", "clear", "set", "solution", "Lcom/jetbrains/rider/model/Solution;", "Companion", "rider"})
public final class SolutionHost
extends ProtocolComponent {
    private final AtomicInteger idFactory;
    @NotNull
    private final SolutionModel model;
    private static final Logger logger;
    @NotNull
    private static final Key<Solution> solutionKey;
    public static final Companion Companion;

    @NotNull
    public final SolutionModel getModel() {
        return this.model;
    }

    public final void set(@NotNull Solution solution) {
        Intrinsics.checkParameterIsNotNull((Object)solution, (String)"solution");
        int id = this.idFactory.incrementAndGet();
        SolutionHost.Companion.getLogger().info("Putting protocol solution...");
        this.model.getSolutions().put(id, solution);
    }

    public final void clear() {
        SolutionHost.Companion.getLogger().info("Clearing protocol solution...");
        this.model.getSolutions().clear();
    }

    public final void assertReadyForSolution() {
        Collection solutions = this.model.getSolutions().values();
        if (!solutions.isEmpty()) {
            Object object = (Solution)CollectionsKt.firstOrNull((Iterable)solutions);
            if (object == null || (object = SolutionHostExtensionsKt.getPath((Solution)object)) == null) {
                object = "EMPTY PATH";
            }
            Object existingSolution = object;
            throw (Throwable)new UnsupportedOperationException("Opening new solution before closing an old one. Current solution: " + (String)existingSolution);
        }
    }

    public SolutionHost(@NotNull IProtocolHost protocolHost) {
        Intrinsics.checkParameterIsNotNull((Object)protocolHost, (String)"protocolHost");
        super(protocolHost);
        this.idFactory = new AtomicInteger(0);
        this.model = SolutionModel.Companion.create(this.getLifetime(), this.getProtocol());
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(SolutionHost.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
        SolutionHost.logger = logger;
        solutionKey = new Key("SolutionKey");
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/jetbrains/resharper/protocol/components/SolutionHost$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "solutionKey", "Lcom/intellij/openapi/util/Key;", "Lcom/jetbrains/rider/model/Solution;", "getSolutionKey", "()Lcom/intellij/openapi/util/Key;", "rider"})
    public static final class Companion {
        private final Logger getLogger() {
            return logger;
        }

        @NotNull
        public final Key<Solution> getSolutionKey() {
            return solutionKey;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

