/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.run.configurations.exe;

import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.util.execution.ParametersListUtil;
import com.jetbrains.resharper.run.configurations.DotNetRunConfigurationBase;
import com.jetbrains.resharper.run.configurations.exe.DotNetExeConfigurationEditor;
import com.jetbrains.resharper.runtime.RiderDotNetActiveRuntimeHost;
import com.jetbrains.rider.model.RunnableProjectKind;
import java.io.File;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 <2\u00020\u0001:\u0001<B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0010\u00100\u001a\u00020\u00172\u0006\u00101\u001a\u000202H\u0016J\b\u00103\u001a\u000204H\u0016J\u0010\u00105\u001a\n\u0012\u0006\b\u0001\u0012\u00020706H\u0016J\u0010\u00108\u001a\u0002042\u0006\u00109\u001a\u00020:H\u0016J\u0010\u0010;\u001a\u0002042\u0006\u00109\u001a\u00020:H\u0016R \u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u0017X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0016\u0010\u001a\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0013R\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00030\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u000fR \u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u001fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0014\u0010\"\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u0013R\u0014\u0010$\u001a\u00020%8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u0014\u0010(\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u0019R\u0014\u0010*\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010\u0019R\u0014\u0010,\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010\u0013R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010\u0013\"\u0004\b/\u0010\u0015\u00a8\u0006="}, d2={"Lcom/jetbrains/resharper/run/configurations/exe/DotNetExeConfiguration;", "Lcom/jetbrains/resharper/run/configurations/DotNetRunConfigurationBase;", "exePath", "", "workingDirectory", "arguments", "", "project", "Lcom/intellij/openapi/project/Project;", "factory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "riderDotNetActiveRuntimeHost", "Lcom/jetbrains/resharper/runtime/RiderDotNetActiveRuntimeHost;", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Lcom/intellij/openapi/project/Project;Lcom/intellij/execution/configurations/ConfigurationFactory;Lcom/jetbrains/resharper/runtime/RiderDotNetActiveRuntimeHost;)V", "getArguments", "()Ljava/util/List;", "setArguments", "(Ljava/util/List;)V", "getExePath", "()Ljava/lang/String;", "setExePath", "(Ljava/lang/String;)V", "executeAsIs", "", "getExecuteAsIs", "()Z", "runtimeArguments", "getRuntimeArguments", "targetArguments", "getTargetArguments", "targetEnvironmentVariables", "", "getTargetEnvironmentVariables", "()Ljava/util/Map;", "targetExecutablePath", "getTargetExecutablePath", "targetProjectKind", "Lcom/jetbrains/rider/model/RunnableProjectKind;", "getTargetProjectKind", "()Lcom/jetbrains/rider/model/RunnableProjectKind;", "targetUseExternalConsole", "getTargetUseExternalConsole", "targetUseMonoRuntime", "getTargetUseMonoRuntime", "targetWorkingDirectory", "getTargetWorkingDirectory", "getWorkingDirectory", "setWorkingDirectory", "canRunOn", "target", "Lcom/intellij/execution/ExecutionTarget;", "checkConfiguration", "", "getConfigurationEditor", "Lcom/intellij/openapi/options/SettingsEditor;", "Lcom/intellij/execution/configurations/RunConfiguration;", "readExternal", "element", "Lorg/jdom/Element;", "writeExternal", "Companion", "rider"})
public final class DotNetExeConfiguration
extends DotNetRunConfigurationBase {
    @NotNull
    private final Map<String, String> targetEnvironmentVariables;
    @Nullable
    private final String runtimeArguments;
    private final boolean executeAsIs = false;
    @NotNull
    private String exePath;
    @NotNull
    private String workingDirectory;
    @NotNull
    private List<String> arguments;
    private static final String exePathElementName = "EXE_PATH";
    private static final String argumentsElementName = "PROGRAM_PARAMETERS";
    private static final String workingDirectoryElementName = "WORKING_DIRECTORY";
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public RunnableProjectKind getTargetProjectKind() {
        return RunnableProjectKind.Console;
    }

    @Override
    @NotNull
    public String getTargetExecutablePath() {
        return this.exePath;
    }

    @Override
    @NotNull
    public String getTargetWorkingDirectory() {
        return this.workingDirectory;
    }

    @Override
    @NotNull
    public List<String> getTargetArguments() {
        return this.arguments;
    }

    @Override
    @NotNull
    public Map<String, String> getTargetEnvironmentVariables() {
        return this.targetEnvironmentVariables;
    }

    @Override
    public boolean getTargetUseMonoRuntime() {
        return false;
    }

    @Override
    public boolean getTargetUseExternalConsole() {
        return false;
    }

    @Override
    @Nullable
    public String getRuntimeArguments() {
        return this.runtimeArguments;
    }

    @Override
    public boolean getExecuteAsIs() {
        return this.executeAsIs;
    }

    public void readExternal(@NotNull Element element) {
        String string2;
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        super.readExternal(element);
        String string3 = JDOMExternalizerUtil.readField((Element)element, (String)DotNetExeConfiguration.Companion.getExePathElementName());
        if (string3 == null) {
            string3 = this.exePath = "";
        }
        if ((string2 = JDOMExternalizerUtil.readField((Element)element, (String)DotNetExeConfiguration.Companion.getWorkingDirectoryElementName())) == null) {
            string2 = "";
        }
        this.workingDirectory = string2;
        String string4 = JDOMExternalizerUtil.readField((Element)element, (String)DotNetExeConfiguration.Companion.getArgumentsElementName());
        if (string4 == null) {
            return;
        }
        String argumentsString = string4;
        List list2 = ParametersListUtil.parse((String)argumentsString);
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"ParametersListUtil.parse(argumentsString)");
        this.arguments = list2;
    }

    public void writeExternal(@NotNull Element element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        super.writeExternal(element);
        JDOMExternalizerUtil.writeField((Element)element, (String)DotNetExeConfiguration.Companion.getExePathElementName(), (String)this.exePath);
        JDOMExternalizerUtil.writeField((Element)element, (String)DotNetExeConfiguration.Companion.getWorkingDirectoryElementName(), (String)this.workingDirectory);
        String argumentsString = ParametersListUtil.join(this.getTargetArguments());
        JDOMExternalizerUtil.writeField((Element)element, (String)DotNetExeConfiguration.Companion.getArgumentsElementName(), (String)argumentsString);
    }

    public void checkConfiguration() {
        if (!new File(this.exePath).exists()) {
            throw (Throwable)new RuntimeConfigurationException("Invalid exe path");
        }
        if (!new File(this.workingDirectory).exists()) {
            throw (Throwable)new RuntimeConfigurationException("Invalid working directory");
        }
    }

    public boolean canRunOn(@NotNull ExecutionTarget target) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        return this.getRiderDotNetActiveRuntimeHost().getCurrentDotNetRuntime(this.getTargetUseMonoRuntime()) != null;
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        Project project2 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        return new DotNetExeConfigurationEditor(project2);
    }

    @NotNull
    public final String getExePath() {
        return this.exePath;
    }

    public final void setExePath(@NotNull String string2) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"<set-?>");
        this.exePath = string2;
    }

    @NotNull
    public final String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public final void setWorkingDirectory(@NotNull String string2) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"<set-?>");
        this.workingDirectory = string2;
    }

    @NotNull
    public final List<String> getArguments() {
        return this.arguments;
    }

    public final void setArguments(@NotNull List<String> list2) {
        Intrinsics.checkParameterIsNotNull(list2, (String)"<set-?>");
        this.arguments = list2;
    }

    public DotNetExeConfiguration(@NotNull String exePath, @NotNull String workingDirectory, @NotNull List<String> arguments, @NotNull Project project2, @NotNull ConfigurationFactory factory2, @NotNull RiderDotNetActiveRuntimeHost riderDotNetActiveRuntimeHost) {
        Map map2;
        Intrinsics.checkParameterIsNotNull((Object)exePath, (String)"exePath");
        Intrinsics.checkParameterIsNotNull((Object)workingDirectory, (String)"workingDirectory");
        Intrinsics.checkParameterIsNotNull(arguments, (String)"arguments");
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)factory2, (String)"factory");
        Intrinsics.checkParameterIsNotNull((Object)riderDotNetActiveRuntimeHost, (String)"riderDotNetActiveRuntimeHost");
        super("DotNetExecutable", project2, factory2, riderDotNetActiveRuntimeHost);
        this.exePath = exePath;
        this.workingDirectory = workingDirectory;
        this.arguments = arguments;
        DotNetExeConfiguration dotNetExeConfiguration = this;
        dotNetExeConfiguration.targetEnvironmentVariables = map2 = MapsKt.emptyMap();
    }

    static {
        exePathElementName = exePathElementName;
        argumentsElementName = argumentsElementName;
        workingDirectoryElementName = workingDirectoryElementName;
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/resharper/run/configurations/exe/DotNetExeConfiguration$Companion;", "", "()V", "argumentsElementName", "", "getArgumentsElementName", "()Ljava/lang/String;", "exePathElementName", "getExePathElementName", "workingDirectoryElementName", "getWorkingDirectoryElementName", "rider"})
    public static final class Companion {
        private final String getExePathElementName() {
            return exePathElementName;
        }

        private final String getArgumentsElementName() {
            return argumentsElementName;
        }

        private final String getWorkingDirectoryElementName() {
            return workingDirectoryElementName;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

