/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.run.configurations.project;

import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.ListCellRendererWrapper;
import com.jetbrains.resharper.icons.IconHost;
import com.jetbrains.resharper.protocol.IPermittedModalities;
import com.jetbrains.resharper.run.configurations.project.DotNetProjectConfigurationFormLayout;
import com.jetbrains.resharper.run.configurations.project.DotNetProjectConfigurationViewModel;
import com.jetbrains.rider.model.Icon;
import com.jetbrains.rider.model.ProjectOutput;
import com.jetbrains.rider.model.RunnableProject;
import com.jetbrains.rider.util.lifetime.Lifetime;
import com.jetbrains.rider.util.reactive.IProperty;
import com.jetbrains.rider.util.reactive.PropertyExKt;
import com.jetbrains.rider.util.reactive.ViewableCollectionExtensionsKt;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\r\u001a\u00020\u000eJ,\u0010\u000f\u001a\u00020\u0010*\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u00112\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/resharper/run/configurations/project/DotNetProjectConfigurationForm;", "Lcom/jetbrains/resharper/run/configurations/project/DotNetProjectConfigurationFormLayout;", "lifetime", "Lcom/jetbrains/rider/util/lifetime/Lifetime;", "project", "Lcom/intellij/openapi/project/Project;", "viewModel", "Lcom/jetbrains/resharper/run/configurations/project/DotNetProjectConfigurationViewModel;", "iconHost", "Lcom/jetbrains/resharper/icons/IconHost;", "(Lcom/jetbrains/rider/util/lifetime/Lifetime;Lcom/intellij/openapi/project/Project;Lcom/jetbrains/resharper/run/configurations/project/DotNetProjectConfigurationViewModel;Lcom/jetbrains/resharper/icons/IconHost;)V", "getViewModel", "()Lcom/jetbrains/resharper/run/configurations/project/DotNetProjectConfigurationViewModel;", "getPanel", "Ljavax/swing/JComponent;", "containsAll", "", "", "", "map", "rider"})
public final class DotNetProjectConfigurationForm
extends DotNetProjectConfigurationFormLayout {
    private final Lifetime lifetime;
    @NotNull
    private final DotNetProjectConfigurationViewModel viewModel;

    @NotNull
    public final JComponent getPanel() {
        IPermittedModalities.Companion.getInstance().allowPumpProtocolUnderCurrentModality();
        JPanel jPanel = this.rootPanel;
        Intrinsics.checkExpressionValueIsNotNull((Object)jPanel, (String)"rootPanel");
        return jPanel;
    }

    private final boolean containsAll(@NotNull Map<String, String> $receiver, Map<String, String> map2) {
        boolean bl;
        block2: {
            if ($receiver.size() != map2.size()) {
                return false;
            }
            Iterable $receiver$iv = $receiver.keySet();
            for (Object element$iv : $receiver$iv) {
                String it = (String)element$iv;
                if (!(Intrinsics.areEqual((Object)$receiver.get(it), (Object)map2.get(it)) ^ true)) continue;
                bl = false;
                break block2;
            }
            bl = true;
        }
        return bl;
    }

    @NotNull
    public final DotNetProjectConfigurationViewModel getViewModel() {
        return this.viewModel;
    }

    public DotNetProjectConfigurationForm(@NotNull Lifetime lifetime, @NotNull Project project2, @NotNull DotNetProjectConfigurationViewModel viewModel, final @NotNull IconHost iconHost) {
        Intrinsics.checkParameterIsNotNull((Object)lifetime, (String)"lifetime");
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)viewModel, (String)"viewModel");
        Intrinsics.checkParameterIsNotNull((Object)iconHost, (String)"iconHost");
        this.lifetime = lifetime;
        this.viewModel = viewModel;
        this.projectEditor.setRenderer((ListCellRenderer)new ListCellRendererWrapper<Object>(){

            public void customize(@Nullable JList<?> list2, @Nullable Object valueRaw, int index, boolean selected, boolean hasFocus) {
                RunnableProject value2;
                Object object = valueRaw;
                if (!(object instanceof RunnableProject)) {
                    object = null;
                }
                if ((value2 = (RunnableProject)object) == null) {
                    this.setText("No projects to run");
                    return;
                }
                Icon icon = value2.getIcon();
                if (icon != null) {
                    this.setIcon(iconHost.toIdeaIcon(icon));
                }
                this.setText(value2.getFullName());
            }
        });
        ViewableCollectionExtensionsKt.bind(this.viewModel.getRunnableProjects(), this.lifetime, (Function1)new Function1<RunnableProject, Unit>(){

            public final void invoke(@NotNull RunnableProject project2) {
                Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
                if (projectEditor.getItemCount() == 0) {
                    projectEditor.addItem(project2);
                    projectEditor.setSelectedIndex(-1);
                } else {
                    projectEditor.addItem(project2);
                }
            }
        }, (Function1)new Function1<RunnableProject, Unit>(){

            public final void invoke(@NotNull RunnableProject project2) {
                Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
                projectEditor.removeItem(project2);
            }
        });
        PropertyExKt.bind(this.viewModel.isProjectsSelectionEnabled(), this.lifetime, (Function1)new Function1<Boolean, Unit>(){

            public final void invoke(boolean it) {
                if (it) {
                    projectEditor.setEnabled(true);
                    PropertyExKt.bind(this.getViewModel().getSelectedProject(), lifetime, (Function1)new Function1<RunnableProject, Unit>(){

                        public final void invoke(final @Nullable RunnableProject it) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public final void run() {
                                    projectEditor.setSelectedItem(it);
                                }
                            });
                        }
                    }, (Function1)new Function1<Function1<? super RunnableProject, ? extends Unit>, Unit>(){

                        public final void invoke(final @NotNull Function1<? super RunnableProject, Unit> it) {
                            Intrinsics.checkParameterIsNotNull(it, (String)"it");
                            projectEditor.addItemListener(new ItemListener(){

                                @Override
                                public final void itemStateChanged(ItemEvent it2) {
                                    it.invoke((Object)((RunnableProject)projectEditor.getSelectedItem()));
                                }
                            });
                        }
                    });
                }
            }
        }, 5.INSTANCE);
        ViewableCollectionExtensionsKt.bind(this.viewModel.getProjectOutputs(), this.lifetime, (Function1)new Function1<ProjectOutput, Unit>(){

            public final void invoke(@NotNull ProjectOutput $tfm) {
                Intrinsics.checkParameterIsNotNull((Object)$tfm, (String)"<name for destructuring parameter 0>");
                String tfm = $tfm.component1();
                projectTfmEditor.addItem(tfm);
            }
        }, (Function1)new Function1<ProjectOutput, Unit>(){

            public final void invoke(@NotNull ProjectOutput $tfm) {
                Intrinsics.checkParameterIsNotNull((Object)$tfm, (String)"<name for destructuring parameter 0>");
                String tfm = $tfm.component1();
                projectTfmEditor.removeItem(tfm);
            }
        });
        PropertyExKt.bind(this.viewModel.getProjectTfmSelectionEnabled(), this.lifetime, (Function1)new Function1<Boolean, Unit>(){

            public final void invoke(boolean it) {
                if (it) {
                    projectTfmEditor.setEnabled(true);
                    PropertyExKt.bind(this.getViewModel().getSelectedTfm(), lifetime, (Function1)new Function1<String, Unit>(){

                        public final void invoke(final @NotNull String it) {
                            Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public final void run() {
                                    projectTfmEditor.setSelectedItem(it);
                                }
                            });
                        }
                    }, (Function1)new Function1<Function1<? super String, ? extends Unit>, Unit>(){

                        public final void invoke(final @NotNull Function1<? super String, Unit> it) {
                            Intrinsics.checkParameterIsNotNull(it, (String)"it");
                            projectTfmEditor.addItemListener(new ItemListener(){

                                @Override
                                public final void itemStateChanged(ItemEvent it2) {
                                    String string2 = (String)projectTfmEditor.getSelectedItem();
                                    if (string2 == null) {
                                        string2 = "";
                                    }
                                    it.invoke((Object)string2);
                                }
                            });
                        }
                    });
                }
            }
        }, 9.INSTANCE);
        PropertyExKt.bind(this.viewModel.getExePath(), this.lifetime, (Function1)new Function1<String, Unit>(){

            public final void invoke(@NotNull String it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                exePathEditor.setText(it);
            }
        }, 11.INSTANCE);
        PropertyExKt.bind(this.viewModel.isEditableArguments(), this.lifetime, (Function1)new Function1<Boolean, Unit>(){

            public final void invoke(boolean it) {
                argumentsEditor.setEnabled(it);
            }
        }, 13.INSTANCE);
        PropertyExKt.bind(this.viewModel.getArgumentsString(), this.lifetime, (Function1)new Function1<String, Unit>(){

            public final void invoke(@NotNull String it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                argumentsEditor.setText(it);
            }
        }, (Function1)new Function1<Function1<? super String, ? extends Unit>, Unit>(){

            public final void invoke(final @NotNull Function1<? super String, Unit> it) {
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                argumentsEditor.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                    protected void textChanged(@Nullable DocumentEvent e2) {
                        String string2 = argumentsEditor.getText();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"argumentsEditor.text");
                        it.invoke((Object)string2);
                    }
                });
            }
        });
        PropertyExKt.bind(this.viewModel.isEditableWorkingDirectory(), this.lifetime, (Function1)new Function1<Boolean, Unit>(){

            public final void invoke(boolean it) {
                workingDirectoryEditor.setEnabled(it);
            }
        }, 17.INSTANCE);
        PropertyExKt.bind(this.viewModel.getWorkingDirectory(), this.lifetime, (Function1)new Function1<String, Unit>(){

            public final void invoke(@NotNull String it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                workingDirectoryEditor.setText(it);
            }
        }, (Function1)new Function1<Function1<? super String, ? extends Unit>, Unit>(){

            public final void invoke(final @NotNull Function1<? super String, Unit> it) {
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                workingDirectoryEditor.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                    protected void textChanged(@Nullable DocumentEvent e2) {
                        String string2 = workingDirectoryEditor.getText();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"workingDirectoryEditor.text");
                        it.invoke((Object)string2);
                    }
                });
            }
        });
        this.workingDirectoryEditor.addBrowseFolderListener("Working Directory", "Select working directory", project2, FileChooserDescriptorFactory.createSingleFolderDescriptor());
        PropertyExKt.bind(this.viewModel.getEnvironmentVariables(), this.lifetime, (Function1)new Function1<Map<String, ? extends String>, Unit>(){

            public final void invoke(final @NotNull Map<String, String> it) {
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public final void run() {
                        environmentVariables.setEnvs(it);
                    }
                });
            }
        }, (Function1)new Function1<Function1<? super Map<String, ? extends String>, ? extends Unit>, Unit>(){

            public final void invoke(@NotNull Function1<? super Map<String, String>, Unit> it) {
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                environmentVariables.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                    protected void textChanged(@Nullable DocumentEvent e2) {
                        DotNetProjectConfigurationForm dotNetProjectConfigurationForm = this;
                        Map<String, String> map2 = environmentVariables.getEnvs();
                        Intrinsics.checkExpressionValueIsNotNull(map2, (String)"environmentVariables.envs");
                        if (!dotNetProjectConfigurationForm.containsAll(this.getViewModel().getEnvironmentVariables().getValue(), map2)) {
                            IProperty<Map<String, String>> iProperty = this.getViewModel().getEnvironmentVariables();
                            Map<String, String> map3 = environmentVariables.getEnvs();
                            Intrinsics.checkExpressionValueIsNotNull(map3, (String)"environmentVariables.envs");
                            PropertyExKt.set(iProperty, map3);
                        }
                    }
                });
            }
        });
        this.viewModel.isMonoAvailable().advise(this.lifetime, (Function1<Boolean, Unit>)((Function1)new Function1<Boolean, Unit>(){

            public final void invoke(boolean it) {
                if (SystemInfo.isWindows) {
                    useMonoRuntime.setVisible(it);
                    useMonoRuntime.setSelected(this.getViewModel().getUseMonoRuntime().getValue());
                } else {
                    useMonoRuntime.setVisible(false);
                }
            }
        }));
        this.useMonoRuntime.addItemListener(new ItemListener(){

            @Override
            public final void itemStateChanged(ItemEvent it) {
                Object object;
                Object checkBox2 = it.getItem();
                PropertyExKt.set(this.getViewModel().getUseMonoRuntime(), (object = checkBox2) instanceof JCheckBox ? ((JCheckBox)checkBox2).isSelected() : false);
            }
        });
        this.viewModel.getUseMonoRuntime().advise(this.lifetime, (Function1<Boolean, Unit>)((Function1)new Function1<Boolean, Unit>(){

            public final void invoke(boolean it) {
                useMonoRuntime.setSelected(this.getViewModel().getUseMonoRuntime().getValue());
            }
        }));
        this.viewModel.isExternalConsoleAvailable().advise(this.lifetime, (Function1<Boolean, Unit>)((Function1)new Function1<Boolean, Unit>(){

            public final void invoke(boolean it) {
                useExternalConsole.setVisible(it);
            }
        }));
        this.useExternalConsole.addItemListener(new ItemListener(){

            @Override
            public final void itemStateChanged(ItemEvent it) {
                Object object;
                Object checkBox2 = it.getItem();
                PropertyExKt.set(this.getViewModel().getUseExternalConsole(), (object = checkBox2) instanceof JCheckBox ? ((JCheckBox)checkBox2).isSelected() : false);
            }
        });
        this.viewModel.getUseExternalConsole().advise(this.lifetime, (Function1<Boolean, Unit>)((Function1)new Function1<Boolean, Unit>(){

            public final void invoke(boolean it) {
                useExternalConsole.setSelected(it);
            }
        }));
    }
}

