/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.run.configurations.xamarin.ios.connectDialogs;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.JBUI;
import com.jetbrains.resharper.run.configurations.xamarin.ios.XamarinIOSConnectionSessionHost;
import com.jetbrains.resharper.run.configurations.xamarin.ios.connectDialogs.XamarinConnectionHelperDialogsKt;
import com.jetbrains.resharper.run.configurations.xamarin.ios.connectDialogs.XamarinServerListModel;
import com.jetbrains.resharper.run.configurations.xamarin.ios.connectDialogs.servers.XamarinAgent;
import com.jetbrains.resharper.run.configurations.xamarin.ios.connectDialogs.servers.XamarinLocalAgent;
import com.jetbrains.resharper.run.xamarin.ios.sessions.XamarinIOSSessionHandler;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XamarinConnectToServerDialog
extends DialogWrapper {
    private JBList hostsList;
    private JScrollPane serversPane;
    private JPanel panel;
    private JButton connectButton;
    private JButton closeButton;
    private XamarinServerListModel macAgentListModel;
    private Project project;

    public XamarinConnectToServerDialog(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/resharper/run/configurations/xamarin/ios/connectDialogs/XamarinConnectToServerDialog", "<init>"));
        }
        super(project2);
        this.project = project2;
        this.$$$setupUI$$$();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.panel;
    }

    private void createUIComponents() {
        this.hostsList = new JBList();
        final XamarinIOSConnectionSessionHost connectionSessionHost = (XamarinIOSConnectionSessionHost)this.project.getComponent(XamarinIOSConnectionSessionHost.class);
        this.macAgentListModel = new XamarinServerListModel(connectionSessionHost);
        this.hostsList.setModel((ListModel)this.macAgentListModel);
        this.hostsList.setCellRenderer((ListCellRenderer)new ColoredListCellRenderer<XamarinAgent>(){

            protected void customizeCellRenderer(@NotNull JList<? extends XamarinAgent> list2, XamarinAgent value2, int index, boolean selected, boolean hasFocus) {
                if (list2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/jetbrains/resharper/run/configurations/xamarin/ios/connectDialogs/XamarinConnectToServerDialog$1", "customizeCellRenderer"));
                }
                if (value2 == null) {
                    return;
                }
                XamarinIOSSessionHandler activeSessionHandler = connectionSessionHost.getActiveConnectionSessionHandler().getValue();
                this.append(value2.getHostName() + " ");
                if (value2.isActive()) {
                    String message2 = "Connected";
                    if (activeSessionHandler != null && !activeSessionHandler.getHostUserName().isEmpty()) {
                        message2 = message2 + " (" + activeSessionHandler.getHostUserName() + ")";
                    }
                    this.append(message2, new SimpleTextAttributes(1, Color.GREEN));
                } else {
                    this.append(value2.getDescription(), SimpleTextAttributes.GRAYED_ATTRIBUTES);
                }
            }
        });
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator((JList)this.hostsList);
        decorator.setAddAction(anActionButton -> {
            DialogWrapper dialog2 = XamarinConnectionHelperDialogsKt.getNewHostAddressDialog(this.panel, this.project, (Function1<? super String, Unit>)((Function1)hostAddress -> {
                this.onHostAdded((String)hostAddress);
                return Unit.INSTANCE;
            }));
            dialog2.show();
        });
        decorator.setRemoveAction(anActionButton -> {
            this.setErrorText(null);
            XamarinAgent selectedAgent = (XamarinAgent)this.hostsList.getSelectedValue();
            if (selectedAgent != null && selectedAgent.isActive()) {
                selectedAgent.disconnect();
                this.macAgentListModel.refresh();
                this.connectButton.setText("Connect");
            }
            this.macAgentListModel.removeHost(this.hostsList.getSelectedIndex());
        });
        decorator.setMoveUpAction(anActionButton -> {
            int index = this.hostsList.getSelectedIndex();
            if (index <= 0) {
                return;
            }
            this.hostsList.setSelectedIndex(index - 1);
        });
        decorator.setMoveDownAction(anActionButton -> {
            int index = this.hostsList.getSelectedIndex();
            if (index < 0 || index >= this.hostsList.getItemsCount() - 1) {
                return;
            }
            this.hostsList.setSelectedIndex(index + 1);
        });
        this.serversPane = ScrollPaneFactory.createScrollPane((Component)decorator.createPanel());
        this.setTitle("Xamarin Mac Agent");
        this.hostsList.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e2) {
                if (e2.getClickCount() == 2) {
                    int index = XamarinConnectToServerDialog.this.hostsList.locationToIndex(e2.getPoint());
                    XamarinConnectToServerDialog.this.onHostChosen(XamarinConnectToServerDialog.this.macAgentListModel.getElementAt(index));
                }
            }

            @Override
            public void mousePressed(MouseEvent e2) {
            }

            @Override
            public void mouseReleased(MouseEvent e2) {
            }

            @Override
            public void mouseEntered(MouseEvent e2) {
            }

            @Override
            public void mouseExited(MouseEvent e2) {
            }
        });
        this.hostsList.addListSelectionListener(e2 -> {
            List values = ((JList)e2.getSource()).getSelectedValuesList();
            XamarinAgent selected = values.size() > 0 ? (XamarinAgent)values.get(0) : null;
            this.connectButton.setEnabled(selected != null && (!selected.isActive() || !(selected instanceof XamarinLocalAgent)));
            this.connectButton.setText(selected != null && selected.isActive() ? "Disconnect" : "Connect");
        });
    }

    private void onHostChosen(@Nullable XamarinAgent host) {
        this.setErrorText(null);
        if (host == null) {
            return;
        }
        if (!host.tryConnect()) {
            this.setErrorText("Failed to connect to Agent");
        } else {
            this.macAgentListModel.refresh();
            this.connectButton.setText("Disconnect");
        }
    }

    private void onHostAdded(String hostName) {
        this.setErrorText(null);
        this.macAgentListModel.addHost(hostName);
    }

    public void show() {
        this.init();
        try {
            JButton okButton = this.getButton(this.getOKAction());
            if (okButton != null) {
                okButton.setVisible(false);
            }
        }
        catch (NullPointerException okButton) {
            // empty catch block
        }
        try {
            JButton cancelButton = this.getButton(this.getCancelAction());
            if (cancelButton != null) {
                cancelButton.setVisible(false);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.connectButton.addActionListener(e2 -> {
            Object selected = this.hostsList.getSelectedValue();
            if (selected == null || !(selected instanceof XamarinAgent)) {
                return;
            }
            XamarinAgent selectedAgent = (XamarinAgent)selected;
            if (selectedAgent.isActive()) {
                selectedAgent.disconnect();
                this.macAgentListModel.refresh();
                this.connectButton.setText("Connect");
                return;
            }
            this.onHostChosen(selectedAgent);
        });
        this.closeButton.addActionListener(e2 -> this.close(1));
        this.connectButton.setEnabled(false);
        this.panel.setPreferredSize((Dimension)JBUI.size((int)300, (int)200));
        super.show();
    }

    @NotNull
    protected JButton createHelpButton(Insets insets) {
        JButton button = super.createHelpButton(insets);
        button.setVisible(false);
        JButton jButton = button;
        if (jButton == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/resharper/run/configurations/xamarin/ios/connectDialogs/XamarinConnectToServerDialog", "createHelpButton"));
        }
        return jButton;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JButton jButton2;
        JPanel jPanel;
        this.createUIComponents();
        this.panel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JScrollPane jScrollPane = this.serversPane;
        jPanel.add((Component)jScrollPane, new GridConstraints(0, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        this.connectButton = jButton2 = new JButton();
        jButton2.setText("Connect");
        jPanel.add((Component)jButton2, new GridConstraints(1, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.closeButton = jButton = new JButton();
        jButton.setText("Close");
        jPanel.add((Component)jButton, new GridConstraints(1, 2, 1, 1, 4, 0, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.panel;
    }
}

