/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.run.configurations.xamarin.mac;

import com.intellij.execution.CantRunException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.jetbrains.resharper.projectView.SolutionHostExtensionsKt;
import com.jetbrains.resharper.run.IDotNetExecutableRunProfile;
import com.jetbrains.resharper.run.configurations.xamarin.XamarinConfiguration;
import com.jetbrains.resharper.run.configurations.xamarin.mac.XamarinMacConfigurationEditor;
import com.jetbrains.resharper.run.xamarin.ios.XamarinIOSIcons;
import com.jetbrains.resharper.run.xamarin.mac.XamarinMacDebugProfileState;
import com.jetbrains.resharper.run.xamarin.mac.XamarinMacRunProfileState;
import com.jetbrains.rider.model.ProjectOutput;
import com.jetbrains.rider.model.RunnableProject;
import com.jetbrains.rider.model.RunnableProjectKind;
import com.jetbrains.rider.model.XamarinMacRunnableProjectsModel;
import com.jetbrains.rider.util.NetUtils;
import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J\n\u0010\u0013\u001a\u0004\u0018\u00010\u0003H\u0002J\u0010\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160\u0015H\u0016J\n\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u001a\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006 "}, d2={"Lcom/jetbrains/resharper/run/configurations/xamarin/mac/XamarinMacConfiguration;", "Lcom/jetbrains/resharper/run/configurations/xamarin/XamarinConfiguration;", "name", "", "project", "Lcom/intellij/openapi/project/Project;", "factory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "(Ljava/lang/String;Lcom/intellij/openapi/project/Project;Lcom/intellij/execution/configurations/ConfigurationFactory;)V", "runnableProjectsModel", "Lcom/jetbrains/rider/model/XamarinMacRunnableProjectsModel;", "getRunnableProjectsModel", "()Lcom/jetbrains/rider/model/XamarinMacRunnableProjectsModel;", "targetProjectKind", "Lcom/jetbrains/rider/model/RunnableProjectKind;", "getTargetProjectKind", "()Lcom/jetbrains/rider/model/RunnableProjectKind;", "checkIsValid", "", "getAppIdentifier", "getConfigurationEditor", "Lcom/intellij/openapi/options/SettingsEditor;", "Lcom/intellij/execution/configurations/RunConfiguration;", "getIcon", "Ljavax/swing/Icon;", "getInfoElementByName", "getState", "Lcom/intellij/execution/configurations/RunProfileState;", "executor", "Lcom/intellij/execution/Executor;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "rider"})
public final class XamarinMacConfiguration
extends XamarinConfiguration {
    @NotNull
    private final XamarinMacRunnableProjectsModel runnableProjectsModel;

    @Override
    @NotNull
    public XamarinMacRunnableProjectsModel getRunnableProjectsModel() {
        return this.runnableProjectsModel;
    }

    @Override
    @NotNull
    public RunnableProjectKind getTargetProjectKind() {
        RunnableProject runnableProject = this.tryGetRunnableProject();
        if (runnableProject == null) {
            return RunnableProjectKind.None;
        }
        RunnableProject project2 = runnableProject;
        return project2.getKind();
    }

    @Override
    @Nullable
    public RunProfileState getState(@NotNull Executor executor2, @NotNull ExecutionEnvironment environment) {
        Intrinsics.checkParameterIsNotNull((Object)executor2, (String)"executor");
        Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
        RunnableProject runnableProject = this.tryGetRunnableProject();
        if (runnableProject == null) {
            return null;
        }
        RunnableProject project2 = runnableProject;
        String string2 = this.getAppIdentifier();
        if (string2 == null) {
            throw (Throwable)new CantRunException("CFBundleName is unknown");
        }
        String appIdentifier = string2;
        Object object = (ProjectOutput)CollectionsKt.firstOrNull(project2.getProjectOutputs());
        if (object == null || (object = ((ProjectOutput)object).getWorkingDirectory()) == null) {
            return null;
        }
        Object projectBinDirectory = object;
        File possibleExecutableFile = Paths.get((String)projectBinDirectory, appIdentifier + ".app", "Contents", "MacOS", appIdentifier).toFile();
        if (Intrinsics.areEqual((Object)executor2.getId(), (Object)DefaultDebugExecutor.EXECUTOR_ID)) {
            IDotNetExecutableRunProfile iDotNetExecutableRunProfile = this;
            int n2 = NetUtils.INSTANCE.findFreePort(8765);
            String string3 = possibleExecutableFile.getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"possibleExecutableFile.path");
            return new XamarinMacDebugProfileState(iDotNetExecutableRunProfile, n2, environment, string3);
        }
        if (Intrinsics.areEqual((Object)executor2.getId(), (Object)DefaultRunExecutor.EXECUTOR_ID)) {
            String string4 = possibleExecutableFile.getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"possibleExecutableFile.path");
            return new XamarinMacRunProfileState(this, environment, string4);
        }
        return null;
    }

    @Nullable
    public Icon getIcon() {
        return XamarinIOSIcons.INSTANCE.getIOS();
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        Project project2 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        return new XamarinMacConfigurationEditor(project2);
    }

    private final String getAppIdentifier() {
        return this.getInfoElementByName("CFBundleName");
    }

    /*
     * WARNING - void declaration
     */
    private final String getInfoElementByName(String name) {
        Node bundleIdentifierMarkerNode;
        Node bundleIdenitifierNode;
        Object v1;
        block7: {
            void $receiver$iv$iv;
            RunnableProject runnableProject = this.tryGetRunnableProject();
            if (runnableProject == null) {
                return null;
            }
            RunnableProject runnableProject2 = runnableProject;
            File infoFile = Paths.get(new File(runnableProject2.getProjectFilePath()).getParent(), "Info.plist").toFile();
            if (!infoFile.exists() || !infoFile.isFile()) {
                return null;
            }
            DocumentBuilderFactory factory2 = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory2.newDocumentBuilder();
            Document document = builder.parse(infoFile);
            NodeList elements = document.getElementsByTagName("key");
            Iterable $receiver$iv = (Iterable)new IntRange(0, elements.getLength() - 1);
            Iterable iterable = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            void $receiver$iv$iv$iv = $receiver$iv$iv;
            Iterator iterator2 = $receiver$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Node node;
                int element$iv$iv$iv = ((IntIterator)iterator2).nextInt();
                int element$iv$iv = element$iv$iv$iv;
                int it = element$iv$iv;
                if (elements.item(it) == null) continue;
                Node it$iv$iv = node;
                destination$iv$iv.add(it$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            for (Object element$iv : $receiver$iv) {
                Node it = (Node)element$iv;
                if (!Intrinsics.areEqual((Object)it.getTextContent(), (Object)name)) continue;
                v1 = element$iv;
                break block7;
            }
            v1 = null;
        }
        if ((Node)v1 == null) {
            return null;
        }
        for (bundleIdenitifierNode = bundleIdentifierMarkerNode = (v3112555); bundleIdenitifierNode != null && Intrinsics.areEqual((Object)bundleIdenitifierNode.getNodeName(), (Object)"string") ^ true; bundleIdenitifierNode = bundleIdenitifierNode.getNextSibling()) {
        }
        if (bundleIdenitifierNode == null || !(bundleIdenitifierNode instanceof Element)) {
            return null;
        }
        return ((Element)bundleIdenitifierNode).getTextContent();
    }

    @Override
    public void checkIsValid() {
        if (!SystemInfo.isMac) {
            throw (Throwable)new CantRunException("Cannot run application on this system");
        }
        String string2 = this.getInfoElementByName("LSMinimumSystemVersion");
        if (string2 == null) {
            return;
        }
        String minimumOSVersion = string2;
        if (!SystemInfo.isOsVersionAtLeast((String)minimumOSVersion)) {
            throw (Throwable)new CantRunException("Application requires at least OS X version " + minimumOSVersion + ", but being run on " + SystemInfo.OS_VERSION);
        }
    }

    public XamarinMacConfiguration(@NotNull String name, @NotNull Project project2, @NotNull ConfigurationFactory factory2) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)factory2, (String)"factory");
        super(name, project2, factory2);
        this.runnableProjectsModel = SolutionHostExtensionsKt.getSolution(project2).getXamarinMacRunnableProjectsModel();
    }
}

