/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.run.dotNetCore;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.util.execution.ParametersListUtil;
import com.jetbrains.resharper.debugger.DebuggerHelperHost;
import com.jetbrains.resharper.debugger.DebuggerWorkerPlatform;
import com.jetbrains.resharper.projectView.SolutionHostExtensionsKt;
import com.jetbrains.resharper.run.DebugProfileStateBase;
import com.jetbrains.resharper.run.IDotNetDebugProfileState;
import com.jetbrains.resharper.run.IDotNetExecutableRunProfile;
import com.jetbrains.resharper.run.ModelUtilKt;
import com.jetbrains.rider.framework.impl.IRdCall;
import com.jetbrains.rider.framework.impl.RdTaskResult;
import com.jetbrains.rider.model.debuggerWorker.DebuggerStartInfoBase;
import com.jetbrains.rider.model.debuggerWorker.DotNetCoreExeStartInfo;
import com.jetbrains.rider.util.lifetime.Lifetime;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J&\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016R\u0014\u0010\t\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\""}, d2={"Lcom/jetbrains/resharper/run/dotNetCore/DotNetCoreDebugProfile;", "Lcom/jetbrains/resharper/run/DebugProfileStateBase;", "configuration", "Lcom/jetbrains/resharper/run/IDotNetExecutableRunProfile;", "executionEnvironment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "currentDotNetCliExePath", "", "(Lcom/jetbrains/resharper/run/IDotNetExecutableRunProfile;Lcom/intellij/execution/runners/ExecutionEnvironment;Ljava/lang/String;)V", "attached", "", "getAttached", "()Z", "getConfiguration", "()Lcom/jetbrains/resharper/run/IDotNetExecutableRunProfile;", "consoleKind", "Lcom/jetbrains/resharper/run/IDotNetDebugProfileState$ConsoleKind;", "getConsoleKind", "()Lcom/jetbrains/resharper/run/IDotNetDebugProfileState$ConsoleKind;", "getCurrentDotNetCliExePath", "()Ljava/lang/String;", "checkBeforeExecution", "", "createModelStartInfo", "Lcom/jetbrains/rider/model/debuggerWorker/DebuggerStartInfoBase;", "createWorkerRunCmd", "Lorg/jetbrains/concurrency/Promise;", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "lifetime", "Lcom/jetbrains/rider/util/lifetime/Lifetime;", "helper", "Lcom/jetbrains/resharper/debugger/DebuggerHelperHost;", "port", "", "rider"})
public final class DotNetCoreDebugProfile
extends DebugProfileStateBase {
    @NotNull
    private final IDotNetDebugProfileState.ConsoleKind consoleKind;
    private final boolean attached = false;
    @NotNull
    private final IDotNetExecutableRunProfile configuration;
    @NotNull
    private final String currentDotNetCliExePath;

    @Override
    @NotNull
    public Promise<GeneralCommandLine> createWorkerRunCmd(@NotNull Lifetime lifetime, @NotNull DebuggerHelperHost helper, int port) {
        String string2;
        Intrinsics.checkParameterIsNotNull((Object)lifetime, (String)"lifetime");
        Intrinsics.checkParameterIsNotNull((Object)helper, (String)"helper");
        AsyncPromise cmdPromise = new AsyncPromise();
        if (this.configuration.getExecuteAsIs()) {
            string2 = this.configuration.getAssemblyToDebug();
            if (string2 == null) {
                throw (Throwable)new IllegalStateException("assemblyToDebug is not specified");
            }
        } else {
            string2 = this.configuration.getTargetExecutablePath();
        }
        String assemblyPath = string2;
        IRdCall.DefaultImpls.start$default(SolutionHostExtensionsKt.getSolution(this.getExecutionEnvironment().getProject()).getDebuggerWorkerConnectionHelper().getGetDbgShimPath(), assemblyPath, null, 2, null).getResult().advise(lifetime, (Function1)new Function1<RdTaskResult<? extends String>, Unit>(cmdPromise, port){
            final /* synthetic */ AsyncPromise $cmdPromise;
            final /* synthetic */ int $port;

            public final void invoke(@NotNull RdTaskResult<String> it) {
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                RdTaskResult<String> rdTaskResult = it;
                if (rdTaskResult instanceof RdTaskResult.Success) {
                    this.$cmdPromise.setResult((Object)DebugProfileStateBase.Companion.createWorkerCmdFor(this.$port, DebuggerWorkerPlatform.AnyCpu, (String)((RdTaskResult.Success)it).getValue()));
                } else if (rdTaskResult instanceof RdTaskResult.Fault) {
                    this.$cmdPromise.setError(((RdTaskResult.Fault)it).getError());
                }
            }
            {
                this.$cmdPromise = asyncPromise;
                this.$port = n2;
                super(1);
            }
        });
        return (Promise)cmdPromise;
    }

    @Override
    @NotNull
    public IDotNetDebugProfileState.ConsoleKind getConsoleKind() {
        return this.consoleKind;
    }

    @Override
    public void checkBeforeExecution() {
        this.configuration.checkIsValid();
    }

    @Override
    @NotNull
    public DebuggerStartInfoBase createModelStartInfo() {
        boolean bl = this.configuration.getTargetUseExternalConsole();
        String string2 = this.configuration.getTargetExecutablePath();
        String string3 = this.configuration.getTargetWorkingDirectory();
        String string4 = ParametersListUtil.join(this.configuration.getTargetArguments());
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"ParametersListUtil.join(\u2026guration.targetArguments)");
        return new DotNetCoreExeStartInfo(this.currentDotNetCliExePath, bl, string2, string3, string4, ModelUtilKt.getToModelMap(this.configuration.getTargetEnvironmentVariables()), this.configuration.getRuntimeArguments(), this.configuration.getExecuteAsIs(), this.createSessionPropertiesModel());
    }

    @Override
    public boolean getAttached() {
        return this.attached;
    }

    @NotNull
    public final IDotNetExecutableRunProfile getConfiguration() {
        return this.configuration;
    }

    @NotNull
    public final String getCurrentDotNetCliExePath() {
        return this.currentDotNetCliExePath;
    }

    public DotNetCoreDebugProfile(@NotNull IDotNetExecutableRunProfile configuration, @NotNull ExecutionEnvironment executionEnvironment, @NotNull String currentDotNetCliExePath) {
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)executionEnvironment, (String)"executionEnvironment");
        Intrinsics.checkParameterIsNotNull((Object)currentDotNetCliExePath, (String)"currentDotNetCliExePath");
        super(executionEnvironment);
        this.configuration = configuration;
        this.currentDotNetCliExePath = currentDotNetCliExePath;
        this.consoleKind = this.configuration.getTargetUseExternalConsole() ? IDotNetDebugProfileState.ConsoleKind.ExternalConsole : IDotNetDebugProfileState.ConsoleKind.Normal;
    }
}

