/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.run.xamarin.android;

import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.ui.DocumentAdapter;
import com.jetbrains.resharper.run.xamarin.android.AndroidSettingsPanel;
import com.jetbrains.resharper.run.xamarin.android.XamarinAndroidSdkHandler;
import com.jetbrains.resharper.run.xamarin.android.XamarinSettingsHost;
import com.jetbrains.rider.model.XamarinSettingsHostModel;
import com.jetbrains.rider.util.reactive.IProperty;
import com.jetbrains.rider.util.reactive.PropertyExKt;
import java.awt.Color;
import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\t\u001a\u00020\nH\u0016J\n\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\n\u0010\u000f\u001a\u0004\u0018\u00010\u000eH\u0016J\b\u0010\u0010\u001a\u00020\u000eH\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\nH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/resharper/run/xamarin/android/AndroidSettingsConfigurable;", "Lcom/intellij/openapi/options/SearchableConfigurable;", "xamarinAndroidSettingsHost", "Lcom/jetbrains/resharper/run/xamarin/android/XamarinSettingsHost;", "(Lcom/jetbrains/resharper/run/xamarin/android/XamarinSettingsHost;)V", "panel", "Lcom/jetbrains/resharper/run/xamarin/android/AndroidSettingsPanel;", "settingsModel", "Lcom/jetbrains/rider/model/XamarinSettingsHostModel;", "apply", "", "createComponent", "Ljavax/swing/JComponent;", "getDisplayName", "", "getHelpTopic", "getId", "isModified", "", "reset", "rider"})
public final class AndroidSettingsConfigurable
implements SearchableConfigurable {
    private final XamarinSettingsHostModel settingsModel;
    private final AndroidSettingsPanel panel;

    @NotNull
    public String getId() {
        return "AndroidSdk.Settings";
    }

    @Nullable
    public JComponent createComponent() {
        return this.panel.panel;
    }

    public boolean isModified() {
        return Intrinsics.areEqual((Object)this.settingsModel.getAndroidSdkPath().getValue(), (Object)this.panel.sdkPathTextField.getText()) ^ true || Intrinsics.areEqual((Object)this.settingsModel.getAndroidNdkPath().getValue(), (Object)this.panel.ndkPathTextField.getText()) ^ true || Intrinsics.areEqual((Object)this.settingsModel.getCustomXamarinAndroidPath().getValue(), (Object)this.panel.customXamarinAndroidLocationField.getText()) ^ true;
    }

    public void apply() {
        IProperty<String> iProperty = this.settingsModel.getAndroidSdkPath();
        String string2 = this.panel.sdkPathTextField.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"panel.sdkPathTextField.text");
        iProperty.setValue(string2);
        IProperty<String> iProperty2 = this.settingsModel.getAndroidNdkPath();
        String string3 = this.panel.ndkPathTextField.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"panel.ndkPathTextField.text");
        iProperty2.setValue(string3);
        IProperty<String> iProperty3 = this.settingsModel.getCustomXamarinAndroidPath();
        String string4 = this.panel.customXamarinAndroidLocationField.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"panel.customXamarinAndroidLocationField.text");
        iProperty3.setValue(string4);
    }

    public void reset() {
        this.panel.sdkPathTextField.setText(this.settingsModel.getAndroidSdkPath().getValue());
        this.panel.ndkPathTextField.setText(this.settingsModel.getAndroidNdkPath().getValue());
        this.panel.customXamarinAndroidLocationField.setText(this.settingsModel.getCustomXamarinAndroidPath().getValue());
    }

    @NotNull
    public String getDisplayName() {
        return "Android";
    }

    @Nullable
    public String getHelpTopic() {
        return "Manage Android SDK's Locations";
    }

    public AndroidSettingsConfigurable(@NotNull XamarinSettingsHost xamarinAndroidSettingsHost) {
        Intrinsics.checkParameterIsNotNull((Object)xamarinAndroidSettingsHost, (String)"xamarinAndroidSettingsHost");
        this.settingsModel = xamarinAndroidSettingsHost.getModel();
        this.panel = new AndroidSettingsPanel();
        this.panel.sdkPathTextField.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@Nullable DocumentEvent e2) {
                String string2 = ((AndroidSettingsConfigurable)this).panel.sdkPathTextField.getText();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"panel.sdkPathTextField.text");
                if (XamarinAndroidSdkHandler.Companion.androidSdkPathIsValid(string2)) {
                    IProperty<String> iProperty = settingsModel.getAndroidSdkPath();
                    String string3 = ((AndroidSettingsConfigurable)this).panel.sdkPathTextField.getText();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"panel.sdkPathTextField.text");
                    PropertyExKt.set(iProperty, string3);
                    ((AndroidSettingsConfigurable)this).panel.sdkPathTextField.getTextField().setForeground(null);
                    ((AndroidSettingsConfigurable)this).panel.sdkPathTextField.getTextField().setToolTipText(null);
                } else {
                    ((AndroidSettingsConfigurable)this).panel.sdkPathTextField.getTextField().setForeground(Color.red);
                    ((AndroidSettingsConfigurable)this).panel.sdkPathTextField.getTextField().setToolTipText("Android SDK path is incorrect");
                }
            }
        });
        this.panel.ndkPathTextField.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@Nullable DocumentEvent e2) {
                String string2 = ((AndroidSettingsConfigurable)this).panel.ndkPathTextField.getText();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"panel.ndkPathTextField.text");
                if (XamarinAndroidSdkHandler.Companion.androidNdkPathIsValid(string2)) {
                    IProperty<String> iProperty = settingsModel.getAndroidNdkPath();
                    String string3 = ((AndroidSettingsConfigurable)this).panel.ndkPathTextField.getText();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"panel.ndkPathTextField.text");
                    PropertyExKt.set(iProperty, string3);
                    ((AndroidSettingsConfigurable)this).panel.ndkPathTextField.getTextField().setForeground(null);
                    ((AndroidSettingsConfigurable)this).panel.ndkPathTextField.getTextField().setToolTipText(null);
                } else {
                    ((AndroidSettingsConfigurable)this).panel.ndkPathTextField.getTextField().setForeground(Color.red);
                    ((AndroidSettingsConfigurable)this).panel.ndkPathTextField.getTextField().setToolTipText("Android NDK path is incorrect");
                }
            }
        });
        this.panel.customXamarinAndroidLocationField.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@Nullable DocumentEvent e2) {
                String string2 = ((AndroidSettingsConfigurable)this).panel.customXamarinAndroidLocationField.getText();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"panel.customXamarinAndroidLocationField.text");
                if (XamarinAndroidSdkHandler.Companion.xamarinAndroidLocationIsValid(string2)) {
                    IProperty<String> iProperty = settingsModel.getCustomXamarinAndroidPath();
                    String string3 = ((AndroidSettingsConfigurable)this).panel.customXamarinAndroidLocationField.getText();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"panel.customXamarinAndroidLocationField.text");
                    PropertyExKt.set(iProperty, string3);
                    ((AndroidSettingsConfigurable)this).panel.customXamarinAndroidLocationField.getTextField().setForeground(null);
                    ((AndroidSettingsConfigurable)this).panel.customXamarinAndroidLocationField.getTextField().setToolTipText(null);
                } else {
                    ((AndroidSettingsConfigurable)this).panel.customXamarinAndroidLocationField.getTextField().setForeground(Color.red);
                    ((AndroidSettingsConfigurable)this).panel.customXamarinAndroidLocationField.getTextField().setToolTipText("Xamarin.Android path is incorrect");
                }
            }
        });
    }
}

