/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.run.xamarin.android;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.CollectingOutputReceiver;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.TimeoutException;
import com.android.prefs.AndroidLocation;
import com.android.sdklib.devices.DeviceManager;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.internal.avd.AvdManager;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.utils.ILogger;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.SystemInfo;
import com.jetbrains.resharper.run.xamarin.android.XamarinAndroidRunManager;
import com.jetbrains.resharper.run.xamarin.android.XamarinAndroidSdkHandler;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u009f\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001\u000f\u0018\u0000 N2\u00020\u0001:\u0001NB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0019\u0010\"\u001a\u00020\u00032\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00030$\u00a2\u0006\u0002\u0010%J\u0018\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u00172\u0006\u0010)\u001a\u00020*H\u0016J\u0010\u0010+\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0017H\u0016J\u0010\u0010,\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0017H\u0016J\u0010\u0010-\u001a\u00020.2\u0006\u0010(\u001a\u00020\u0017H\u0002J\u0013\u0010/\u001a\n\u0012\u0006\b\u0001\u0012\u0002000$\u00a2\u0006\u0002\u00101J\u0013\u00102\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00170$\u00a2\u0006\u0002\u00103J\u0012\u00104\u001a\u0004\u0018\u00010\u00172\u0006\u00105\u001a\u00020\u0003H\u0002J\u0013\u00106\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00170$\u00a2\u0006\u0002\u00103J\b\u00107\u001a\u00020'H\u0002J\u0016\u00108\u001a\u00020'2\u0006\u00109\u001a\u00020\u00032\u0006\u0010:\u001a\u00020;J\u000e\u0010<\u001a\u00020'2\u0006\u0010:\u001a\u00020;J\u000e\u0010=\u001a\u00020'2\u0006\u0010:\u001a\u00020;J\u000e\u0010>\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0017J!\u0010?\u001a\u00020@2\u0006\u0010(\u001a\u00020\u00172\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00030$\u00a2\u0006\u0002\u0010AJ+\u0010B\u001a\u00020C2\u0006\u0010(\u001a\u00020\u00172\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00030$2\b\b\u0002\u0010D\u001a\u00020*\u00a2\u0006\u0002\u0010EJ\u000e\u0010F\u001a\u00020\u00172\u0006\u00105\u001a\u00020\u0003J\u0006\u0010G\u001a\u00020'J&\u0010H\u001a\u00020.2\u0006\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u00020J2\f\u0010L\u001a\b\u0012\u0004\u0012\u00020.0MH\u0002R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006O"}, d2={"Lcom/jetbrains/resharper/run/xamarin/android/XamarinAndroidSdkHandler;", "Lcom/android/ddmlib/AndroidDebugBridge$IDeviceChangeListener;", "androidSdkPath", "", "(Ljava/lang/String;)V", "adb", "Lcom/android/ddmlib/AndroidDebugBridge;", "getAdb", "()Lcom/android/ddmlib/AndroidDebugBridge;", "setAdb", "(Lcom/android/ddmlib/AndroidDebugBridge;)V", "adbFile", "Ljava/io/File;", "androidFile", "androidLogger", "com/jetbrains/resharper/run/xamarin/android/XamarinAndroidSdkHandler$androidLogger$1", "Lcom/jetbrains/resharper/run/xamarin/android/XamarinAndroidSdkHandler$androidLogger$1;", "avdManager", "Lcom/android/sdklib/internal/avd/AvdManager;", "deviceManager", "Lcom/android/sdklib/devices/DeviceManager;", "devicesList", "", "Lcom/android/ddmlib/IDevice;", "emulatorFile", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "platformToolsFolder", "sdkManager", "Lcom/android/sdklib/repository/AndroidSdkHandler;", "shellPath", "getShellPath", "()Ljava/lang/String;", "toolsFolder", "createCommand", "commandParts", "", "([Ljava/lang/String;)Ljava/lang/String;", "deviceChanged", "", "device", "p1", "", "deviceConnected", "deviceDisconnected", "deviceIsReady", "", "getAvailableAndroidDevices", "Lcom/android/sdklib/internal/avd/AvdInfo;", "()[Lcom/android/sdklib/internal/avd/AvdInfo;", "getConnectedDevices", "()[Lcom/android/ddmlib/IDevice;", "getDevice", "avdName", "getRunningDevices", "initDevicesList", "runAndroidService", "suffix", "project", "Lcom/intellij/openapi/project/Project;", "runAvdManager", "runSdkManager", "runShell", "sendCommandViaAdb", "Lcom/intellij/execution/process/ProcessHandler;", "(Lcom/android/ddmlib/IDevice;[Ljava/lang/String;)Lcom/intellij/execution/process/ProcessHandler;", "sendShellCommandViaAdbAndWait", "Lcom/intellij/execution/process/ProcessOutput;", "timeout", "(Lcom/android/ddmlib/IDevice;[Ljava/lang/String;I)Lcom/intellij/execution/process/ProcessOutput;", "startEmulator", "terminate", "wait", "sleepDuration", "", "numberOfTries", "stop", "Lkotlin/Function0;", "Companion", "rider"})
public final class XamarinAndroidSdkHandler
implements AndroidDebugBridge.IDeviceChangeListener {
    private final Logger logger;
    private androidLogger.1 androidLogger;
    private File adbFile;
    private File emulatorFile;
    private File androidFile;
    private File platformToolsFolder;
    private File toolsFolder;
    private AndroidSdkHandler sdkManager;
    private DeviceManager deviceManager;
    private AvdManager avdManager;
    @NotNull
    private AndroidDebugBridge adb;
    private final List<IDevice> devicesList;
    @NotNull
    private static final String PLATFORM_TOOLS_DIRECTORY_NAME = "platform-tools";
    @NotNull
    private static final String TOOLS_DIRECTORY_NAME = "tools";
    @NotNull
    private static final String ADB_FILE_NAME = "adb";
    @NotNull
    private static final String EMULATOR_FILE_NAME = "emulator";
    private static final int DEFAULT_TIMEOUT = 5000;
    @NotNull
    private static final String ANDROID_FILE_NAME = "android";
    public static final Companion Companion = new Companion(null);

    public void deviceChanged(@NotNull IDevice device, int p1) {
        Intrinsics.checkParameterIsNotNull((Object)device, (String)"device");
        this.logger.info("State of device " + device.getSerialNumber() + " has changed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deviceConnected(@NotNull IDevice device) {
        Intrinsics.checkParameterIsNotNull((Object)device, (String)"device");
        List<IDevice> list2 = this.devicesList;
        synchronized (list2) {
            if (!this.devicesList.contains(device)) {
                this.logger.info("Added new device " + device.getSerialNumber() + " to the list of devices");
                this.devicesList.add(device);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deviceDisconnected(@NotNull IDevice device) {
        Intrinsics.checkParameterIsNotNull((Object)device, (String)"device");
        List<IDevice> list2 = this.devicesList;
        synchronized (list2) {
            this.logger.info("Removed device " + device.getSerialNumber() + " from the list of devices");
            boolean bl = this.devicesList.remove(device);
        }
    }

    public final void terminate() {
        AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
    }

    @NotNull
    public final AndroidDebugBridge getAdb() {
        return this.adb;
    }

    public final void setAdb(@NotNull AndroidDebugBridge androidDebugBridge) {
        Intrinsics.checkParameterIsNotNull((Object)androidDebugBridge, (String)"<set-?>");
        this.adb = androidDebugBridge;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void initDevicesList() {
        List<IDevice> list2 = this.devicesList;
        synchronized (list2) {
            this.devicesList.clear();
            Collection collection = this.devicesList;
            IDevice[] iDeviceArray = this.adb.getDevices();
            Intrinsics.checkExpressionValueIsNotNull((Object)iDeviceArray, (String)"adb.devices");
            boolean bl = CollectionsKt.addAll((Collection)collection, (Object[])iDeviceArray);
        }
    }

    @NotNull
    public final ProcessOutput sendShellCommandViaAdbAndWait(@NotNull IDevice device, @NotNull String[] commandParts, int timeout) {
        Intrinsics.checkParameterIsNotNull((Object)device, (String)"device");
        Intrinsics.checkParameterIsNotNull((Object)commandParts, (String)"commandParts");
        CollectingOutputReceiver receiver = new CollectingOutputReceiver();
        ProcessOutput output = new ProcessOutput();
        String command = this.createCommand(commandParts);
        try {
            device.executeShellCommand(command, (IShellOutputReceiver)receiver, (long)timeout, TimeUnit.MILLISECONDS);
            output.appendStdout(receiver.getOutput());
        }
        catch (Exception e2) {
            this.logger.warn((Throwable)e2);
            output.appendStderr(e2.getMessage());
        }
        this.logger.trace("Executing remote command on device " + device.getName() + ": " + command + "." + "\n" + "Output: " + output.getStdout() + "\n" + "Errors: " + output.getStderr());
        return output;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ ProcessOutput sendShellCommandViaAdbAndWait$default(XamarinAndroidSdkHandler xamarinAndroidSdkHandler, IDevice iDevice, String[] stringArray, int n2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            n2 = Companion.getDEFAULT_TIMEOUT();
        }
        return xamarinAndroidSdkHandler.sendShellCommandViaAdbAndWait(iDevice, stringArray, n2);
    }

    @NotNull
    public final String createCommand(@NotNull String[] commandParts) {
        Intrinsics.checkParameterIsNotNull((Object)commandParts, (String)"commandParts");
        StringBuilder builder = new StringBuilder();
        for (int i2 = 0; i2 < commandParts.length; ++i2) {
            String part = commandParts[i2];
            if (StringsKt.contains$default((CharSequence)part, (CharSequence)" ", (boolean)false, (int)2, null)) {
                builder.append("\"" + part + "\"" + " ");
                continue;
            }
            builder.append(part + " ");
        }
        String string2 = builder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"builder.toString()");
        return string2;
    }

    @NotNull
    public final ProcessHandler sendCommandViaAdb(@NotNull IDevice device, @NotNull String[] commandParts) {
        Intrinsics.checkParameterIsNotNull((Object)device, (String)"device");
        Intrinsics.checkParameterIsNotNull((Object)commandParts, (String)"commandParts");
        SpreadBuilder spreadBuilder = new SpreadBuilder(4);
        spreadBuilder.add((Object)this.adbFile.getAbsolutePath());
        spreadBuilder.add((Object)"-s");
        spreadBuilder.add((Object)device.getSerialNumber());
        spreadBuilder.addSpread((Object)commandParts);
        return (ProcessHandler)new CapturingProcessHandler(new GeneralCommandLine((String[])spreadBuilder.toArray((Object[])new String[spreadBuilder.size()])));
    }

    @NotNull
    public final AvdInfo[] getAvailableAndroidDevices() {
        try {
            this.avdManager.reloadAvds((ILogger)this.androidLogger);
        }
        catch (Exception exception) {
            // empty catch block
        }
        AvdInfo[] avdInfoArray = this.avdManager.getAllAvds();
        Intrinsics.checkExpressionValueIsNotNull((Object)avdInfoArray, (String)"avdManager.allAvds");
        return avdInfoArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final IDevice[] getRunningDevices() {
        List<IDevice> list2 = this.devicesList;
        synchronized (list2) {
            Collection $receiver$iv;
            Collection collection = $receiver$iv = (Collection)this.devicesList;
            if (collection == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
            }
            Collection thisCollection$iv = collection;
            IDevice[] iDeviceArray = thisCollection$iv.toArray(new IDevice[thisCollection$iv.size()]);
            if (iDeviceArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            IDevice[] iDeviceArray2 = (IDevice[])((Object[])iDeviceArray);
            return iDeviceArray2;
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final IDevice[] getConnectedDevices() {
        void $receiver$iv$iv;
        Object $receiver$iv;
        IDevice[] allDevices = this.getRunningDevices();
        Object[] objectArray = $receiver$iv = (Object[])allDevices;
        Collection destination$iv$iv = new ArrayList();
        for (int i2 = 0; i2 < ((void)$receiver$iv$iv).length; ++i2) {
            void element$iv$iv = $receiver$iv$iv[i2];
            IDevice device = (IDevice)element$iv$iv;
            if (!(!device.isEmulator())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        Collection thisCollection$iv = (Collection)$receiver$iv;
        IDevice[] iDeviceArray = thisCollection$iv.toArray(new IDevice[thisCollection$iv.size()]);
        if (iDeviceArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return (IDevice[])((Object[])iDeviceArray);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final IDevice startEmulator(@NotNull String avdName) {
        void deviceIsReady;
        Intrinsics.checkParameterIsNotNull((Object)avdName, (String)"avdName");
        IDevice emulator = this.getDevice(avdName);
        if (emulator != null) {
            return emulator;
        }
        CapturingProcessHandler handler2 = new CapturingProcessHandler(new GeneralCommandLine(new String[]{this.emulatorFile.getAbsolutePath(), "-avd", avdName}));
        ProcessOutput output = handler2.runProcess(1000, false);
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        booleanRef.element = false;
        if (!this.wait(100L, 3000L, (Function0<Boolean>)((Function0)new Function0<Boolean>(this, avdName, (Ref.BooleanRef)deviceIsReady, handler2){
            final /* synthetic */ XamarinAndroidSdkHandler this$0;
            final /* synthetic */ String $avdName;
            final /* synthetic */ Ref.BooleanRef $deviceIsReady;
            final /* synthetic */ CapturingProcessHandler $handler;

            public final boolean invoke() {
                IDevice device = XamarinAndroidSdkHandler.access$getDevice(this.this$0, this.$avdName);
                this.$deviceIsReady.element = device != null ? XamarinAndroidSdkHandler.access$deviceIsReady(this.this$0, device) : false;
                return this.$handler.isProcessTerminated() || this.$handler.isProcessTerminating() || this.$deviceIsReady.element;
            }
            {
                this.this$0 = xamarinAndroidSdkHandler;
                this.$avdName = string2;
                this.$deviceIsReady = booleanRef;
                this.$handler = capturingProcessHandler;
                super(0);
            }
        }))) {
            handler2.destroyProcess();
            throw (Throwable)new TimeoutException("Timeout on emulator " + avdName + " start");
        }
        emulator = this.getDevice(avdName);
        if (emulator == null || emulator.isOffline() || !deviceIsReady.element) {
            throw (Throwable)new IllegalStateException("Failed to load emulator with AVD name " + avdName + "." + "\n" + output.getStderr());
        }
        return emulator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final IDevice getDevice(String avdName) {
        List<IDevice> list2 = this.devicesList;
        synchronized (list2) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)this.devicesList;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                IDevice device = (IDevice)element$iv$iv;
                if (!(device.isEmulator() && Intrinsics.areEqual((Object)device.getAvdName(), (Object)avdName))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            IDevice iDevice = (IDevice)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
            return iDevice;
        }
    }

    private final boolean deviceIsReady(IDevice device) {
        if (!device.isOnline()) {
            return false;
        }
        if (device.getProperty("dev.bootcomplete") == null) {
            return false;
        }
        return ((Object[])device.getClients()).length > 5 || device.getClient("android.process.acore") != null || device.getClient("com.google.android.wearable.app") != null;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean wait(long sleepDuration, long numberOfTries, Function0<Boolean> stop2) {
        long totalTime = 0L;
        long l2 = 0;
        long l3 = numberOfTries;
        if (l2 <= l3) {
            while (true) {
                void i2;
                Thread.sleep(sleepDuration);
                totalTime += sleepDuration;
                if (((Boolean)stop2.invoke()).booleanValue()) {
                    return true;
                }
                if (i2 == l3) break;
                ++i2;
            }
        }
        return false;
    }

    public final void runAvdManager(@NotNull Project project2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        this.runAndroidService("avd", project2);
    }

    public final void runSdkManager(@NotNull Project project2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        this.runAndroidService("sdk", project2);
    }

    public final void runAndroidService(@NotNull String suffix, @NotNull Project project2) {
        Intrinsics.checkParameterIsNotNull((Object)suffix, (String)"suffix");
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        ProcessOutput output = new CapturingProcessHandler(new GeneralCommandLine(new String[]{this.androidFile.getAbsolutePath(), suffix})).runProcess();
        CharSequence charSequence = output.getStderr();
        if (!(charSequence.length() == 0)) {
            this.logger.error(output.getStderr());
        }
        if (StringsKt.contains((CharSequence)output.getStdout(), (CharSequence)"is deprecated", (boolean)true)) {
            XamarinAndroidRunManager.Companion.getANDROID_SDK_NOTIFICATION_GROUP().createNotification(output.getStdout(), MessageType.WARNING).notify(project2);
        }
    }

    public final void runShell(@NotNull IDevice device) {
        Intrinsics.checkParameterIsNotNull((Object)device, (String)"device");
        if (SystemInfo.isMac || SystemInfo.isLinux) {
            return;
        }
        ProcessOutput output = new CapturingProcessHandler(new GeneralCommandLine(new String[]{this.getShellPath(), "/c", "start", this.adbFile.getAbsolutePath(), "-s", device.getSerialNumber(), "shell"})).runProcess();
        CharSequence charSequence = output.getStderr();
        if (!(charSequence.length() == 0)) {
            this.logger.error(output.getStderr());
        }
    }

    private final String getShellPath() {
        String shell = System.getenv("SHELL");
        if (shell != null && new File(shell).canExecute()) {
            return shell;
        }
        if (SystemInfo.isUnix) {
            if (new File("/bin/bash").exists()) {
                return "/bin/bash";
            }
            return "/bin/sh";
        }
        return "cmd.exe";
    }

    public XamarinAndroidSdkHandler(@NotNull String androidSdkPath) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)androidSdkPath, (String)"androidSdkPath");
        XamarinAndroidSdkHandler xamarinAndroidSdkHandler = this;
        Logger logger = Logger.getInstance(XamarinAndroidSdkHandler.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
        xamarinAndroidSdkHandler.logger = object = logger;
        this.androidLogger = new ILogger(this){
            final /* synthetic */ XamarinAndroidSdkHandler this$0;

            public void error(@Nullable Throwable t2, @Nullable String msgFormat, Object ... args) {
                String message2;
                String string2;
                Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
                if (msgFormat != null) {
                    StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                    Object[] objectArray = new Object[]{args};
                    String string3 = String.format(msgFormat, Arrays.copyOf(objectArray, objectArray.length));
                    string2 = string3;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(format, *args)");
                } else {
                    string2 = message2 = "";
                }
                if (t2 != null) {
                    XamarinAndroidSdkHandler.access$getLogger$p(this.this$0).error(message2, t2);
                } else {
                    XamarinAndroidSdkHandler.access$getLogger$p(this.this$0).error(message2);
                }
            }

            public void info(@NotNull String messageFormat, Object ... args) {
                Intrinsics.checkParameterIsNotNull((Object)messageFormat, (String)"messageFormat");
                Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                Object[] objectArray = new Object[]{args};
                Logger logger = XamarinAndroidSdkHandler.access$getLogger$p(this.this$0);
                String string2 = String.format(messageFormat, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
                String string3 = string2;
                logger.info(string3);
            }

            public void warning(@NotNull String messageFormat, Object ... args) {
                Intrinsics.checkParameterIsNotNull((Object)messageFormat, (String)"messageFormat");
                Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                Object[] objectArray = new Object[]{args};
                Logger logger = XamarinAndroidSdkHandler.access$getLogger$p(this.this$0);
                String string2 = String.format(messageFormat, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
                String string3 = string2;
                logger.warn(string3);
            }

            public void verbose(@NotNull String messageFormat, Object ... args) {
                Intrinsics.checkParameterIsNotNull((Object)messageFormat, (String)"messageFormat");
                Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                Object[] objectArray = new Object[]{args};
                Logger logger = XamarinAndroidSdkHandler.access$getLogger$p(this.this$0);
                String string2 = String.format(messageFormat, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
                String string3 = string2;
                logger.info(string3);
            }
            {
                this.this$0 = $outer;
            }
        };
        xamarinAndroidSdkHandler = this;
        xamarinAndroidSdkHandler.devicesList = object = (List)new ArrayList();
        File sdkFolder = new File(androidSdkPath);
        if (!sdkFolder.exists() || !sdkFolder.isDirectory()) {
            throw (Throwable)new AndroidLocation.AndroidLocationException("Location " + androidSdkPath + " is not valid");
        }
        File file2 = (File)ArraysKt.firstOrNull((Object[])sdkFolder.listFiles(1.INSTANCE));
        if (file2 == null) {
            throw (Throwable)new AndroidLocation.AndroidLocationException("Location " + androidSdkPath + " is not valid: there is no " + "'" + PLATFORM_TOOLS_DIRECTORY_NAME + "'" + " directory");
        }
        this.platformToolsFolder = file2;
        File file3 = (File)ArraysKt.firstOrNull((Object[])sdkFolder.listFiles(2.INSTANCE));
        if (file3 == null) {
            throw (Throwable)new AndroidLocation.AndroidLocationException("Location " + androidSdkPath + " is not valid: there is no " + "'" + TOOLS_DIRECTORY_NAME + "'" + " directory");
        }
        this.toolsFolder = file3;
        File file4 = (File)ArraysKt.firstOrNull((Object[])this.platformToolsFolder.listFiles(3.INSTANCE));
        if (file4 == null) {
            throw (Throwable)new AndroidLocation.AndroidLocationException("Location " + androidSdkPath + " is not valid: there is no " + "'" + ADB_FILE_NAME + "'" + " file in " + "'" + PLATFORM_TOOLS_DIRECTORY_NAME + "'" + " directory");
        }
        this.adbFile = file4;
        File file5 = (File)ArraysKt.firstOrNull((Object[])this.toolsFolder.listFiles(4.INSTANCE));
        if (file5 == null) {
            throw (Throwable)new AndroidLocation.AndroidLocationException("Location " + androidSdkPath + " is not valid: there is no " + "'" + EMULATOR_FILE_NAME + "'" + " file in " + "'" + TOOLS_DIRECTORY_NAME + "'" + " directory");
        }
        this.emulatorFile = file5;
        File file6 = (File)ArraysKt.firstOrNull((Object[])this.toolsFolder.listFiles(5.INSTANCE));
        if (file6 == null) {
            throw (Throwable)new AndroidLocation.AndroidLocationException("Location " + androidSdkPath + " is not valid: there is no " + "'" + ANDROID_FILE_NAME + "'" + " file in " + "'" + TOOLS_DIRECTORY_NAME + "'" + " directory");
        }
        this.androidFile = file6;
        AndroidSdkHandler androidSdkHandler = AndroidSdkHandler.getInstance((File)sdkFolder);
        Intrinsics.checkExpressionValueIsNotNull((Object)androidSdkHandler, (String)"AndroidSdkHandler.getInstance(sdkFolder)");
        this.sdkManager = androidSdkHandler;
        DeviceManager deviceManager = DeviceManager.createInstance((File)sdkFolder, (ILogger)this.androidLogger);
        Intrinsics.checkExpressionValueIsNotNull((Object)deviceManager, (String)"DeviceManager.createInst\u2026sdkFolder, androidLogger)");
        this.deviceManager = deviceManager;
        AvdManager avdManager = AvdManager.getInstance((AndroidSdkHandler)this.sdkManager, (ILogger)this.androidLogger);
        Intrinsics.checkExpressionValueIsNotNull((Object)avdManager, (String)"AvdManager.getInstance(sdkManager, androidLogger)");
        this.avdManager = avdManager;
        AndroidDebugBridge androidDebugBridge = AndroidDebugBridge.createBridge((String)this.adbFile.getAbsolutePath(), (boolean)false);
        Intrinsics.checkExpressionValueIsNotNull((Object)androidDebugBridge, (String)"AndroidDebugBridge.creat\u2026File.absolutePath, false)");
        this.adb = androidDebugBridge;
        AndroidDebugBridge.initIfNeeded((boolean)true);
        this.initDevicesList();
        AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
    }

    static {
        PLATFORM_TOOLS_DIRECTORY_NAME = PLATFORM_TOOLS_DIRECTORY_NAME;
        TOOLS_DIRECTORY_NAME = TOOLS_DIRECTORY_NAME;
        ADB_FILE_NAME = ADB_FILE_NAME;
        EMULATOR_FILE_NAME = EMULATOR_FILE_NAME;
        DEFAULT_TIMEOUT = 5000;
        ANDROID_FILE_NAME = ANDROID_FILE_NAME;
    }

    @Nullable
    public static final /* synthetic */ IDevice access$getDevice(XamarinAndroidSdkHandler $this, @NotNull String avdName) {
        return $this.getDevice(avdName);
    }

    public static final /* synthetic */ boolean access$deviceIsReady(XamarinAndroidSdkHandler $this, @NotNull IDevice device) {
        return $this.deviceIsReady(device);
    }

    @NotNull
    public static final /* synthetic */ Logger access$getLogger$p(XamarinAndroidSdkHandler $this) {
        return $this.logger;
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0004J\u000e\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0004J\u0010\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0004H\u0002J\u000e\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0004R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\nX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0014\u0010\u000f\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u0014\u0010\u0011\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0006\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/resharper/run/xamarin/android/XamarinAndroidSdkHandler$Companion;", "", "()V", "ADB_FILE_NAME", "", "getADB_FILE_NAME", "()Ljava/lang/String;", "ANDROID_FILE_NAME", "getANDROID_FILE_NAME", "DEFAULT_TIMEOUT", "", "getDEFAULT_TIMEOUT", "()I", "EMULATOR_FILE_NAME", "getEMULATOR_FILE_NAME", "PLATFORM_TOOLS_DIRECTORY_NAME", "getPLATFORM_TOOLS_DIRECTORY_NAME", "TOOLS_DIRECTORY_NAME", "getTOOLS_DIRECTORY_NAME", "androidNdkPathIsValid", "", "path", "androidSdkPathIsValid", "filenameWithoutExtension", "name", "xamarinAndroidLocationIsValid", "rider"})
    public static final class Companion {
        @NotNull
        public final String getPLATFORM_TOOLS_DIRECTORY_NAME() {
            return PLATFORM_TOOLS_DIRECTORY_NAME;
        }

        @NotNull
        public final String getTOOLS_DIRECTORY_NAME() {
            return TOOLS_DIRECTORY_NAME;
        }

        @NotNull
        public final String getADB_FILE_NAME() {
            return ADB_FILE_NAME;
        }

        @NotNull
        public final String getEMULATOR_FILE_NAME() {
            return EMULATOR_FILE_NAME;
        }

        public final int getDEFAULT_TIMEOUT() {
            return DEFAULT_TIMEOUT;
        }

        @NotNull
        public final String getANDROID_FILE_NAME() {
            return ANDROID_FILE_NAME;
        }

        public final boolean androidSdkPathIsValid(@NotNull String path) {
            Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
            File sdkFolder = new File(path);
            if (!sdkFolder.exists() || !sdkFolder.isDirectory()) {
                return false;
            }
            File file2 = (File)ArraysKt.firstOrNull((Object[])sdkFolder.listFiles(androidSdkPathIsValid.platformToolsFolder.1.INSTANCE));
            if (file2 == null) {
                return false;
            }
            File platformToolsFolder2 = file2;
            File file3 = (File)ArraysKt.firstOrNull((Object[])sdkFolder.listFiles(androidSdkPathIsValid.toolsFolder.1.INSTANCE));
            if (file3 == null) {
                return false;
            }
            File toolsFolder2 = file3;
            if ((File)ArraysKt.firstOrNull((Object[])platformToolsFolder2.listFiles(androidSdkPathIsValid.1.INSTANCE)) == null) {
                return false;
            }
            if ((File)ArraysKt.firstOrNull((Object[])toolsFolder2.listFiles(androidSdkPathIsValid.2.INSTANCE)) == null) {
                return false;
            }
            return (File)ArraysKt.firstOrNull((Object[])toolsFolder2.listFiles(androidSdkPathIsValid.3.INSTANCE)) != null;
            {
            }
        }

        public final boolean androidNdkPathIsValid(@NotNull String path) {
            Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
            File directory = new File(path);
            return directory.exists() && directory.isDirectory();
        }

        /*
         * WARNING - void declaration
         */
        public final boolean xamarinAndroidLocationIsValid(@NotNull String path) {
            void $receiver$iv$iv;
            boolean bl;
            Object element$iv;
            Object[] objectArray;
            File[] children2;
            block6: {
                Object[] file2;
                Iterator $receiver$iv$iv2;
                Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
                File directory = new File(path);
                if (!directory.exists() || !directory.isDirectory()) {
                    return false;
                }
                children2 = directory.listFiles();
                Object $receiver$iv = children2;
                objectArray = $receiver$iv;
                Collection destination$iv$iv = new ArrayList();
                for (int i2 = 0; i2 < ((void)$receiver$iv$iv2).length; ++i2) {
                    void element$iv$iv = $receiver$iv$iv2[i2];
                    file2 = (Object[])element$iv$iv;
                    if (!(file2.isDirectory() && StringsKt.equals((String)file2.getName(), (String)"Xamarin", (boolean)true))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $receiver$iv = (List)destination$iv$iv;
                $receiver$iv$iv2 = $receiver$iv.iterator();
                while ($receiver$iv$iv2.hasNext()) {
                    element$iv = $receiver$iv$iv2.next();
                    File file3 = (File)element$iv;
                    Object[] objectArray2 = file3.listFiles(xamarinAndroidLocationIsValid.2.1.INSTANCE);
                    file2 = objectArray2;
                    if (!(!(file2.length == 0))) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
            if (bl) {
                return true;
            }
            Object[] $receiver$iv = children2;
            element$iv = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            for (int i3 = 0; i3 < ((void)$receiver$iv$iv).length; ++i3) {
                void element$iv$iv = $receiver$iv$iv[i3];
                File child = (File)element$iv$iv;
                if (!(child.isDirectory() && StringsKt.equals((String)child.getName(), (String)"lib", (boolean)true))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            File file4 = (File)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
            if (file4 == null) {
                return false;
            }
            File libDirectory = file4;
            Object[] objectArray3 = objectArray = (Object[])libDirectory.listFiles(xamarinAndroidLocationIsValid.3.INSTANCE);
            return !(objectArray3.length == 0);
        }

        private final String filenameWithoutExtension(String name) {
            CharSequence charSequence = name;
            Regex regex = new Regex("[.][^.]+$");
            String string2 = "";
            return regex.replaceFirst(charSequence, string2);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

