/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.run.xamarin.android.deviceDialog;

import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TitledSeparator;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.resharper.run.xamarin.android.AndroidManifestFileDescriptor;
import com.jetbrains.resharper.run.xamarin.android.deviceDialog.DevicePickerEntry;
import com.jetbrains.resharper.run.xamarin.android.deviceDialog.dialogItems.AndroidItem;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J:\u0010\u0006\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0014J<\u0010\u0010\u001a\u00020\u00112\u0010\u0010\b\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0002\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/resharper/run/xamarin/android/deviceDialog/AndroidItemCellRenderer;", "Lcom/intellij/ui/ColoredListCellRenderer;", "Lcom/jetbrains/resharper/run/xamarin/android/deviceDialog/DevicePickerEntry;", "descriptor", "Lcom/jetbrains/resharper/run/xamarin/android/AndroidManifestFileDescriptor;", "(Lcom/jetbrains/resharper/run/xamarin/android/AndroidManifestFileDescriptor;)V", "customizeCellRenderer", "", "list", "Ljavax/swing/JList;", "value", "index", "", "selected", "", "hasFocus", "getListCellRendererComponent", "Ljava/awt/Component;", "renderEmptyMarker", "title", "", "renderOldDevice", "device", "Lcom/jetbrains/resharper/run/xamarin/android/deviceDialog/dialogItems/AndroidItem;", "renderTitledSeparator", "rider"})
public final class AndroidItemCellRenderer
extends ColoredListCellRenderer<DevicePickerEntry> {
    private final AndroidManifestFileDescriptor descriptor;

    protected void customizeCellRenderer(@NotNull JList<? extends DevicePickerEntry> list2, @Nullable DevicePickerEntry value2, int index, boolean selected, boolean hasFocus) {
        Intrinsics.checkParameterIsNotNull(list2, (String)"list");
        if (value2 == null) {
            return;
        }
        if (value2.isMarker() || value2.getAndroidDevice() == null) {
            return;
        }
        AndroidItem androidItem = value2.getAndroidDevice();
        if (androidItem == null) {
            Intrinsics.throwNpe();
        }
        AndroidItem device = androidItem;
        this.append(device.toString(), device.getVersion().compareTo(this.descriptor.getMinAndroidVersion()) >= 0 ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.GRAYED_ATTRIBUTES);
    }

    @NotNull
    public Component getListCellRendererComponent(@Nullable JList<? extends DevicePickerEntry> list2, @Nullable DevicePickerEntry value2, int index, boolean selected, boolean hasFocus) {
        if (value2 instanceof DevicePickerEntry && value2.isMarker()) {
            String string2 = value2.getMarker();
            if (string2 == null) {
                String string3 = "Device picker marker entry doesn't have a descriptive string";
                throw (Throwable)new IllegalStateException(string3.toString());
            }
            String marker = string2;
            if (value2 == DevicePickerEntry.Companion.getNONE()) {
                return this.renderEmptyMarker(marker);
            }
            return this.renderTitledSeparator(marker);
        }
        if (value2 instanceof DevicePickerEntry) {
            AndroidItem androidItem = value2.getAndroidDevice();
            if (androidItem == null) {
                Intrinsics.throwNpe();
            }
            if (androidItem.getVersion().compareTo(this.descriptor.getMinAndroidVersion()) < 0) {
                AndroidItem androidItem2 = value2.getAndroidDevice();
                if (androidItem2 == null) {
                    Intrinsics.throwNpe();
                }
                return this.renderOldDevice(androidItem2);
            }
        }
        Component component = super.getListCellRendererComponent(list2, (Object)value2, index, selected, hasFocus);
        Intrinsics.checkExpressionValueIsNotNull((Object)component, (String)"super.getListCellRendere\u2026ndex, selected, hasFocus)");
        return component;
    }

    private final Component renderTitledSeparator(String title) {
        TitledSeparator separator = new TitledSeparator(title);
        separator.setBackground(UIUtil.getListBackground());
        separator.setTitleFont(UIUtil.getLabelFont());
        return (Component)separator;
    }

    private final Component renderEmptyMarker(String title) {
        return new JLabel(title);
    }

    private final Component renderOldDevice(AndroidItem device) {
        JLabel label = new JLabel(device.toString());
        label.setEnabled(false);
        return label;
    }

    public AndroidItemCellRenderer(@NotNull AndroidManifestFileDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        this.descriptor = descriptor2;
    }
}

