/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.run.xamarin.android.deviceDialog;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBList;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.jetbrains.resharper.run.xamarin.android.AndroidManifestFileDescriptor;
import com.jetbrains.resharper.run.xamarin.android.XamarinAndroidRunManager;
import com.jetbrains.resharper.run.xamarin.android.XamarinAndroidSdkHandler;
import com.jetbrains.resharper.run.xamarin.android.deviceDialog.AndroidItemCellRenderer;
import com.jetbrains.resharper.run.xamarin.android.deviceDialog.DevicePickerEntry;
import com.jetbrains.resharper.run.xamarin.android.deviceDialog.DevicePickerListModel;
import com.jetbrains.resharper.run.xamarin.android.deviceDialog.dialogItems.AndroidItem;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.function.Function;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DevicePicker
implements Disposable,
ListSelectionListener {
    private JPanel panel;
    private JButton manageDevicesButton;
    private JScrollPane devicesScrollPane;
    private JBList devicesList;
    private XamarinAndroidRunManager runManager;
    private AndroidManifestFileDescriptor descriptor;
    private Function<AndroidItem, Void> onItemSelected;

    DevicePicker(XamarinAndroidRunManager runManager, AndroidManifestFileDescriptor descriptor2, Project project2, Function<AndroidItem, Void> onItemSelected) {
        this.runManager = runManager;
        this.descriptor = descriptor2;
        this.onItemSelected = onItemSelected;
        this.$$$setupUI$$$();
        this.manageDevicesButton.addActionListener(e2 -> {
            XamarinAndroidSdkHandler handler2 = runManager.getCurrentSdkHandler();
            if (handler2 == null) {
                return;
            }
            handler2.runAvdManager(project2);
            this.devicesList.setModel((ListModel)DevicePickerListModel.Companion.createModel(runManager));
        });
    }

    private void createUIComponents() {
        this.devicesList = new JBList();
        DevicePickerListModel devicePickerListModel = DevicePickerListModel.Companion.createModel(this.runManager);
        this.devicesList.setModel((ListModel)devicePickerListModel);
        this.devicesList.setCellRenderer((ListCellRenderer)((Object)new AndroidItemCellRenderer(this.descriptor)));
        this.devicesScrollPane = ScrollPaneFactory.createScrollPane((Component)this.devicesList);
        this.devicesList.setSelectionMode(0);
        this.devicesList.addListSelectionListener((ListSelectionListener)this);
    }

    public void dispose() {
    }

    public JComponent getComponent() {
        return this.panel;
    }

    public AndroidItem getSelectedItem() {
        if (this.devicesList.getSelectedValue() != null) {
            if (!(this.devicesList.getSelectedValue() instanceof DevicePickerEntry)) {
                return null;
            }
            AndroidItem item = ((DevicePickerEntry)this.devicesList.getSelectedValue()).getAndroidDevice();
            if (item == null) {
                return null;
            }
            if (item.getVersion().compareTo(this.descriptor.getMinAndroidVersion()) < 0) {
                return null;
            }
            return item;
        }
        return null;
    }

    @Override
    public void valueChanged(ListSelectionEvent e2) {
        AndroidItem selectedItem = this.getSelectedItem();
        this.onItemSelected.apply(selectedItem);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JPanel jPanel;
        this.createUIComponents();
        this.panel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JScrollPane jScrollPane = this.devicesScrollPane;
        jPanel.add((Component)jScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.manageDevicesButton = jButton = new JButton();
        jButton.setText("Manage Devices...");
        jPanel.add((Component)jButton, new GridConstraints(1, 0, 1, 1, 10, 0, 3, 0, null, null, null, 1));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.panel;
    }
}

