/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.runtime;

import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.jetbrains.resharper.projectView.SolutionHostExtensionsKt;
import com.jetbrains.resharper.runtime.DotNetRuntime;
import com.jetbrains.resharper.runtime.dotNetCore.DotNetCoreRuntime;
import com.jetbrains.resharper.runtime.mono.MonoRuntime;
import com.jetbrains.resharper.runtime.msNet.MsNetRuntime;
import com.jetbrains.resharper.util.idea.ILifetimedComponent;
import com.jetbrains.resharper.util.idea.LifetimedComponent;
import com.jetbrains.rider.model.RdActiveRuntime;
import com.jetbrains.rider.util.lifetime.Lifetime;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u001f2\u00020\u00012\u00020\u0002:\u0001\u001fB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u001d\u001a\u00020\u001eR\u0012\u0010\u0006\u001a\u00020\u0007X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u0006 "}, d2={"Lcom/jetbrains/resharper/runtime/RiderDotNetActiveRuntimeHost;", "Lcom/intellij/openapi/components/AbstractProjectComponent;", "Lcom/jetbrains/resharper/util/idea/ILifetimedComponent;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "componentLifetime", "Lcom/jetbrains/rider/util/lifetime/Lifetime;", "getComponentLifetime", "()Lcom/jetbrains/rider/util/lifetime/Lifetime;", "dotNetCoreRuntime", "Lcom/jetbrains/resharper/runtime/dotNetCore/DotNetCoreRuntime;", "getDotNetCoreRuntime", "()Lcom/jetbrains/resharper/runtime/dotNetCore/DotNetCoreRuntime;", "setDotNetCoreRuntime", "(Lcom/jetbrains/resharper/runtime/dotNetCore/DotNetCoreRuntime;)V", "monoRuntime", "Lcom/jetbrains/resharper/runtime/mono/MonoRuntime;", "getMonoRuntime", "()Lcom/jetbrains/resharper/runtime/mono/MonoRuntime;", "setMonoRuntime", "(Lcom/jetbrains/resharper/runtime/mono/MonoRuntime;)V", "msNetRuntime", "Lcom/jetbrains/resharper/runtime/DotNetRuntime;", "getMsNetRuntime", "()Lcom/jetbrains/resharper/runtime/DotNetRuntime;", "setMsNetRuntime", "(Lcom/jetbrains/resharper/runtime/DotNetRuntime;)V", "getCurrentDotNetRuntime", "useMonoUnderWindows", "", "Companion", "rider"})
public final class RiderDotNetActiveRuntimeHost
extends AbstractProjectComponent
implements ILifetimedComponent {
    @NotNull
    private DotNetRuntime msNetRuntime;
    @Nullable
    private DotNetCoreRuntime dotNetCoreRuntime;
    @Nullable
    private MonoRuntime monoRuntime;
    private static final Logger logger;
    public static final Companion Companion;
    private final /* synthetic */ LifetimedComponent $$delegate_0;

    @NotNull
    public final DotNetRuntime getMsNetRuntime() {
        return this.msNetRuntime;
    }

    public final void setMsNetRuntime(@NotNull DotNetRuntime dotNetRuntime) {
        Intrinsics.checkParameterIsNotNull((Object)dotNetRuntime, (String)"<set-?>");
        this.msNetRuntime = dotNetRuntime;
    }

    @Nullable
    public final DotNetCoreRuntime getDotNetCoreRuntime() {
        return this.dotNetCoreRuntime;
    }

    public final void setDotNetCoreRuntime(@Nullable DotNetCoreRuntime dotNetCoreRuntime) {
        this.dotNetCoreRuntime = dotNetCoreRuntime;
    }

    @Nullable
    public final MonoRuntime getMonoRuntime() {
        return this.monoRuntime;
    }

    public final void setMonoRuntime(@Nullable MonoRuntime monoRuntime) {
        this.monoRuntime = monoRuntime;
    }

    @Nullable
    public final DotNetRuntime getCurrentDotNetRuntime(boolean useMonoUnderWindows) {
        MonoRuntime currentMonoRuntime = this.monoRuntime;
        if (SystemInfo.isWindows && !useMonoUnderWindows) {
            return this.msNetRuntime;
        }
        if (currentMonoRuntime != null) {
            return currentMonoRuntime;
        }
        return null;
    }

    public RiderDotNetActiveRuntimeHost(@NotNull Project project2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        super(project2);
        this.$$delegate_0 = new LifetimedComponent(project2);
        this.msNetRuntime = new MsNetRuntime();
        SolutionHostExtensionsKt.getSolution(project2).getDotNetActiveRuntimeHost().getActiveRuntime().advise(this.getComponentLifetime(), (Function1<RdActiveRuntime, Unit>)((Function1)new Function1<RdActiveRuntime, Unit>(){

            public final void invoke(@NotNull RdActiveRuntime it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                String dotNetCliExePath = it.getDotNetCliExePath();
                if (dotNetCliExePath != null) {
                    this.setDotNetCoreRuntime(new DotNetCoreRuntime(dotNetCliExePath));
                } else {
                    this.setDotNetCoreRuntime(null);
                }
                String monoExePath = it.getMonoExePath();
                if (monoExePath != null) {
                    this.setMonoRuntime(new MonoRuntime(monoExePath, null, 2, null));
                } else {
                    this.setMonoRuntime(null);
                }
                Companion.getLogger().info("Update active runtime: " + it);
            }
        }));
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(RiderDotNetActiveRuntimeHost.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
        RiderDotNetActiveRuntimeHost.logger = logger;
    }

    @Override
    @NotNull
    public Lifetime getComponentLifetime() {
        return this.$$delegate_0.getComponentLifetime();
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/resharper/runtime/RiderDotNetActiveRuntimeHost$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "rider"})
    public static final class Companion {
        private final Logger getLogger() {
            return logger;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

