/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.settings;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.FileIndentOptionsProvider;
import com.jetbrains.resharper.editors.TextControlHost;
import com.jetbrains.resharper.util.idea.ApplicationKt;
import com.jetbrains.resharper.util.idea.PsiFileExKt;
import com.jetbrains.rider.model.TextControlModel;
import com.jetbrains.rider.util.reactive.PropertyExKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/jetbrains/resharper/settings/RiderFileIndentOptionsProvider;", "Lcom/intellij/psi/codeStyle/FileIndentOptionsProvider;", "()V", "getIndentOptions", "Lcom/intellij/psi/codeStyle/CommonCodeStyleSettings$IndentOptions;", "settings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "psiFile", "Lcom/intellij/psi/PsiFile;", "rider"})
public final class RiderFileIndentOptionsProvider
extends FileIndentOptionsProvider {
    @Nullable
    public CommonCodeStyleSettings.IndentOptions getIndentOptions(@NotNull CodeStyleSettings settings, @NotNull PsiFile psiFile) {
        boolean newUseTab;
        boolean bl;
        boolean bl2;
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        Intrinsics.checkParameterIsNotNull((Object)psiFile, (String)"psiFile");
        ApplicationKt.getApplication().assertIsDispatchThread();
        if (!PsiFileExKt.getIsRider(psiFile)) {
            return null;
        }
        Project project2 = psiFile.getProject();
        if (project2.isDisposed()) {
            return null;
        }
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project2);
        EditorFactory editorFactory = EditorFactory.getInstance();
        Document document = psiDocumentManager.getDocument(psiFile);
        if (document == null) {
            return null;
        }
        Document document2 = document;
        Editor editor = (Editor)ArraysKt.firstOrNull((Object[])editorFactory.getEditors(document2, project2));
        if (editor == null) {
            return null;
        }
        Editor editor2 = editor;
        TextControlModel textControlModel = (TextControlModel)editor2.getUserData(TextControlHost.Companion.getTextControlKey());
        if (textControlModel == null) {
            return null;
        }
        TextControlModel textControlModel2 = textControlModel;
        Object object = settings.getIndentOptions(psiFile.getFileType()).clone();
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.codeStyle.CommonCodeStyleSettings.IndentOptions");
        }
        CommonCodeStyleSettings.IndentOptions indentOptions = (CommonCodeStyleSettings.IndentOptions)object;
        Integer n2 = PropertyExKt.getValueOrNull(textControlModel2.getTabSize());
        int newTabSize = n2 != null ? n2 : indentOptions.TAB_SIZE;
        boolean bl3 = bl2 = newTabSize >= 0;
        if (_Assertions.ENABLED && !bl2) {
            String string2 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        Integer n3 = PropertyExKt.getValueOrNull(textControlModel2.getIndentSize());
        int newIndentSize = n3 != null ? n3 : indentOptions.INDENT_SIZE;
        boolean bl4 = bl = newIndentSize >= 0;
        if (_Assertions.ENABLED && !bl) {
            String string3 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string3));
        }
        Boolean bl5 = PropertyExKt.getValueOrNull(textControlModel2.getUseTab());
        boolean bl6 = newUseTab = bl5 != null ? bl5 : indentOptions.USE_TAB_CHARACTER;
        if (indentOptions.TAB_SIZE != newTabSize || newIndentSize != indentOptions.TAB_SIZE || newUseTab != indentOptions.USE_TAB_CHARACTER) {
            indentOptions.setOverrideLanguageOptions(true);
            indentOptions.TAB_SIZE = newTabSize;
            indentOptions.INDENT_SIZE = newIndentSize;
            indentOptions.USE_TAB_CHARACTER = newUseTab;
            return indentOptions;
        }
        return null;
    }
}

