/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.settings;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableGroup;
import com.intellij.openapi.options.newEditor.SettingsDialogFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.DialogWrapper;
import com.jetbrains.resharper.settings.ReSharperConfigurableUtilKt;
import com.jetbrains.resharper.settings.RiderSettingsDialog;
import com.jetbrains.resharper.settings.RiderSettingsDialogFactoryCookie;
import com.jetbrains.resharper.settings.SettingsViewModelHost;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J7\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016\u00a2\u0006\u0002\u0010\u0010J0\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0016J0\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0016J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0017\u001a\u00020\rJ'\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0019\u001a\u00020\u00132\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0002\u0010\u001aJ\u000e\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/resharper/settings/RiderSettingsDialogFactory;", "Lcom/intellij/openapi/options/newEditor/SettingsDialogFactory;", "projectManager", "Lcom/intellij/openapi/project/ProjectManager;", "(Lcom/intellij/openapi/project/ProjectManager;)V", "create", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "groups", "", "Lcom/intellij/openapi/options/ConfigurableGroup;", "configurable", "Lcom/intellij/openapi/options/Configurable;", "filter", "", "(Lcom/intellij/openapi/project/Project;[Lcom/intellij/openapi/options/ConfigurableGroup;Lcom/intellij/openapi/options/Configurable;Ljava/lang/String;)Lcom/intellij/openapi/ui/DialogWrapper;", "key", "showApplyButton", "", "showResetButton", "parent", "Ljava/awt/Component;", "source", "filterConfigurableGroup", "shouldFilter", "(Z[Lcom/intellij/openapi/options/ConfigurableGroup;)[Lcom/intellij/openapi/options/ConfigurableGroup;", "getOrCreateGroup", "rider"})
public final class RiderSettingsDialogFactory
extends SettingsDialogFactory {
    private final ProjectManager projectManager;

    @Override
    @NotNull
    public DialogWrapper create(@NotNull Project project2, @NotNull String key, @NotNull Configurable configurable, boolean showApplyButton, boolean showResetButton) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)configurable, (String)"configurable");
        SettingsViewModelHost host = SettingsViewModelHost.Companion.getOrCreate(project2);
        RiderSettingsDialog dialog2 = new RiderSettingsDialog(project2, key, configurable, showApplyButton, showResetButton, host);
        return dialog2;
    }

    @Override
    @NotNull
    public DialogWrapper create(@NotNull Project project2, @NotNull ConfigurableGroup[] groups2, @Nullable Configurable configurable, @Nullable String filter2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)groups2, (String)"groups");
        SettingsViewModelHost host = SettingsViewModelHost.Companion.getOrCreate(project2);
        ConfigurableGroup[] filteredGroups = this.filterConfigurableGroup(host.getLayer() != null, groups2);
        RiderSettingsDialogFactoryCookie.Companion.setProject(project2);
        RiderSettingsDialog dialog2 = new RiderSettingsDialog(project2, filteredGroups, configurable, filter2, host);
        RiderSettingsDialogFactoryCookie.Companion.setProject(null);
        return dialog2;
    }

    @Override
    @NotNull
    public DialogWrapper create(@NotNull Component parent, @NotNull String key, @NotNull Configurable configurable, boolean showApplyButton, boolean showResetButton) {
        Intrinsics.checkParameterIsNotNull((Object)parent, (String)"parent");
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)configurable, (String)"configurable");
        Project project2 = this.projectManager.getDefaultProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"projectManager.defaultProject");
        SettingsViewModelHost host = SettingsViewModelHost.Companion.getOrCreate(project2);
        RiderSettingsDialog dialog2 = new RiderSettingsDialog(parent, key, configurable, showApplyButton, showResetButton, host);
        return dialog2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ConfigurableGroup[] filterConfigurableGroup(boolean shouldFilter, @NotNull ConfigurableGroup[] groups2) {
        void filteredGroups;
        Ref.ObjectRef objectRef;
        Intrinsics.checkParameterIsNotNull((Object)groups2, (String)"groups");
        if (!shouldFilter) {
            return groups2;
        }
        Ref.ObjectRef objectRef2 = objectRef = new Ref.ObjectRef();
        List list2 = new ArrayList();
        objectRef2.element = list2;
        Object $receiver$iv = groups2;
        for (int i2 = 0; i2 < ((Object[])$receiver$iv).length; ++i2) {
            Configurable group;
            Object element$iv = $receiver$iv[i2];
            ConfigurableGroup it = (ConfigurableGroup)element$iv;
            if (!(it instanceof Configurable) || (group = this.filter((Configurable)it)) == null) continue;
            ConfigurableGroup wrappedGrouped2 = this.getOrCreateGroup(group);
            ((List)filteredGroups.element).add(wrappedGrouped2);
        }
        $receiver$iv = (List)filteredGroups.element;
        if ($receiver$iv == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Collection thisCollection$iv = (Collection)$receiver$iv;
        ConfigurableGroup[] configurableGroupArray = thisCollection$iv.toArray(new ConfigurableGroup[thisCollection$iv.size()]);
        if (configurableGroupArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return (ConfigurableGroup[])((Object[])configurableGroupArray);
    }

    @Nullable
    public final Configurable filter(@NotNull Configurable source) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        if (source instanceof Configurable && ReSharperConfigurableUtilKt.checkIsConfigurableFromReSharper(source)) {
            return source;
        }
        if (source instanceof Configurable.Composite) {
            List filteredChildren = new ArrayList();
            Object[] $receiver$iv = ((Configurable.Composite)source).getConfigurables();
            for (int i2 = 0; i2 < $receiver$iv.length; ++i2) {
                Configurable it;
                Object element$iv = $receiver$iv[i2];
                Configurable configurable = it = (Configurable)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)configurable, (String)"it");
                Configurable child = this.filter(configurable);
                if (child == null) continue;
                filteredChildren.add(child);
            }
            if (CollectionsKt.any((Iterable)filteredChildren)) {
                ConfigurableGroup stub2 = new ConfigurableGroup(source, filteredChildren){
                    final /* synthetic */ Configurable $source;
                    final /* synthetic */ List $filteredChildren;

                    @NotNull
                    public String getShortName() {
                        return "";
                    }

                    @Nullable
                    public JComponent createComponent() {
                        return null;
                    }

                    public boolean isModified() {
                        return false;
                    }

                    public void apply() {
                    }

                    @NotNull
                    public String getDisplayName() {
                        String string2 = this.$source.getDisplayName();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"source.displayName");
                        return string2;
                    }

                    @NotNull
                    public Configurable[] getConfigurables() {
                        Collection $receiver$iv;
                        Collection collection = $receiver$iv = (Collection)this.$filteredChildren;
                        if (collection == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
                        }
                        Collection thisCollection$iv = collection;
                        Configurable[] configurableArray = thisCollection$iv.toArray(new Configurable[thisCollection$iv.size()]);
                        if (configurableArray == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                        }
                        return (Configurable[])((Object[])configurableArray);
                    }
                    {
                        this.$source = $captured_local_variable$0;
                        this.$filteredChildren = $captured_local_variable$1;
                    }
                };
                return (Configurable)stub2;
            }
        }
        return null;
    }

    @NotNull
    public final ConfigurableGroup getOrCreateGroup(@NotNull Configurable source) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        if (source instanceof ConfigurableGroup) {
            return (ConfigurableGroup)source;
        }
        ConfigurableGroup wrappedGrouped2 = new ConfigurableGroup(source){
            final /* synthetic */ Configurable $source;

            @NotNull
            public String getDisplayName() {
                String string2 = this.$source.getDisplayName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"source.displayName");
                return string2;
            }

            @NotNull
            public String getShortName() {
                return "";
            }

            @NotNull
            public Configurable[] getConfigurables() {
                Configurable[] elements$iv = new Configurable[]{this.$source};
                return (Configurable[])((Object[])elements$iv);
            }
            {
                this.$source = $captured_local_variable$0;
            }
        };
        return wrappedGrouped2;
    }

    public RiderSettingsDialogFactory(@NotNull ProjectManager projectManager) {
        Intrinsics.checkParameterIsNotNull((Object)projectManager, (String)"projectManager");
        this.projectManager = projectManager;
    }
}

