/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.settings;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableGroup;
import com.intellij.openapi.options.OptionsBundle;
import com.intellij.openapi.options.newEditor.SettingsFilter;
import com.intellij.openapi.options.newEditor.SettingsTreeView;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.jetbrains.resharper.settings.ReSharperConfigurableUtilKt;
import javax.swing.Icon;
import javax.swing.JLabel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B!\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0010\u0010\u0004\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0006\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0007J,\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014R\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/resharper/settings/RiderSettingsTreeView;", "Lcom/intellij/openapi/options/newEditor/SettingsTreeView;", "filter", "Lcom/intellij/openapi/options/newEditor/SettingsFilter;", "groups", "", "Lcom/intellij/openapi/options/ConfigurableGroup;", "(Lcom/intellij/openapi/options/newEditor/SettingsFilter;[Lcom/intellij/openapi/options/ConfigurableGroup;)V", "layersIcon", "Ljavax/swing/Icon;", "Lorg/jetbrains/annotations/NotNull;", "solutionIcon", "setProjectIcon", "", "projectIcon", "Ljavax/swing/JLabel;", "myConfigurable", "Lcom/intellij/openapi/options/Configurable;", "project", "Lcom/intellij/openapi/project/Project;", "selected", "", "rider"})
public final class RiderSettingsTreeView
extends SettingsTreeView {
    private final Icon layersIcon = IconLoader.getIcon((String)"/rider/codeStyle/configurableLayer.png");
    private final Icon solutionIcon = IconLoader.getIcon((String)"/rider/codeStyle/configurableProject.png");

    @Override
    protected void setProjectIcon(@NotNull JLabel projectIcon, @Nullable Configurable myConfigurable, @Nullable Project project2, boolean selected) {
        Intrinsics.checkParameterIsNotNull((Object)projectIcon, (String)"projectIcon");
        boolean isConfigurableFromReSharper = ReSharperConfigurableUtilKt.checkIsConfigurableFromReSharper(myConfigurable);
        if (isConfigurableFromReSharper) {
            projectIcon.setIcon(this.layersIcon);
            projectIcon.setToolTipText("These options can be shared via ReSharper settings layers");
            projectIcon.setVisible(true);
        } else if (project2 != null) {
            projectIcon.setIcon(this.solutionIcon);
            projectIcon.setToolTipText(OptionsBundle.message((String)(project2.isDefault() ? "configurable.default.project.tooltip" : "configurable.current.project.tooltip"), (Object[])new Object[0]));
            projectIcon.setVisible(true);
        } else {
            projectIcon.setVisible(false);
        }
    }

    public RiderSettingsTreeView(@Nullable SettingsFilter filter2, @Nullable ConfigurableGroup[] groups2) {
        super(filter2, groups2);
    }
}

