/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.settings;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.jetbrains.resharper.protocol.ApplicationProtocolKt;
import com.jetbrains.resharper.settings.OptionsUtilsHost;
import com.jetbrains.resharper.settings.SettingsViewModelHost;
import com.jetbrains.resharper.util.idea.ApplicationKt;
import com.jetbrains.resharper.util.idea.DisposableExKt;
import com.jetbrains.rider.model.OptionsDialog;
import com.jetbrains.rider.model.OptionsPage;
import com.jetbrains.rider.model.OptionsPageContentBase;
import com.jetbrains.rider.model.OptionsPageInfo;
import com.jetbrains.rider.model.SettingsLayer;
import com.jetbrains.rider.model.SettingsLayerCollection;
import com.jetbrains.rider.model.SettingsViewModel;
import com.jetbrains.rider.util.lifetime.Lifetime;
import com.jetbrains.rider.util.lifetime.LifetimeDefinition;
import com.jetbrains.rider.util.reactive.IProperty;
import com.jetbrains.rider.util.reactive.IReadonlyProperty;
import com.jetbrains.rider.util.reactive.PropertyExKt;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \"2\u00020\u0001:\u0001\"B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u0014J\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u0017J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010\u001b\u001a\u00020\u0012J$\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00172\u0014\u0010\u001d\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u001f\u0012\u0004\u0012\u00020\u00120\u001eJ\u000e\u0010 \u001a\u00020\u00122\u0006\u0010!\u001a\u00020\u0017R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006#"}, d2={"Lcom/jetbrains/resharper/settings/SettingsViewModelHost;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "layer", "Lcom/jetbrains/rider/model/SettingsLayer;", "getLayer", "()Lcom/jetbrains/rider/model/SettingsLayer;", "lifetimeDef", "Lcom/jetbrains/rider/util/lifetime/LifetimeDefinition;", "getLifetimeDef", "()Lcom/jetbrains/rider/util/lifetime/LifetimeDefinition;", "settingsViewModel", "Lcom/jetbrains/rider/model/SettingsViewModel;", "getSettingsViewModel", "()Lcom/jetbrains/rider/model/SettingsViewModel;", "cancel", "", "getCurrentDialogLifetime", "Lcom/jetbrains/rider/util/lifetime/Lifetime;", "getPageKeywords", "", "", "id", "isDialogOpen", "", "ok", "requestPage", "handler", "Lkotlin/Function1;", "Lcom/jetbrains/rider/model/OptionsPageContentBase;", "saveTo", "layerName", "Companion", "rider"})
public final class SettingsViewModelHost {
    @NotNull
    private final LifetimeDefinition lifetimeDef;
    @NotNull
    private final SettingsViewModel settingsViewModel;
    @Nullable
    private final SettingsLayer layer;
    @NotNull
    private static final Logger logger;
    private static SettingsViewModelHost instance;
    public static final Companion Companion;

    @NotNull
    public final LifetimeDefinition getLifetimeDef() {
        return this.lifetimeDef;
    }

    @NotNull
    public final SettingsViewModel getSettingsViewModel() {
        return this.settingsViewModel;
    }

    @Nullable
    public final SettingsLayer getLayer() {
        return this.layer;
    }

    @NotNull
    public final Lifetime getCurrentDialogLifetime() {
        return this.lifetimeDef.getLifetime();
    }

    public final void requestPage(@NotNull String id, @NotNull Function1<? super OptionsPageContentBase, Unit> handler2) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        Intrinsics.checkParameterIsNotNull(handler2, (String)"handler");
        Lifetime lifetime = Lifetime.Companion.create(this.getCurrentDialogLifetime()).getLifetime();
        IProperty<OptionsDialog> dialog2 = this.settingsViewModel.getOptionsDialog();
        if (PropertyExKt.getHasValue((IReadonlyProperty)dialog2)) {
            Map map2;
            Map map3;
            Map map4 = map3 = (map2 = (Map)dialog2.getValue().getPages());
            if (map4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<K, *>");
            }
            if (map4.containsKey(id)) {
                IProperty<OptionsPageInfo> infoProperty;
                Object v2 = dialog2.getValue().getPages().get(id);
                if (v2 == null) {
                    Intrinsics.throwNpe();
                }
                if ((infoProperty = ((OptionsPage)v2).getInfo()).getValue() == null) {
                    infoProperty.advise(lifetime, (Function1<OptionsPageInfo, Unit>)((Function1)new Function1<OptionsPageInfo, Unit>(handler2){
                        final /* synthetic */ Function1 $handler;

                        public final void invoke(@Nullable OptionsPageInfo it) {
                            OptionsPageInfo optionsPageInfo = it;
                            this.$handler.invoke((Object)(optionsPageInfo != null ? optionsPageInfo.getContent() : null));
                        }
                        {
                            this.$handler = function1;
                            super(1);
                        }
                    }));
                } else {
                    OptionsPageInfo optionsPageInfo = infoProperty.getValue();
                    handler2.invoke((Object)(optionsPageInfo != null ? optionsPageInfo.getContent() : null));
                }
                return;
            }
            OptionsPage optionPage = new OptionsPage();
            optionPage.getInfo().setValue(null);
            this.settingsViewModel.getProtocol().getScheduler().queue((Function0<Unit>)((Function0)new Function0<Unit>(optionPage, dialog2, id, lifetime, handler2){
                final /* synthetic */ OptionsPage $optionPage;
                final /* synthetic */ IProperty $dialog;
                final /* synthetic */ String $id;
                final /* synthetic */ Lifetime $lifetime;
                final /* synthetic */ Function1 $handler;

                public final void invoke() {
                    Map map2 = ((OptionsDialog)this.$dialog.getValue()).getPages();
                    String string2 = this.$id;
                    OptionsPage optionsPage = this.$optionPage;
                    map2.put(string2, optionsPage);
                    this.$optionPage.getInfo().advise(this.$lifetime, (Function1<OptionsPageInfo, Unit>)((Function1)new Function1<OptionsPageInfo, Unit>(this){
                        final /* synthetic */ requestPage.2 this$0;

                        public final void invoke(@Nullable OptionsPageInfo it) {
                            OptionsPageInfo optionsPageInfo = it;
                            this.this$0.$handler.invoke((Object)(optionsPageInfo != null ? optionsPageInfo.getContent() : null));
                        }
                        {
                            this.this$0 = var1_1;
                            super(1);
                        }
                    }));
                }
                {
                    this.$optionPage = optionsPage;
                    this.$dialog = iProperty;
                    this.$id = string2;
                    this.$lifetime = lifetime;
                    this.$handler = function1;
                    super(0);
                }
            }));
        }
    }

    @NotNull
    public final List<String> getPageKeywords(@NotNull String id) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        IProperty<OptionsDialog> dialog2 = this.settingsViewModel.getOptionsDialog();
        if (PropertyExKt.getHasValue((IReadonlyProperty)dialog2)) {
            Map map2;
            Map map3;
            Map map4 = map3 = (map2 = (Map)dialog2.getValue().getPages());
            if (map4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<K, *>");
            }
            if (map4.containsKey(id)) {
                IProperty<OptionsPageInfo> infoProperty;
                OptionsPageInfo infoPropertyValue;
                Object v2 = dialog2.getValue().getPages().get(id);
                if (v2 == null) {
                    Intrinsics.throwNpe();
                }
                if ((infoPropertyValue = (infoProperty = ((OptionsPage)v2).getInfo()).getValue()) != null) {
                    return infoPropertyValue.getSearchableKeywords();
                }
            }
        }
        return CollectionsKt.emptyList();
    }

    public final void ok() {
        this.settingsViewModel.getOptionsDialog().getValue().getSave().fire();
        this.lifetimeDef.terminate();
    }

    public final void cancel() {
        this.settingsViewModel.getOptionsDialog().getValue().getCancel().fire();
        this.lifetimeDef.terminate();
    }

    public final void saveTo(@NotNull String layerName) {
        Intrinsics.checkParameterIsNotNull((Object)layerName, (String)"layerName");
        if (this.layer != null) {
            this.ok();
            return;
        }
        SettingsLayerCollection layerCollection = this.settingsViewModel.getOptionsDialog().getValue().getSettingsLayerCollection().getValue();
        if (layerCollection != null) {
            Iterable $receiver$iv = layerCollection.getLayers();
            for (Object element$iv : $receiver$iv) {
                SettingsLayer it = (SettingsLayer)element$iv;
                if (!Intrinsics.areEqual((Object)it.getDisplayName(), (Object)layerName)) continue;
                this.settingsViewModel.getOptionsDialog().getValue().getSaveTo().fire(it);
                this.lifetimeDef.terminate();
                return;
            }
        }
    }

    public final boolean isDialogOpen() {
        return !this.lifetimeDef.isTerminated();
    }

    public SettingsViewModelHost(@NotNull Project project2) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        boolean bl2 = bl = SettingsViewModelHost.Companion.getInstance() == null;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        this.lifetimeDef = !project2.isDefault() ? DisposableExKt.makeLifetimeDefinition((Disposable)project2) : Lifetime.Companion.getEternal().createNestedDef();
        this.lifetimeDef.getLifetime().add((Function0<Unit>)((Function0)1.INSTANCE));
        this.settingsViewModel = project2.isDefault() ? SettingsViewModel.Companion.create(this.lifetimeDef.getLifetime(), ApplicationProtocolKt.getWarmProtocol(ApplicationKt.getApplication())) : SettingsViewModel.Companion.create(this.lifetimeDef.getLifetime(), ApplicationProtocolKt.getProtocol(project2));
        this.layer = OptionsUtilsHost.Companion.getLayer();
        this.settingsViewModel.getOptionsDialog().setValue(new OptionsDialog(this.layer));
        SettingsViewModelHost.Companion.setInstance(this);
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(SettingsViewModelHost.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
        SettingsViewModelHost.logger = logger;
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\r\u001a\u0004\u0018\u00010\u0004J\u000e\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/resharper/settings/SettingsViewModelHost$Companion;", "", "()V", "instance", "Lcom/jetbrains/resharper/settings/SettingsViewModelHost;", "getInstance", "()Lcom/jetbrains/resharper/settings/SettingsViewModelHost;", "setInstance", "(Lcom/jetbrains/resharper/settings/SettingsViewModelHost;)V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "getCurrentInstance", "getOrCreate", "project", "Lcom/intellij/openapi/project/Project;", "rider"})
    public static final class Companion {
        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        private final SettingsViewModelHost getInstance() {
            return instance;
        }

        private final void setInstance(SettingsViewModelHost settingsViewModelHost) {
            instance = settingsViewModelHost;
        }

        @Nullable
        public final SettingsViewModelHost getCurrentInstance() {
            return this.getInstance();
        }

        @NotNull
        public final SettingsViewModelHost getOrCreate(@NotNull Project project2) {
            Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
            ApplicationKt.getApplication().assertIsDispatchThread();
            if (this.getInstance() == null) {
                return new SettingsViewModelHost(project2);
            }
            SettingsViewModelHost settingsViewModelHost = this.getInstance();
            if (settingsViewModelHost == null) {
                Intrinsics.throwNpe();
            }
            return settingsViewModelHost;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

