/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.settings.codeStyle;

import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.util.EmptyEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.jetbrains.resharper.ideaInterop.fileTypes.csharp.CSharpFileType;
import com.jetbrains.resharper.settings.codeStyle.PreviewFactory;
import com.jetbrains.resharper.settings.naming.NamingChangeTracker;
import com.jetbrains.resharper.settings.naming.NamingItemCommitter;
import com.jetbrains.resharper.settings.naming.NamingPolicyEditor;
import com.jetbrains.resharper.settings.naming.NamingPolicySelectionHandler;
import com.jetbrains.resharper.settings.naming.NamingRuleEditor;
import com.jetbrains.resharper.settings.naming.NamingTreeFactory;
import com.jetbrains.resharper.settings.naming.ViewRefresher;
import com.jetbrains.resharper.settings.tree.CodeStyleTreeFactory;
import com.jetbrains.rider.model.CodeStylePageContent;
import com.jetbrains.rider.model.NamingPageContent;
import com.jetbrains.rider.model.NamingPolicy;
import com.jetbrains.rider.model.NamingRuleItem;
import com.jetbrains.rider.model.StyleItemState;
import com.jetbrains.rider.util.lifetime.Lifetime;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0012\u0010\u0015\u001a\u00020\u00122\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\u0012\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0014J\u0010\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u001dH\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0014J\b\u0010 \u001a\u00020\u0014H\u0016J\b\u0010!\u001a\u00020\u0003H\u0014J\b\u0010\"\u001a\u00020#H\u0014J\b\u0010$\u001a\u00020\u0003H\u0014J\u0012\u0010%\u001a\u00020&2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\u0012\u0010'\u001a\u00020\u00122\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0014J\u000e\u0010(\u001a\u00020\u00122\u0006\u0010)\u001a\u00020\u001cJ\u000e\u0010(\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001dR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006*"}, d2={"Lcom/jetbrains/resharper/settings/codeStyle/RiderCodeStyleTabPanel;", "Lcom/intellij/application/options/CodeStyleAbstractPanel;", "title", "", "lifetime", "Lcom/jetbrains/rider/util/lifetime/Lifetime;", "settings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "(Ljava/lang/String;Lcom/jetbrains/rider/util/lifetime/Lifetime;Lcom/intellij/psi/codeStyle/CodeStyleSettings;)V", "getLifetime", "()Lcom/jetbrains/rider/util/lifetime/Lifetime;", "myPanel", "Ljavax/swing/JPanel;", "getMyPanel", "()Ljavax/swing/JPanel;", "getTitle", "()Ljava/lang/String;", "addViewToPanel", "", "view", "Ljavax/swing/JComponent;", "apply", "createHighlighter", "Lcom/intellij/openapi/editor/highlighter/EditorHighlighter;", "scheme", "Lcom/intellij/openapi/editor/colors/EditorColorsScheme;", "createView", "content", "Lcom/jetbrains/rider/model/CodeStylePageContent;", "Lcom/jetbrains/rider/model/NamingPageContent;", "getFileType", "Lcom/intellij/openapi/fileTypes/FileType;", "getPanel", "getPreviewText", "getRightMargin", "", "getTabTitle", "isModified", "", "resetImpl", "setContent", "codeStylePageContent", "rider"})
public final class RiderCodeStyleTabPanel
extends CodeStyleAbstractPanel {
    @NotNull
    private final JPanel myPanel;
    @NotNull
    private final String title;
    @NotNull
    private final Lifetime lifetime;

    @NotNull
    public final JPanel getMyPanel() {
        return this.myPanel;
    }

    public final void setContent(@NotNull CodeStylePageContent codeStylePageContent) {
        Intrinsics.checkParameterIsNotNull((Object)codeStylePageContent, (String)"codeStylePageContent");
        JComponent view2 = this.createView(codeStylePageContent);
        this.addViewToPanel(view2);
    }

    public final void setContent(@NotNull NamingPageContent content2) {
        Intrinsics.checkParameterIsNotNull((Object)content2, (String)"content");
        JComponent view2 = this.createView(content2);
        this.addViewToPanel(view2);
    }

    @Override
    @NotNull
    protected String getTabTitle() {
        return this.title;
    }

    @Override
    protected int getRightMargin() {
        return 0;
    }

    @Override
    @NotNull
    protected EditorHighlighter createHighlighter(@Nullable EditorColorsScheme scheme2) {
        return new EmptyEditorHighlighter(this.getEditor().getColorsScheme().getAttributes(HighlighterColors.TEXT));
    }

    @Override
    @NotNull
    protected FileType getFileType() {
        return (FileType)CSharpFileType.INSTANCE;
    }

    @Override
    @NotNull
    protected String getPreviewText() {
        return "preview text";
    }

    @Override
    public void apply(@Nullable CodeStyleSettings settings) {
    }

    @Override
    public boolean isModified(@Nullable CodeStyleSettings settings) {
        return false;
    }

    @Override
    @NotNull
    public JComponent getPanel() {
        return this.myPanel;
    }

    @Override
    protected void resetImpl(@Nullable CodeStyleSettings settings) {
    }

    private final JComponent createView(CodeStylePageContent content2) {
        CodeStyleTreeFactory treeFactory = new CodeStyleTreeFactory();
        TreeTable treeTable2 = treeFactory.CreateTree(content2);
        JScrollPane scrollPanel = new JScrollPane((Component)treeTable2);
        scrollPanel.setBorder(IdeBorderFactory.createBorder());
        PreviewFactory previewFactory = new PreviewFactory();
        JPanel preview = previewFactory.Build(this.lifetime, content2.getPreview());
        JSplitPane splitPanel = new JSplitPane(0);
        splitPanel.setBorder(IdeBorderFactory.createEmptyBorder((int)0, (int)0, (int)0, (int)0));
        splitPanel.setTopComponent(scrollPanel);
        splitPanel.setBottomComponent(preview);
        splitPanel.setResizeWeight(0.66);
        JPanel panel2 = new JPanel();
        panel2.setLayout(new GridLayout(0, 1));
        panel2.setBorder(IdeBorderFactory.createEmptyBorder((int)0, (int)0, (int)0, (int)0));
        panel2.add(splitPanel);
        GuiUtils.replaceJSplitPaneWithIDEASplitter((JComponent)splitPanel);
        return panel2;
    }

    private final JComponent createView(NamingPageContent content2) {
        JPanel panel2 = new JPanel();
        NamingTreeFactory treeBuilder = new NamingTreeFactory();
        ViewRefresher viewRefresher = new ViewRefresher(panel2);
        NamingItemCommitter namingItemCommitter = new NamingItemCommitter(viewRefresher);
        NamingChangeTracker namingChangeTracker = new NamingChangeTracker(namingItemCommitter);
        NamingRuleEditor ruleEditor = new NamingRuleEditor(namingChangeTracker);
        NamingPolicyEditor policyEditor = new NamingPolicyEditor(ruleEditor, namingChangeTracker);
        NamingPolicySelectionHandler handler2 = new NamingPolicySelectionHandler(policyEditor);
        namingItemCommitter.set(policyEditor);
        JComponent treeTable2 = treeBuilder.BuildTree(content2, handler2);
        JScrollPane scrollPanel = new JScrollPane(treeTable2);
        scrollPanel.setBorder(IdeBorderFactory.createBorder());
        JSplitPane splitPanel = new JSplitPane(1);
        splitPanel.setBorder(IdeBorderFactory.createEmptyBorder((int)0, (int)0, (int)0, (int)0));
        splitPanel.setTopComponent(scrollPanel);
        splitPanel.setBottomComponent(policyEditor);
        panel2.setLayout(new GridLayout(0, 1));
        panel2.setBorder(IdeBorderFactory.createEmptyBorder((int)0, (int)0, (int)0, (int)0));
        panel2.add(splitPanel);
        GuiUtils.replaceJSplitPaneWithIDEASplitter((JComponent)splitPanel);
        Iterable $receiver$iv = content2.getItems();
        for (Object element$iv : $receiver$iv) {
            NamingRuleItem it = (NamingRuleItem)element$iv;
            it.getPolicy().getChange().advise(this.lifetime, (Function1)new Function1<NamingPolicy, Unit>(this, viewRefresher){
                final /* synthetic */ RiderCodeStyleTabPanel this$0;
                final /* synthetic */ ViewRefresher $viewRefresher$inlined;
                {
                    this.this$0 = riderCodeStyleTabPanel;
                    this.$viewRefresher$inlined = viewRefresher;
                    super(1);
                }

                public final void invoke(NamingPolicy it) {
                    this.$viewRefresher$inlined.refresh();
                }
            });
            it.getState().getChange().advise(this.lifetime, (Function1)new Function1<StyleItemState, Unit>(this, viewRefresher){
                final /* synthetic */ RiderCodeStyleTabPanel this$0;
                final /* synthetic */ ViewRefresher $viewRefresher$inlined;
                {
                    this.this$0 = riderCodeStyleTabPanel;
                    this.$viewRefresher$inlined = viewRefresher;
                    super(1);
                }

                public final void invoke(StyleItemState it) {
                    this.$viewRefresher$inlined.refresh();
                }
            });
            it.getPreview().getChange().advise(this.lifetime, (Function1)new Function1<String, Unit>(this, viewRefresher){
                final /* synthetic */ RiderCodeStyleTabPanel this$0;
                final /* synthetic */ ViewRefresher $viewRefresher$inlined;
                {
                    this.this$0 = riderCodeStyleTabPanel;
                    this.$viewRefresher$inlined = viewRefresher;
                    super(1);
                }

                public final void invoke(String it) {
                    this.$viewRefresher$inlined.refresh();
                }
            });
        }
        return panel2;
    }

    private final void addViewToPanel(JComponent view2) {
        this.myPanel.removeAll();
        this.myPanel.add((Component)view2, "North");
        this.myPanel.validate();
        this.myPanel.repaint();
    }

    @NotNull
    public final String getTitle() {
        return this.title;
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    public RiderCodeStyleTabPanel(@NotNull String title, @NotNull Lifetime lifetime, @NotNull CodeStyleSettings settings) {
        Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
        Intrinsics.checkParameterIsNotNull((Object)lifetime, (String)"lifetime");
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        super(settings);
        this.title = title;
        this.lifetime = lifetime;
        this.myPanel = new JPanel();
        this.myPanel.setLayout(new GridLayout(0, 1));
        this.myPanel.setBorder(IdeBorderFactory.createEmptyBorder((int)0, (int)0, (int)0, (int)0));
        JBLoadingPanel myLoadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)this);
        myLoadingPanel.startLoading();
        this.myPanel.add((Component)myLoadingPanel, "Center");
    }
}

