/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.settings.layers;

import com.intellij.CommonBundle;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.util.ui.JBDimension;
import com.jetbrains.resharper.actions.RiderActionGroup;
import com.jetbrains.resharper.actions.RiderActionPlaces;
import com.jetbrains.resharper.icons.IconHost;
import com.jetbrains.resharper.settings.layers.LayersDialog;
import com.jetbrains.resharper.settings.layers.LayersModelHost;
import com.jetbrains.resharper.settings.layers.LayersTreeFactory;
import com.jetbrains.resharper.util.idea.DisposableExKt;
import com.jetbrains.rider.model.Layer;
import com.jetbrains.rider.model.ManageLayersDialog;
import com.jetbrains.rider.model.ManageLayersDialogContent;
import com.jetbrains.rider.util.lifetime.Lifetime;
import com.jetbrains.rider.util.reactive.IViewable;
import com.jetbrains.rider.util.reactive.PropertyExKt;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0013\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0014\u00a2\u0006\u0002\u0010\u0011J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0014J\u0013\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0014\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u0015\u001a\u00020\u0016H\u0014J\b\u0010\u0017\u001a\u00020\u0016H\u0014J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0014J\n\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J \u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/jetbrains/resharper/settings/layers/LayersDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "host", "Lcom/jetbrains/resharper/settings/layers/LayersModelHost;", "iconHost", "Lcom/jetbrains/resharper/icons/IconHost;", "outerLifetime", "Lcom/jetbrains/rider/util/lifetime/Lifetime;", "(Lcom/jetbrains/resharper/settings/layers/LayersModelHost;Lcom/jetbrains/resharper/icons/IconHost;Lcom/jetbrains/rider/util/lifetime/Lifetime;)V", "lifetime", "myLogger", "Lcom/intellij/openapi/diagnostic/Logger;", "myManageLayersDialog", "Lcom/jetbrains/rider/model/ManageLayersDialog;", "createActions", "", "Ljavax/swing/Action;", "()[Ljavax/swing/Action;", "createCenterPanel", "Ljavax/swing/JComponent;", "createLeftSideActions", "dispose", "", "doHelpAction", "getDimensionServiceKey", "", "getInitialLocation", "Ljava/awt/Point;", "repaintLayers", "panel", "Ljavax/swing/JPanel;", "content", "Lcom/jetbrains/rider/model/ManageLayersDialogContent;", "lt", "rider"})
public final class LayersDialog
extends DialogWrapper {
    private final Lifetime lifetime;
    private final ManageLayersDialog myManageLayersDialog;
    private final Logger myLogger;
    private final LayersModelHost host;
    private final IconHost iconHost;

    @NotNull
    protected Action[] createActions() {
        DialogWrapper.DialogWrapperAction myCloseAction2 = new DialogWrapper.DialogWrapperAction(this, CommonBundle.message((String)"close.action.name", (Object[])new Object[0])){
            final /* synthetic */ LayersDialog this$0;

            protected void doAction(@NotNull ActionEvent e2) {
                Intrinsics.checkParameterIsNotNull((Object)e2, (String)"e");
                this.this$0.close(0);
            }
            {
                this.this$0 = $outer;
                super((DialogWrapper)$outer, $super_call_param$1);
            }
        };
        Action[] elements$iv = new Action[]{(Action)myCloseAction2};
        return (Action[])((Object[])elements$iv);
    }

    @NotNull
    protected Action[] createLeftSideActions() {
        Action[] actionArray = new Action[1];
        Action action2 = this.getHelpAction();
        Intrinsics.checkExpressionValueIsNotNull((Object)action2, (String)"helpAction");
        actionArray[0] = action2;
        Action[] elements$iv = actionArray;
        return (Action[])((Object[])elements$iv);
    }

    protected void doHelpAction() {
        BrowserUtil.browse((String)"https://www.jetbrains.com/help/resharper/2017.1/Sharing_Configuration_Options.html");
    }

    @Nullable
    public Point getInitialLocation() {
        Point ownerLocation = this.getOwner().getLocation();
        Dimension ownerSize = this.getOwner().getSize();
        double magic = 0.33;
        return new Point(ownerLocation.x + (int)((double)ownerSize.width * magic), ownerLocation.y + (int)((double)ownerSize.height * magic));
    }

    @Nullable
    protected String getDimensionServiceKey() {
        return "LayersDialog";
    }

    @Nullable
    protected JComponent createCenterPanel() {
        this.myLogger.debug("createCenterPanel");
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        JBLoadingPanel loadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), this.myDisposable);
        loadingPanel.startLoading();
        mainPanel.add((Component)loadingPanel);
        mainPanel.setPreferredSize(new Dimension(150, 100));
        PropertyExKt.viewNotNull((IViewable)this.myManageLayersDialog.getContent(), this.lifetime, (Function2)new Function2<Lifetime, ManageLayersDialogContent, Unit>(this, loadingPanel, mainPanel){
            final /* synthetic */ LayersDialog this$0;
            final /* synthetic */ JBLoadingPanel $loadingPanel;
            final /* synthetic */ JPanel $mainPanel;

            public final void invoke(@NotNull Lifetime lt, @NotNull ManageLayersDialogContent content2) {
                Intrinsics.checkParameterIsNotNull((Object)lt, (String)"lt");
                Intrinsics.checkParameterIsNotNull((Object)content2, (String)"content");
                this.$loadingPanel.stopLoading();
                LayersDialog.access$getMyLogger$p(this.this$0).debug("reload layers");
                LayersDialog.access$repaintLayers(this.this$0, this.$mainPanel, content2, lt);
                content2.getLayers().advise(lt, (Function1<List<Layer>, Unit>)((Function1)new Function1<List<? extends Layer>, Unit>(this, content2, lt){
                    final /* synthetic */ createCenterPanel.1 this$0;
                    final /* synthetic */ ManageLayersDialogContent $content;
                    final /* synthetic */ Lifetime $lt;

                    public final void invoke(@NotNull List<Layer> it) {
                        Intrinsics.checkParameterIsNotNull(it, (String)"it");
                        LayersDialog.access$repaintLayers(this.this$0.this$0, this.this$0.$mainPanel, this.$content, this.$lt);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$content = manageLayersDialogContent;
                        this.$lt = lifetime;
                        super(1);
                    }
                }));
            }
            {
                this.this$0 = layersDialog;
                this.$loadingPanel = jBLoadingPanel;
                this.$mainPanel = jPanel;
                super(2);
            }
        });
        this.host.getLayersModel().getManageLayersDialog().setValue(this.myManageLayersDialog);
        return mainPanel;
    }

    protected void dispose() {
        this.host.getLayersModel().getManageLayersDialog().setValue(null);
        super.dispose();
    }

    private final void repaintLayers(JPanel panel2, ManageLayersDialogContent content2, Lifetime lt) {
        Component lastComponent;
        Object[] objectArray;
        LayersTreeFactory factory2 = new LayersTreeFactory(this.iconHost);
        RiderActionGroup actionGroup = new RiderActionGroup("RiderSettingsLayersDialogContextMenu", false);
        AnAction dblClickAction = ActionManager.getInstance().getAction("RiderEditSettingsLayerOptions");
        ActionGroup actionGroup2 = (ActionGroup)actionGroup;
        AnAction anAction = dblClickAction;
        Intrinsics.checkExpressionValueIsNotNull((Object)anAction, (String)"dblClickAction");
        TreeTable tree2 = factory2.createTree(content2, actionGroup2, anAction, lt);
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar(RiderActionPlaces.INSTANCE.getSETTINGS_LAYERS_DIALOG(), (ActionGroup)actionGroup, true);
        toolbar.setTargetComponent((JComponent)tree2);
        int selectedRow = -1;
        Object object = objectArray = (Object[])panel2.getComponents();
        if (!(((Object[])object).length == 0) && (lastComponent = (Component)ArraysKt.last((Object[])panel2.getComponents())) instanceof TreeTable) {
            selectedRow = ((TreeTable)lastComponent).getSelectedRow();
        }
        panel2.removeAll();
        object = new JPanel(new BorderLayout());
        JPanel $receiver = (JPanel)object;
        $receiver.add((Component)toolbar.getComponent(), "Center");
        $receiver.setPreferredSize((Dimension)new JBDimension(1, 29));
        JPanel toolbarPanel = (JPanel)object;
        panel2.add((Component)toolbarPanel, "First");
        panel2.add((Component)tree2, "Center");
        panel2.setBackground(Color.lightGray);
        panel2.validate();
        panel2.repaint();
        this.repaint();
        tree2.requestFocus();
        int rowCount = tree2.getRowCount();
        if (rowCount == 0) {
            return;
        }
        int rowToSelect = 0;
        if (selectedRow >= 0 && selectedRow < rowCount) {
            rowToSelect = selectedRow;
        }
        tree2.getSelectionModel().addSelectionInterval(rowToSelect, rowToSelect);
    }

    public LayersDialog(@NotNull LayersModelHost host, @NotNull IconHost iconHost, @NotNull Lifetime outerLifetime) {
        Logger logger;
        Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
        Intrinsics.checkParameterIsNotNull((Object)iconHost, (String)"iconHost");
        Intrinsics.checkParameterIsNotNull((Object)outerLifetime, (String)"outerLifetime");
        super(true);
        this.host = host;
        this.iconHost = iconHost;
        this.lifetime = DisposableExKt.makeLifetime(this.myDisposable);
        this.myManageLayersDialog = new ManageLayersDialog();
        LayersDialog layersDialog = this;
        Logger logger2 = Logger.getInstance(LayersDialog.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger2, (String)"Logger.getInstance(T::class.java)");
        layersDialog.myLogger = logger = logger2;
        this.myLogger.debug("before init");
        this.setModal(false);
        this.setTitle(CommonBundle.settingsTitle() + " Layers");
        this.init();
        this.myLogger.debug("after init");
        outerLifetime.add((Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                this.close(1);
            }
        }));
    }

    @NotNull
    public static final /* synthetic */ Logger access$getMyLogger$p(LayersDialog $this) {
        return $this.myLogger;
    }

    public static final /* synthetic */ void access$repaintLayers(LayersDialog $this, @NotNull JPanel panel2, @NotNull ManageLayersDialogContent content2, @NotNull Lifetime lt) {
        $this.repaintLayers(panel2, content2, lt);
    }
}

