/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.settings.naming;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.AnActionButtonUpdater;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.JBTable;
import com.jetbrains.resharper.settings.naming.ICurrentPolicyProvider;
import com.jetbrains.resharper.settings.naming.MutableNamingRule;
import com.jetbrains.resharper.settings.naming.NamingChangeTracker;
import com.jetbrains.resharper.settings.naming.NamingRuleEditor;
import com.jetbrains.resharper.settings.naming.NamingRulesTableModel;
import com.jetbrains.rider.model.NamingPolicy;
import com.jetbrains.rider.model.NamingRule;
import com.jetbrains.rider.model.NamingStyleKinds;
import com.jetbrains.rider.util.reactive.IProperty;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0013\u001a\u00020\u000bH\u0002J\b\u0010\u0014\u001a\u00020\u000bH\u0002J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0002J\u0010\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u00012\u0006\u0010\u001e\u001a\u00020\rH\u0002J\u0014\u0010\u001f\u001a\u00020\u00162\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!J\b\u0010#\u001a\u00020\"H\u0016J\u0010\u0010$\u001a\u00020\u00162\u0006\u0010%\u001a\u00020\u0018H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/jetbrains/resharper/settings/naming/NamingPolicyEditor;", "Ljavax/swing/JPanel;", "Lcom/jetbrains/resharper/settings/naming/ICurrentPolicyProvider;", "namingRuleEditor", "Lcom/jetbrains/resharper/settings/naming/NamingRuleEditor;", "namingChangeTracker", "Lcom/jetbrains/resharper/settings/naming/NamingChangeTracker;", "(Lcom/jetbrains/resharper/settings/naming/NamingRuleEditor;Lcom/jetbrains/resharper/settings/naming/NamingChangeTracker;)V", "inspectionsEnabled", "Ljavax/swing/JCheckBox;", "myRuleSelected", "", "myTable", "Lcom/intellij/ui/table/JBTable;", "rules", "Ljava/util/ArrayList;", "Lcom/jetbrains/resharper/settings/naming/MutableNamingRule;", "tableSelectionModel", "Ljavax/swing/ListSelectionModel;", "canChangeRuleList", "canRemove", "changeRules", "", "from", "", "to", "convertToMutable", "rule", "Lcom/jetbrains/rider/model/NamingRule;", "createPanel", "table", "fillFromPolicy", "policy", "Lcom/jetbrains/rider/util/reactive/IProperty;", "Lcom/jetbrains/rider/model/NamingPolicy;", "get", "setSelection", "k", "rider"})
public final class NamingPolicyEditor
extends JPanel
implements ICurrentPolicyProvider {
    private final JCheckBox inspectionsEnabled;
    private final ArrayList<MutableNamingRule> rules;
    private final ListSelectionModel tableSelectionModel;
    private boolean myRuleSelected;
    private final JBTable myTable;
    private final NamingRuleEditor namingRuleEditor;
    private final NamingChangeTracker namingChangeTracker;

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public NamingPolicy get() {
        boolean enableInspection = this.inspectionsEnabled.isSelected();
        ArrayList<NamingRule> extraRules = new ArrayList<NamingRule>();
        MutableNamingRule firstRule = (MutableNamingRule)CollectionsKt.first((List)this.rules);
        NamingRule mainRule = new NamingRule(firstRule.getKind(), firstRule.getPrefix(), firstRule.getSuffix());
        Iterable $receiver$iv = this.rules;
        int index$iv = 0;
        for (Object item$iv : $receiver$iv) {
            void it;
            int n2 = index$iv++;
            MutableNamingRule mutableNamingRule = (MutableNamingRule)item$iv;
            int i2 = n2;
            if (i2 == 0) continue;
            NamingRule rule = new NamingRule(it.getKind(), it.getPrefix(), it.getSuffix());
            extraRules.add(rule);
        }
        NamingPolicy policy = new NamingPolicy(mainRule, (List<NamingRule>)extraRules, enableInspection);
        return policy;
    }

    public final void fillFromPolicy(@NotNull IProperty<NamingPolicy> policy) {
        Intrinsics.checkParameterIsNotNull(policy, (String)"policy");
        this.tableSelectionModel.clearSelection();
        this.namingChangeTracker.stopTracking();
        NamingPolicy policyValue = policy.getValue();
        this.inspectionsEnabled.setSelected(policyValue.getEnableInspection());
        this.inspectionsEnabled.setEnabled(true);
        this.myRuleSelected = true;
        this.rules.clear();
        this.rules.add(this.convertToMutable(policyValue.getRule()));
        Iterable $receiver$iv = policyValue.getExtraRules();
        for (Object element$iv : $receiver$iv) {
            NamingRule it = (NamingRule)element$iv;
            this.rules.add(this.convertToMutable(it));
        }
        this.setSelection(0);
        this.validate();
        this.repaint();
        this.namingChangeTracker.startTracking(policy);
    }

    private final JPanel createPanel(JBTable table2) {
        JPanel rulesPanel2;
        AnActionButtonRunnable addRuleAction2 = new AnActionButtonRunnable(this){
            final /* synthetic */ NamingPolicyEditor this$0;

            public final void run(AnActionButton it) {
                NamingPolicyEditor.access$getTableSelectionModel$p(this.this$0).clearSelection();
                MutableNamingRule newRule = new MutableNamingRule(NamingStyleKinds.AaBb, "", "");
                NamingPolicyEditor.access$getRules$p(this.this$0).add(newRule);
                Collection collection = NamingPolicyEditor.access$getRules$p(this.this$0);
                int lastIndex = collection.size() - 1;
                NamingPolicyEditor.access$setSelection(this.this$0, lastIndex);
                NamingPolicyEditor.access$getNamingChangeTracker$p(this.this$0).handleDataChanged();
            }
            {
                this.this$0 = namingPolicyEditor;
            }
        };
        AnActionButtonRunnable removeRuleAction2 = new AnActionButtonRunnable(this){
            final /* synthetic */ NamingPolicyEditor this$0;

            public final void run(AnActionButton it) {
                Collection collection = NamingPolicyEditor.access$getRules$p(this.this$0);
                if (collection.size() <= 1) {
                    return;
                }
                int selectedIndex = NamingPolicyEditor.access$getTableSelectionModel$p(this.this$0).getLeadSelectionIndex();
                if (selectedIndex >= 0) {
                    NamingPolicyEditor.access$getTableSelectionModel$p(this.this$0).clearSelection();
                    NamingPolicyEditor.access$getRules$p(this.this$0).remove(selectedIndex);
                    int newSelectionIndex = selectedIndex > 0 ? selectedIndex - 1 : 0;
                    NamingPolicyEditor.access$setSelection(this.this$0, newSelectionIndex);
                    NamingPolicyEditor.access$getNamingChangeTracker$p(this.this$0).handleDataChanged();
                }
            }
            {
                this.this$0 = namingPolicyEditor;
            }
        };
        AnActionButtonRunnable moveUpRuleAction2 = new AnActionButtonRunnable(this){
            final /* synthetic */ NamingPolicyEditor this$0;

            public final void run(AnActionButton it) {
                int selectedIndex = NamingPolicyEditor.access$getTableSelectionModel$p(this.this$0).getLeadSelectionIndex();
                if (selectedIndex > 0) {
                    NamingPolicyEditor.access$changeRules(this.this$0, selectedIndex, selectedIndex - 1);
                }
            }
            {
                this.this$0 = namingPolicyEditor;
            }
        };
        AnActionButtonRunnable moveDownRuleAction2 = new AnActionButtonRunnable(this){
            final /* synthetic */ NamingPolicyEditor this$0;

            public final void run(AnActionButton it) {
                Collection collection;
                int n2;
                int selectedIndex = NamingPolicyEditor.access$getTableSelectionModel$p(this.this$0).getLeadSelectionIndex();
                int n3 = selectedIndex;
                if (n3 < (n2 = (collection = (Collection)NamingPolicyEditor.access$getRules$p(this.this$0)).size()) - 1) {
                    NamingPolicyEditor.access$changeRules(this.this$0, selectedIndex, selectedIndex + 1);
                }
            }
            {
                this.this$0 = namingPolicyEditor;
            }
        };
        JPanel jPanel = rulesPanel2 = ToolbarDecorator.createDecorator((JTable)((JTable)table2)).setAddAction(addRuleAction2).setAddActionUpdater(new AnActionButtonUpdater(this){
            final /* synthetic */ NamingPolicyEditor this$0;

            public final boolean isEnabled(AnActionEvent it) {
                return NamingPolicyEditor.access$canChangeRuleList(this.this$0);
            }
            {
                this.this$0 = namingPolicyEditor;
            }
        }).setRemoveAction(removeRuleAction2).setRemoveActionUpdater(new AnActionButtonUpdater(this){
            final /* synthetic */ NamingPolicyEditor this$0;

            public final boolean isEnabled(AnActionEvent it) {
                return NamingPolicyEditor.access$canRemove(this.this$0);
            }
            {
                this.this$0 = namingPolicyEditor;
            }
        }).setMoveUpAction(moveUpRuleAction2).setMoveDownAction(moveDownRuleAction2).createPanel();
        if (jPanel == null) {
            Intrinsics.throwNpe();
        }
        return jPanel;
    }

    private final MutableNamingRule convertToMutable(NamingRule rule) {
        MutableNamingRule res2 = new MutableNamingRule(rule.getKind(), rule.getPrefix(), rule.getSuffix());
        return res2;
    }

    private final void changeRules(int from, int to) {
        MutableNamingRule ruleI = this.rules.get(from);
        MutableNamingRule ruleJ = this.rules.get(to);
        this.rules.set(to, ruleI);
        this.rules.set(from, ruleJ);
        this.tableSelectionModel.clearSelection();
        this.setSelection(to);
        this.namingChangeTracker.handleDataChanged();
    }

    private final void setSelection(int k2) {
        this.tableSelectionModel.setSelectionInterval(k2, k2);
    }

    private final boolean canChangeRuleList() {
        return this.myRuleSelected;
    }

    private final boolean canRemove() {
        Collection collection = this.rules;
        return collection.size() > 1;
    }

    public NamingPolicyEditor(@NotNull NamingRuleEditor namingRuleEditor, @NotNull NamingChangeTracker namingChangeTracker) {
        Intrinsics.checkParameterIsNotNull((Object)namingRuleEditor, (String)"namingRuleEditor");
        Intrinsics.checkParameterIsNotNull((Object)namingChangeTracker, (String)"namingChangeTracker");
        this.namingRuleEditor = namingRuleEditor;
        this.namingChangeTracker = namingChangeTracker;
        this.inspectionsEnabled = new JCheckBox();
        this.rules = new ArrayList();
        this.setLayout(new BorderLayout());
        JPanel panelInspections = new JPanel();
        panelInspections.setLayout(new FlowLayout(0));
        this.inspectionsEnabled.setText("Enable inspections");
        this.inspectionsEnabled.setAlignmentX(0.0f);
        panelInspections.setAlignmentX(0.0f);
        panelInspections.add(this.inspectionsEnabled);
        this.add((Component)panelInspections, "Last");
        JPanel innerPanel = new JPanel();
        innerPanel.setLayout(new BorderLayout());
        innerPanel.add((Component)this.namingRuleEditor, "Last");
        NamingRulesTableModel model2 = new NamingRulesTableModel((List<MutableNamingRule>)this.rules);
        this.myTable = new JBTable((TableModel)model2);
        ListSelectionModel listSelectionModel = this.myTable.getSelectionModel();
        Intrinsics.checkExpressionValueIsNotNull((Object)listSelectionModel, (String)"myTable.selectionModel");
        this.tableSelectionModel = listSelectionModel;
        this.tableSelectionModel.setSelectionMode(0);
        this.tableSelectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public final void valueChanged(ListSelectionEvent e2) {
                int selectedIndex = tableSelectionModel.getLeadSelectionIndex();
                tableSelectionModel.getMaxSelectionIndex();
                if (selectedIndex >= 0) {
                    MutableNamingRule selectedRule = (MutableNamingRule)rules.get(selectedIndex);
                    namingChangeTracker.stopTracking();
                    NamingRuleEditor namingRuleEditor = namingRuleEditor;
                    MutableNamingRule mutableNamingRule = selectedRule;
                    Intrinsics.checkExpressionValueIsNotNull((Object)mutableNamingRule, (String)"selectedRule");
                    namingRuleEditor.fillFromRule(mutableNamingRule);
                    NamingChangeTracker.startTracking$default(namingChangeTracker, null, 1, null);
                    TableUtil.updateScroller((JTable)((JTable)myTable));
                    TableUtil.scrollSelectionToVisible((JTable)((JTable)myTable));
                }
            }
        });
        JPanel rulesPanel2 = this.createPanel(this.myTable);
        innerPanel.add(rulesPanel2);
        this.add(innerPanel);
        this.inspectionsEnabled.addActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent it) {
                namingChangeTracker.handleDataChanged();
            }
        });
        this.inspectionsEnabled.setEnabled(false);
    }

    public static final /* synthetic */ void access$setSelection(NamingPolicyEditor $this, int k2) {
        $this.setSelection(k2);
    }

    public static final /* synthetic */ void access$changeRules(NamingPolicyEditor $this, int from, int to) {
        $this.changeRules(from, to);
    }

    public static final /* synthetic */ boolean access$canChangeRuleList(NamingPolicyEditor $this) {
        return $this.canChangeRuleList();
    }

    public static final /* synthetic */ boolean access$canRemove(NamingPolicyEditor $this) {
        return $this.canRemove();
    }
}

