/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.settings.naming;

import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.jetbrains.resharper.settings.naming.MutableNamingRule;
import com.jetbrains.resharper.settings.naming.NamingChangeTracker;
import com.jetbrains.resharper.settings.naming.NamingStyleKindsConverter;
import com.jetbrains.rider.model.NamingStyleKinds;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\bJ\b\u0010\u0012\u001a\u00020\u0010H\u0002J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/resharper/settings/naming/NamingRuleEditor;", "Ljavax/swing/JPanel;", "namingChangeTracker", "Lcom/jetbrains/resharper/settings/naming/NamingChangeTracker;", "(Lcom/jetbrains/resharper/settings/naming/NamingChangeTracker;)V", "converter", "Lcom/jetbrains/resharper/settings/naming/NamingStyleKindsConverter;", "currentRule", "Lcom/jetbrains/resharper/settings/naming/MutableNamingRule;", "prefix", "Ljavax/swing/JTextField;", "style", "Ljavax/swing/JComboBox;", "", "suffix", "fillFromRule", "", "rule", "handleDataChanged", "setIsEnabled", "value", "", "setMaxHeight", "c", "Ljavax/swing/JComponent;", "rider"})
public final class NamingRuleEditor
extends JPanel {
    private final JTextField prefix;
    private JTextField suffix;
    private JComboBox<String> style;
    private MutableNamingRule currentRule;
    private final NamingStyleKindsConverter converter;
    private final NamingChangeTracker namingChangeTracker;

    public final void fillFromRule(@NotNull MutableNamingRule rule) {
        Intrinsics.checkParameterIsNotNull((Object)rule, (String)"rule");
        this.setIsEnabled(true);
        this.currentRule = rule;
        this.prefix.setText(rule.getPrefix());
        this.suffix.setText(rule.getSuffix());
        this.style.setSelectedItem(this.converter.convert(rule.getKind()));
    }

    private final void handleDataChanged() {
        boolean bl;
        if (!this.namingChangeTracker.getShouldTrackChanged()) {
            return;
        }
        boolean bl2 = bl = this.currentRule != null;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        MutableNamingRule mutableNamingRule = this.currentRule;
        if (mutableNamingRule == null) {
            Intrinsics.throwNpe();
        }
        MutableNamingRule rule = mutableNamingRule;
        String string3 = this.prefix.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"prefix.text");
        rule.setPrefix(string3);
        String string4 = this.suffix.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"suffix.text");
        rule.setSuffix(string4);
        NamingStyleKinds kind = this.converter.convertBack(this.style.getSelectedItem().toString());
        rule.setKind(kind);
        this.namingChangeTracker.handleDataChanged();
    }

    private final void setMaxHeight(JComponent c2) {
        c2.setMaximumSize(new Dimension(c2.getMaximumSize().width, c2.getPreferredSize().height));
    }

    private final void setIsEnabled(boolean value2) {
        this.prefix.setEnabled(value2);
        this.suffix.setEnabled(value2);
        this.style.setEnabled(value2);
    }

    public NamingRuleEditor(@NotNull NamingChangeTracker namingChangeTracker) {
        JComboBox<Object> jComboBox;
        Intrinsics.checkParameterIsNotNull((Object)namingChangeTracker, (String)"namingChangeTracker");
        this.namingChangeTracker = namingChangeTracker;
        this.prefix = new JTextField("Select a rule to edit");
        this.suffix = new JTextField("Select a rule to edit");
        this.converter = new NamingStyleKindsConverter();
        this.setLayout(new BoxLayout(this, 1));
        this.setAlignmentX(0.0f);
        ArrayList<JLabel> descriptionLabels = new ArrayList<JLabel>();
        JPanel panelWithPrefix = new JPanel();
        this.setMaxHeight(this.prefix);
        panelWithPrefix.setLayout(new BoxLayout(panelWithPrefix, 0));
        panelWithPrefix.setAlignmentX(0.0f);
        JLabel prefixDescriptionLabel = new JLabel("Prefix:");
        descriptionLabels.add(prefixDescriptionLabel);
        panelWithPrefix.add(prefixDescriptionLabel);
        panelWithPrefix.add(this.prefix);
        JPanel panelWithSuffix = new JPanel();
        this.setMaxHeight(this.suffix);
        panelWithSuffix.setLayout(new BoxLayout(panelWithSuffix, 0));
        panelWithSuffix.setAlignmentX(0.0f);
        JLabel suffixDescriptionLabel = new JLabel("Suffix:");
        descriptionLabels.add(suffixDescriptionLabel);
        panelWithSuffix.add(suffixDescriptionLabel);
        panelWithSuffix.add(this.suffix);
        ArrayList<String> allKinds = new ArrayList<String>();
        Object $receiver$iv = (Object[])NamingStyleKinds.values();
        for (int i2 = 0; i2 < ((Object[])$receiver$iv).length; ++i2) {
            Object element$iv = $receiver$iv[i2];
            NamingStyleKinds it = (NamingStyleKinds)((Object)element$iv);
            allKinds.add(this.converter.convert(it));
        }
        $receiver$iv = allKinds;
        JComboBox<Object> jComboBox2 = jComboBox;
        JComboBox<Object> jComboBox3 = jComboBox;
        NamingRuleEditor namingRuleEditor = this;
        Collection thisCollection$iv = (Collection)$receiver$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[thisCollection$iv.size()]);
        if (stringArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Object[] objectArray = stringArray;
        jComboBox2(objectArray);
        namingRuleEditor.style = jComboBox3;
        this.setMaxHeight(this.style);
        JPanel panelWithStyle = new JPanel();
        panelWithStyle.setLayout(new BoxLayout(panelWithStyle, 0));
        panelWithStyle.setAlignmentX(0.0f);
        JLabel styleDescriptionLabel = new JLabel("Style:");
        descriptionLabels.add(styleDescriptionLabel);
        panelWithStyle.add(styleDescriptionLabel);
        panelWithStyle.add(this.style);
        this.setBorder(IdeBorderFactory.createEmptyBorder());
        this.add(panelWithPrefix);
        this.add(panelWithSuffix);
        this.add(panelWithStyle);
        int width = 35;
        Iterable $receiver$iv2 = descriptionLabels;
        for (Object element$iv : $receiver$iv2) {
            JLabel it = (JLabel)element$iv;
            it.setMinimumSize(new Dimension(width, it.getMinimumSize().height));
            it.setPreferredSize(new Dimension(width, it.getMinimumSize().height));
            it.setMaximumSize(new Dimension(width, it.getMinimumSize().height));
        }
        this.prefix.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e2) {
                Intrinsics.checkParameterIsNotNull((Object)e2, (String)"e");
                this.handleDataChanged();
            }
        });
        this.suffix.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e2) {
                Intrinsics.checkParameterIsNotNull((Object)e2, (String)"e");
                this.handleDataChanged();
            }
        });
        this.style.addActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent it) {
                this.handleDataChanged();
            }
        });
        this.setIsEnabled(false);
    }
}

