/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.settings.tree.editors;

import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBList;
import com.intellij.util.IconUtil;
import com.jetbrains.resharper.settings.tree.editors.DirectionButtonListener;
import com.jetbrains.resharper.settings.tree.editors.MyListSelectionListener;
import com.jetbrains.resharper.settings.tree.editors.OptionEditorExKt;
import com.jetbrains.resharper.settings.tree.renderers.CodeStyleOrderedCollectionRenderer;
import com.jetbrains.rider.model.CodeStyleOrderedCollectionOption;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionListener;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J.\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/jetbrains/resharper/settings/tree/editors/OrderedCollectionEditor;", "", "()V", "downButton", "Ljavax/swing/JButton;", "initialValues", "Ljava/util/ArrayList;", "", "listView", "Lcom/intellij/ui/components/JBList;", "model", "Ljavax/swing/DefaultListModel;", "panel", "Ljavax/swing/JPanel;", "panelWithButtons", "selectedValuePanel", "Lcom/jetbrains/resharper/settings/tree/renderers/CodeStyleOrderedCollectionRenderer;", "getSelectedValuePanel", "()Lcom/jetbrains/resharper/settings/tree/renderers/CodeStyleOrderedCollectionRenderer;", "upButton", "getValue", "reset", "", "option", "Lcom/jetbrains/rider/model/CodeStyleOrderedCollectionOption;", "table", "Ljavax/swing/JTable;", "row", "", "column", "isEnabled", "", "rider"})
public final class OrderedCollectionEditor {
    @NotNull
    private final CodeStyleOrderedCollectionRenderer selectedValuePanel = new CodeStyleOrderedCollectionRenderer();
    private final DefaultListModel<String> model = new DefaultListModel();
    private ArrayList<String> initialValues = new ArrayList();
    private final JBList<String> listView = new JBList((ListModel)this.model);
    private final JPanel panel = new JPanel();
    private final JButton upButton = new JButton();
    private final JButton downButton = new JButton();
    private final JPanel panelWithButtons = new JPanel();

    @NotNull
    public final CodeStyleOrderedCollectionRenderer getSelectedValuePanel() {
        return this.selectedValuePanel;
    }

    public final void reset(@NotNull CodeStyleOrderedCollectionOption option, @NotNull JTable table2, int row, int column, boolean isEnabled) {
        Intrinsics.checkParameterIsNotNull((Object)option, (String)"option");
        Intrinsics.checkParameterIsNotNull((Object)table2, (String)"table");
        this.model.removeAllElements();
        this.initialValues.clear();
        this.selectedValuePanel.reset(option, isEnabled);
        Iterable $receiver$iv = option.getValue().getValue().getItems();
        for (Object element$iv : $receiver$iv) {
            String it = (String)element$iv;
            this.model.addElement(it);
            this.initialValues.add(it);
        }
        this.upButton.setEnabled(false);
        this.downButton.setEnabled(false);
        Rectangle rect = table2.getCellRect(row, column, true);
        Point point = new Point(rect.x, rect.y + table2.getRowHeight());
        RelativePoint relativePoint = new RelativePoint((Component)table2, point);
        JBPopup popup2 = OptionEditorExKt.disableSurrenderFocusOnKeystroke(JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)this.panel, (JComponent)this.panel).setRequestFocus(true).setFocusable(true), table2).setResizable(false).setMovable(false).setModalContext(false).setShowShadow(true).setShowBorder(true).setCancelKeyEnabled(true).setCancelOnClickOutside(true).setCancelOnOtherWindowOpen(true).createPopup();
        popup2.show(relativePoint);
    }

    @NotNull
    public final ArrayList<String> getValue() {
        Iterator $receiver$iv;
        Iterator iterator2;
        ArrayList<String> res2 = new ArrayList<String>();
        Iterator iterator3 = iterator2 = ($receiver$iv = CollectionsKt.iterator(this.model.elements()));
        while (iterator3.hasNext()) {
            Object element$iv = iterator3.next();
            String it = (String)element$iv;
            res2.add(it);
        }
        return res2;
    }

    public OrderedCollectionEditor() {
        this.upButton.addActionListener(new DirectionButtonListener(this.model, this.listView, true));
        this.downButton.addActionListener(new DirectionButtonListener(this.model, this.listView, false));
        this.upButton.setIcon(IconUtil.getMoveUpIcon());
        this.downButton.setIcon(IconUtil.getMoveDownIcon());
        this.panelWithButtons.setLayout(new GridLayout(2, 1));
        this.panelWithButtons.add(this.upButton);
        this.panelWithButtons.add(this.downButton);
        this.listView.addListSelectionListener((ListSelectionListener)new MyListSelectionListener(this.model, this.listView, this.upButton, this.downButton));
        this.panel.add((Component)this.listView);
        this.panel.add(this.panelWithButtons);
    }
}

