/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.settings.tree.renderers;

import com.intellij.ui.components.JBComboBoxLabel;
import com.jetbrains.resharper.settings.util.ColorUtil;
import com.jetbrains.rider.model.EnumWithValue;
import com.jetbrains.rider.model.RdColor;
import com.jetbrains.rider.model.Severity;
import com.jetbrains.rider.model.SeverityElement;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J8\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/resharper/settings/tree/renderers/NodeNotifyRenderer;", "Ljavax/swing/table/TableCellRenderer;", "()V", "colorUtil", "Lcom/jetbrains/resharper/settings/util/ColorUtil;", "myEmptyLabel", "Ljavax/swing/JPanel;", "myEnumRenderer", "Lcom/intellij/ui/components/JBComboBoxLabel;", "myReadonlyRenderer", "GetSeverityElement", "Lcom/jetbrains/rider/model/SeverityElement;", "severity", "Lcom/jetbrains/rider/model/Severity;", "getRendererComponent", "Ljava/awt/Component;", "value", "", "background", "Ljava/awt/Color;", "getTableCellRendererComponent", "table", "Ljavax/swing/JTable;", "isSelected", "", "hasFocus", "row", "", "column", "rider"})
public final class NodeNotifyRenderer
implements TableCellRenderer {
    private final JBComboBoxLabel myEnumRenderer = new JBComboBoxLabel();
    private final JBComboBoxLabel myReadonlyRenderer = new JBComboBoxLabel();
    private final JPanel myEmptyLabel = new JPanel();
    private final ColorUtil colorUtil = new ColorUtil();

    @Override
    @NotNull
    public Component getTableCellRendererComponent(@NotNull JTable table2, @NotNull Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
        Intrinsics.checkParameterIsNotNull((Object)table2, (String)"table");
        Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
        Color color = table2.getBackground();
        Intrinsics.checkExpressionValueIsNotNull((Object)color, (String)"table.background");
        Component component = this.getRendererComponent(value2, color);
        return component;
    }

    private final Component getRendererComponent(Object value2, Color background) {
        if (value2 instanceof Severity) {
            SeverityElement element = this.GetSeverityElement((Severity)value2);
            if (element != null) {
                String text2 = element.getValue().getPresentation();
                RdColor color = element.getColor();
                Color rendererColor = new Color(color.getR(), color.getG(), color.getB(), color.getA());
                if (((Severity)value2).isEnabled()) {
                    this.myEnumRenderer.setText(text2);
                    this.myEnumRenderer.setBackground(ColorUtil.convertColor$default(this.colorUtil, rendererColor, 0.0, 2, null));
                    return (Component)this.myEnumRenderer;
                }
                this.myReadonlyRenderer.setText(text2);
                this.myReadonlyRenderer.setBackground(this.colorUtil.convertColor(rendererColor, 0.5));
                return (Component)this.myReadonlyRenderer;
            }
            this.myReadonlyRenderer.setText("unknown");
            return (Component)this.myReadonlyRenderer;
        }
        this.myEmptyLabel.setBackground(background);
        return this.myEmptyLabel;
    }

    private final SeverityElement GetSeverityElement(Severity severity) {
        int currentValue = ((Number)severity.getValue().getValue()).intValue();
        for (SeverityElement severityElement : severity.getPossibleValues()) {
            EnumWithValue value2 = severityElement.getValue();
            if (value2.getValue() != currentValue) continue;
            return severityElement;
        }
        return null;
    }

    public NodeNotifyRenderer() {
        this.myEnumRenderer.setEnabled(true);
        this.myEnumRenderer.setHorizontalAlignment(0);
        this.myEnumRenderer.setRegularIcon();
        this.myReadonlyRenderer.setEnabled(false);
        this.myReadonlyRenderer.setHorizontalAlignment(0);
        this.myReadonlyRenderer.setSelectionIcon();
        Color color = this.myReadonlyRenderer.getForeground();
        this.myReadonlyRenderer.setForeground(new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)Math.round((double)color.getAlpha() * 0.5)));
    }
}

