/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.settings.typingAssists;

import com.intellij.application.options.editor.EditorOptionsProvider;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.SmartBackspaceMode;
import com.intellij.lang.CodeDocumentationAwareCommenter;
import com.intellij.lang.Commenter;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageCommenters;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.keymap.impl.ModifierKeyDoubleClickHandler;
import com.intellij.openapi.options.BaseConfigurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.util.Weighted;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.resharper.settings.typingAssists.RiderEditorSmartKeysConfigurable;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.KeyEvent;
import java.util.Collection;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class IjPartEditorBehaviorPage
extends BaseConfigurable
implements EditorOptionsProvider,
Weighted {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.resharper.settings.typingAssists.IjPartEditorBehaviorPage");
    private JCheckBox myCbSmartHome;
    private JCheckBox myCbSmartEnd;
    private JPanel myRootPanel;
    private JCheckBox myCbInsertJavadocStubOnEnter;
    private JCheckBox myCbSurroundSelectionOnTyping;
    private JComboBox mySmartBackspaceCombo;
    private JCheckBox myCbEnableAddingCaretsOnDoubleCtrlArrows;
    private static final String OFF = ApplicationBundle.message((String)"combobox.smart.backspace.off", (Object[])new Object[0]);
    private static final String SIMPLE = ApplicationBundle.message((String)"combobox.smart.backspace.simple", (Object[])new Object[0]);
    private static final String SMART = ApplicationBundle.message((String)"combobox.smart.backspace.smart", (Object[])new Object[0]);

    public IjPartEditorBehaviorPage() {
        this.$$$setupUI$$$();
        this.mySmartBackspaceCombo.addItem(OFF);
        this.mySmartBackspaceCombo.addItem(SIMPLE);
        this.mySmartBackspaceCombo.addItem(SMART);
        this.myCbInsertJavadocStubOnEnter.setVisible(IjPartEditorBehaviorPage.hasAnyDocAwareCommenters());
        this.myCbEnableAddingCaretsOnDoubleCtrlArrows.setText(ApplicationBundle.message((String)"checkbox.enable.double.ctrl", (Object[])new Object[]{KeyEvent.getKeyText(ModifierKeyDoubleClickHandler.getMultiCaretActionModifier())}));
    }

    private static boolean hasAnyDocAwareCommenters() {
        Collection languages = Language.getRegisteredLanguages();
        for (Language language : languages) {
            CodeDocumentationAwareCommenter docCommenter;
            Commenter commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(language);
            if (!(commenter instanceof CodeDocumentationAwareCommenter) || (docCommenter = (CodeDocumentationAwareCommenter)commenter).getDocumentationCommentLinePrefix() == null) continue;
            return true;
        }
        return false;
    }

    @Nls
    public String getDisplayName() {
        return "Smart Keys";
    }

    public String getHelpTopic() {
        return "reference.settingsdialog.IDE.editor.smartkey";
    }

    public JComponent createComponent() {
        return this.myRootPanel;
    }

    public void reset() {
        EditorSettingsExternalizable editorSettings = EditorSettingsExternalizable.getInstance();
        CodeInsightSettings codeInsightSettings = CodeInsightSettings.getInstance();
        this.myCbSmartHome.setSelected(editorSettings.isSmartHome());
        this.myCbSmartEnd.setSelected(codeInsightSettings.SMART_END_ACTION);
        this.myCbInsertJavadocStubOnEnter.setSelected(codeInsightSettings.JAVADOC_STUB_ON_ENTER);
        this.myCbSurroundSelectionOnTyping.setSelected(codeInsightSettings.SURROUND_SELECTION_ON_QUOTE_TYPED);
        this.myCbEnableAddingCaretsOnDoubleCtrlArrows.setSelected(editorSettings.addCaretsOnDoubleCtrl());
        SmartBackspaceMode backspaceMode = codeInsightSettings.getBackspaceMode();
        switch (backspaceMode) {
            case OFF: {
                this.mySmartBackspaceCombo.setSelectedItem(OFF);
                break;
            }
            case INDENT: {
                this.mySmartBackspaceCombo.setSelectedItem(SIMPLE);
                break;
            }
            case AUTOINDENT: {
                this.mySmartBackspaceCombo.setSelectedItem(SMART);
                break;
            }
            default: {
                LOG.error("Unexpected smart backspace mode value: " + backspaceMode);
            }
        }
        super.reset();
    }

    public void apply() throws ConfigurationException {
        EditorSettingsExternalizable editorSettings = EditorSettingsExternalizable.getInstance();
        CodeInsightSettings codeInsightSettings = CodeInsightSettings.getInstance();
        editorSettings.setSmartHome(this.myCbSmartHome.isSelected());
        codeInsightSettings.SMART_END_ACTION = this.myCbSmartEnd.isSelected();
        codeInsightSettings.JAVADOC_STUB_ON_ENTER = this.myCbInsertJavadocStubOnEnter.isSelected();
        codeInsightSettings.SURROUND_SELECTION_ON_QUOTE_TYPED = this.myCbSurroundSelectionOnTyping.isSelected();
        codeInsightSettings.setBackspaceMode(this.getSmartBackspaceModeValue());
        editorSettings.setAddCaretsOnDoubleCtrl(this.myCbEnableAddingCaretsOnDoubleCtrlArrows.isSelected());
    }

    public boolean isModified() {
        if (super.isModified()) {
            return true;
        }
        EditorSettingsExternalizable editorSettings = EditorSettingsExternalizable.getInstance();
        CodeInsightSettings codeInsightSettings = CodeInsightSettings.getInstance();
        boolean isModified = this.isModified(this.myCbSmartHome, editorSettings.isSmartHome());
        isModified |= this.isModified(this.myCbSmartEnd, codeInsightSettings.SMART_END_ACTION);
        isModified |= this.isModified(this.myCbInsertJavadocStubOnEnter, codeInsightSettings.JAVADOC_STUB_ON_ENTER);
        isModified |= this.isModified(this.myCbSurroundSelectionOnTyping, codeInsightSettings.SURROUND_SELECTION_ON_QUOTE_TYPED);
        isModified |= this.isModified(this.myCbEnableAddingCaretsOnDoubleCtrlArrows, editorSettings.addCaretsOnDoubleCtrl());
        return isModified |= this.getSmartBackspaceModeValue() != codeInsightSettings.getBackspaceMode();
    }

    private SmartBackspaceMode getSmartBackspaceModeValue() {
        Object selectedItem = this.mySmartBackspaceCombo.getSelectedItem();
        if (OFF.equals(selectedItem)) {
            return SmartBackspaceMode.OFF;
        }
        if (SIMPLE.equals(selectedItem)) {
            return SmartBackspaceMode.INDENT;
        }
        if (SMART.equals(selectedItem)) {
            return SmartBackspaceMode.AUTOINDENT;
        }
        LOG.error("Unexpected smart backspace item value: " + selectedItem);
        return SmartBackspaceMode.OFF;
    }

    @NotNull
    public String getId() {
        if ("editor.preferences.smartKeys" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/resharper/settings/typingAssists/IjPartEditorBehaviorPage", "getId"));
        }
        return "editor.preferences.smartKeys";
    }

    public double getWeight() {
        return RiderEditorSmartKeysConfigurable.Companion.getFIRST() + 1.0;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JComboBox jComboBox;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JCheckBox jCheckBox5;
        JPanel jPanel;
        this.myRootPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, 0, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(6, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)"Miscellaneous", (int)0, (int)0, null, null));
        this.myCbSurroundSelectionOnTyping = jCheckBox5 = new JCheckBox();
        jCheckBox5.setText("Surround selection on typing quote or brace");
        jPanel2.add((Component)jCheckBox5, new GridConstraints(2, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        this.myCbSmartHome = jCheckBox4 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox4, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.smart.home"));
        jCheckBox4.setSelected(true);
        jPanel2.add((Component)jCheckBox4, new GridConstraints(0, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        this.myCbSmartEnd = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.smart.end.on.blank.line"));
        jCheckBox3.setSelected(true);
        jPanel2.add((Component)jCheckBox3, new GridConstraints(1, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        this.myCbEnableAddingCaretsOnDoubleCtrlArrows = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.enable.double.ctrl"));
        jCheckBox2.setSelected(true);
        jPanel2.add((Component)jCheckBox2, new GridConstraints(3, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        this.myCbInsertJavadocStubOnEnter = jCheckBox = new JCheckBox();
        jCheckBox.setActionCommand("Insert documentation comment stub on Enter");
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.javadoc.stub.after.slash.star.star"));
        jCheckBox.setSelected(true);
        jPanel2.add((Component)jCheckBox, new GridConstraints(4, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Unindent on Backspace:");
        jPanel2.add((Component)jLabel, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(5, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.mySmartBackspaceCombo = jComboBox = new JComboBox();
        jPanel2.add(jComboBox, new GridConstraints(5, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c2 = '\u0000';
        int n2 = -1;
        for (int i2 = 0; i2 < string2.length(); ++i2) {
            if (string2.charAt(i2) == '&') {
                if (++i2 == string2.length()) break;
                if (!bl && string2.charAt(i2) != '&') {
                    bl = true;
                    c2 = string2.charAt(i2);
                    n2 = stringBuffer.length();
                }
            }
            stringBuffer.append(string2.charAt(i2));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c2);
            abstractButton.setDisplayedMnemonicIndex(n2);
        }
    }
}

