/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.solutionAnalysis.actions;

import com.intellij.CommonBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.util.ui.OptionsMessageDialog;
import com.jetbrains.resharper.icons.ReSharperSolutionAnalysisIcons;
import com.jetbrains.resharper.solutionAnalysis.SolutionAnalysisHost;
import com.jetbrains.resharper.solutionAnalysis.actions.SWEAActionBase;
import com.jetbrains.rider.model.SolutionAnalysisAction;
import com.jetbrains.rider.util.reactive.PropertyExKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016J\u0012\u0010\u0007\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016\u00a8\u0006\t"}, d2={"Lcom/jetbrains/resharper/solutionAnalysis/actions/SWEAReanalyzeAllAction;", "Lcom/jetbrains/resharper/solutionAnalysis/actions/SWEAActionBase;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "SWEAConfirmationDialog", "rider"})
public final class SWEAReanalyzeAllAction
extends SWEAActionBase {
    public void actionPerformed(@Nullable AnActionEvent e2) {
        if (e2 == null || e2.getProject() == null) {
            return;
        }
        SolutionAnalysisHost solutionAnalysisHost = this.getAnalysisHost(e2);
        if (solutionAnalysisHost == null) {
            return;
        }
        SolutionAnalysisHost host = solutionAnalysisHost;
        Project project2 = e2.getProject();
        if (project2 == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"e.project!!");
        if (new SWEAConfirmationDialog(project2).showAndGet()) {
            host.getModel().getRunAction().fire(SolutionAnalysisAction.ReanalyzeAll);
        }
    }

    public void update(@Nullable AnActionEvent e2) {
        super.update(e2);
        if (e2 == null) {
            return;
        }
        SolutionAnalysisHost solutionAnalysisHost = this.getAnalysisHost(e2);
        if (solutionAnalysisHost == null) {
            return;
        }
        SolutionAnalysisHost host = solutionAnalysisHost;
        if (!host.getHostReady() || !host.getLoaded()) {
            e2.getPresentation().setEnabled(false);
            return;
        }
        if (PropertyExKt.getHasValue(host.getModel().getState())) {
            e2.getPresentation().setEnabled(host.getModel().getState().getValue().getEnabled());
        }
    }

    public SWEAReanalyzeAllAction() {
        super(ReSharperSolutionAnalysisIcons.Companion.getReanalyzeAllFiles());
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\n\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0014J\n\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0014J\b\u0010\b\u001a\u00020\tH\u0014J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\tH\u0014J\b\u0010\u000e\u001a\u00020\tH\u0014\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/resharper/solutionAnalysis/actions/SWEAReanalyzeAllAction$SWEAConfirmationDialog;", "Lcom/intellij/util/ui/OptionsMessageDialog;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getCancelActionName", "", "getOkActionName", "isToBeShown", "", "setToBeShown", "", "value", "onOk", "shouldSaveOptionsOnCancel", "rider"})
    private static final class SWEAConfirmationDialog
    extends OptionsMessageDialog {
        protected boolean isToBeShown() {
            throw (Throwable)new UnsupportedOperationException();
        }

        protected void setToBeShown(boolean value2, boolean onOk) {
            throw (Throwable)new UnsupportedOperationException();
        }

        protected boolean shouldSaveOptionsOnCancel() {
            throw (Throwable)new UnsupportedOperationException();
        }

        @Nullable
        protected String getOkActionName() {
            return CommonBundle.getYesButtonText();
        }

        @Nullable
        protected String getCancelActionName() {
            return CommonBundle.getNoButtonText();
        }

        public SWEAConfirmationDialog(@NotNull Project project2) {
            Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
            super(project2, "Are you sure you want to drop all analysis results and reanalyze all files?", "Reanalyze All?", null);
            this.setDoNotAskOption(null);
            this.init();
        }
    }
}

