/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.solutionAnalysis.ui;

import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.jetbrains.resharper.icons.IconHost;
import com.jetbrains.resharper.icons.IconHostKt;
import com.jetbrains.resharper.icons.ReSharperSolutionAnalysisIcons;
import com.jetbrains.resharper.solutionAnalysis.ui.TreeErrorModel;
import com.jetbrains.resharper.solutionAnalysis.ui.TreeFileModel;
import com.jetbrains.resharper.solutionAnalysis.ui.TreeFrameworkModel;
import javax.swing.Icon;
import javax.swing.JTree;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004JB\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/resharper/solutionAnalysis/ui/SWEATreeCellRenderer;", "Lcom/intellij/ui/ColoredTreeCellRenderer;", "iconHost", "Lcom/jetbrains/resharper/icons/IconHost;", "(Lcom/jetbrains/resharper/icons/IconHost;)V", "getIconHost", "()Lcom/jetbrains/resharper/icons/IconHost;", "customizeCellRenderer", "", "tree", "Ljavax/swing/JTree;", "value", "", "selected", "", "expanded", "leaf", "row", "", "hasFocus", "rider"})
public final class SWEATreeCellRenderer
extends ColoredTreeCellRenderer {
    @NotNull
    private final IconHost iconHost;

    public void customizeCellRenderer(@NotNull JTree tree2, @Nullable Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Intrinsics.checkParameterIsNotNull((Object)tree2, (String)"tree");
        Object object = value2;
        if (object instanceof TreeFileModel) {
            Icon icon;
            if (!((TreeFileModel)value2).isFileIgnored().getValue().booleanValue()) {
                com.jetbrains.rider.model.Icon icon2 = ((TreeFileModel)value2).getIcon();
                icon = icon2 != null ? IconHostKt.toIdeaIcon(icon2, this.iconHost) : null;
            } else {
                icon = ReSharperSolutionAnalysisIcons.Companion.getIgnoreErrors();
            }
            this.setIcon(icon);
            this.append(((TreeFileModel)value2).getFileName());
            int errorCount = ((TreeFileModel)value2).getErrorCount();
            this.append(" \u2022 " + errorCount + " error" + (errorCount == 1 ? "" : "s"), SimpleTextAttributes.GRAYED_ATTRIBUTES);
        } else if (object instanceof TreeErrorModel) {
            this.setIcon(((TreeErrorModel)value2).getErrorModel().getIgnored() ? ReSharperSolutionAnalysisIcons.Companion.getIgnoreErrors() : null);
            this.append(((TreeErrorModel)value2).getErrorModel().getText());
            int frameworkCount = ((TreeErrorModel)value2).getCurrentChildren().size();
            if (frameworkCount > 1) {
                this.append(" \u2022 with " + frameworkCount + " framework" + (frameworkCount == 1 ? "" : "s"), SimpleTextAttributes.GRAYED_ATTRIBUTES);
            }
        } else if (object instanceof TreeFrameworkModel) {
            this.setIcon(((TreeFrameworkModel)value2).getError().getIgnored() ? ReSharperSolutionAnalysisIcons.Companion.getIgnoreErrors() : null);
            Intrinsics.checkExpressionValueIsNotNull((Object)this.append(((TreeFrameworkModel)value2).getFramework()), (String)"append(value.framework)");
        } else if (object instanceof String) {
            Intrinsics.checkExpressionValueIsNotNull((Object)this.append((String)value2), (String)"append(value)");
        } else {
            Intrinsics.checkExpressionValueIsNotNull((Object)this.append("Loading..."), (String)"append(\"Loading...\")");
        }
    }

    @NotNull
    public final IconHost getIconHost() {
        return this.iconHost;
    }

    public SWEATreeCellRenderer(@NotNull IconHost iconHost) {
        Intrinsics.checkParameterIsNotNull((Object)iconHost, (String)"iconHost");
        this.iconHost = iconHost;
    }
}

