/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.todo;

import com.intellij.ide.todo.TodoView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.psi.search.TodoAttributes;
import com.intellij.psi.search.TodoPattern;
import com.intellij.util.containers.BidirectionalMap;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.jetbrains.resharper.projectView.SolutionHostExtensionsKt;
import com.jetbrains.resharper.todo.TodoSettingsHostKt;
import com.jetbrains.resharper.util.idea.ApplicationKt;
import com.jetbrains.resharper.util.idea.ILifetimedComponent;
import com.jetbrains.resharper.util.idea.LifetimedComponent;
import com.jetbrains.resharper.util.idea.ui.ExtensionsKt;
import com.jetbrains.rider.model.TodoPatterns;
import com.jetbrains.rider.util.lifetime.Lifetime;
import com.jetbrains.rider.util.reactive.IProperty;
import com.jetbrains.rider.util.reactive.IReadonlyProperty;
import com.jetbrains.rider.util.reactive.PropertyExKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0013\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\u0018\u00a2\u0006\u0002\u0010\u0019J\u0010\u0010\u001a\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001b\u001a\u00020\fJ\u0006\u0010\u001c\u001a\u00020\u001dJ\u0014\u0010\u001e\u001a\u00020\u001d2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\r0 R\u0012\u0010\u0006\u001a\u00020\u0007X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n \u0013*\u0004\u0018\u00010\u00120\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/jetbrains/resharper/todo/TodoSettingsHost;", "Lcom/intellij/openapi/components/AbstractProjectComponent;", "Lcom/jetbrains/resharper/util/idea/ILifetimedComponent;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "componentLifetime", "Lcom/jetbrains/rider/util/lifetime/Lifetime;", "getComponentLifetime", "()Lcom/jetbrains/rider/util/lifetime/Lifetime;", "idToPatternMap", "Lcom/intellij/util/containers/BidirectionalMap;", "", "Lcom/intellij/psi/search/TodoPattern;", "todoSettingsModel", "Lcom/jetbrains/rider/util/reactive/IProperty;", "Lcom/jetbrains/rider/model/TodoPatterns;", "updateQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "kotlin.jvm.PlatformType", "createIdeaPattern", "it", "Lcom/jetbrains/rider/model/TodoPattern;", "getConvertedModel", "", "()[Lcom/intellij/psi/search/TodoPattern;", "getPattern", "patternId", "refreshAllBrowsers", "", "syncPatterns", "viewPatterns", "", "rider"})
public final class TodoSettingsHost
extends AbstractProjectComponent
implements ILifetimedComponent {
    private final MergingUpdateQueue updateQueue;
    private final IProperty<TodoPatterns> todoSettingsModel;
    private final BidirectionalMap<String, TodoPattern> idToPatternMap;
    private final /* synthetic */ LifetimedComponent $$delegate_0;

    public final void refreshAllBrowsers() {
        this.updateQueue.queue(new Update("update tree"){

            public void run() {
                Object[] $receiver$iv = ProjectManager.getInstance().getOpenProjects();
                for (int i2 = 0; i2 < $receiver$iv.length; ++i2) {
                    Object element$iv = $receiver$iv[i2];
                    Project project2 = (Project)element$iv;
                    if (project2.isDisposed()) continue;
                    ((TodoView)ServiceManager.getService((Project)project2, TodoView.class)).refresh();
                }
            }
        });
    }

    public final void syncPatterns(@NotNull List<? extends TodoPattern> viewPatterns) {
        Intrinsics.checkParameterIsNotNull(viewPatterns, (String)"viewPatterns");
        ArrayList<com.jetbrains.rider.model.TodoPattern> modelPatterns = new ArrayList<com.jetbrains.rider.model.TodoPattern>();
        Iterable $receiver$iv = viewPatterns;
        for (Object element$iv : $receiver$iv) {
            TodoPattern it = (TodoPattern)element$iv;
            Object object = this.idToPatternMap.getKeysByValue((Object)it);
            if (object == null || (object = (String)CollectionsKt.firstOrNull((List)object)) == null) {
                String string2 = it.getPatternString();
                object = string2;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"it.patternString");
            }
            Object id = object;
            String string3 = it.getPatternString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"it.patternString");
            com.jetbrains.rider.model.TodoPattern modelPattern = new com.jetbrains.rider.model.TodoPattern((String)id, string3, it.isCaseSensitive(), TodoSettingsHostKt.toIconStyle(it.getAttributes().getIcon()), ExtensionsKt.toRgbColor(it.getAttributes().getTextAttributes().getForegroundColor()));
            modelPatterns.add(modelPattern);
        }
        TodoPatterns todoPatterns = new TodoPatterns((List<com.jetbrains.rider.model.TodoPattern>)modelPatterns);
        PropertyExKt.set(this.todoSettingsModel, todoPatterns);
        this.refreshAllBrowsers();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final TodoPattern[] getConvertedModel() {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        boolean bl = PropertyExKt.getHasValue((IReadonlyProperty)this.todoSettingsModel);
        if (!bl) {
            String string2 = "attempting to get todo items before shell is initialized";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        TodoPatterns modelPatterns = this.todoSettingsModel.getValue();
        Iterable iterable = $receiver$iv = (Iterable)modelPatterns.getPatterns();
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            com.jetbrains.rider.model.TodoPattern todoPattern = (com.jetbrains.rider.model.TodoPattern)item$iv$iv;
            Collection collection = destination$iv$iv;
            TodoPattern todoPattern2 = this.createIdeaPattern((com.jetbrains.rider.model.TodoPattern)it);
            collection.add(todoPattern2);
        }
        $receiver$iv = (List)destination$iv$iv;
        Collection thisCollection$iv = (Collection)$receiver$iv;
        TodoPattern[] todoPatternArray = thisCollection$iv.toArray(new TodoPattern[thisCollection$iv.size()]);
        if (todoPatternArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return (TodoPattern[])((Object[])todoPatternArray);
    }

    private final TodoPattern createIdeaPattern(com.jetbrains.rider.model.TodoPattern it) {
        return new TodoPattern(it.getPattern(), new TodoAttributes(TodoSettingsHostKt.toIcon(it.getIconStyle()), new TextAttributes(TodoSettingsHostKt.toColor(it.getColor()), null, null, EffectType.BOXED, 0)), it.getCaseSensitive());
    }

    @Nullable
    public final TodoPattern getPattern(@NotNull String patternId) {
        Intrinsics.checkParameterIsNotNull((Object)patternId, (String)"patternId");
        TodoPattern result2 = (TodoPattern)this.idToPatternMap.get((Object)patternId);
        if (result2 == null) {
            Object v0;
            Iterable iterable;
            Object object;
            block3: {
                object = this.todoSettingsModel.getValue().getPatterns();
                iterable = object;
                for (Object t2 : iterable) {
                    com.jetbrains.rider.model.TodoPattern it = (com.jetbrains.rider.model.TodoPattern)t2;
                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)patternId)) continue;
                    v0 = t2;
                    break block3;
                }
                v0 = null;
            }
            com.jetbrains.rider.model.TodoPattern todoPattern = v0;
            if (todoPattern == null) {
                return null;
            }
            com.jetbrains.rider.model.TodoPattern modelPattern = todoPattern;
            result2 = this.createIdeaPattern(modelPattern);
            object = (Map)this.idToPatternMap;
            iterable = result2;
            object.put(patternId, iterable);
        }
        return result2;
    }

    public TodoSettingsHost(@NotNull Project project2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        super(project2);
        this.$$delegate_0 = new LifetimedComponent(project2);
        this.updateQueue = new MergingUpdateQueue("updateQueue", 3000, true, MergingUpdateQueue.ANY_COMPONENT, (Disposable)project2, null, true).setRestartTimerOnAdd(true);
        this.todoSettingsModel = SolutionHostExtensionsKt.getSolution(project2).getTodoModel().getTodoPatterns();
        this.idToPatternMap = new BidirectionalMap();
        ApplicationKt.getApplication().invokeLater(new Runnable(){

            @Override
            public final void run() {
                todoSettingsModel.advise(this.getComponentLifetime(), (Function1)new Function1<TodoPatterns, Unit>(){

                    public final void invoke(@NotNull TodoPatterns it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        idToPatternMap.clear();
                        this.refreshAllBrowsers();
                    }
                });
            }
        });
    }

    @Override
    @NotNull
    public Lifetime getComponentLifetime() {
        return this.$$delegate_0.getComponentLifetime();
    }
}

