/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.ui.bindableUi;

import com.intellij.openapi.util.TextRange;
import com.intellij.ui.SimpleTextAttributes;
import com.jetbrains.resharper.ui.bindableUi.RichString;
import com.jetbrains.resharper.ui.bindableUi.ViewModel;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001a\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0003B\u000f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u001b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u0017\u001a\u00020\u00182\b\b\u0001\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u001bJ\u0016\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u001dJ\b\u0010\u001e\u001a\u00020\u0000H\u0016J\u000e\u0010\u001f\u001a\u00020\u00182\u0006\u0010 \u001a\u00020!J\b\u0010\"\u001a\u00020\u0005H\u0016J\u0018\u0010#\u001a\u00020\u0018*\u00060$j\u0002`%2\u0006\u0010&\u001a\u00020!H\u0002J\u0018\u0010'\u001a\u00020\u0018*\u00060$j\u0002`%2\u0006\u0010(\u001a\u00020\u001dH\u0002R\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006)"}, d2={"Lcom/jetbrains/resharper/ui/bindableUi/RichText;", "Lcom/jetbrains/resharper/ui/bindableUi/ViewModel;", "", "()V", "text", "", "(Ljava/lang/String;)V", "parts", "", "Lcom/jetbrains/resharper/ui/bindableUi/RichString;", "(Ljava/lang/String;Ljava/util/Collection;)V", "length", "", "getLength", "()I", "myParts", "Ljava/util/ArrayList;", "myString", "", "getParts", "()Ljava/util/List;", "getText", "()Ljava/lang/String;", "addStyle", "", "style", "textRange", "Lcom/intellij/openapi/util/TextRange;", "append", "Lcom/intellij/ui/SimpleTextAttributes;", "clone", "setForeColor", "fgColor", "Ljava/awt/Color;", "toString", "dumpColor", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "bgColor", "dumpStyleAndFont", "a", "rider"})
public final class RichText
implements ViewModel,
Cloneable {
    private String myString;
    private ArrayList<RichString> myParts;

    @NotNull
    public final List<RichString> getParts() {
        return this.myParts;
    }

    @NotNull
    public final String getText() {
        return this.myString;
    }

    public final int getLength() {
        return this.getText().length();
    }

    public final void append(@NotNull String text2, @NotNull SimpleTextAttributes style) {
        Intrinsics.checkParameterIsNotNull((Object)text2, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)style, (String)"style");
        TextRange range = new TextRange(this.myString.length(), this.myString.length() + text2.length());
        this.myString = this.myString + text2;
        this.myParts.add(new RichString(range, style, this));
    }

    public final void setForeColor(@NotNull Color fgColor) {
        Intrinsics.checkParameterIsNotNull((Object)fgColor, (String)"fgColor");
        for (RichString part : this.getParts()) {
            SimpleTextAttributes attributes = part.getAttributes();
            int style = attributes.getStyle();
            Color bgColor = attributes.getBgColor();
            Color waveColor = attributes.getWaveColor();
            SimpleTextAttributes simpleTextAttributes = attributes.derive(style, fgColor, bgColor, waveColor);
            Intrinsics.checkExpressionValueIsNotNull((Object)simpleTextAttributes, (String)"attributes.derive(style,\u2026olor, bgColor, waveColor)");
            part.setAttributes(simpleTextAttributes);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void addStyle(@SimpleTextAttributes.StyleAttributeConstant int style, @NotNull TextRange textRange) {
        Intrinsics.checkParameterIsNotNull((Object)textRange, (String)"textRange");
        if (RangesKt.until((int)0, (int)this.getLength()).contains(textRange.getStartOffset()) ^ true) {
            throw (Throwable)new IllegalArgumentException("textRange");
        }
        int n2 = textRange.getEndOffset();
        if (0 > n2 || n2 > this.getLength()) {
            throw (Throwable)new IllegalArgumentException("textRange");
        }
        ArrayList<RichString> newParts = new ArrayList<RichString>();
        Iterator<RichString> iterator2 = this.myParts.iterator();
        while (iterator2.hasNext()) {
            SimpleTextAttributes newAttributes;
            void attributes;
            void partRange;
            RichString part;
            RichString richString = part = iterator2.next();
            TextRange textRange2 = richString.component1();
            SimpleTextAttributes simpleTextAttributes = richString.component2();
            richString = null;
            TextRange intersection = textRange.intersection((TextRange)partRange);
            if (intersection == null) {
                newParts.add(part);
                continue;
            }
            if (partRange.getStartOffset() != intersection.getStartOffset()) {
                newParts.add(new RichString(new TextRange(partRange.getStartOffset(), intersection.getStartOffset()), (SimpleTextAttributes)attributes, this));
            }
            SimpleTextAttributes simpleTextAttributes2 = newAttributes = attributes.derive(attributes.getStyle() | style, null, null, null);
            Intrinsics.checkExpressionValueIsNotNull((Object)simpleTextAttributes2, (String)"newAttributes");
            newParts.add(new RichString(intersection, simpleTextAttributes2, this));
            if (intersection.getEndOffset() == partRange.getEndOffset()) continue;
            newParts.add(new RichString(new TextRange(intersection.getEndOffset(), partRange.getEndOffset()), (SimpleTextAttributes)attributes, this));
        }
        this.myParts = newParts;
    }

    @NotNull
    public RichText clone() {
        RichText copy = new RichText();
        copy.myString = this.myString;
        for (RichString richString : this.myParts) {
            TextRange textRange = richString.component1();
            SimpleTextAttributes attributes = richString.component2();
            copy.myParts.add(new RichString(textRange, attributes, copy));
        }
        return copy;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String toString() {
        StringBuilder acc = new StringBuilder();
        for (RichString p2 : this.myParts) {
            Color waveColor;
            Color fgColor;
            void a;
            Object object = p2;
            TextRange textRange = ((RichString)object).component1();
            SimpleTextAttributes simpleTextAttributes = ((RichString)object).component2();
            object = null;
            object = acc;
            StringBuilder $receiver = (StringBuilder)object;
            $receiver.append("<span styles=\"");
            Color bgColor = a.getBgColor();
            if (bgColor != null) {
                $receiver.append("background-color:");
                this.dumpColor($receiver, bgColor);
            }
            if ((fgColor = a.getFgColor()) != null) {
                $receiver.append("color:");
                this.dumpColor($receiver, fgColor);
            }
            if ((waveColor = a.getWaveColor()) != null) {
                $receiver.append("wave-color:");
                Color color = fgColor;
                Intrinsics.checkExpressionValueIsNotNull((Object)color, (String)"fgColor");
                this.dumpColor($receiver, color);
            }
            this.dumpStyleAndFont($receiver, (SimpleTextAttributes)a);
            $receiver.append("");
            $receiver.append("\">");
            $receiver.append(p2.getText());
            $receiver.append("</span>");
        }
        String string2 = acc.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"acc.toString()");
        return string2;
    }

    private final void dumpStyleAndFont(@NotNull StringBuilder $receiver, SimpleTextAttributes a) {
        switch (a.getFontStyle()) {
            case 0: {
                $receiver.append("font-style: plain;");
                break;
            }
            case 2: {
                $receiver.append("font-style: italic;");
                break;
            }
            case 1: {
                $receiver.append("font-weight: bold;");
            }
        }
        if (a.isSearchMatch()) {
            $receiver.append("text-decoration: searchMatch;");
        } else if (a.isStrikeout()) {
            $receiver.append("text-decoration: strikeout;");
        } else if (a.isWaved()) {
            $receiver.append("text-decoration: waved;");
        } else if (a.isUnderline()) {
            $receiver.append("text-decoration: underline;");
        } else if (a.isBoldDottedLine()) {
            $receiver.append("text-decoration: boldDottedLine;");
        } else if (a.isOpaque()) {
            $receiver.append("text-decoration: opaque;");
        } else if (a.isSmaller()) {
            $receiver.append("text-decoration: smaller;");
        }
    }

    private final void dumpColor(@NotNull StringBuilder $receiver, Color bgColor) {
        $receiver.append("rgb(");
        $receiver.append(bgColor.getRed());
        $receiver.append(",");
        $receiver.append(bgColor.getGreen());
        $receiver.append(",");
        $receiver.append(bgColor.getBlue());
        $receiver.append(");");
    }

    public RichText(@NotNull String text2, @NotNull Collection<RichString> parts) {
        Intrinsics.checkParameterIsNotNull((Object)text2, (String)"text");
        Intrinsics.checkParameterIsNotNull(parts, (String)"parts");
        this.myString = text2;
        this.myParts = new ArrayList<RichString>(parts);
    }

    public RichText() {
        this("", CollectionsKt.emptyList());
    }

    public RichText(@NotNull String text2) {
        Intrinsics.checkParameterIsNotNull((Object)text2, (String)"text");
        this();
        SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
        Intrinsics.checkExpressionValueIsNotNull((Object)simpleTextAttributes, (String)"SimpleTextAttributes.REGULAR_ATTRIBUTES");
        this.append(text2, simpleTextAttributes);
    }
}

