/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.unitTesting;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.project.Project;
import com.jetbrains.resharper.icons.IconHost;
import com.jetbrains.resharper.projectView.ProjectModelViewHost;
import com.jetbrains.resharper.projectView.SolutionHostExtensionsKt;
import com.jetbrains.resharper.projectView.nodes.ProjectModelNode;
import com.jetbrains.resharper.unitTesting.RiderUnitTestComponentBase;
import com.jetbrains.resharper.unitTesting.RiderUnitTestElementRepository;
import com.jetbrains.resharper.unitTesting.RiderUnitTestGroupingRuleType;
import com.jetbrains.resharper.unitTesting.RiderUnitTestGroupingRules;
import com.jetbrains.resharper.unitTesting.RiderUnitTestToolWindowManager;
import com.jetbrains.resharper.unitTesting.RiderUnitTestViewSettings;
import com.jetbrains.resharper.unitTesting.trees.base.RiderUnitTestElementNode;
import com.jetbrains.resharper.unitTesting.trees.base.RiderUnitTestNode;
import com.jetbrains.resharper.unitTesting.trees.base.RiderUnitTestProjectNode;
import com.jetbrains.rider.model.RdProjectDescriptor;
import com.jetbrains.rider.model.RdProjectFileDescriptor;
import com.jetbrains.rider.model.RdProjectFolderDescriptor;
import com.jetbrains.rider.model.RdProjectModelItemDescriptor;
import com.jetbrains.rider.model.RdSolutionFolderDescriptor;
import com.jetbrains.rider.model.RdUnitTestHost;
import com.jetbrains.rider.model.RdUnitTestSelection;
import java.util.Collection;
import java.util.HashSet;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020&J\f\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)J\u0010\u0010+\u001a\u0004\u0018\u00010*2\u0006\u0010,\u001a\u00020-J\u001c\u0010.\u001a\u00020$2\u0006\u0010,\u001a\u00020-2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020*0)J\u0018\u00100\u001a\u0002012\u0006\u00102\u001a\u0002032\b\b\u0002\u00104\u001a\u00020$R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u00065"}, d2={"Lcom/jetbrains/resharper/unitTesting/RiderUnitTestFacade;", "Lcom/jetbrains/resharper/unitTesting/RiderUnitTestComponentBase;", "iconHost", "Lcom/jetbrains/resharper/icons/IconHost;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/jetbrains/resharper/icons/IconHost;Lcom/intellij/openapi/project/Project;)V", "elementRepository", "Lcom/jetbrains/resharper/unitTesting/RiderUnitTestElementRepository;", "getElementRepository", "()Lcom/jetbrains/resharper/unitTesting/RiderUnitTestElementRepository;", "groupingRules", "Lcom/jetbrains/resharper/unitTesting/RiderUnitTestGroupingRules;", "getGroupingRules", "()Lcom/jetbrains/resharper/unitTesting/RiderUnitTestGroupingRules;", "host", "Lcom/jetbrains/rider/model/RdUnitTestHost;", "getHost", "()Lcom/jetbrains/rider/model/RdUnitTestHost;", "getIconHost", "()Lcom/jetbrains/resharper/icons/IconHost;", "getProject", "()Lcom/intellij/openapi/project/Project;", "projectModelViewHost", "Lcom/jetbrains/resharper/projectView/ProjectModelViewHost;", "getProjectModelViewHost", "()Lcom/jetbrains/resharper/projectView/ProjectModelViewHost;", "twManager", "Lcom/jetbrains/resharper/unitTesting/RiderUnitTestToolWindowManager;", "getTwManager", "()Lcom/jetbrains/resharper/unitTesting/RiderUnitTestToolWindowManager;", "viewSettings", "Lcom/jetbrains/resharper/unitTesting/RiderUnitTestViewSettings;", "getViewSettings", "()Lcom/jetbrains/resharper/unitTesting/RiderUnitTestViewSettings;", "areSame", "", "selection1", "Lcom/jetbrains/rider/model/RdUnitTestSelection;", "selection2", "getEnabledRules", "Ljava/util/HashSet;", "Lcom/jetbrains/resharper/unitTesting/RiderUnitTestGroupingRuleType;", "getRuleTypeForProjectId", "projectId", "", "isEnabledProjectId", "enabledRules", "navigateToNode", "", "node", "Lcom/jetbrains/resharper/unitTesting/trees/base/RiderUnitTestNode;", "requestFocus", "rider"})
public final class RiderUnitTestFacade
extends RiderUnitTestComponentBase {
    @NotNull
    private final RiderUnitTestGroupingRules groupingRules;
    @NotNull
    private final IconHost iconHost;
    @NotNull
    private final Project project;

    @NotNull
    public final RdUnitTestHost getHost() {
        return SolutionHostExtensionsKt.getSolution(this.myProject).getUnitTestHost();
    }

    @NotNull
    public final ProjectModelViewHost getProjectModelViewHost() {
        ComponentManager $receiver$iv = (ComponentManager)this.project;
        Object object = $receiver$iv.getComponent(ProjectModelViewHost.class);
        if (object == null) {
            throw (Throwable)new IllegalStateException("Component " + ProjectModelViewHost.class + " not found in container " + $receiver$iv);
        }
        return (ProjectModelViewHost)object;
    }

    @NotNull
    public final RiderUnitTestElementRepository getElementRepository() {
        return RiderUnitTestElementRepository.Companion.getInstance(this.project);
    }

    @NotNull
    public final RiderUnitTestViewSettings getViewSettings() {
        ComponentManager $receiver$iv = (ComponentManager)this.project;
        Object object = $receiver$iv.getComponent(RiderUnitTestViewSettings.class);
        if (object == null) {
            throw (Throwable)new IllegalStateException("Component " + RiderUnitTestViewSettings.class + " not found in container " + $receiver$iv);
        }
        return (RiderUnitTestViewSettings)((Object)object);
    }

    @NotNull
    public final RiderUnitTestToolWindowManager getTwManager() {
        ComponentManager $receiver$iv = (ComponentManager)this.project;
        Object object = $receiver$iv.getComponent(RiderUnitTestToolWindowManager.class);
        if (object == null) {
            throw (Throwable)new IllegalStateException("Component " + RiderUnitTestToolWindowManager.class + " not found in container " + $receiver$iv);
        }
        return (RiderUnitTestToolWindowManager)((Object)object);
    }

    @NotNull
    public final RiderUnitTestGroupingRules getGroupingRules() {
        return this.groupingRules;
    }

    @NotNull
    public final HashSet<RiderUnitTestGroupingRuleType> getEnabledRules() {
        return (HashSet)this.groupingRules.getEnabledRules();
    }

    public final void navigateToNode(@NotNull RiderUnitTestNode node, boolean requestFocus2) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        RiderUnitTestNode riderUnitTestNode = node;
        if (riderUnitTestNode instanceof RiderUnitTestElementNode) {
            this.getElementRepository().navigateToElement(((RiderUnitTestElementNode)node).getElementIndex(), requestFocus2);
        } else if (riderUnitTestNode instanceof RiderUnitTestProjectNode) {
            this.getElementRepository().navigateToProject(((RiderUnitTestProjectNode)node).getProjectId(), requestFocus2);
        }
    }

    public static /* bridge */ /* synthetic */ void navigateToNode$default(RiderUnitTestFacade riderUnitTestFacade, RiderUnitTestNode riderUnitTestNode, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = true;
        }
        riderUnitTestFacade.navigateToNode(riderUnitTestNode, bl);
    }

    public final boolean areSame(@NotNull RdUnitTestSelection selection1, @NotNull RdUnitTestSelection selection2) {
        int i2;
        Intrinsics.checkParameterIsNotNull((Object)selection1, (String)"selection1");
        Intrinsics.checkParameterIsNotNull((Object)selection2, (String)"selection2");
        if (selection1.getElementIds().size() != selection2.getElementIds().size()) {
            return false;
        }
        if (selection1.getProjectIds().size() != selection2.getProjectIds().size()) {
            return false;
        }
        int n2 = 0;
        int n3 = ((Collection)selection1.getElementIds()).size() - 1;
        if (n2 <= n3) {
            while (true) {
                if (((Number)selection1.getElementIds().get(i2)).intValue() != ((Number)selection2.getElementIds().get(i2)).intValue()) {
                    return false;
                }
                if (i2 == n3) break;
                ++i2;
            }
        }
        if ((i2 = 0) <= (n3 = ((Collection)selection1.getProjectIds()).size() - 1)) {
            while (true) {
                if (((Number)selection1.getProjectIds().get(i2)).intValue() != ((Number)selection2.getProjectIds().get(i2)).intValue()) {
                    return false;
                }
                if (i2 == n3) break;
                ++i2;
            }
        }
        return true;
    }

    public final boolean isEnabledProjectId(int projectId, @NotNull HashSet<RiderUnitTestGroupingRuleType> enabledRules) {
        Intrinsics.checkParameterIsNotNull(enabledRules, (String)"enabledRules");
        RiderUnitTestGroupingRuleType riderUnitTestGroupingRuleType = this.getRuleTypeForProjectId(projectId);
        if (riderUnitTestGroupingRuleType == null) {
            return false;
        }
        RiderUnitTestGroupingRuleType ruleType = riderUnitTestGroupingRuleType;
        return enabledRules.contains((Object)ruleType);
    }

    @Nullable
    public final RiderUnitTestGroupingRuleType getRuleTypeForProjectId(int projectId) {
        ProjectModelNode projectModelNode = this.getProjectModelViewHost().getItemById(projectId);
        if (projectModelNode == null) {
            return null;
        }
        ProjectModelNode projectItem = projectModelNode;
        RdProjectModelItemDescriptor rdProjectModelItemDescriptor = projectItem.getDescriptor();
        return rdProjectModelItemDescriptor instanceof RdSolutionFolderDescriptor ? RiderUnitTestGroupingRuleType.SolutionFolder : (rdProjectModelItemDescriptor instanceof RdProjectDescriptor ? RiderUnitTestGroupingRuleType.Project : (rdProjectModelItemDescriptor instanceof RdProjectFolderDescriptor ? RiderUnitTestGroupingRuleType.Folder : (rdProjectModelItemDescriptor instanceof RdProjectFileDescriptor ? RiderUnitTestGroupingRuleType.File : null)));
    }

    @NotNull
    public final IconHost getIconHost() {
        return this.iconHost;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public RiderUnitTestFacade(@NotNull IconHost iconHost, @NotNull Project project2) {
        Intrinsics.checkParameterIsNotNull((Object)iconHost, (String)"iconHost");
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        super(project2);
        this.iconHost = iconHost;
        this.project = project2;
        this.groupingRules = RiderUnitTestGroupingRules.Companion.getInstance(this.project);
    }
}

