/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.usages;

import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.project.Project;
import com.intellij.usages.ReadWriteAccessUsage;
import com.intellij.usages.Usage;
import com.intellij.usages.UsagePresentation;
import com.jetbrains.resharper.editors.ITextControlHost;
import com.jetbrains.resharper.icons.IconHost;
import com.jetbrains.resharper.usages.IRiderUsage;
import com.jetbrains.resharper.usages.RdUsageExtensionsKt;
import com.jetbrains.resharper.usages.RiderMergeableUsage;
import com.jetbrains.resharper.usages.RiderUsagePresentation;
import com.jetbrains.resharper.util.idea.ExtensionsKt;
import com.jetbrains.rider.model.Icon;
import com.jetbrains.rider.model.RdUsage;
import com.jetbrains.rider.model.RdUsageBase;
import com.jetbrains.rider.model.RdUsageGroupNavigationData;
import com.jetbrains.rider.model.RdUsageList;
import com.jetbrains.rider.model.RdUsageNavigationData;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\b\u0012\u0004\u0012\u00020\u00040\u00032\u00020\u0004B-\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u001fH\u0016J\u0011\u0010!\u001a\u00020\b2\u0006\u0010\"\u001a\u00020\u0004H\u0096\u0002J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u001fH\u0002J\u0012\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010(\u001a\u00020)H\u0016J\"\u0010*\u001a\u0004\u0018\u00010)2\u0006\u0010(\u001a\u00020)2\u0006\u0010+\u001a\u00020\b2\u0006\u0010,\u001a\u00020\bH\u0016J\u0006\u0010-\u001a\u00020\u001fJ\b\u0010.\u001a\u00020/H\u0016J\b\u00100\u001a\u000201H\u0016J\b\u00102\u001a\u000203H\u0016J\b\u00104\u001a\u00020\u001fH\u0016J\b\u00105\u001a\u00020\u001fH\u0016J\b\u00106\u001a\u00020\u001fH\u0016J\b\u00107\u001a\u00020\u001fH\u0016J\u0010\u00108\u001a\u0002032\u0006\u0010%\u001a\u00020\u001fH\u0016J\u0010\u00109\u001a\u0002032\u0006\u0010:\u001a\u00020;H\u0016J\b\u0010<\u001a\u000203H\u0016R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006="}, d2={"Lcom/jetbrains/resharper/usages/RiderUsage;", "Lcom/intellij/usages/Usage;", "Lcom/intellij/usages/ReadWriteAccessUsage;", "", "Lcom/jetbrains/resharper/usages/IRiderUsage;", "project", "Lcom/intellij/openapi/project/Project;", "index", "", "usages", "Lcom/jetbrains/rider/model/RdUsageList;", "textControlHost", "Lcom/jetbrains/resharper/editors/ITextControlHost;", "iconHost", "Lcom/jetbrains/resharper/icons/IconHost;", "(Lcom/intellij/openapi/project/Project;ILcom/jetbrains/rider/model/RdUsageList;Lcom/jetbrains/resharper/editors/ITextControlHost;Lcom/jetbrains/resharper/icons/IconHost;)V", "getIconHost", "()Lcom/jetbrains/resharper/icons/IconHost;", "getIndex", "()I", "model", "Lcom/jetbrains/rider/model/RdUsage;", "getModel", "()Lcom/jetbrains/rider/model/RdUsage;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getTextControlHost", "()Lcom/jetbrains/resharper/editors/ITextControlHost;", "getUsages", "()Lcom/jetbrains/rider/model/RdUsageList;", "canNavigate", "", "canNavigateToSource", "compareTo", "other", "createNavigationData", "Lcom/jetbrains/rider/model/RdUsageNavigationData;", "requestFocus", "getGroupIcon", "Lcom/jetbrains/rider/model/Icon;", "groupingRuleName", "", "getGroupText", "startLevel", "endLevel", "getIsValid", "getLocation", "Lcom/intellij/openapi/fileEditor/FileEditorLocation;", "getPresentation", "Lcom/intellij/usages/UsagePresentation;", "highlightInEditor", "", "isAccessedForReading", "isAccessedForWriting", "isReadOnly", "isValid", "navigate", "navigateToGroup", "groupInfo", "Lcom/jetbrains/rider/model/RdUsageGroupNavigationData;", "selectInEditor", "rider"})
public final class RiderUsage
implements Usage,
ReadWriteAccessUsage,
Comparable<IRiderUsage>,
IRiderUsage {
    @NotNull
    private final RdUsage model;
    @NotNull
    private final Project project;
    private final int index;
    @NotNull
    private final RdUsageList usages;
    @NotNull
    private final ITextControlHost textControlHost;
    @NotNull
    private final IconHost iconHost;

    @Override
    public void navigateToGroup(@NotNull RdUsageGroupNavigationData groupInfo) {
        Intrinsics.checkParameterIsNotNull((Object)groupInfo, (String)"groupInfo");
        ExtensionsKt.syncFromBackend$default(this.usages.getNavigateToGroup(), groupInfo, this.project, null, 4, null);
    }

    @NotNull
    public final RdUsage getModel() {
        return this.model;
    }

    public boolean isAccessedForWriting() {
        return this.model.getAccessType().isAccessedForReading();
    }

    public boolean isAccessedForReading() {
        return this.model.getAccessType().isAccessedForWriting();
    }

    @NotNull
    public UsagePresentation getPresentation() {
        return new RiderUsagePresentation(this.model, this.iconHost);
    }

    public final boolean getIsValid() {
        return RdUsageExtensionsKt.getIsValid(this.model);
    }

    public boolean isValid() {
        return this.getIsValid();
    }

    public boolean isReadOnly() {
        return true;
    }

    @NotNull
    public FileEditorLocation getLocation() {
        throw (Throwable)new UnsupportedOperationException();
    }

    public void selectInEditor() {
    }

    public void highlightInEditor() {
    }

    private final RdUsageNavigationData createNavigationData(boolean requestFocus2) {
        return new RdUsageNavigationData(this.getIndex(), requestFocus2);
    }

    public void navigate(boolean requestFocus2) {
        ExtensionsKt.syncFromBackend$default(this.usages.getNavigateTo(), this.createNavigationData(requestFocus2), this.project, null, 4, null);
    }

    public boolean canNavigate() {
        return this.isValid();
    }

    public boolean canNavigateToSource() {
        return this.isValid();
    }

    @Override
    public int compareTo(@NotNull IRiderUsage other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        IRiderUsage iRiderUsage = other;
        return iRiderUsage instanceof RiderUsage ? this.model.getText().compareTo(((RiderUsage)other).model.getText()) : (iRiderUsage instanceof RiderMergeableUsage ? this.model.getText().compareTo(((RiderMergeableUsage)other).getPosition().getDocumentMoniker()) : 0);
    }

    @Override
    @Nullable
    public String getGroupText(@NotNull String groupingRuleName, int startLevel, int endLevel) {
        Intrinsics.checkParameterIsNotNull((Object)groupingRuleName, (String)"groupingRuleName");
        return RdUsageExtensionsKt.getRelativeGroupText(this.model, this.project, groupingRuleName, startLevel, endLevel);
    }

    @Override
    @Nullable
    public Icon getGroupIcon(@NotNull String groupingRuleName) {
        Intrinsics.checkParameterIsNotNull((Object)groupingRuleName, (String)"groupingRuleName");
        return RdUsageExtensionsKt.getGroupIcon(this.model, groupingRuleName);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @NotNull
    public final RdUsageList getUsages() {
        return this.usages;
    }

    @NotNull
    public final ITextControlHost getTextControlHost() {
        return this.textControlHost;
    }

    @NotNull
    public final IconHost getIconHost() {
        return this.iconHost;
    }

    public RiderUsage(@NotNull Project project2, int index, @NotNull RdUsageList usages, @NotNull ITextControlHost textControlHost, @NotNull IconHost iconHost) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)usages, (String)"usages");
        Intrinsics.checkParameterIsNotNull((Object)textControlHost, (String)"textControlHost");
        Intrinsics.checkParameterIsNotNull((Object)iconHost, (String)"iconHost");
        this.project = project2;
        this.index = index;
        this.usages = usages;
        this.textControlHost = textControlHost;
        this.iconHost = iconHost;
        RdUsageBase rdUsageBase = this.usages.getItems().get(this.getIndex());
        if (rdUsageBase == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.jetbrains.rider.model.RdUsage");
        }
        this.model = (RdUsage)rdUsageBase;
    }
}

