/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.util.idea;

import com.intellij.codeStyle.CodeStyleFacade;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=2, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0012\u0010\u0004\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\"\u0010\b\u001a\u00020\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\t\u00a8\u0006\u000f"}, d2={"underlyingIdentifierRange", "Lcom/intellij/openapi/util/TextRange;", "event", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "join", "Ljava/io/File;", "s", "", "translatePhysicalToLogicalColumn", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "line", "physicalColumn", "rider"})
public final class DocumentUtilKt {
    public static final int translatePhysicalToLogicalColumn(@NotNull VirtualFile $receiver, @NotNull Project project2, int line, int physicalColumn) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        if (physicalColumn < 0) {
            return physicalColumn;
        }
        if (line < 0) {
            return physicalColumn;
        }
        Document document = FileDocumentManager.getInstance().getDocument($receiver);
        if (document == null) {
            throw (Throwable)new IllegalStateException("Unable to get document for file " + $receiver);
        }
        Document document2 = document;
        int lineStart = document2.getLineStartOffset(line);
        CharSequence docText = document2.getCharsSequence();
        int tabSize = CodeStyleFacade.getInstance((Project)project2).getTabSize($receiver.getFileType());
        int tempUiColumn = 0;
        for (int offset = lineStart; offset < lineStart + physicalColumn; ++offset) {
            tempUiColumn += docText.charAt(offset) == '\t' ? tabSize : 1;
        }
        return tempUiColumn;
    }

    @NotNull
    public static final File join(@NotNull File $receiver, @NotNull String s2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)s2, (String)"s");
        return new File($receiver, s2);
    }

    @NotNull
    public static final TextRange underlyingIdentifierRange(@NotNull DocumentEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        int start2 = event.getOffset();
        int end = start2 + event.getNewLength();
        return new TextRange(start2, end);
    }
}

