/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.util.idea.ui;

import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.usages.TextChunk;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.resharper.ui.bindableUi.RichText;
import com.jetbrains.resharper.util.idea.ui.ColorUtilsKt;
import com.jetbrains.resharper.util.idea.ui.ModelRichTextExKt$WhenMappings;
import com.jetbrains.rider.model.FontStyle;
import com.jetbrains.rider.model.ModelRichString;
import com.jetbrains.rider.model.ModelRichText;
import com.jetbrains.rider.model.RgbColor;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=2, d1={"\u0000F\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001e\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\b\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u001a\n\u0010\u0007\u001a\u00020\u0006*\u00020\b\u001a\n\u0010\t\u001a\u00020\n*\u00020\u000b\u001a\u0012\u0010\f\u001a\u00020\r*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0016\u0010\u000e\u001a\u00020\u000f*\u00020\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0006\u001a\u0015\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013*\u00020\u0004\u00a2\u0006\u0002\u0010\u0015\u00a8\u0006\u0016"}, d2={"append", "", "Lcom/intellij/ui/SimpleColoredComponent;", "richText", "Lcom/jetbrains/rider/model/ModelRichText;", "bgColor", "Ljava/awt/Color;", "toColor", "Lcom/jetbrains/rider/model/RgbColor;", "toFont", "", "Lcom/jetbrains/rider/model/FontStyle;", "toRichText", "Lcom/jetbrains/resharper/ui/bindableUi/RichText;", "toSimpleTextAttributes", "Lcom/intellij/ui/SimpleTextAttributes;", "Lcom/jetbrains/rider/model/ModelRichString;", "globalBgColor", "toTextChunks", "", "Lcom/intellij/usages/TextChunk;", "(Lcom/jetbrains/rider/model/ModelRichText;)[Lcom/intellij/usages/TextChunk;", "rider"})
public final class ModelRichTextExKt {
    @NotNull
    public static final TextChunk[] toTextChunks(@NotNull ModelRichText $receiver) {
        Collection $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        ArrayList<TextChunk> chunks = new ArrayList<TextChunk>();
        for (ModelRichString part : $receiver.getParts()) {
            SimpleTextAttributes attributes = ModelRichTextExKt.toSimpleTextAttributes(part, UIUtil.getTreeTextBackground());
            TextChunk chunk = new TextChunk(attributes.toTextAttributes(), part.getText());
            chunks.add(chunk);
        }
        Collection thisCollection$iv = $receiver$iv = (Collection)chunks;
        TextChunk[] textChunkArray = thisCollection$iv.toArray(new TextChunk[thisCollection$iv.size()]);
        if (textChunkArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return (TextChunk[])((Object[])textChunkArray);
    }

    @NotNull
    public static final SimpleTextAttributes toSimpleTextAttributes(@NotNull ModelRichString $receiver, @Nullable Color globalBgColor) {
        Color bgColor;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        int style = ModelRichTextExKt.toFont($receiver.getFontStyle());
        switch (ModelRichTextExKt$WhenMappings.$EnumSwitchMapping$0[$receiver.getEffectStyle().ordinal()]) {
            case 1: {
                style |= 0x10;
                break;
            }
            case 2: {
                style |= 8;
                break;
            }
            case 3: {
                style |= 4;
                break;
            }
            case 4: {
                style |= 0x40;
                break;
            }
            case 5: {
                break;
            }
            default: {
                throw (Throwable)new IllegalArgumentException("Unexpected EffectStyle value:  " + $receiver.getEffectStyle().toString());
            }
        }
        RgbColor rgbColor = $receiver.getForegroundColor();
        Color fgColor = rgbColor != null ? ModelRichTextExKt.toColor(rgbColor) : null;
        RgbColor rgbColor2 = $receiver.getBackgroundColor();
        Color localBgColor = rgbColor2 != null ? ModelRichTextExKt.toColor(rgbColor2) : null;
        Color color = localBgColor;
        if (color == null) {
            color = bgColor = globalBgColor;
        }
        if (fgColor != null && bgColor != null) {
            fgColor = ColorUtilsKt.getContrastedForeground(bgColor, fgColor);
        }
        RgbColor rgbColor3 = $receiver.getEffectColor();
        return new SimpleTextAttributes(localBgColor, fgColor, rgbColor3 != null ? ModelRichTextExKt.toColor(rgbColor3) : null, style);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ SimpleTextAttributes toSimpleTextAttributes$default(ModelRichString modelRichString, Color color, int n2, Object object) {
        if ((n2 & 1) != 0) {
            color = null;
        }
        return ModelRichTextExKt.toSimpleTextAttributes(modelRichString, color);
    }

    public static final int toFont(@NotNull FontStyle $receiver) {
        int n2;
        Intrinsics.checkParameterIsNotNull((Object)((Object)$receiver), (String)"$receiver");
        switch (ModelRichTextExKt$WhenMappings.$EnumSwitchMapping$1[$receiver.ordinal()]) {
            case 1: {
                n2 = 0;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 1;
                break;
            }
            case 4: {
                n2 = 4;
                break;
            }
            case 5: {
                n2 = 16;
                break;
            }
            default: {
                throw (Throwable)new IllegalArgumentException();
            }
        }
        return n2;
    }

    @NotNull
    public static final Color toColor(@NotNull RgbColor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return new Color($receiver.getRed(), $receiver.getGreen(), $receiver.getBlue());
    }

    @NotNull
    public static final RichText toRichText(@NotNull ModelRichText $receiver, @NotNull Color bgColor) {
        RichText richText;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)bgColor, (String)"bgColor");
        RichText $receiver2 = richText = new RichText();
        for (ModelRichString part : $receiver.getParts()) {
            SimpleTextAttributes attributes = ModelRichTextExKt.toSimpleTextAttributes(part, bgColor);
            $receiver2.append(part.getText(), attributes);
        }
        return richText;
    }

    public static final void append(@NotNull SimpleColoredComponent $receiver, @Nullable ModelRichText richText, @Nullable Color bgColor) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if (richText == null) {
            $receiver.append("unnamed item", SimpleTextAttributes.REGULAR_ATTRIBUTES);
            return;
        }
        for (ModelRichString part : richText.getParts()) {
            SimpleTextAttributes attributes = ModelRichTextExKt.toSimpleTextAttributes(part, bgColor);
            $receiver.append(part.getText(), attributes);
        }
    }
}

