/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.utils.collections;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Spliterator;
import org.jetbrains.annotations.NotNull;

public class IdentityHashSet<E>
extends AbstractSet<E>
implements Set<E>,
Cloneable {
    private IdentityHashMap<E, Object> map;
    private static final Object STUB = new Object();

    public IdentityHashSet() {
        this.map = new IdentityHashMap();
    }

    public IdentityHashSet(Collection<? extends E> c2) {
        this.map = new IdentityHashMap(Math.max((int)((float)c2.size() / 0.75f) + 1, 16));
        this.addAll(c2);
    }

    public IdentityHashSet(int initialCapacity) {
        this.map = new IdentityHashMap(initialCapacity);
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        Iterator<E> iterator2 = this.map.keySet().iterator();
        if (iterator2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/resharper/utils/collections/IdentityHashSet", "iterator"));
        }
        return iterator2;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object o2) {
        return this.map.containsKey(o2);
    }

    @Override
    public boolean add(E e2) {
        return this.map.put(e2, STUB) == null;
    }

    @Override
    public boolean remove(Object o2) {
        return this.map.remove(o2) == STUB;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    public Object clone() {
        try {
            IdentityHashSet newSet = (IdentityHashSet)super.clone();
            newSet.map = (IdentityHashMap)this.map.clone();
            return newSet;
        }
        catch (CloneNotSupportedException e2) {
            throw new InternalError(e2);
        }
    }

    @Override
    public Spliterator<E> spliterator() {
        throw new UnsupportedOperationException();
    }
}

