/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.framework;

import com.jetbrains.rider.framework.RdId;
import com.jetbrains.rider.framework.RdVoid;
import com.jetbrains.rider.framework.SerializationCtx;
import com.jetbrains.rider.util.PublicApi;
import java.io.EOFException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CharIterator;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=2, d1={"\u0000\u00e2\u0001\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0018\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0016\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u0017\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b-\u001a\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u001a.\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\b0\u0007\"\u0006\b\u0000\u0010\b\u0018\u0001*\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\b0\u000bH\u0087\b\u00a2\u0006\u0002\u0010\f\u001a\n\u0010\r\u001a\u00020\u000e*\u00020\t\u001a\n\u0010\u000f\u001a\u00020\u000e*\u00020\t\u001a\n\u0010\u0010\u001a\u00020\u0011*\u00020\t\u001a\n\u0010\u0012\u001a\u00020\u0013*\u00020\t\u001a\n\u0010\u0014\u001a\u00020\u0004*\u00020\t\u001a\n\u0010\u0015\u001a\u00020\u0016*\u00020\t\u001a\n\u0010\u0017\u001a\u00020\u0018*\u00020\t\u001a\n\u0010\u0019\u001a\u00020\u001a*\u00020\t\u001a\n\u0010\u001b\u001a\u00020\u001c*\u00020\t\u001a\n\u0010\u001d\u001a\u00020\u001e*\u00020\t\u001a$\u0010\u001f\u001a\u0002H\b\"\u0010\b\u0000\u0010\b\u0018\u0001*\b\u0012\u0004\u0012\u0002H\b0 *\u00020\tH\u0086\b\u00a2\u0006\u0002\u0010!\u001a\n\u0010\"\u001a\u00020#*\u00020\t\u001a\n\u0010$\u001a\u00020%*\u00020\t\u001a\n\u0010&\u001a\u00020'*\u00020\t\u001a\n\u0010(\u001a\u00020)*\u00020\t\u001a\n\u0010*\u001a\u00020+*\u00020\t\u001a)\u0010,\u001a\b\u0012\u0004\u0012\u0002H\b0-\"\u0006\b\u0000\u0010\b\u0018\u0001*\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\b0\u000bH\u0086\b\u001a=\u0010,\u001a\b\u0012\u0004\u0012\u0002H\b0-\"\u0006\b\u0000\u0010\b\u0018\u0001*\u00020\t2\u0006\u0010.\u001a\u00020/2\u0018\u00100\u001a\u0014\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u0002H\b01H\u0086\b\u001a\n\u00102\u001a\u00020\u0001*\u00020\t\u001a\n\u00103\u001a\u000204*\u00020\t\u001a,\u00105\u001a\u0004\u0018\u0001H\b\"\b\b\u0000\u0010\b*\u000206*\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\b0\u000bH\u0086\b\u00a2\u0006\u0002\u00107\u001a=\u00108\u001a\n\u0012\u0004\u0012\u0002H\b\u0018\u00010-\"\u0004\b\u0000\u0010\b*\u00020\t2\u0006\u0010.\u001a\u00020/2\u0018\u00100\u001a\u0014\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u0002H\b01H\u0086\b\u001a\f\u00109\u001a\u0004\u0018\u00010:*\u00020\t\u001aJ\u0010;\u001a\u0002H\b\"\b\b\u0000\u0010\b*\u000206*\u00020\t2\u0012\u0010<\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u0002H\b0=2\u0018\u0010>\u001a\u0014\u0012\u0004\u0012\u0002H\b\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020?01H\u0082\b\u00a2\u0006\u0002\u0010@\u001aL\u0010A\u001a\u0004\u0018\u0001H\b\"\b\b\u0000\u0010\b*\u000206*\u00020\t2\u0012\u0010<\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u0002H\b0=2\u0018\u0010>\u001a\u0014\u0012\u0004\u0012\u0002H\b\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020?01H\u0082\b\u00a2\u0006\u0002\u0010@\u001a\n\u0010B\u001a\u00020C*\u00020\t\u001a\n\u0010D\u001a\u00020E*\u00020\t\u001a\n\u0010F\u001a\u00020G*\u00020\t\u001a\n\u0010H\u001a\u00020:*\u00020\t\u001a\n\u0010I\u001a\u00020J*\u00020\t\u001a\n\u0010K\u001a\u00020'*\u00020\t\u001a\f\u0010L\u001a\u00020M*\u00020\tH\u0007\u001a9\u0010N\u001a\u00020?\"\u0004\b\u0000\u0010\b*\u00020O2\f\u0010P\u001a\b\u0012\u0004\u0012\u0002H\b0\u00072\u0012\u0010Q\u001a\u000e\u0012\u0004\u0012\u0002H\b\u0012\u0004\u0012\u00020?0=H\u0007\u00a2\u0006\u0002\u0010R\u001a\u0012\u0010S\u001a\u00020?*\u00020O2\u0006\u0010T\u001a\u00020\u000e\u001a\u0012\u0010U\u001a\u00020?*\u00020O2\u0006\u0010T\u001a\u00020\u000e\u001a\u0012\u0010V\u001a\u00020?*\u00020O2\u0006\u0010P\u001a\u00020\u0011\u001a\u0012\u0010W\u001a\u00020?*\u00020O2\u0006\u0010T\u001a\u00020\u0013\u001a\u0012\u0010X\u001a\u00020?*\u00020O2\u0006\u0010P\u001a\u00020\u0004\u001a\u0012\u0010Y\u001a\u00020?*\u00020O2\u0006\u0010T\u001a\u00020\u0016\u001a\u0012\u0010Z\u001a\u00020?*\u00020O2\u0006\u0010P\u001a\u00020\u0018\u001a\u0012\u0010[\u001a\u00020?*\u00020O2\u0006\u0010P\u001a\u00020\u001a\u001a\u0012\u0010\\\u001a\u00020?*\u00020O2\u0006\u0010T\u001a\u00020\u001c\u001a\u0012\u0010]\u001a\u00020?*\u00020O2\u0006\u0010P\u001a\u00020\u001e\u001a-\u0010^\u001a\u00020?\"\u0010\b\u0000\u0010\b\u0018\u0001*\b\u0012\u0004\u0012\u0002H\b0 *\u00020O2\f\u0010P\u001a\b\u0012\u0004\u0012\u0002H\b0 H\u0086\b\u001a\u0012\u0010_\u001a\u00020?*\u00020O2\u0006\u0010T\u001a\u00020#\u001a\u0012\u0010`\u001a\u00020?*\u00020O2\u0006\u0010P\u001a\u00020%\u001a\u0012\u0010a\u001a\u00020?*\u00020O2\u0006\u0010P\u001a\u00020'\u001a\u0012\u0010b\u001a\u00020?*\u00020O2\u0006\u0010T\u001a\u00020)\u001a\u0012\u0010c\u001a\u00020?*\u00020O2\u0006\u0010P\u001a\u00020+\u001a\u001c\u0010d\u001a\u00020?*\u00020)2\u0006\u0010e\u001a\u00020\u00042\b\b\u0002\u0010f\u001a\u00020)\u001a2\u0010g\u001a\u00020?\"\u0004\b\u0000\u0010\b*\u00020O2\f\u0010P\u001a\b\u0012\u0004\u0012\u0002H\b0-2\u0012\u0010Q\u001a\u000e\u0012\u0004\u0012\u0002H\b\u0012\u0004\u0012\u00020?0=\u001a=\u0010g\u001a\u00020?\"\u0006\b\u0000\u0010\b\u0018\u0001*\u00020O2\f\u0010P\u001a\b\u0012\u0004\u0012\u0002H\b0-2\u0018\u0010Q\u001a\u0014\u0012\u0004\u0012\u00020O\u0012\u0004\u0012\u0002H\b\u0012\u0004\u0012\u00020?01H\u0086\b\u001a\u0012\u0010h\u001a\u00020?*\u00020O2\u0006\u0010T\u001a\u00020\u0001\u001a\u0012\u0010i\u001a\u00020?*\u00020O2\u0006\u0010P\u001a\u000204\u001a7\u0010j\u001a\u00020?\"\b\b\u0000\u0010\b*\u000206*\u00020O2\b\u0010P\u001a\u0004\u0018\u0001H\b2\u0012\u0010Q\u001a\u000e\u0012\u0004\u0012\u0002H\b\u0012\u0004\u0012\u00020?0=\u00a2\u0006\u0002\u0010k\u001a?\u0010l\u001a\u00020?\"\u0006\b\u0000\u0010\b\u0018\u0001*\u00020O2\u000e\u0010P\u001a\n\u0012\u0004\u0012\u0002H\b\u0018\u00010-2\u0018\u0010Q\u001a\u0014\u0012\u0004\u0012\u00020O\u0012\u0004\u0012\u0002H\b\u0012\u0004\u0012\u00020?01H\u0086\b\u001a\u0014\u0010m\u001a\u00020?*\u00020O2\b\u0010P\u001a\u0004\u0018\u00010:\u001aN\u0010n\u001a\u00020?\"\b\b\u0000\u0010\b*\u000206*\u00020O2\b\u0010o\u001a\u0004\u0018\u0001H\b2\u0012\u0010p\u001a\u000e\u0012\u0004\u0012\u0002H\b\u0012\u0004\u0012\u00020)0=2\u0012\u0010q\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020?0=H\u0082\b\u00a2\u0006\u0002\u0010r\u001aN\u0010s\u001a\u00020?\"\b\b\u0000\u0010\b*\u000206*\u00020O2\b\u0010o\u001a\u0004\u0018\u0001H\b2\u0012\u0010p\u001a\u000e\u0012\u0004\u0012\u0002H\b\u0012\u0004\u0012\u00020)0=2\u0012\u0010q\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020?0=H\u0082\b\u00a2\u0006\u0002\u0010r\u001a\u0012\u0010t\u001a\u00020?*\u00020O2\u0006\u0010P\u001a\u00020C\u001a\u0012\u0010u\u001a\u00020?*\u00020O2\u0006\u0010T\u001a\u00020E\u001a\u0012\u0010v\u001a\u00020?*\u00020O2\u0006\u0010P\u001a\u00020G\u001a\u0012\u0010w\u001a\u00020?*\u00020O2\u0006\u0010P\u001a\u00020:\u001a\u0012\u0010x\u001a\u00020?*\u00020O2\u0006\u0010P\u001a\u00020J\u001a\u0012\u0010y\u001a\u00020?*\u00020O2\u0006\u0010P\u001a\u00020'\u001a\u0016\u0010z\u001a\u00020?*\u00020O2\b\b\u0001\u0010{\u001a\u00020MH\u0007\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006|"}, d2={"TICKS_AT_EPOCH", "", "TICKS_PER_MILLISECOND", "transformGuidUuid", "", "data", "readArray", "", "T", "Ljava/io/InputStream;", "inner", "Lkotlin/Function0;", "(Ljava/io/InputStream;Lkotlin/jvm/functions/Function0;)[Ljava/lang/Object;", "readBool", "", "readBoolean", "readBooleanArray", "", "readByte", "", "readByteArray", "readChar", "", "readCharArray", "", "readDateTime", "Ljava/util/Date;", "readDouble", "", "readDoubleArray", "", "readEnum", "", "(Ljava/io/InputStream;)Ljava/lang/Enum;", "readFloat", "", "readFloatArray", "", "readGuid", "Ljava/util/UUID;", "readInt", "", "readIntArray", "", "readList", "", "ctx", "Lcom/jetbrains/rider/framework/SerializationCtx;", "elemReader", "Lkotlin/Function2;", "readLong", "readLongArray", "", "readNullable", "", "(Ljava/io/InputStream;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "readNullableList", "readNullableString", "", "readPrimitivesArray", "ctr", "Lkotlin/Function1;", "setter", "", "(Ljava/io/InputStream;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "readPrimitivesNullableArray", "readRdId", "Lcom/jetbrains/rider/framework/RdId;", "readShort", "", "readShortArray", "", "readString", "readUri", "Ljava/net/URI;", "readUuid", "readVoid", "Lcom/jetbrains/rider/framework/RdVoid;", "writeArray", "Ljava/io/OutputStream;", "value", "elemWriter", "(Ljava/io/OutputStream;[Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)V", "writeBool", "x", "writeBoolean", "writeBooleanArray", "writeByte", "writeByteArray", "writeChar", "writeCharArray", "writeDateTime", "writeDouble", "writeDoubleArray", "writeEnum", "writeFloat", "writeFloatArray", "writeGuid", "writeInt", "writeIntArray", "writeIntoByteArray", "dst", "offset", "writeList", "writeLong", "writeLongArray", "writeNullable", "(Ljava/io/OutputStream;Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)V", "writeNullableList", "writeNullableString", "writePrimitivesArray", "array", "getLength", "writeElem", "(Ljava/io/OutputStream;Ljava/lang/Object;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "writePrimitivesNullableArray", "writeRdId", "writeShort", "writeShortArray", "writeString", "writeUri", "writeUuid", "writeVoid", "tmp", "rider-framework"})
public final class SerializersKt {
    private static final long TICKS_AT_EPOCH = 621355968000000000L;
    private static final long TICKS_PER_MILLISECOND = 10000L;

    private static final byte[] transformGuidUuid(byte[] data) {
        return new byte[]{data[3], data[2], data[1], data[0], data[5], data[4], data[7], data[6], data[8], data[9], data[10], data[11], data[12], data[13], data[14], data[15]};
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final String readNullableString(@NotNull InputStream $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        int len = SerializersKt.readInt($receiver);
        if (len < 0) {
            return null;
        }
        int n2 = 0;
        char[] res2 = new char[len];
        int n3 = res2.length - 1;
        if (n2 <= n3) {
            while (true) {
                void i2;
                res2[i2] = SerializersKt.readChar($receiver);
                if (i2 == n3) break;
                ++i2;
            }
        }
        return new String(res2);
    }

    @NotNull
    public static final String readString(@NotNull InputStream $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        String string2 = SerializersKt.readNullableString($receiver);
        if (string2 == null) {
            throw (Throwable)new IllegalStateException("String is null");
        }
        return string2;
    }

    @NotNull
    public static final UUID readUuid(@NotNull InputStream $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        ByteBuffer bb2 = ByteBuffer.wrap(SerializersKt.transformGuidUuid(SerializersKt.readByteArray($receiver)));
        return new UUID(bb2.getLong(), bb2.getLong());
    }

    @NotNull
    public static final UUID readGuid(@NotNull InputStream $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return SerializersKt.readUuid($receiver);
    }

    @NotNull
    public static final Date readDateTime(@NotNull InputStream $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        long l2 = SerializersKt.readLong($receiver);
        return new Date((l2 - TICKS_AT_EPOCH) / TICKS_PER_MILLISECOND);
    }

    @NotNull
    public static final URI readUri(@NotNull InputStream $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        URI uRI = URI.create(SerializersKt.readString($receiver));
        Intrinsics.checkExpressionValueIsNotNull((Object)uRI, (String)"URI.create(readString())");
        return uRI;
    }

    /*
     * WARNING - void declaration
     */
    private static final <T> T readPrimitivesNullableArray(@NotNull InputStream $receiver, Function1<? super Integer, ? extends T> ctr, Function2<? super T, ? super Integer, Unit> setter) {
        int len = SerializersKt.readInt($receiver);
        if (len < 0) {
            return null;
        }
        Object res2 = ctr.invoke((Object)len);
        int n2 = 0;
        int n3 = len - 1;
        if (n2 <= n3) {
            while (true) {
                void i2;
                setter.invoke(res2, (Object)((int)i2));
                if (i2 == n3) break;
                ++i2;
            }
        }
        return (T)res2;
    }

    /*
     * WARNING - void declaration
     */
    private static final <T> T readPrimitivesArray(@NotNull InputStream $receiver, Function1<? super Integer, ? extends T> ctr, Function2<? super T, ? super Integer, Unit> setter) {
        Object object;
        Object object2;
        InputStream $receiver$iv = $receiver;
        int len$iv = SerializersKt.readInt($receiver$iv);
        if (len$iv < 0) {
            object2 = null;
        } else {
            Object res$iv = ctr.invoke((Object)len$iv);
            int n2 = 0;
            int n3 = len$iv - 1;
            if (n2 <= n3) {
                while (true) {
                    void i$iv;
                    setter.invoke(res$iv, (Object)((int)i$iv));
                    if (i$iv == n3) break;
                    ++i$iv;
                }
            }
            object2 = object = res$iv;
        }
        if (object == null) {
            String string2 = "Required value was null.";
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return (T)object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final byte[] readByteArray(@NotNull InputStream $receiver) {
        byte[] byArray;
        byte[] byArray2;
        InputStream $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        InputStream $receiver$iv$iv = $receiver$iv = $receiver;
        int len$iv$iv = SerializersKt.readInt($receiver$iv$iv);
        if (len$iv$iv < 0) {
            byArray2 = null;
        } else {
            int p1 = len$iv$iv;
            byte[] res$iv$iv = new byte[p1];
            int n2 = 0;
            int n3 = len$iv$iv - 1;
            if (n2 <= n3) {
                void i$iv$iv;
                do {
                    void $i$a$1$unknown = ++i$iv$iv;
                    byte[] a = res$iv$iv;
                    a[i] = SerializersKt.readByte($receiver);
                } while (i$iv$iv != n3);
            }
            byArray2 = byArray = res$iv$iv;
        }
        if (byArray == null) {
            String string2 = "Required value was null.";
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final short[] readShortArray(@NotNull InputStream $receiver) {
        short[] sArray;
        short[] sArray2;
        InputStream $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        InputStream $receiver$iv$iv = $receiver$iv = $receiver;
        int len$iv$iv = SerializersKt.readInt($receiver$iv$iv);
        if (len$iv$iv < 0) {
            sArray2 = null;
        } else {
            int p1 = len$iv$iv;
            short[] res$iv$iv = new short[p1];
            int n2 = 0;
            int n3 = len$iv$iv - 1;
            if (n2 <= n3) {
                void i$iv$iv;
                do {
                    void $i$a$1$unknown = ++i$iv$iv;
                    short[] a = res$iv$iv;
                    a[i] = SerializersKt.readShort($receiver);
                } while (i$iv$iv != n3);
            }
            sArray2 = sArray = res$iv$iv;
        }
        if (sArray == null) {
            String string2 = "Required value was null.";
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return sArray;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final int[] readIntArray(@NotNull InputStream $receiver) {
        int[] nArray;
        int[] nArray2;
        InputStream $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        InputStream $receiver$iv$iv = $receiver$iv = $receiver;
        int len$iv$iv = SerializersKt.readInt($receiver$iv$iv);
        if (len$iv$iv < 0) {
            nArray2 = null;
        } else {
            int p1 = len$iv$iv;
            int[] res$iv$iv = new int[p1];
            int n2 = 0;
            int n3 = len$iv$iv - 1;
            if (n2 <= n3) {
                void i$iv$iv;
                do {
                    void $i$a$1$unknown = ++i$iv$iv;
                    int[] a = res$iv$iv;
                    a[i] = SerializersKt.readInt($receiver);
                } while (i$iv$iv != n3);
            }
            nArray2 = nArray = res$iv$iv;
        }
        if (nArray == null) {
            String string2 = "Required value was null.";
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return nArray;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final long[] readLongArray(@NotNull InputStream $receiver) {
        long[] lArray;
        long[] lArray2;
        InputStream $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        InputStream $receiver$iv$iv = $receiver$iv = $receiver;
        int len$iv$iv = SerializersKt.readInt($receiver$iv$iv);
        if (len$iv$iv < 0) {
            lArray2 = null;
        } else {
            int p1 = len$iv$iv;
            long[] res$iv$iv = new long[p1];
            int n2 = 0;
            int n3 = len$iv$iv - 1;
            if (n2 <= n3) {
                void i$iv$iv;
                do {
                    void $i$a$1$unknown = ++i$iv$iv;
                    long[] a = res$iv$iv;
                    a[i] = SerializersKt.readLong($receiver);
                } while (i$iv$iv != n3);
            }
            lArray2 = lArray = res$iv$iv;
        }
        if (lArray == null) {
            String string2 = "Required value was null.";
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return lArray;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final float[] readFloatArray(@NotNull InputStream $receiver) {
        float[] fArray;
        float[] fArray2;
        InputStream $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        InputStream $receiver$iv$iv = $receiver$iv = $receiver;
        int len$iv$iv = SerializersKt.readInt($receiver$iv$iv);
        if (len$iv$iv < 0) {
            fArray2 = null;
        } else {
            int p1 = len$iv$iv;
            float[] res$iv$iv = new float[p1];
            int n2 = 0;
            int n3 = len$iv$iv - 1;
            if (n2 <= n3) {
                void i$iv$iv;
                do {
                    void $i$a$1$unknown = ++i$iv$iv;
                    float[] a = res$iv$iv;
                    a[i] = SerializersKt.readFloat($receiver);
                } while (i$iv$iv != n3);
            }
            fArray2 = fArray = res$iv$iv;
        }
        if (fArray == null) {
            String string2 = "Required value was null.";
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return fArray;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final double[] readDoubleArray(@NotNull InputStream $receiver) {
        double[] dArray;
        double[] dArray2;
        InputStream $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        InputStream $receiver$iv$iv = $receiver$iv = $receiver;
        int len$iv$iv = SerializersKt.readInt($receiver$iv$iv);
        if (len$iv$iv < 0) {
            dArray2 = null;
        } else {
            int p1 = len$iv$iv;
            double[] res$iv$iv = new double[p1];
            int n2 = 0;
            int n3 = len$iv$iv - 1;
            if (n2 <= n3) {
                void i$iv$iv;
                do {
                    void $i$a$1$unknown = ++i$iv$iv;
                    double[] a = res$iv$iv;
                    a[i] = SerializersKt.readDouble($receiver);
                } while (i$iv$iv != n3);
            }
            dArray2 = dArray = res$iv$iv;
        }
        if (dArray == null) {
            String string2 = "Required value was null.";
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return dArray;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final char[] readCharArray(@NotNull InputStream $receiver) {
        char[] cArray;
        char[] cArray2;
        InputStream $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        InputStream $receiver$iv$iv = $receiver$iv = $receiver;
        int len$iv$iv = SerializersKt.readInt($receiver$iv$iv);
        if (len$iv$iv < 0) {
            cArray2 = null;
        } else {
            int p1 = len$iv$iv;
            char[] res$iv$iv = new char[p1];
            int n2 = 0;
            int n3 = len$iv$iv - 1;
            if (n2 <= n3) {
                void i$iv$iv;
                do {
                    void $i$a$1$unknown = ++i$iv$iv;
                    char[] a = res$iv$iv;
                    a[i] = SerializersKt.readChar($receiver);
                } while (i$iv$iv != n3);
            }
            cArray2 = cArray = res$iv$iv;
        }
        if (cArray == null) {
            String string2 = "Required value was null.";
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return cArray;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final boolean[] readBooleanArray(@NotNull InputStream $receiver) {
        boolean[] blArray;
        boolean[] blArray2;
        InputStream $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        InputStream $receiver$iv$iv = $receiver$iv = $receiver;
        int len$iv$iv = SerializersKt.readInt($receiver$iv$iv);
        if (len$iv$iv < 0) {
            blArray2 = null;
        } else {
            int p1 = len$iv$iv;
            boolean[] res$iv$iv = new boolean[p1];
            int n2 = 0;
            int n3 = len$iv$iv - 1;
            if (n2 <= n3) {
                void i$iv$iv;
                do {
                    void $i$a$1$unknown = ++i$iv$iv;
                    boolean[] a = res$iv$iv;
                    a[i] = SerializersKt.readBoolean($receiver);
                } while (i$iv$iv != n3);
            }
            blArray2 = blArray = res$iv$iv;
        }
        if (blArray == null) {
            String string2 = "Required value was null.";
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return blArray;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final <T> List<T> readNullableList(@NotNull InputStream $receiver, @NotNull SerializationCtx ctx, @NotNull Function2<? super SerializationCtx, ? super InputStream, ? extends T> elemReader) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
        Intrinsics.checkParameterIsNotNull(elemReader, (String)"elemReader");
        int len = SerializersKt.readInt($receiver);
        if (len < 0) {
            return null;
        }
        ArrayList<Object> res2 = new ArrayList<Object>(len);
        int n2 = 1;
        int n3 = len;
        if (n2 <= n3) {
            while (true) {
                void i2;
                res2.add(elemReader.invoke((Object)ctx, (Object)$receiver));
                if (i2 == n3) break;
                ++i2;
            }
        }
        return res2;
    }

    /*
     * WARNING - void declaration
     */
    private static final <T> List<T> readList(@NotNull InputStream $receiver, SerializationCtx ctx, Function2<? super SerializationCtx, ? super InputStream, ? extends T> elemReader) {
        List list2;
        InputStream $receiver$iv = $receiver;
        int len$iv = SerializersKt.readInt($receiver$iv);
        if (len$iv < 0) {
            list2 = null;
        } else {
            ArrayList<Object> res$iv = new ArrayList<Object>(len$iv);
            int n2 = 1;
            int n3 = len$iv;
            if (n2 <= n3) {
                while (true) {
                    void i$iv;
                    res$iv.add(elemReader.invoke((Object)ctx, (Object)$receiver$iv));
                    if (i$iv == n3) break;
                    ++i$iv;
                }
            }
            list2 = res$iv;
        }
        if (list2 == null) {
            throw (Throwable)new IllegalStateException("list is null");
        }
        return list2;
    }

    public static final boolean readBool(@NotNull InputStream $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.read() != 0;
    }

    public static final boolean readBoolean(@NotNull InputStream $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return SerializersKt.readBool($receiver);
    }

    public static final byte readByte(@NotNull InputStream $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return (byte)($receiver.read() & 0xFF);
    }

    public static final char readChar(@NotNull InputStream $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        int c1 = $receiver.read();
        int c2 = $receiver.read();
        if ((c1 | c2) < 0) {
            throw (Throwable)new EOFException();
        }
        return (char)((c1 << 0) + (c2 << 8));
    }

    public static final short readShort(@NotNull InputStream $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        int c1 = $receiver.read();
        int c2 = $receiver.read();
        if ((c1 | c2) < 0) {
            throw (Throwable)new EOFException();
        }
        return (short)((c1 << 0) + (c2 << 8));
    }

    public static final int readInt(@NotNull InputStream $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        int c1 = $receiver.read();
        int c2 = $receiver.read();
        int c3 = $receiver.read();
        int c4 = $receiver.read();
        if ((c1 | c2 | c3 | c4) < 0) {
            throw (Throwable)new EOFException();
        }
        return (c1 << 0) + (c2 << 8) + (c3 << 16) + (c4 << 24);
    }

    public static final long readLong(@NotNull InputStream $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        int i1 = SerializersKt.readInt($receiver);
        int i2 = SerializersKt.readInt($receiver);
        return ((long)i1 & 0xFFFFFFFFL) + ((long)i2 << 32);
    }

    public static final float readFloat(@NotNull InputStream $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        int i2 = SerializersKt.readInt($receiver);
        return Float.intBitsToFloat(i2);
    }

    public static final double readDouble(@NotNull InputStream $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        long l2 = SerializersKt.readLong($receiver);
        return Double.longBitsToDouble(l2);
    }

    @PublicApi
    @NotNull
    public static final RdVoid readVoid(@NotNull InputStream $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return RdVoid.INSTANCE;
    }

    private static final <T extends Enum<T>> T readEnum(@NotNull InputStream $receiver) {
        int intValue = SerializersKt.readInt($receiver);
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        Enum enum_ = ((Enum[])Enum.class.getEnumConstants())[intValue];
        Intrinsics.checkExpressionValueIsNotNull((Object)enum_, (String)"T::class.java.enumConstants[intValue]");
        return (T)enum_;
    }

    @NotNull
    public static final RdId readRdId(@NotNull InputStream $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return RdId.Companion.read($receiver);
    }

    @Nullable
    public static final <T> T readNullable(@NotNull InputStream $receiver, @NotNull Function0<? extends T> inner) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(inner, (String)"inner");
        if (!SerializersKt.readBool($receiver)) {
            return null;
        }
        return (T)inner.invoke();
    }

    /*
     * WARNING - void declaration
     */
    @PublicApi
    private static final <T> T[] readArray(@NotNull InputStream $receiver, Function0<? extends T> inner) {
        int len = SerializersKt.readInt($receiver);
        if (len < 0) {
            throw (Throwable)new NullPointerException("Length of array is negative: " + len);
        }
        Intrinsics.reifiedOperationMarker((int)0, (String)"T?");
        Object[] result$iv = new Object[len];
        int n2 = 0;
        int n3 = len - 1;
        if (n2 <= n3) {
            void i$iv;
            do {
                Object object;
                void var8_6 = ++i$iv;
                void var12_8 = i$iv;
                Object[] objectArray = result$iv;
                objectArray[var12_8] = object = inner.invoke();
            } while (i$iv != n3);
        }
        Object[] res2 = result$iv;
        return res2;
    }

    /*
     * WARNING - void declaration
     */
    private static final <T> List<T> readList(@NotNull InputStream $receiver, Function0<? extends T> inner) {
        int len = SerializersKt.readInt($receiver);
        if (len < 0) {
            throw (Throwable)new NullPointerException("Length of array is negative: " + len);
        }
        ArrayList<Object> res2 = new ArrayList<Object>(len);
        int n2 = 1;
        int n3 = len;
        if (n2 <= n3) {
            while (true) {
                void i2;
                res2.add(inner.invoke());
                if (i2 == n3) break;
                ++i2;
            }
        }
        return res2;
    }

    public static final void writeChar(@NotNull OutputStream $receiver, char x2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        char xx = x2;
        $receiver.write(xx & 0xFF);
        $receiver.write(xx >>> 8 & 0xFF);
    }

    public static final void writeBool(@NotNull OutputStream $receiver, boolean x2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        $receiver.write(x2 ? 1 : 0);
    }

    public static final void writeBoolean(@NotNull OutputStream $receiver, boolean x2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        SerializersKt.writeBool($receiver, x2);
    }

    public static final void writeByte(@NotNull OutputStream $receiver, byte x2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        $receiver.write(x2);
    }

    public static final void writeShort(@NotNull OutputStream $receiver, short x2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        $receiver.write(x2 & 0xFF);
        $receiver.write(x2 >>> 8 & 0xFF);
    }

    public static final void writeInt(@NotNull OutputStream $receiver, int x2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        $receiver.write(x2 & 0xFF);
        $receiver.write(x2 >>> 8 & 0xFF);
        $receiver.write(x2 >>> 16 & 0xFF);
        $receiver.write(x2 >>> 24 & 0xFF);
    }

    public static final void writeIntoByteArray(int $receiver, @NotNull byte[] dst, int offset) {
        Intrinsics.checkParameterIsNotNull((Object)dst, (String)"dst");
        dst[offset] = (byte)($receiver & 0xFF);
        dst[offset + 1] = (byte)($receiver >>> 8 & 0xFF);
        dst[offset + 2] = (byte)($receiver >>> 16 & 0xFF);
        dst[offset + 3] = (byte)($receiver >>> 24 & 0xFF);
    }

    public static /* bridge */ /* synthetic */ void writeIntoByteArray$default(int n2, byte[] byArray, int n3, int n4, Object object) {
        if ((n4 & 2) != 0) {
            n3 = 0;
        }
        SerializersKt.writeIntoByteArray(n2, byArray, n3);
    }

    public static final void writeLong(@NotNull OutputStream $receiver, long x2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        SerializersKt.writeInt($receiver, (int)(x2 & 0xFFFFFFFFL));
        SerializersKt.writeInt($receiver, (int)(x2 >>> 32 & 0xFFFFFFFFL));
    }

    public static final void writeDouble(@NotNull OutputStream $receiver, double x2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        SerializersKt.writeLong($receiver, Double.doubleToRawLongBits(x2));
    }

    public static final void writeFloat(@NotNull OutputStream $receiver, float x2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        SerializersKt.writeInt($receiver, Float.floatToRawIntBits(x2));
    }

    @PublicApi
    public static final void writeVoid(@NotNull OutputStream $receiver, @NotNull RdVoid tmp) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)tmp, (String)"tmp");
    }

    public static final void writeNullableString(@NotNull OutputStream $receiver, @Nullable String value2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if (value2 == null) {
            OutputStream outputStream;
            OutputStream it = outputStream = $receiver;
            SerializersKt.writeInt($receiver, -1);
            return;
        }
        SerializersKt.writeInt($receiver, value2.length());
        CharIterator charIterator = StringsKt.iterator((CharSequence)value2);
        while (charIterator.hasNext()) {
            char c2 = charIterator.nextChar();
            SerializersKt.writeChar($receiver, c2);
        }
    }

    public static final void writeString(@NotNull OutputStream $receiver, @NotNull String value2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
        SerializersKt.writeNullableString($receiver, value2);
    }

    /*
     * WARNING - void declaration
     */
    private static final <T> void writePrimitivesNullableArray(@NotNull OutputStream $receiver, T array2, Function1<? super T, Integer> getLength, Function1<? super Integer, Unit> writeElem) {
        if (array2 == null) {
            SerializersKt.writeInt($receiver, -1);
            return;
        }
        int len = ((Number)getLength.invoke(array2)).intValue();
        SerializersKt.writeInt($receiver, len);
        int n2 = 0;
        int n3 = len - 1;
        if (n2 <= n3) {
            while (true) {
                void i2;
                writeElem.invoke((Object)((int)i2));
                if (i2 == n3) break;
                ++i2;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final <T> void writePrimitivesArray(@NotNull OutputStream $receiver, T array2, Function1<? super T, Integer> getLength, Function1<? super Integer, Unit> writeElem) {
        OutputStream $receiver$iv = $receiver;
        if (array2 == null) {
            SerializersKt.writeInt($receiver$iv, -1);
        } else {
            int len$iv = ((Number)getLength.invoke(array2)).intValue();
            SerializersKt.writeInt($receiver$iv, len$iv);
            int n2 = 0;
            int n3 = len$iv - 1;
            if (n2 <= n3) {
                while (true) {
                    void i$iv;
                    writeElem.invoke((Object)((int)i$iv));
                    if (i$iv == n3) break;
                    ++i$iv;
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void writeByteArray(@NotNull OutputStream $receiver, @NotNull byte[] value2) {
        OutputStream $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
        OutputStream $receiver$iv$iv = $receiver$iv = $receiver;
        if (value2 == null) {
            SerializersKt.writeInt($receiver$iv$iv, -1);
        } else {
            byte[] it = value2;
            int len$iv$iv = it.length;
            SerializersKt.writeInt($receiver$iv$iv, len$iv$iv);
            int n2 = 0;
            int n3 = len$iv$iv - 1;
            if (n2 <= n3) {
                void i$iv$iv;
                do {
                    void i2 = ++i$iv$iv;
                    SerializersKt.writeByte($receiver, value2[i2]);
                } while (i$iv$iv != n3);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void writeShortArray(@NotNull OutputStream $receiver, @NotNull short[] value2) {
        OutputStream $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
        OutputStream $receiver$iv$iv = $receiver$iv = $receiver;
        if (value2 == null) {
            SerializersKt.writeInt($receiver$iv$iv, -1);
        } else {
            short[] it = value2;
            int len$iv$iv = it.length;
            SerializersKt.writeInt($receiver$iv$iv, len$iv$iv);
            int n2 = 0;
            int n3 = len$iv$iv - 1;
            if (n2 <= n3) {
                void i$iv$iv;
                do {
                    void i2 = ++i$iv$iv;
                    SerializersKt.writeShort($receiver, value2[i2]);
                } while (i$iv$iv != n3);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void writeIntArray(@NotNull OutputStream $receiver, @NotNull int[] value2) {
        OutputStream $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
        OutputStream $receiver$iv$iv = $receiver$iv = $receiver;
        if (value2 == null) {
            SerializersKt.writeInt($receiver$iv$iv, -1);
        } else {
            int[] it = value2;
            int len$iv$iv = it.length;
            SerializersKt.writeInt($receiver$iv$iv, len$iv$iv);
            int n2 = 0;
            int n3 = len$iv$iv - 1;
            if (n2 <= n3) {
                void i$iv$iv;
                do {
                    void i2 = ++i$iv$iv;
                    SerializersKt.writeInt($receiver, value2[i2]);
                } while (i$iv$iv != n3);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void writeLongArray(@NotNull OutputStream $receiver, @NotNull long[] value2) {
        OutputStream $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
        OutputStream $receiver$iv$iv = $receiver$iv = $receiver;
        if (value2 == null) {
            SerializersKt.writeInt($receiver$iv$iv, -1);
        } else {
            long[] it = value2;
            int len$iv$iv = it.length;
            SerializersKt.writeInt($receiver$iv$iv, len$iv$iv);
            int n2 = 0;
            int n3 = len$iv$iv - 1;
            if (n2 <= n3) {
                void i$iv$iv;
                do {
                    void i2 = ++i$iv$iv;
                    SerializersKt.writeLong($receiver, value2[i2]);
                } while (i$iv$iv != n3);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void writeFloatArray(@NotNull OutputStream $receiver, @NotNull float[] value2) {
        OutputStream $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
        OutputStream $receiver$iv$iv = $receiver$iv = $receiver;
        if (value2 == null) {
            SerializersKt.writeInt($receiver$iv$iv, -1);
        } else {
            float[] it = value2;
            int len$iv$iv = it.length;
            SerializersKt.writeInt($receiver$iv$iv, len$iv$iv);
            int n2 = 0;
            int n3 = len$iv$iv - 1;
            if (n2 <= n3) {
                void i$iv$iv;
                do {
                    void i2 = ++i$iv$iv;
                    SerializersKt.writeFloat($receiver, value2[i2]);
                } while (i$iv$iv != n3);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void writeDoubleArray(@NotNull OutputStream $receiver, @NotNull double[] value2) {
        OutputStream $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
        OutputStream $receiver$iv$iv = $receiver$iv = $receiver;
        if (value2 == null) {
            SerializersKt.writeInt($receiver$iv$iv, -1);
        } else {
            double[] it = value2;
            int len$iv$iv = it.length;
            SerializersKt.writeInt($receiver$iv$iv, len$iv$iv);
            int n2 = 0;
            int n3 = len$iv$iv - 1;
            if (n2 <= n3) {
                void i$iv$iv;
                do {
                    void i2 = ++i$iv$iv;
                    SerializersKt.writeDouble($receiver, value2[i2]);
                } while (i$iv$iv != n3);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void writeCharArray(@NotNull OutputStream $receiver, @NotNull char[] value2) {
        OutputStream $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
        OutputStream $receiver$iv$iv = $receiver$iv = $receiver;
        if (value2 == null) {
            SerializersKt.writeInt($receiver$iv$iv, -1);
        } else {
            char[] it = value2;
            int len$iv$iv = it.length;
            SerializersKt.writeInt($receiver$iv$iv, len$iv$iv);
            int n2 = 0;
            int n3 = len$iv$iv - 1;
            if (n2 <= n3) {
                void i$iv$iv;
                do {
                    void i2 = ++i$iv$iv;
                    SerializersKt.writeChar($receiver, value2[i2]);
                } while (i$iv$iv != n3);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void writeBooleanArray(@NotNull OutputStream $receiver, @NotNull boolean[] value2) {
        OutputStream $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
        OutputStream $receiver$iv$iv = $receiver$iv = $receiver;
        if (value2 == null) {
            SerializersKt.writeInt($receiver$iv$iv, -1);
        } else {
            boolean[] it = value2;
            int len$iv$iv = it.length;
            SerializersKt.writeInt($receiver$iv$iv, len$iv$iv);
            int n2 = 0;
            int n3 = len$iv$iv - 1;
            if (n2 <= n3) {
                void i$iv$iv;
                do {
                    void i2 = ++i$iv$iv;
                    SerializersKt.writeBoolean($receiver, value2[i2]);
                } while (i$iv$iv != n3);
            }
        }
    }

    public static final void writeUuid(@NotNull OutputStream $receiver, @NotNull UUID value2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
        byte[] byArray = ByteBuffer.allocate(16).putLong(value2.getMostSignificantBits()).putLong(value2.getLeastSignificantBits()).array();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"ByteBuffer.allocate(16).\u2026tSignificantBits).array()");
        SerializersKt.writeByteArray($receiver, SerializersKt.transformGuidUuid(byArray));
    }

    public static final void writeGuid(@NotNull OutputStream $receiver, @NotNull UUID value2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
        SerializersKt.writeUuid($receiver, value2);
    }

    public static final void writeDateTime(@NotNull OutputStream $receiver, @NotNull Date value2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
        SerializersKt.writeLong($receiver, value2.getTime() * TICKS_PER_MILLISECOND + TICKS_AT_EPOCH);
    }

    public static final void writeUri(@NotNull OutputStream $receiver, @NotNull URI value2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
        String string2 = value2.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"value.toString()");
        SerializersKt.writeString($receiver, string2);
    }

    public static final <T> void writeNullable(@NotNull OutputStream $receiver, @Nullable T value2, @NotNull Function1<? super T, Unit> elemWriter) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(elemWriter, (String)"elemWriter");
        if (value2 == null) {
            SerializersKt.writeBool($receiver, false);
        } else {
            SerializersKt.writeBool($receiver, true);
            elemWriter.invoke(value2);
        }
    }

    @PublicApi
    public static final <T> void writeArray(@NotNull OutputStream $receiver, @NotNull T[] value2, @NotNull Function1<? super T, Unit> elemWriter) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(value2, (String)"value");
        Intrinsics.checkParameterIsNotNull(elemWriter, (String)"elemWriter");
        SerializersKt.writeInt($receiver, value2.length);
        T[] $receiver$iv = value2;
        for (int i2 = 0; i2 < $receiver$iv.length; ++i2) {
            T element$iv;
            T it = element$iv = $receiver$iv[i2];
            elemWriter.invoke(it);
        }
    }

    public static final <T> void writeList(@NotNull OutputStream $receiver, @NotNull List<? extends T> value2, @NotNull Function1<? super T, Unit> elemWriter) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(value2, (String)"value");
        Intrinsics.checkParameterIsNotNull(elemWriter, (String)"elemWriter");
        SerializersKt.writeInt($receiver, value2.size());
        Iterable $receiver$iv = value2;
        Iterator iterator2 = $receiver$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv;
            Object it = element$iv = iterator2.next();
            elemWriter.invoke(it);
        }
    }

    private static final <T extends Enum<T>> void writeEnum(@NotNull OutputStream $receiver, Enum<T> value2) {
        SerializersKt.writeInt($receiver, value2.ordinal());
    }

    private static final <T> void writeNullableList(@NotNull OutputStream $receiver, List<? extends T> value2, Function2<? super OutputStream, ? super T, Unit> elemWriter) {
        if (value2 == null) {
            OutputStream outputStream;
            OutputStream it = outputStream = $receiver;
            SerializersKt.writeInt($receiver, -1);
            return;
        }
        SerializersKt.writeInt($receiver, value2.size());
        for (T item : value2) {
            elemWriter.invoke((Object)$receiver, item);
        }
    }

    private static final <T> void writeList(@NotNull OutputStream $receiver, List<? extends T> value2, Function2<? super OutputStream, ? super T, Unit> elemWriter) {
        OutputStream $receiver$iv = $receiver;
        if (value2 == null) {
            OutputStream outputStream;
            OutputStream it$iv = outputStream = $receiver$iv;
            SerializersKt.writeInt($receiver$iv, -1);
        } else {
            SerializersKt.writeInt($receiver$iv, value2.size());
            for (T item$iv : value2) {
                elemWriter.invoke((Object)$receiver$iv, item$iv);
            }
        }
    }

    public static final void writeRdId(@NotNull OutputStream $receiver, @NotNull RdId value2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
        value2.write($receiver);
    }

    static {
        TICKS_AT_EPOCH = 621355968000000000L;
        TICKS_PER_MILLISECOND = 10000L;
    }

    @Nullable
    public static final /* synthetic */ Object access$readPrimitivesNullableArray(@NotNull InputStream $receiver, @NotNull Function1 ctr, @NotNull Function2 setter) {
        return SerializersKt.readPrimitivesNullableArray($receiver, ctr, setter);
    }

    public static final /* synthetic */ void access$writePrimitivesNullableArray(@NotNull OutputStream $receiver, @Nullable Object array2, @NotNull Function1 getLength, @NotNull Function1 writeElem) {
        SerializersKt.writePrimitivesNullableArray($receiver, array2, getLength, (Function1<? super Integer, Unit>)writeElem);
    }
}

