/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.framework;

import com.jetbrains.rider.framework.IProtocol;
import com.jetbrains.rider.framework.RdId;
import com.jetbrains.rider.framework.SerializationCtx;
import com.jetbrains.rider.framework.SerializersKt;
import com.jetbrains.rider.framework.base.WireBase;
import com.jetbrains.rider.util.lifetime.Lifetime;
import com.jetbrains.rider.util.lifetime.LifetimeExKt;
import com.jetbrains.rider.util.reactive.IProperty;
import com.jetbrains.rider.util.reactive.OneWriteProperty;
import com.jetbrains.rider.util.reactive.PropertyExKt;
import com.jetbrains.rider.util.threading.ByteArraySlice;
import com.jetbrains.rider.util.threading.ByteBufferAsyncProcessor;
import com.jetbrains.rider.util.threading.ByteBufferAsyncProcessorKt;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0003\u0003\u0004\u0005B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rider/framework/SocketWire;", "", "()V", "Base", "Client", "Server", "rider-framework"})
public final class SocketWire {

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u001f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001dH\u0002J*\u0010#\u001a\u00020!2\u0006\u0010\u0002\u001a\u00020$2\u0018\u0010%\u001a\u0014\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020!0&H\u0016J\u0010\u0010(\u001a\u00020!2\u0006\u0010)\u001a\u00020*H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\u0018X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006+"}, d2={"Lcom/jetbrains/rider/framework/SocketWire$Base;", "Lcom/jetbrains/rider/framework/base/WireBase;", "id", "", "lifetime", "Lcom/jetbrains/rider/util/lifetime/Lifetime;", "protocol", "Lcom/jetbrains/rider/framework/IProtocol;", "(Ljava/lang/String;Lcom/jetbrains/rider/util/lifetime/Lifetime;Lcom/jetbrains/rider/framework/IProtocol;)V", "getId", "()Ljava/lang/String;", "input", "Ljava/io/InputStream;", "lock", "Ljava/lang/Object;", "getLock", "()Ljava/lang/Object;", "logger", "Lorg/apache/commons/logging/Log;", "getLogger", "()Lorg/apache/commons/logging/Log;", "output", "Ljava/io/OutputStream;", "sendBuffer", "Lcom/jetbrains/rider/util/threading/ByteBufferAsyncProcessor;", "getSendBuffer", "()Lcom/jetbrains/rider/util/threading/ByteBufferAsyncProcessor;", "socketProvider", "Lcom/jetbrains/rider/util/reactive/OneWriteProperty;", "Ljava/net/Socket;", "getSocketProvider", "()Lcom/jetbrains/rider/util/reactive/OneWriteProperty;", "ReceiverProc", "", "socket", "send", "Lcom/jetbrains/rider/framework/RdId;", "writer", "Lkotlin/Function2;", "Lcom/jetbrains/rider/framework/SerializationCtx;", "send0", "msg", "Lcom/jetbrains/rider/util/threading/ByteArraySlice;", "rider-framework"})
    public static abstract class Base
    extends WireBase {
        @NotNull
        private final Log logger;
        @NotNull
        private final OneWriteProperty<Socket> socketProvider;
        private OutputStream output;
        private InputStream input;
        @NotNull
        private final ByteBufferAsyncProcessor sendBuffer;
        @NotNull
        private final Object lock;
        @NotNull
        private final String id;
        private final Lifetime lifetime;

        @NotNull
        protected final Log getLogger() {
            return this.logger;
        }

        @NotNull
        protected final OneWriteProperty<Socket> getSocketProvider() {
            return this.socketProvider;
        }

        @NotNull
        protected final ByteBufferAsyncProcessor getSendBuffer() {
            return this.sendBuffer;
        }

        @NotNull
        protected final Object getLock() {
            return this.lock;
        }

        private final void ReceiverProc(Socket socket) {
            while (!this.lifetime.isTerminated()) {
                try {
                    byte[] bytes;
                    boolean bl;
                    if (!socket.isConnected()) {
                        this.logger.debug((Object)"Stop receive messages because socket disconnected");
                        ByteBufferAsyncProcessor.terminate$default(this.sendBuffer, 0L, 1, null);
                        break;
                    }
                    InputStream inputStream = this.input;
                    if (inputStream == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"input");
                    }
                    boolean bl2 = bl = (bytes = SerializersKt.readByteArray(inputStream)).length >= 4;
                    if (_Assertions.ENABLED && !bl) {
                        String string2 = "Assertion failed";
                        throw (Throwable)((Object)new AssertionError((Object)string2));
                    }
                    ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
                    RdId id = RdId.Companion.read(stream);
                    this.getMessageBroker().dispatch(id, stream);
                }
                catch (Exception ex) {
                    Exception exception = ex;
                    if (exception instanceof SocketException || exception instanceof EOFException) {
                        this.logger.debug((Object)("Exception in SocketWire.Receive:  " + this.id + ": " + ex));
                    } else {
                        this.logger.error((Object)(this.id + " caught processing"), (Throwable)ex);
                    }
                    ByteBufferAsyncProcessor.terminate$default(this.sendBuffer, 0L, 1, null);
                    break;
                }
            }
        }

        private final void send0(ByteArraySlice msg) {
            try {
                OutputStream outputStream = this.output;
                if (outputStream == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"output");
                }
                ByteBufferAsyncProcessorKt.write(outputStream, msg);
            }
            catch (SocketException ex) {
                ByteBufferAsyncProcessor.terminate$default(this.sendBuffer, 0L, 1, null);
            }
        }

        @Override
        public void send(@NotNull RdId id, @NotNull Function2<? super SerializationCtx, ? super OutputStream, Unit> writer) {
            Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
            Intrinsics.checkParameterIsNotNull(writer, (String)"writer");
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            SerializersKt.writeInt(stream, 0);
            int ptr = stream.size();
            id.write(stream);
            writer.invoke((Object)this.getSerializationCtx(), (Object)stream);
            int len = stream.size() - ptr;
            byte[] data = stream.toByteArray();
            Intrinsics.checkExpressionValueIsNotNull((Object)data, (String)"data");
            SerializersKt.writeIntoByteArray$default(len, data, 0, 2, null);
            Intrinsics.checkExpressionValueIsNotNull((Object)data, (String)"data");
            this.sendBuffer.put(data);
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        protected Base(@NotNull String id, @NotNull Lifetime lifetime, @NotNull IProtocol protocol2) {
            Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
            Intrinsics.checkParameterIsNotNull((Object)lifetime, (String)"lifetime");
            Intrinsics.checkParameterIsNotNull((Object)protocol2, (String)"protocol");
            super(protocol2);
            this.id = id;
            this.lifetime = lifetime;
            Log log = LogFactory.getLog(this.getClass());
            Intrinsics.checkExpressionValueIsNotNull((Object)log, (String)"LogFactory.getLog(javaClass)");
            this.logger = log;
            this.socketProvider = new OneWriteProperty();
            this.sendBuffer = new ByteBufferAsyncProcessor(this.id + "-AsyncSendProcessor", 0, (Function1)new Function1<ByteArraySlice, Unit>(this){
                final /* synthetic */ Base this$0;

                public final void invoke(@NotNull ByteArraySlice it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    Base.access$send0(this.this$0, it);
                }
                {
                    this.this$0 = base;
                    super(1);
                }
            }, 2, null);
            this.lock = new Object();
            this.socketProvider.advise(this.lifetime, (Function1<Socket, Unit>)((Function1)new Function1<Socket, Unit>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void invoke(@NotNull Socket socket) {
                    Intrinsics.checkParameterIsNotNull((Object)socket, (String)"socket");
                    Object object = this.getLock();
                    synchronized (object) {
                        if (lifetime.isTerminated()) {
                            return;
                        }
                        OutputStream outputStream = socket.getOutputStream();
                        Intrinsics.checkExpressionValueIsNotNull((Object)outputStream, (String)"socket.outputStream");
                        output = outputStream;
                        InputStream inputStream = socket.getInputStream();
                        int n2 = 0;
                        boolean bl = true;
                        Object var6_8 = null;
                        Base base = this;
                        if (bl & true) {
                            n2 = 8192;
                        }
                        BufferedInputStream bufferedInputStream = inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream, n2);
                        base.input = bufferedInputStream;
                        this.getSendBuffer().start();
                        Unit unit = Unit.INSTANCE;
                    }
                    this.ReceiverProc(socket);
                }
            }));
        }

        public static final /* synthetic */ void access$send0(Base $this, @NotNull ByteArraySlice msg) {
            $this.send0(msg);
        }

        @NotNull
        public static final /* synthetic */ OutputStream access$getOutput$p(Base $this) {
            OutputStream outputStream = $this.output;
            if (outputStream == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"output");
            }
            return outputStream;
        }

        @NotNull
        public static final /* synthetic */ InputStream access$getInput$p(Base $this) {
            InputStream inputStream = $this.input;
            if (inputStream == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"input");
            }
            return inputStream;
        }
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rider/framework/SocketWire$Client;", "Lcom/jetbrains/rider/framework/SocketWire$Base;", "lifetime", "Lcom/jetbrains/rider/util/lifetime/Lifetime;", "protocol", "Lcom/jetbrains/rider/framework/IProtocol;", "port", "", "optId", "", "(Lcom/jetbrains/rider/util/lifetime/Lifetime;Lcom/jetbrains/rider/framework/IProtocol;ILjava/lang/String;)V", "rider-framework"})
    public static final class Client
    extends Base {
        /*
         * WARNING - void declaration
         */
        public Client(@NotNull Lifetime lifetime, @NotNull IProtocol protocol2, int port, @Nullable String optId) {
            void socket;
            Intrinsics.checkParameterIsNotNull((Object)lifetime, (String)"lifetime");
            Intrinsics.checkParameterIsNotNull((Object)protocol2, (String)"protocol");
            String string2 = optId;
            if (string2 == null) {
                string2 = "ClientSocket";
            }
            super(string2, lifetime, protocol2);
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            objectRef.element = null;
            Thread thread2 = ThreadsKt.thread$default((boolean)false, (boolean)false, null, (String)this.getId(), (int)0, (Function0)((Function0)new Function0<Unit>(this, lifetime, port, (Ref.ObjectRef)socket){
                final /* synthetic */ Client this$0;
                final /* synthetic */ Lifetime $lifetime;
                final /* synthetic */ int $port;
                final /* synthetic */ Ref.ObjectRef $socket;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void invoke() {
                    try {
                        int timeout = 500;
                        while (!this.$lifetime.isTerminated()) {
                            try {
                                Socket s2 = new Socket();
                                s2.setTcpNoDelay(true);
                                s2.connect(new InetSocketAddress(InetAddress.getLoopbackAddress(), this.$port));
                                Object object = this.this$0.getLock();
                                synchronized (object) {
                                    if (this.$lifetime.isTerminated()) {
                                        try {
                                            s2.close();
                                        }
                                        catch (Throwable e$iv) {
                                            LogFactory.getLog((String)"catch").error((Object)"Isolated exception", e$iv);
                                        }
                                    } else {
                                        this.$socket.element = s2;
                                    }
                                    Unit $i$a$1$catch = Unit.INSTANCE;
                                }
                                PropertyExKt.set(this.this$0.getSocketProvider(), s2);
                                break;
                            }
                            catch (ConnectException e2) {
                                boolean bl;
                                Object object = this.this$0.getLock();
                                synchronized (object) {
                                    boolean bl2;
                                    if (!this.$lifetime.isTerminated()) {
                                        this.this$0.getLock().wait(timeout);
                                        bl2 = !this.$lifetime.isTerminated();
                                    } else {
                                        bl2 = false;
                                    }
                                    bl = bl2;
                                }
                                boolean reconnect = bl;
                                if (reconnect) {
                                    continue;
                                }
                                break;
                            }
                        }
                    }
                    catch (SocketException ex) {
                        this.this$0.getLogger().info((Object)(this.this$0.getId() + " closed with exception: " + ex));
                    }
                }
                {
                    this.this$0 = client;
                    this.$lifetime = lifetime;
                    this.$port = n2;
                    this.$socket = objectRef;
                    super(0);
                }
            }), (int)23, null);
            LifetimeExKt.plusAssign(lifetime, (Function0<Unit>)((Function0)new Function0<Unit>((Ref.ObjectRef)socket, thread2){
                final /* synthetic */ Ref.ObjectRef $socket;
                final /* synthetic */ Thread $thread;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void invoke() {
                    this.getLogger().debug((Object)("Terminating " + this.getId() + " lifetime"));
                    boolean sendBufferStopped = this.getSendBuffer().stop(5000L);
                    this.getLogger().debug((Object)(this.getId() + ": SendBufferStopped: " + sendBufferStopped));
                    Object object = this.getLock();
                    synchronized (object) {
                        try {
                            Socket socket = (Socket)this.$socket.element;
                            if (socket != null) {
                                socket.close();
                            }
                        }
                        catch (Throwable e$iv) {
                            LogFactory.getLog((String)"catch").error((Object)"Isolated exception", e$iv);
                        }
                        this.getLock().notifyAll();
                        Unit unit = Unit.INSTANCE;
                    }
                    this.$thread.join();
                    this.getLogger().debug((Object)(this.getId() + " terminated"));
                }
                {
                    this.$socket = objectRef;
                    this.$thread = thread2;
                    super(0);
                }
            }));
            objectRef = null;
        }

        public /* synthetic */ Client(Lifetime lifetime, IProtocol iProtocol, int n2, String string2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 8) != 0) {
                string2 = null;
            }
            this(lifetime, iProtocol, n2, string2);
        }
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rider/framework/SocketWire$Server;", "Lcom/jetbrains/rider/framework/SocketWire$Base;", "lifetime", "Lcom/jetbrains/rider/util/lifetime/Lifetime;", "protocol", "Lcom/jetbrains/rider/framework/IProtocol;", "port", "", "optId", "", "(Lcom/jetbrains/rider/util/lifetime/Lifetime;Lcom/jetbrains/rider/framework/IProtocol;Ljava/lang/Integer;Ljava/lang/String;)V", "getPort", "()I", "rider-framework"})
    public static final class Server
    extends Base {
        private final int port;

        public final int getPort() {
            return this.port;
        }

        /*
         * WARNING - void declaration
         */
        public Server(@NotNull Lifetime lifetime, @NotNull IProtocol protocol2, @Nullable Integer port, @Nullable String optId) {
            void socket;
            Intrinsics.checkParameterIsNotNull((Object)lifetime, (String)"lifetime");
            Intrinsics.checkParameterIsNotNull((Object)protocol2, (String)"protocol");
            String string2 = optId;
            if (string2 == null) {
                string2 = "ServerSocket";
            }
            super(string2, lifetime, protocol2);
            Integer n2 = port;
            final ServerSocket ss = new ServerSocket(n2 != null ? n2 : 0, 0, InetAddress.getByName("127.0.0.1"));
            this.port = ss.getLocalPort();
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            objectRef.element = null;
            Thread thread2 = ThreadsKt.thread$default((boolean)false, (boolean)false, null, (String)this.getId(), (int)0, (Function0)((Function0)new Function0<Unit>(this, ss, lifetime, (Ref.ObjectRef)socket){
                final /* synthetic */ Server this$0;
                final /* synthetic */ ServerSocket $ss;
                final /* synthetic */ Lifetime $lifetime;
                final /* synthetic */ Ref.ObjectRef $socket;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void invoke() {
                    try {
                        Socket s2 = this.$ss.accept();
                        s2.setTcpNoDelay(true);
                        Object object = this.this$0.getLock();
                        synchronized (object) {
                            if (this.$lifetime.isTerminated()) {
                                try {
                                    s2.close();
                                }
                                catch (Throwable e$iv) {
                                    LogFactory.getLog((String)"catch").error((Object)"Isolated exception", e$iv);
                                }
                            } else {
                                this.$socket.element = s2;
                            }
                            Unit unit = Unit.INSTANCE;
                        }
                        IProperty iProperty = this.this$0.getSocketProvider();
                        Socket socket = s2;
                        Intrinsics.checkExpressionValueIsNotNull((Object)socket, (String)"s");
                        PropertyExKt.set(iProperty, socket);
                    }
                    catch (SocketException ex) {
                        this.this$0.getLogger().info((Object)(this.this$0.getId() + " closed with exception: " + ex));
                    }
                }
                {
                    this.this$0 = server;
                    this.$ss = serverSocket;
                    this.$lifetime = lifetime;
                    this.$socket = objectRef;
                    super(0);
                }
            }), (int)23, null);
            LifetimeExKt.plusAssign(lifetime, (Function0<Unit>)((Function0)new Function0<Unit>((Ref.ObjectRef)socket, thread2){
                final /* synthetic */ Ref.ObjectRef $socket;
                final /* synthetic */ Thread $thread;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void invoke() {
                    this.getLogger().debug((Object)("Terminating " + this.getId() + " lifetime"));
                    boolean sendBufferStopped = this.getSendBuffer().stop(5000L);
                    this.getLogger().debug((Object)(this.getId() + ": SendBufferStopped: " + sendBufferStopped));
                    try {
                        ss.close();
                    }
                    catch (Throwable e$iv) {
                        LogFactory.getLog((String)"catch").error((Object)"Isolated exception", e$iv);
                    }
                    try {
                        Object object = this.getLock();
                        synchronized (object) {
                            Unit unit;
                            Socket socket = (Socket)this.$socket.element;
                            if (socket != null) {
                                socket.close();
                                unit = Unit.INSTANCE;
                            } else {
                                unit = null;
                            }
                            Unit unit2 = unit;
                        }
                    }
                    catch (Throwable e$iv) {
                        LogFactory.getLog((String)"catch").error((Object)"Isolated exception", e$iv);
                    }
                    this.$thread.join();
                    this.getLogger().debug((Object)(this.getId() + " terminated"));
                }
                {
                    this.$socket = objectRef;
                    this.$thread = thread2;
                    super(0);
                }
            }));
            objectRef = null;
        }

        public /* synthetic */ Server(Lifetime lifetime, IProtocol iProtocol, Integer n2, String string2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 8) != 0) {
                string2 = null;
            }
            this(lifetime, iProtocol, n2, string2);
        }
    }
}

