/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.framework.base;

import com.jetbrains.rider.framework.IIdentities;
import com.jetbrains.rider.framework.ISerializers;
import com.jetbrains.rider.framework.IWire;
import com.jetbrains.rider.framework.Protocol;
import com.jetbrains.rider.framework.RdId;
import com.jetbrains.rider.framework.base.IRdReactive;
import com.jetbrains.rider.framework.base.IRdReactiveKt;
import com.jetbrains.rider.framework.base.RdBindableBase;
import com.jetbrains.rider.util.Maybe;
import com.jetbrains.rider.util.lifetime.Lifetime;
import com.jetbrains.rider.util.lifetime.LifetimeExKt;
import com.jetbrains.rider.util.reactive.IScheduler;
import com.jetbrains.rider.util.string.PrettyPrinter;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 ,2\u00020\u00012\u00020\u0002:\u0001,B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u001e\u001a\u00020\u001fH\u0004J\b\u0010 \u001a\u00020\u001fH\u0004J\u0010\u0010!\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020&H\u0014J!\u0010'\u001a\u0002H(\"\u0004\b\u0000\u0010(2\f\u0010)\u001a\b\u0012\u0004\u0012\u0002H(0*H\u0004\u00a2\u0006\u0002\u0010+R\u001a\u0010\u0004\u001a\u00020\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0007\"\u0004\b\u0015\u0010\tR\u0014\u0010\u0016\u001a\u00020\u00178DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u001b8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006-"}, d2={"Lcom/jetbrains/rider/framework/base/RdReactiveBase;", "Lcom/jetbrains/rider/framework/base/RdBindableBase;", "Lcom/jetbrains/rider/framework/base/IRdReactive;", "()V", "async", "", "getAsync", "()Z", "setAsync", "(Z)V", "defaultScheduler", "Lcom/jetbrains/rider/util/reactive/IScheduler;", "getDefaultScheduler", "()Lcom/jetbrains/rider/util/reactive/IScheduler;", "id", "Lcom/jetbrains/rider/framework/RdId;", "getId", "()Lcom/jetbrains/rider/framework/RdId;", "setId", "(Lcom/jetbrains/rider/framework/RdId;)V", "isLocalChange", "setLocalChange", "serializers", "Lcom/jetbrains/rider/framework/ISerializers;", "getSerializers", "()Lcom/jetbrains/rider/framework/ISerializers;", "wire", "Lcom/jetbrains/rider/framework/IWire;", "getWire", "()Lcom/jetbrains/rider/framework/IWire;", "assertBound", "", "assertThreading", "identify", "ids", "Lcom/jetbrains/rider/framework/IIdentities;", "init", "lifetime", "Lcom/jetbrains/rider/util/lifetime/Lifetime;", "localChange", "T", "action", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "Companion", "rider-framework"})
public abstract class RdReactiveBase
extends RdBindableBase
implements IRdReactive {
    @NotNull
    private RdId id = RdId.Companion.getNull();
    private boolean async;
    private boolean isLocalChange;
    @NotNull
    private static final Maybe.Just<Log> logReceived;
    @NotNull
    private static final Maybe.Just<Log> logSend;
    @NotNull
    private static final Log logAssert;
    public static final Companion Companion;

    @Override
    @NotNull
    public RdId getId() {
        return this.id;
    }

    @Override
    public void setId(@NotNull RdId rdId2) {
        Intrinsics.checkParameterIsNotNull((Object)rdId2, (String)"<set-?>");
        this.id = rdId2;
    }

    @Override
    public void identify(@NotNull IIdentities ids) {
        Intrinsics.checkParameterIsNotNull((Object)ids, (String)"ids");
        IRdReactiveKt.withId(this, ids.next());
    }

    @Override
    public boolean getAsync() {
        return this.async;
    }

    @Override
    public void setAsync(boolean bl) {
        this.async = bl;
    }

    protected final void assertThreading() {
        if (!this.getAsync() && !this.getDefaultScheduler().isActive()) {
            Companion.getLogAssert().error((Object)"Must be executed on UI thread", (Throwable)new IllegalStateException("|E| Wrong thread"));
        }
    }

    protected final void assertBound() {
        boolean $receiver$iv = this.isBound();
        if (!$receiver$iv) {
            throw (Throwable)new IllegalStateException("Not bound");
        }
    }

    @NotNull
    protected final ISerializers getSerializers() {
        return this.getProtocol().getSerializers();
    }

    @NotNull
    protected final IWire getWire() {
        return this.getProtocol().getWire();
    }

    @NotNull
    protected final IScheduler getDefaultScheduler() {
        return this.getProtocol().getScheduler();
    }

    protected final boolean isLocalChange() {
        return this.isLocalChange;
    }

    protected final void setLocalChange(boolean bl) {
        this.isLocalChange = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final <T> T localChange(@NotNull Function0<? extends T> action2) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull(action2, (String)"action");
        if (this.isBound() && !this.getAsync()) {
            this.assertThreading();
        }
        boolean bl2 = bl = !this.isLocalChange;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "!isLocalChange";
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        this.isLocalChange = true;
        try {
            Object object = action2.invoke();
            return (T)object;
        }
        finally {
            this.isLocalChange = false;
        }
    }

    @Override
    protected void init(@NotNull Lifetime lifetime) {
        Intrinsics.checkParameterIsNotNull((Object)lifetime, (String)"lifetime");
        LifetimeExKt.assertIsAlive(lifetime);
        this.getDefaultScheduler().assertThread();
        this.getId().notNull();
        LifetimeExKt.plusAssign(lifetime, (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ RdReactiveBase this$0;

            public final void invoke() {
                this.this$0.setId(RdId.Companion.getNull());
            }
            {
                this.this$0 = rdReactiveBase;
                super(0);
            }
        }));
    }

    static {
        Companion = new Companion(null);
        logReceived = Protocol.Companion.sublogger("RECEIVED");
        logSend = Protocol.Companion.sublogger("SEND");
        Log log = LogFactory.getLog(RdReactiveBase.class);
        if (log == null) {
            Intrinsics.throwNpe();
        }
        logAssert = log;
    }

    @Override
    public void print(@NotNull PrettyPrinter printer2) {
        Intrinsics.checkParameterIsNotNull((Object)printer2, (String)"printer");
        IRdReactive.DefaultImpls.print(this, printer2);
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\n\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rider/framework/base/RdReactiveBase$Companion;", "", "()V", "logAssert", "Lorg/apache/commons/logging/Log;", "getLogAssert", "()Lorg/apache/commons/logging/Log;", "logReceived", "Lcom/jetbrains/rider/util/Maybe$Just;", "getLogReceived", "()Lcom/jetbrains/rider/util/Maybe$Just;", "logSend", "getLogSend", "rider-framework"})
    public static final class Companion {
        @NotNull
        public final Maybe.Just<Log> getLogReceived() {
            return logReceived;
        }

        @NotNull
        public final Maybe.Just<Log> getLogSend() {
            return logSend;
        }

        @NotNull
        public final Log getLogAssert() {
            return logAssert;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

