/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.framework.impl;

import com.jetbrains.rider.framework.ISerializer;
import com.jetbrains.rider.framework.SerializationCtx;
import com.jetbrains.rider.framework.SerializersKt;
import com.jetbrains.rider.util.ThrowableUtilKt;
import java.io.InputStream;
import java.io.OutputStream;
import java.rmi.RemoteException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u0007*\u0006\b\u0000\u0010\u0001 \u00012\u00020\u0002:\u0004\u0006\u0007\b\tB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u000b\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0005\u0082\u0001\u0003\n\u000b\f\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rider/framework/impl/RdTaskResult;", "T", "", "()V", "unwrap", "()Ljava/lang/Object;", "Cancelled", "Companion", "Fault", "Success", "Lcom/jetbrains/rider/framework/impl/RdTaskResult$Success;", "Lcom/jetbrains/rider/framework/impl/RdTaskResult$Cancelled;", "Lcom/jetbrains/rider/framework/impl/RdTaskResult$Fault;", "rider-framework"})
public abstract class RdTaskResult<T> {
    public static final Companion Companion = new Companion(null);

    public final T unwrap() {
        RdTaskResult rdTaskResult = this;
        if (!(rdTaskResult instanceof Success)) {
            if (rdTaskResult instanceof Cancelled) {
                throw (Throwable)new InterruptedException("Task finished in Cancelled state");
            }
            if (rdTaskResult instanceof Fault) {
                throw ((Fault)this).getError();
            }
            throw new NoWhenBranchMatchedException();
        }
        return ((Success)this).getValue();
    }

    private RdTaskResult() {
    }

    public /* synthetic */ RdTaskResult(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000*\u0006\b\u0001\u0010\u0001 \u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0004R\u0013\u0010\u0003\u001a\u00028\u0001\u00a2\u0006\n\n\u0002\u0010\u0007\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rider/framework/impl/RdTaskResult$Success;", "T", "Lcom/jetbrains/rider/framework/impl/RdTaskResult;", "value", "(Ljava/lang/Object;)V", "getValue", "()Ljava/lang/Object;", "Ljava/lang/Object;", "rider-framework"})
    public static final class Success<T>
    extends RdTaskResult<T> {
        private final T value;

        public final T getValue() {
            return this.value;
        }

        public Success(T value2) {
            super(null);
            this.value = value2;
        }
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\u0006\b\u0001\u0010\u0001 \u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/jetbrains/rider/framework/impl/RdTaskResult$Cancelled;", "T", "Lcom/jetbrains/rider/framework/impl/RdTaskResult;", "()V", "rider-framework"})
    public static final class Cancelled<T>
    extends RdTaskResult<T> {
        public Cancelled() {
            super(null);
        }
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0004\u0018\u0000*\u0006\b\u0001\u0010\u0001 \u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rider/framework/impl/RdTaskResult$Fault;", "T", "Lcom/jetbrains/rider/framework/impl/RdTaskResult;", "error", "", "(Ljava/lang/Throwable;)V", "getError", "()Ljava/lang/Throwable;", "rider-framework"})
    public static final class Fault<T>
    extends RdTaskResult<T> {
        @NotNull
        private final Throwable error;

        @NotNull
        public final Throwable getError() {
            return this.error;
        }

        public Fault(@NotNull Throwable error) {
            Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
            super(null);
            this.error = error;
        }
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0004\b\u0001\u0010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00050\u000bJ8\u0010\f\u001a\u00020\r\"\u0004\b\u0001\u0010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u00050\u00042\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00050\u000b\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rider/framework/impl/RdTaskResult$Companion;", "", "()V", "read", "Lcom/jetbrains/rider/framework/impl/RdTaskResult;", "T", "ctx", "Lcom/jetbrains/rider/framework/SerializationCtx;", "stream", "Ljava/io/InputStream;", "serializer", "Lcom/jetbrains/rider/framework/ISerializer;", "write", "", "Ljava/io/OutputStream;", "value", "rider-framework"})
    public static final class Companion {
        @NotNull
        public final <T> RdTaskResult<T> read(@NotNull SerializationCtx ctx, @NotNull InputStream stream, @NotNull ISerializer<T> serializer2) {
            RdTaskResult rdTaskResult;
            Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
            Intrinsics.checkParameterIsNotNull((Object)stream, (String)"stream");
            Intrinsics.checkParameterIsNotNull(serializer2, (String)"serializer");
            int kind = SerializersKt.readInt(stream);
            switch (kind) {
                case 0: {
                    rdTaskResult = new Success<T>(serializer2.read(ctx, stream));
                    break;
                }
                case 1: {
                    rdTaskResult = new Cancelled();
                    break;
                }
                case 2: {
                    rdTaskResult = new Fault(new RemoteException(SerializersKt.readString(stream)));
                    break;
                }
                default: {
                    throw (Throwable)new IllegalArgumentException(String.valueOf(kind));
                }
            }
            return rdTaskResult;
        }

        public final <T> void write(@NotNull SerializationCtx ctx, @NotNull OutputStream stream, @NotNull RdTaskResult<? extends T> value2, @NotNull ISerializer<T> serializer2) {
            Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
            Intrinsics.checkParameterIsNotNull((Object)stream, (String)"stream");
            Intrinsics.checkParameterIsNotNull(value2, (String)"value");
            Intrinsics.checkParameterIsNotNull(serializer2, (String)"serializer");
            RdTaskResult<? extends T> rdTaskResult = value2;
            if (rdTaskResult instanceof Success) {
                SerializersKt.writeInt(stream, 0);
                serializer2.write(ctx, stream, ((Success)value2).getValue());
            } else if (rdTaskResult instanceof Cancelled) {
                SerializersKt.writeInt(stream, 1);
            } else if (rdTaskResult instanceof Fault) {
                SerializersKt.writeInt(stream, 2);
                String text2 = ThrowableUtilKt.getThrowableText(((Fault)value2).getError());
                CharSequence charSequence = text2;
                if (charSequence.length() == 0) {
                    text2 = "<empty message>";
                }
                SerializersKt.writeString(stream, text2);
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

