/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.framework.impl;

import com.jetbrains.rider.framework.IMarshaller;
import com.jetbrains.rider.framework.OriginKind;
import com.jetbrains.rider.framework.RdId;
import com.jetbrains.rider.framework.SerializationCtx;
import com.jetbrains.rider.framework.SerializersKt;
import com.jetbrains.rider.framework.base.IRdReactive;
import com.jetbrains.rider.framework.base.IRdReactiveKt;
import com.jetbrains.rider.framework.base.RdReactiveBase;
import com.jetbrains.rider.framework.impl.RdTextKt;
import com.jetbrains.rider.framework.impl.RdTextReplace;
import com.jetbrains.rider.framework.impl.TextBufferVersion;
import com.jetbrains.rider.util.lifetime.Lifetime;
import com.jetbrains.rider.util.reactive.AddRemove;
import com.jetbrains.rider.util.reactive.Signal;
import com.jetbrains.rider.util.reactive.ViewableList;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u0000 62\u00020\u0001:\u00016B\u001b\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\"\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020#0'J\u0010\u0010(\u001a\u00020#2\u0006\u0010)\u001a\u00020*H\u0002J\u0010\u0010+\u001a\u00020#2\u0006\u0010,\u001a\u00020\u0010H\u0002J\u0016\u0010-\u001a\u00020#2\u0006\u0010&\u001a\u00020\u00102\u0006\u0010.\u001a\u00020\u001bJ\u0006\u0010/\u001a\u00020#J\u0010\u00100\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0014J\u0010\u00101\u001a\u00020#2\u0006\u00102\u001a\u00020\u0010H\u0002J\u000e\u00103\u001a\u00020#2\u0006\u00104\u001a\u00020\u0003J\b\u00105\u001a\u00020\u0003H\u0016R$\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001e\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\u00100\u000fj\b\u0012\u0004\u0012\u00020\u0010`\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u001bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001cR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00100 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00100\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/jetbrains/rider/framework/impl/RdTextBuffer;", "Lcom/jetbrains/rider/framework/base/RdReactiveBase;", "initialText", "", "origin", "Lcom/jetbrains/rider/framework/OriginKind;", "(Ljava/lang/String;Lcom/jetbrains/rider/framework/OriginKind;)V", "<set-?>", "Lcom/jetbrains/rider/framework/impl/TextBufferVersion;", "bufferVersion", "getBufferVersion", "()Lcom/jetbrains/rider/framework/impl/TextBufferVersion;", "setBufferVersion", "(Lcom/jetbrains/rider/framework/impl/TextBufferVersion;)V", "changesToConfirmOrRollback", "Ljava/util/ArrayList;", "Lcom/jetbrains/rider/framework/impl/RdTextReplace;", "Lkotlin/collections/ArrayList;", "historyChanged", "Lcom/jetbrains/rider/util/reactive/Signal;", "getHistoryChanged", "()Lcom/jetbrains/rider/util/reactive/Signal;", "getInitialText", "()Ljava/lang/String;", "setInitialText", "(Ljava/lang/String;)V", "isMaster", "", "()Z", "getOrigin", "()Lcom/jetbrains/rider/framework/OriginKind;", "queuedChanges", "Lcom/jetbrains/rider/util/reactive/ViewableList;", "textChanged", "advise", "", "lifetime", "Lcom/jetbrains/rider/util/lifetime/Lifetime;", "change", "Lkotlin/Function1;", "changeFromWire", "stream", "Ljava/io/InputStream;", "doSendOnWire", "queuedChange", "fire", "queueWireDispatch", "flushQueuedChanges", "init", "queueChange", "newChange", "recover", "text", "toString", "Companion", "rider-framework"})
public final class RdTextBuffer
extends RdReactiveBase {
    private final boolean isMaster = true;
    private final ArrayList<RdTextReplace> changesToConfirmOrRollback;
    private final Signal<RdTextReplace> textChanged;
    @NotNull
    private final Signal<RdTextReplace> historyChanged;
    private final ViewableList<RdTextReplace> queuedChanges;
    @NotNull
    private TextBufferVersion bufferVersion;
    @Nullable
    private String initialText;
    @NotNull
    private final OriginKind origin;
    private static final Log logger;
    private static int versionInitial;
    public static final Companion Companion;

    public final boolean isMaster() {
        return this.isMaster;
    }

    @NotNull
    public final Signal<RdTextReplace> getHistoryChanged() {
        return this.historyChanged;
    }

    @NotNull
    public final TextBufferVersion getBufferVersion() {
        return this.bufferVersion;
    }

    private final void setBufferVersion(TextBufferVersion textBufferVersion) {
        this.bufferVersion = textBufferVersion;
    }

    @Override
    protected void init(@NotNull Lifetime lifetime) {
        Intrinsics.checkParameterIsNotNull((Object)lifetime, (String)"lifetime");
        super.init(lifetime);
        this.queuedChanges.advise(lifetime, (Function3<AddRemove, RdTextReplace, Integer, Unit>)((Function3)new Function3<AddRemove, RdTextReplace, Integer, Unit>(this){
            final /* synthetic */ RdTextBuffer this$0;

            public final void invoke(@NotNull AddRemove addRemove, @NotNull RdTextReplace rdTextReplace, int i2) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)addRemove), (String)"addRemove");
                Intrinsics.checkParameterIsNotNull((Object)rdTextReplace, (String)"rdTextReplace");
                if (Intrinsics.areEqual((Object)((Object)addRemove), (Object)((Object)AddRemove.Add))) {
                    this.this$0.getHistoryChanged().fire(rdTextReplace);
                }
            }
            {
                this.this$0 = rdTextBuffer;
                super(3);
            }
        }));
        this.textChanged.advise(lifetime, (Function1<RdTextReplace, Unit>)((Function1)new Function1<RdTextReplace, Unit>(this){
            final /* synthetic */ RdTextBuffer this$0;

            public final void invoke(@NotNull RdTextReplace rdTextReplace) {
                Intrinsics.checkParameterIsNotNull((Object)rdTextReplace, (String)"rdTextReplace");
                this.this$0.getHistoryChanged().fire(rdTextReplace);
            }
            {
                this.this$0 = rdTextBuffer;
                super(1);
            }
        }));
        this.getProtocol().getWire().advise(lifetime, this.getId(), (Function2<? super SerializationCtx, ? super InputStream, Unit>)((Function2)new Function2<SerializationCtx, InputStream, Unit>(this){
            final /* synthetic */ RdTextBuffer this$0;

            public final void invoke(@NotNull SerializationCtx ctx, @NotNull InputStream stream) {
                Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
                Intrinsics.checkParameterIsNotNull((Object)stream, (String)"stream");
                RdTextBuffer.access$changeFromWire(this.this$0, stream);
            }
            {
                this.this$0 = rdTextBuffer;
                super(2);
            }
        }));
    }

    private final void changeFromWire(InputStream stream) {
        int masterVersionRemote = SerializersKt.readInt(stream);
        int slaveVersionRemote = SerializersKt.readInt(stream);
        int start2 = SerializersKt.readInt(stream);
        String oldValue = SerializersKt.readNullableString(stream);
        String newValue = SerializersKt.readString(stream);
        int fullTextLength = SerializersKt.readInt(stream);
        String fullText = SerializersKt.readNullableString(stream);
        RdTextReplace rdTextReplace = new RdTextReplace(start2, oldValue, newValue, OriginKind.Remote, fullTextLength, fullText);
        if (this.isMaster) {
            if (masterVersionRemote != this.bufferVersion.getMaster()) {
                RdTextBuffer.Companion.getLogger().warn((Object)("Rejecting the change '" + newValue + "'"));
            } else {
                this.bufferVersion = new TextBufferVersion(masterVersionRemote, slaveVersionRemote);
                this.textChanged.fire(rdTextReplace);
            }
        } else if (slaveVersionRemote != this.bufferVersion.getSlave()) {
            for (RdTextReplace change : CollectionsKt.reversed((Iterable)this.changesToConfirmOrRollback)) {
                this.textChanged.fire(RdTextKt.reverse(change));
            }
            this.bufferVersion = new TextBufferVersion(masterVersionRemote, slaveVersionRemote);
            this.textChanged.fire(rdTextReplace);
        } else {
            this.changesToConfirmOrRollback.clear();
            this.bufferVersion = new TextBufferVersion(masterVersionRemote, slaveVersionRemote);
            this.textChanged.fire(rdTextReplace);
        }
    }

    public final void recover(@NotNull String text2) {
        Intrinsics.checkParameterIsNotNull((Object)text2, (String)"text");
        RdTextReplace change = new RdTextReplace(0, null, text2, OriginKind.Local, text2.length(), null, 32, null);
        this.queueChange(change);
        this.flushQueuedChanges();
    }

    public final void fire(@NotNull RdTextReplace change, boolean queueWireDispatch) {
        Intrinsics.checkParameterIsNotNull((Object)change, (String)"change");
        this.assertThreading();
        if (this.isMaster) {
            if (queueWireDispatch) {
                this.queueChange(change);
            } else {
                boolean bl = this.queuedChanges.isEmpty();
                if (!bl) {
                    String string2 = "queuedChanges queue is not empty";
                    throw (Throwable)new IllegalArgumentException(string2.toString());
                }
                this.queueChange(change);
                this.flushQueuedChanges();
            }
        } else {
            this.bufferVersion = this.bufferVersion.incrementSlave();
            this.changesToConfirmOrRollback.add(change);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void flushQueuedChanges() {
        try {
            boolean bl;
            Collection collection = this.queuedChanges;
            StringBuilder stringBuilder = new StringBuilder().append("Sending ");
            Log log = RdTextBuffer.Companion.getLogger();
            int n2 = collection.size();
            log.debug((Object)stringBuilder.append(n2).append(" queued changes").toString());
            boolean bl2 = bl = !this.queuedChanges.isEmpty();
            if (!bl) {
                String string2 = "queuedChanges should not be empty";
                throw (Throwable)new IllegalArgumentException(string2.toString());
            }
            for (RdTextReplace queuedChange : this.queuedChanges) {
                this.doSendOnWire(queuedChange);
            }
        }
        finally {
            this.queuedChanges.clear();
        }
    }

    private final void doSendOnWire(RdTextReplace queuedChange) {
        RdTextReplace change = queuedChange;
        this.textChanged.fire(change);
        this.getProtocol().getWire().send(this.getId(), (Function2<? super SerializationCtx, ? super OutputStream, Unit>)((Function2)new Function2<SerializationCtx, OutputStream, Unit>(this, change){
            final /* synthetic */ RdTextBuffer this$0;
            final /* synthetic */ RdTextReplace $change;

            public final void invoke(@NotNull SerializationCtx ctx, @NotNull OutputStream stream) {
                Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
                Intrinsics.checkParameterIsNotNull((Object)stream, (String)"stream");
                SerializersKt.writeInt(stream, this.this$0.getBufferVersion().getMaster());
                SerializersKt.writeInt(stream, this.this$0.getBufferVersion().getSlave());
                SerializersKt.writeInt(stream, this.$change.getStart());
                SerializersKt.writeNullableString(stream, this.$change.getOldValue());
                SerializersKt.writeString(stream, this.$change.getNewValue());
                SerializersKt.writeInt(stream, this.$change.getFullTextLength());
                SerializersKt.writeNullableString(stream, this.$change.getFullText());
            }
            {
                this.this$0 = rdTextBuffer;
                this.$change = rdTextReplace;
                super(2);
            }
        }));
    }

    private final void queueChange(RdTextReplace newChange) {
        if (this.queuedChanges.isEmpty()) {
            this.bufferVersion = this.bufferVersion.incrementMaster();
            this.queuedChanges.add(newChange);
            return;
        }
        RdTextReplace firstQueuedChange = (RdTextReplace)CollectionsKt.first((List)this.queuedChanges);
        if (this.queuedChanges.size() > 1 || newChange.getStart() != firstQueuedChange.getStart() + firstQueuedChange.getNewValue().length() || newChange.getNewValue().length() != 1 || firstQueuedChange.getNewValue().length() != 1) {
            this.bufferVersion = this.bufferVersion.incrementMaster();
            this.queuedChanges.add(newChange);
        } else {
            StringBuilder sb2 = new StringBuilder(firstQueuedChange.getNewValue());
            int initialOffset = firstQueuedChange.getStart();
            int initialFullLength = firstQueuedChange.getFullTextLength() + newChange.getNewValue().length();
            sb2.append(newChange.getNewValue());
            this.queuedChanges.remove(firstQueuedChange);
            String string2 = firstQueuedChange.getOldValue();
            String string3 = sb2.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"sb.toString()");
            this.queuedChanges.add(new RdTextReplace(initialOffset, string2, string3, OriginKind.Local, initialFullLength, null, 32, null));
        }
    }

    public final void advise(@NotNull Lifetime lifetime, @NotNull Function1<? super RdTextReplace, Unit> change) {
        Intrinsics.checkParameterIsNotNull((Object)lifetime, (String)"lifetime");
        Intrinsics.checkParameterIsNotNull(change, (String)"change");
        this.textChanged.advise(lifetime, change);
    }

    @NotNull
    public String toString() {
        return "Text Buffer Stateless: (" + this.getId() + ")";
    }

    @Nullable
    public final String getInitialText() {
        return this.initialText;
    }

    public final void setInitialText(@Nullable String string2) {
        this.initialText = string2;
    }

    @NotNull
    public final OriginKind getOrigin() {
        return this.origin;
    }

    public RdTextBuffer(@Nullable String initialText, @NotNull OriginKind origin) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)origin), (String)"origin");
        this.initialText = initialText;
        this.origin = origin;
        this.isMaster = true;
        RdTextBuffer rdTextBuffer = this;
        ArrayList arrayList = new ArrayList();
        rdTextBuffer.changesToConfirmOrRollback = arrayList;
        this.textChanged = new Signal();
        this.historyChanged = new Signal();
        this.queuedChanges = new ViewableList();
        this.bufferVersion = new TextBufferVersion(RdTextBuffer.Companion.getVersionInitial(), RdTextBuffer.Companion.getVersionInitial());
    }

    public /* synthetic */ RdTextBuffer(String string2, OriginKind originKind, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            string2 = null;
        }
        if ((n2 & 2) != 0) {
            originKind = OriginKind.Local;
        }
        this(string2, originKind);
    }

    public RdTextBuffer() {
        this(null, null, 3, null);
    }

    static {
        Companion = new Companion(null);
        logger = LogFactory.getLog(RdTextBuffer.class);
        versionInitial = -1;
    }

    public static final /* synthetic */ void access$changeFromWire(RdTextBuffer $this, @NotNull InputStream stream) {
        $this.changeFromWire(stream);
    }

    @NotNull
    public static final /* synthetic */ TextBufferVersion access$getBufferVersion$p(RdTextBuffer $this) {
        return $this.bufferVersion;
    }

    public static final /* synthetic */ void access$setBufferVersion$p(RdTextBuffer $this, @NotNull TextBufferVersion textBufferVersion) {
        $this.bufferVersion = textBufferVersion;
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J \u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0002H\u0016R\u0018\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/rider/framework/impl/RdTextBuffer$Companion;", "Lcom/jetbrains/rider/framework/IMarshaller;", "Lcom/jetbrains/rider/framework/impl/RdTextBuffer;", "()V", "_type", "Ljava/lang/Class;", "get_type", "()Ljava/lang/Class;", "logger", "Lorg/apache/commons/logging/Log;", "kotlin.jvm.PlatformType", "getLogger", "()Lorg/apache/commons/logging/Log;", "versionInitial", "", "getVersionInitial", "()I", "setVersionInitial", "(I)V", "read", "ctx", "Lcom/jetbrains/rider/framework/SerializationCtx;", "stream", "Ljava/io/InputStream;", "write", "", "Ljava/io/OutputStream;", "value", "rider-framework"})
    public static final class Companion
    implements IMarshaller<RdTextBuffer> {
        private final Log getLogger() {
            return logger;
        }

        @Override
        @NotNull
        public Class<?> get_type() {
            throw (Throwable)new IllegalStateException("Mustn't be used for polymorphic marshalling");
        }

        @Override
        @NotNull
        public RdTextBuffer read(@NotNull SerializationCtx ctx, @NotNull InputStream stream) {
            Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
            Intrinsics.checkParameterIsNotNull((Object)stream, (String)"stream");
            RdId id = RdId.Companion.read(stream);
            String text2 = SerializersKt.readString(stream);
            return (RdTextBuffer)IRdReactiveKt.withId((IRdReactive)new RdTextBuffer(text2, OriginKind.Remote), id);
        }

        @Override
        public void write(@NotNull SerializationCtx ctx, @NotNull OutputStream stream, @NotNull RdTextBuffer value2) {
            Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
            Intrinsics.checkParameterIsNotNull((Object)stream, (String)"stream");
            Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
            SerializersKt.writeRdId(stream, value2.getId());
            String string2 = value2.getInitialText();
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            SerializersKt.writeString(stream, string2);
            value2.setInitialText(null);
        }

        private final int getVersionInitial() {
            return versionInitial;
        }

        private final void setVersionInitial(int n2) {
            versionInitial = n2;
        }

        private Companion() {
        }

        @Override
        @NotNull
        public RdId getId() {
            return IMarshaller.DefaultImpls.getId(this);
        }

        public static final /* synthetic */ void access$setVersionInitial$p(Companion $this, int n2) {
            $this.setVersionInitial(n2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

