/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.util;

import com.jetbrains.rider.util.BinSearchUtilKt$WhenMappings;
import com.jetbrains.rider.util.OfEqualItems;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=2, d1={"\u0000&\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003H\u0002\u001aQ\u0010\u0006\u001a\u00020\u0003\"\u0004\b\u0000\u0010\u0007*\b\u0012\u0004\u0012\u0002H\u00070\b2\u0006\u0010\t\u001a\u0002H\u00072\u000e\u0010\n\u001a\n\u0012\u0006\b\u0000\u0012\u0002H\u00070\u000b2\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000e\u00a8\u0006\u000f"}, d2={"rangeCheck", "", "size", "", "fromIndex", "toIndex", "binSearch", "T", "", "element", "comparator", "Ljava/util/Comparator;", "which", "Lcom/jetbrains/rider/util/OfEqualItems;", "(Ljava/util/List;Ljava/lang/Object;Ljava/util/Comparator;IILcom/jetbrains/rider/util/OfEqualItems;)I", "rider-util"})
public final class BinSearchUtilKt {
    public static final <T> int binSearch(@NotNull List<? extends T> $receiver, T element, @NotNull Comparator<? super T> comparator2, int fromIndex, int toIndex, @NotNull OfEqualItems which) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(comparator2, (String)"comparator");
        Intrinsics.checkParameterIsNotNull((Object)((Object)which), (String)"which");
        BinSearchUtilKt.rangeCheck($receiver.size(), fromIndex, toIndex);
        int left = fromIndex;
        int right = fromIndex + toIndex - 1;
        if (left > right) {
            return -1;
        }
        switch (BinSearchUtilKt$WhenMappings.$EnumSwitchMapping$0[which.ordinal()]) {
            case 1: {
                while (left <= right) {
                    int median = left + right >>> 1;
                    int diff = comparator2.compare($receiver.get(median), element);
                    if (diff == 0) {
                        return median;
                    }
                    if (diff < 0) {
                        left = median + 1;
                        continue;
                    }
                    right = median - 1;
                }
                return -(left + 1);
            }
            case 2: {
                while (left < right) {
                    int median = left + right >>> 1;
                    int diff = comparator2.compare($receiver.get(median), element);
                    if (diff < 0) {
                        left = median + 1;
                        continue;
                    }
                    right = median;
                }
                int lastDiff = comparator2.compare($receiver.get(left), element);
                if (lastDiff == 0) {
                    return left;
                }
                if (lastDiff > 0) {
                    return -(left + 1);
                }
                return -(left + 1 + 1);
            }
            case 3: {
                while (left < right) {
                    int median = left + right + 1 >>> 1;
                    int diff = comparator2.compare($receiver.get(median), element);
                    if (diff > 0) {
                        right = median - 1;
                        continue;
                    }
                    left = median;
                }
                int lastDiff = comparator2.compare($receiver.get(left), element);
                if (lastDiff == 0) {
                    return left;
                }
                if (lastDiff > 0) {
                    return -(left + 1);
                }
                return -(left + 1 + 1);
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    public static /* bridge */ /* synthetic */ int binSearch$default(List list2, Object object, Comparator comparator2, int n2, int n3, OfEqualItems ofEqualItems, int n4, Object object2) {
        if ((n4 & 4) != 0) {
            n2 = 0;
        }
        if ((n4 & 8) != 0) {
            n3 = list2.size();
        }
        if ((n4 & 0x10) != 0) {
            ofEqualItems = OfEqualItems.TakeAny;
        }
        return BinSearchUtilKt.binSearch(list2, object, comparator2, n2, n3, ofEqualItems);
    }

    private static final void rangeCheck(int size, int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw (Throwable)new IllegalArgumentException("fromIndex (" + fromIndex + ") is greater than toIndex (" + toIndex + ").");
        }
        if (fromIndex < 0) {
            throw (Throwable)new IndexOutOfBoundsException("fromIndex (" + fromIndex + ") is less than zero.");
        }
        if (toIndex > size) {
            throw (Throwable)new IndexOutOfBoundsException("toIndex (" + toIndex + ") is greater than size (" + size + ").");
        }
    }
}

