/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.util.reactive;

import com.jetbrains.rider.util.lifetime.Lifetime;
import com.jetbrains.rider.util.reactive.AddRemove;
import com.jetbrains.rider.util.reactive.IMutableViewableList;
import com.jetbrains.rider.util.reactive.IViewableList;
import com.jetbrains.rider.util.reactive.Signal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010)\n\u0002\b\u0002\n\u0002\u0010+\n\u0002\b\n\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0015\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0011J\u001d\u0010\u000e\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0014J\u001e\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\t2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u0017H\u0016J\u0016\u0010\u0015\u001a\u00020\u000f2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u0017H\u0016J*\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001a2\u0018\u0010\u001b\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\u0004\u0012\u00020\u00120\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u0012H\u0016J\u0016\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u0011J\u0016\u0010\u001f\u001a\u00020\u000f2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u0017H\u0016J\u0016\u0010 \u001a\u00028\u00002\u0006\u0010\u0013\u001a\u00020\tH\u0096\u0002\u00a2\u0006\u0002\u0010!J\u0015\u0010\"\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010#J\b\u0010$\u001a\u00020\u000fH\u0016J\u000f\u0010%\u001a\b\u0012\u0004\u0012\u00028\u00000&H\u0096\u0002J\u0015\u0010'\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010#J\u000e\u0010(\u001a\b\u0012\u0004\u0012\u00028\u00000)H\u0016J\u0016\u0010(\u001a\b\u0012\u0004\u0012\u00028\u00000)2\u0006\u0010\u0013\u001a\u00020\tH\u0016J\u0015\u0010*\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0011J\u0016\u0010+\u001a\u00020\u000f2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u0017H\u0016J\u0015\u0010,\u001a\u00028\u00002\u0006\u0010\u0013\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010!J\u0016\u0010-\u001a\u00020\u000f2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u0017H\u0016J\u001e\u0010.\u001a\u00028\u00002\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010/J\u001e\u00100\u001a\b\u0012\u0004\u0012\u00028\u00000\r2\u0006\u00101\u001a\u00020\t2\u0006\u00102\u001a\u00020\tH\u0016R\u001a\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/jetbrains/rider/util/reactive/ViewableList;", "T", "", "Lcom/jetbrains/rider/util/reactive/IMutableViewableList;", "()V", "change", "Lcom/jetbrains/rider/util/reactive/Signal;", "Lcom/jetbrains/rider/util/reactive/IViewableList$Event;", "size", "", "getSize", "()I", "storage", "", "add", "", "element", "(Ljava/lang/Object;)Z", "", "index", "(ILjava/lang/Object;)V", "addAll", "elements", "", "advise", "lifetime", "Lcom/jetbrains/rider/util/lifetime/Lifetime;", "handler", "Lkotlin/Function1;", "clear", "contains", "containsAll", "get", "(I)Ljava/lang/Object;", "indexOf", "(Ljava/lang/Object;)I", "isEmpty", "iterator", "", "lastIndexOf", "listIterator", "", "remove", "removeAll", "removeAt", "retainAll", "set", "(ILjava/lang/Object;)Ljava/lang/Object;", "subList", "fromIndex", "toIndex", "rider-util"})
public final class ViewableList<T>
implements IMutableViewableList<T> {
    private final List<T> storage;
    private final Signal<IViewableList.Event<T>> change;

    @Override
    public void advise(@NotNull Lifetime lifetime, @NotNull Function1<? super IViewableList.Event<T>, Unit> handler2) {
        Intrinsics.checkParameterIsNotNull((Object)lifetime, (String)"lifetime");
        Intrinsics.checkParameterIsNotNull(handler2, (String)"handler");
        this.change.advise(lifetime, handler2);
        Iterable $receiver$iv = CollectionsKt.withIndex((Iterable)this);
        for (Object element$iv : $receiver$iv) {
            IndexedValue it = (IndexedValue)element$iv;
            try {
                handler2.invoke(new IViewableList.Event<Object>(AddRemove.Add, it.getValue(), it.getIndex()));
            }
            catch (Throwable e$iv) {
                LogFactory.getLog((String)"catch").error((Object)"Isolated exception", e$iv);
            }
        }
    }

    @Override
    public boolean add(@NotNull T element) {
        Intrinsics.checkParameterIsNotNull(element, (String)"element");
        boolean ret = this.storage.add(element);
        if (ret) {
            this.change.fire(new IViewableList.Event<T>(AddRemove.Add, element, this.size() - 1));
        }
        return ret;
    }

    @Override
    public void add(int index, @NotNull T element) {
        Intrinsics.checkParameterIsNotNull(element, (String)"element");
        this.storage.add(index, element);
        this.change.fire(new IViewableList.Event<T>(AddRemove.Add, element, index));
    }

    @NotNull
    public T removeAt(int index) {
        T res2 = this.storage.remove(index);
        this.change.fire(new IViewableList.Event<T>(AddRemove.Remove, res2, index));
        return res2;
    }

    @Override
    public boolean remove(@NotNull Object element) {
        if (element == null) {
            return false;
        }
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        int index = this.storage.indexOf(element);
        if (index == -1) {
            return false;
        }
        this.remove(index);
        return true;
    }

    @Override
    @NotNull
    public T set(int index, @NotNull T element) {
        Intrinsics.checkParameterIsNotNull(element, (String)"element");
        T old = this.storage.set(index, element);
        this.change.fire(new IViewableList.Event<T>(AddRemove.Remove, old, index));
        this.change.fire(new IViewableList.Event<T>(AddRemove.Add, element, index));
        return old;
    }

    @Override
    public boolean addAll(int index, @NotNull Collection<? extends T> elements) {
        Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
        ArrayList<IViewableList.Event<T>> changes = new ArrayList<IViewableList.Event<T>>();
        int idx = index;
        for (T element : elements) {
            if (this.storage.contains(element)) continue;
            this.storage.add(idx, element);
            changes.add(new IViewableList.Event<T>(AddRemove.Add, element, idx));
            ++idx;
        }
        Iterable $receiver$iv = changes;
        for (Object element$iv : $receiver$iv) {
            IViewableList.Event it = (IViewableList.Event)element$iv;
            this.change.fire(it);
        }
        Collection collection = changes;
        return !collection.isEmpty();
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends T> elements) {
        Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
        ArrayList<IViewableList.Event<T>> changes = new ArrayList<IViewableList.Event<T>>();
        for (T element : elements) {
            if (!this.storage.add(element)) continue;
            changes.add(new IViewableList.Event<T>(AddRemove.Add, element, this.size() - 1));
        }
        Iterable $receiver$iv = changes;
        for (Object element$iv : $receiver$iv) {
            IViewableList.Event it = (IViewableList.Event)element$iv;
            this.change.fire(it);
        }
        Collection collection = changes;
        return !collection.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void clear() {
        int n2;
        ArrayList<IViewableList.Event<T>> changes = new ArrayList<IViewableList.Event<T>>();
        int n3 = this.storage.size() - 1;
        if (n3 >= (n2 = 0)) {
            while (true) {
                void i2;
                changes.add(new IViewableList.Event<T>(AddRemove.Remove, this.storage.get((int)i2), (int)i2));
                if (i2 == n2) break;
                --i2;
            }
        }
        this.storage.clear();
        Iterable $receiver$iv = changes;
        for (Object element$iv : $receiver$iv) {
            IViewableList.Event it = (IViewableList.Event)element$iv;
            this.change.fire(it);
        }
    }

    @Override
    public boolean removeAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
        boolean res2 = false;
        ArrayList<IViewableList.Event<Object>> changes = new ArrayList<IViewableList.Event<Object>>();
        for (Object object : elements) {
            int index = this.storage.indexOf(object);
            if (index == -1) continue;
            this.storage.remove(index);
            changes.add(new IViewableList.Event<Object>(AddRemove.Remove, object, index));
            res2 = true;
        }
        Iterable iterable = changes;
        for (Object element$iv : iterable) {
            IViewableList.Event it = (IViewableList.Event)element$iv;
            this.change.fire(it);
        }
        return res2;
    }

    @Override
    public boolean retainAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
        boolean res2 = false;
        Iterator<T> iterator2 = this.storage.iterator();
        ArrayList<IViewableList.Event<T>> changes = new ArrayList<IViewableList.Event<T>>();
        int index = 0;
        while (iterator2.hasNext()) {
            T value2 = iterator2.next();
            if (!elements.contains(value2)) {
                changes.add(new IViewableList.Event<T>(AddRemove.Remove, value2, index));
                iterator2.remove();
                res2 = true;
                continue;
            }
            ++index;
        }
        Iterable $receiver$iv = changes;
        for (Object element$iv : $receiver$iv) {
            IViewableList.Event it = (IViewableList.Event)element$iv;
            this.change.fire(it);
        }
        return res2;
    }

    public int getSize() {
        return this.storage.size();
    }

    @Override
    public boolean contains(@NotNull Object element) {
        if (element == null) {
            return false;
        }
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        return this.storage.contains(element);
    }

    @Override
    public boolean containsAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
        return this.storage.containsAll(elements);
    }

    @Override
    @NotNull
    public T get(int index) {
        return this.storage.get(index);
    }

    @Override
    public int indexOf(@NotNull Object element) {
        if (element == null) {
            return -1;
        }
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        return this.storage.indexOf(element);
    }

    @Override
    public boolean isEmpty() {
        return this.storage.isEmpty();
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return this.storage.iterator();
    }

    @Override
    public int lastIndexOf(@NotNull Object element) {
        if (element == null) {
            return -1;
        }
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        return this.storage.lastIndexOf(element);
    }

    @Override
    @NotNull
    public ListIterator<T> listIterator() {
        return this.storage.listIterator();
    }

    @Override
    @NotNull
    public ListIterator<T> listIterator(int index) {
        return this.storage.listIterator(index);
    }

    @Override
    @NotNull
    public List<T> subList(int fromIndex, int toIndex) {
        throw (Throwable)new UnsupportedOperationException();
    }

    public ViewableList() {
        ViewableList viewableList = this;
        ArrayList arrayList = new ArrayList();
        viewableList.storage = arrayList;
        this.change = new Signal();
    }

    @Override
    public void advise(@NotNull Lifetime lifetime, @NotNull Function3<? super AddRemove, ? super T, ? super Integer, Unit> handler2) {
        Intrinsics.checkParameterIsNotNull((Object)lifetime, (String)"lifetime");
        Intrinsics.checkParameterIsNotNull(handler2, (String)"handler");
        IMutableViewableList.DefaultImpls.advise(this, lifetime, handler2);
    }

    @Override
    public void view(@NotNull Lifetime lifetime, @NotNull Function2<? super Lifetime, ? super T, Unit> handler2) {
        Intrinsics.checkParameterIsNotNull((Object)lifetime, (String)"lifetime");
        Intrinsics.checkParameterIsNotNull(handler2, (String)"handler");
        IMutableViewableList.DefaultImpls.view(this, lifetime, handler2);
    }

    @Override
    public Object[] toArray() {
        return CollectionToArray.toArray((Collection)this);
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        return CollectionToArray.toArray((Collection)this, (Object[])TArray);
    }
}

