/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.util.threading;

import com.jetbrains.rider.util.threading.ByteArraySlice;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0012\n\u0002\b\u000b\u0018\u0000 =2\u00020\u0001:\u0003<=>B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0002\u0010\nJ\b\u00100\u001a\u00020\tH\u0002J\b\u00101\u001a\u00020\tH\u0002J\u000e\u00102\u001a\u00020\t2\u0006\u00103\u001a\u000204J\u0006\u00105\u001a\u00020\tJ\u0010\u00106\u001a\u00020\f2\b\b\u0002\u00107\u001a\u00020\u001cJ\u0010\u00108\u001a\u00020\f2\b\b\u0002\u00107\u001a\u00020\u001cJ \u00109\u001a\u00020\f2\u0006\u00107\u001a\u00020\u001c2\u0006\u0010:\u001a\u00020*2\u0006\u0010;\u001a\u00020\u0003H\u0002R&\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f8\u0006@BX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001f\u001a\n !*\u0004\u0018\u00010 0 X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u001a\u0010&\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\u0015\"\u0004\b(\u0010)R$\u0010+\u001a\u00020*2\u0006\u0010\u000b\u001a\u00020*@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/\u00a8\u0006?"}, d2={"Lcom/jetbrains/rider/util/threading/ByteBufferAsyncProcessor;", "", "id", "", "chunkSize", "", "processor", "Lkotlin/Function1;", "Lcom/jetbrains/rider/util/threading/ByteArraySlice;", "", "(Ljava/lang/String;ILkotlin/jvm/functions/Function1;)V", "<set-?>", "", "allDataProcessed", "getAllDataProcessed", "()Z", "setAllDataProcessed", "(Z)V", "asyncProcessingThread", "Ljava/lang/Thread;", "getChunkSize", "()I", "firstChunkToProcess", "Lcom/jetbrains/rider/util/threading/ByteBufferAsyncProcessor$Chunk;", "freeChunk", "getId", "()Ljava/lang/String;", "lastShrinkOrGrowTimeMs", "", "lock", "Ljava/lang/Object;", "log", "Lorg/apache/commons/logging/Log;", "kotlin.jvm.PlatformType", "getLog", "()Lorg/apache/commons/logging/Log;", "getProcessor", "()Lkotlin/jvm/functions/Function1;", "shrinkIntervalMs", "getShrinkIntervalMs", "setShrinkIntervalMs", "(I)V", "Lcom/jetbrains/rider/util/threading/ByteBufferAsyncProcessor$StateKind;", "state", "getState", "()Lcom/jetbrains/rider/util/threading/ByteBufferAsyncProcessor$StateKind;", "setState", "(Lcom/jetbrains/rider/util/threading/ByteBufferAsyncProcessor$StateKind;)V", "ThreadProc", "cleanup0", "put", "newData", "", "start", "stop", "timeoutMs", "terminate", "terminate0", "stateToSet", "action", "Chunk", "Companion", "StateKind", "rider-util"})
public final class ByteBufferAsyncProcessor {
    private final Log log;
    private final Object lock;
    private long lastShrinkOrGrowTimeMs;
    private Thread asyncProcessingThread;
    private Chunk freeChunk;
    private Chunk firstChunkToProcess;
    private int shrinkIntervalMs;
    private volatile boolean allDataProcessed;
    @NotNull
    private StateKind state;
    @NotNull
    private final String id;
    private final int chunkSize;
    @NotNull
    private final Function1<ByteArraySlice, Unit> processor;
    private static final int DefaultChunkSize = 16380;
    private static final int DefaultShrinkIntervalMs = 30000;
    public static final Companion Companion = new Companion(null);

    protected final Log getLog() {
        return this.log;
    }

    public final int getShrinkIntervalMs() {
        return this.shrinkIntervalMs;
    }

    public final void setShrinkIntervalMs(int n2) {
        this.shrinkIntervalMs = n2;
    }

    public final boolean getAllDataProcessed() {
        return this.allDataProcessed;
    }

    private final void setAllDataProcessed(boolean bl) {
        this.allDataProcessed = bl;
    }

    @NotNull
    public final StateKind getState() {
        return this.state;
    }

    private final void setState(StateKind stateKind) {
        this.state = stateKind;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void cleanup0() {
        Object object = this.lock;
        synchronized (object) {
            this.state = StateKind.Terminated;
            this.freeChunk = Chunk.Companion.getEmpty();
            this.firstChunkToProcess = null;
            this.allDataProcessed = true;
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean terminate0(long timeoutMs, StateKind stateToSet, String action2) {
        boolean res2;
        Object object = this.lock;
        synchronized (object) {
            block12: {
                block11: {
                    if (!Intrinsics.areEqual((Object)((Object)this.state), (Object)((Object)StateKind.Initialized))) break block11;
                    this.log.debug((Object)("Can't " + action2 + " '" + this.id + "', because it hasn't been started yet"));
                    this.cleanup0();
                    boolean bl = true;
                    return bl;
                }
                if (this.state.compareTo((Enum)stateToSet) < 0) break block12;
                this.log.debug((Object)("Trying to " + action2 + " async processor '" + this.id + "' but it's in state '" + (Object)((Object)this.state) + "'"));
                boolean bl = true;
                return bl;
            }
            this.state = stateToSet;
            this.lock.notifyAll();
            Unit unit = Unit.INSTANCE;
        }
        Thread thread2 = this.asyncProcessingThread;
        if (thread2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"asyncProcessingThread");
        }
        thread2.join(timeoutMs);
        Thread thread3 = this.asyncProcessingThread;
        if (thread3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"asyncProcessingThread");
        }
        if (!(res2 = thread3.isAlive())) {
            try {
                Thread thread4 = this.asyncProcessingThread;
                if (thread4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"asyncProcessingThread");
                }
                thread4.stop();
            }
            catch (Throwable e$iv) {
                LogFactory.getLog((String)"catch").error((Object)"Isolated exception", e$iv);
            }
        }
        this.cleanup0();
        return res2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void ThreadProc() {
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        Chunk chunk = this.firstChunkToProcess;
        if (chunk == null) {
            Intrinsics.throwNpe();
        }
        objectRef.element = chunk;
        this.firstChunkToProcess = null;
        while (true) {
            void chunk2;
            Object object = this.lock;
            synchronized (object) {
                long now;
                if (this.state.compareTo((Enum)StateKind.Terminated) >= 0) {
                    return;
                }
                while (((Chunk)chunk2.element).getPtr() == 0) {
                    this.allDataProcessed = true;
                    if (this.state.compareTo((Enum)StateKind.Stopping) >= 0) {
                        return;
                    }
                    this.lock.wait();
                    if (this.state.compareTo((Enum)StateKind.Terminating) < 0) continue;
                    return;
                }
                if (Intrinsics.areEqual((Object)this.freeChunk, (Object)((Chunk)chunk2.element))) {
                    this.freeChunk = ((Chunk)chunk2.element).getNext();
                }
                if ((now = System.currentTimeMillis()) - this.lastShrinkOrGrowTimeMs > (long)this.shrinkIntervalMs) {
                    this.lastShrinkOrGrowTimeMs = now;
                    while (Intrinsics.areEqual((Object)this.freeChunk.getNext(), (Object)((Chunk)chunk2.element)) ^ true && this.freeChunk.getPtr() == 0) {
                        this.log.debug((Object)("Shrink: " + this.chunkSize + " bytes"));
                        if (this.freeChunk.getNext().getPtr() != 0) {
                            this.log.debug((Object)"freeChunk.next.ptr != 0");
                        }
                        this.freeChunk.setNext(this.freeChunk.getNext().getNext());
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
            try {
                this.processor.invoke((Object)new ByteArraySlice(((Chunk)chunk2.element).getData(), 0, ((Chunk)chunk2.element).getPtr()));
                continue;
            }
            catch (Exception e2) {
                this.log.error((Object)"Exception while processing byte queue", (Throwable)e2);
                continue;
            }
            finally {
                object = this.lock;
                synchronized (object) {
                    ((Chunk)chunk2.element).setPtr(0);
                    chunk2.element = ((Chunk)chunk2.element).getNext();
                    Unit unit = Unit.INSTANCE;
                }
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() {
        Object object = this.lock;
        synchronized (object) {
            Thread thread2;
            if (Intrinsics.areEqual((Object)((Object)this.state), (Object)((Object)StateKind.Initialized)) ^ true) {
                this.log.debug((Object)("Trying to START async processor '" + this.id + "' but it's in state '" + (Object)((Object)this.state) + "'"));
                return;
            }
            this.state = StateKind.AsyncProcessing;
            Thread thread3 = new Thread(new Runnable(this){
                final /* synthetic */ ByteBufferAsyncProcessor this$0;
                {
                    this.this$0 = byteBufferAsyncProcessor;
                }

                public final void run() {
                    ByteBufferAsyncProcessor.access$ThreadProc(this.this$0);
                }
            }, this.id);
            ByteBufferAsyncProcessor byteBufferAsyncProcessor = this;
            Thread $receiver = thread3;
            $receiver.setDaemon(true);
            byteBufferAsyncProcessor.asyncProcessingThread = thread2 = thread3;
            Thread thread4 = this.asyncProcessingThread;
            if (thread4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"asyncProcessingThread");
            }
            thread4.start();
            byteBufferAsyncProcessor = Unit.INSTANCE;
        }
    }

    public final boolean stop(long timeoutMs) {
        return this.terminate0(timeoutMs, StateKind.Stopping, "STOP");
    }

    public static /* bridge */ /* synthetic */ boolean stop$default(ByteBufferAsyncProcessor byteBufferAsyncProcessor, long l2, int n2, Object object) {
        if ((n2 & 1) != 0) {
            l2 = 0L;
        }
        return byteBufferAsyncProcessor.stop(l2);
    }

    public final boolean terminate(long timeoutMs) {
        return this.terminate0(timeoutMs, StateKind.Terminating, "TERMINATE");
    }

    public static /* bridge */ /* synthetic */ boolean terminate$default(ByteBufferAsyncProcessor byteBufferAsyncProcessor, long l2, int n2, Object object) {
        if ((n2 & 1) != 0) {
            l2 = 0L;
        }
        return byteBufferAsyncProcessor.terminate(l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void put(@NotNull byte[] newData) {
        Intrinsics.checkParameterIsNotNull((Object)newData, (String)"newData");
        Object object = this.lock;
        synchronized (object) {
            if (this.state.compareTo((Enum)StateKind.Stopping) >= 0) {
                return;
            }
            int ptr = 0;
            int count = newData.length;
            while (ptr < count) {
                int rest = count - ptr;
                int available = this.chunkSize - this.freeChunk.getPtr();
                if (available > 0) {
                    int copylen = Math.min(rest, available);
                    System.arraycopy(newData, ptr, this.freeChunk.getData(), this.freeChunk.getPtr(), copylen);
                    Chunk chunk = this.freeChunk;
                    chunk.setPtr(chunk.getPtr() + copylen);
                    ptr += copylen;
                    continue;
                }
                if (this.freeChunk.getNext().getPtr() != 0) {
                    this.log.debug((Object)("Grow: " + this.chunkSize + " bytes"));
                    Chunk chunk = new Chunk(this.chunkSize);
                    Chunk chunk2 = this.freeChunk;
                    Chunk $receiver = chunk;
                    $receiver.setNext(this.freeChunk.getNext());
                    Chunk chunk3 = chunk;
                    chunk2.setNext(chunk3);
                    this.lastShrinkOrGrowTimeMs = System.currentTimeMillis();
                }
                this.freeChunk = this.freeChunk.getNext();
            }
            if (this.allDataProcessed) {
                this.allDataProcessed = false;
                this.lock.notify();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    public final int getChunkSize() {
        return this.chunkSize;
    }

    @NotNull
    public final Function1<ByteArraySlice, Unit> getProcessor() {
        return this.processor;
    }

    public ByteBufferAsyncProcessor(@NotNull String id, int chunkSize, @NotNull Function1<? super ByteArraySlice, Unit> processor2) {
        Chunk chunk;
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        Intrinsics.checkParameterIsNotNull(processor2, (String)"processor");
        this.id = id;
        this.chunkSize = chunkSize;
        this.processor = processor2;
        this.log = LogFactory.getLog(ByteBufferAsyncProcessor.class);
        this.lock = new Object();
        this.lastShrinkOrGrowTimeMs = System.currentTimeMillis();
        this.shrinkIntervalMs = 30000;
        this.state = StateKind.Initialized;
        this.freeChunk = chunk = Chunk.Companion.createCycledPair(this.chunkSize);
        this.firstChunkToProcess = chunk;
    }

    public /* synthetic */ ByteBufferAsyncProcessor(String string2, int n2, Function1 function1, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            n2 = 16380;
        }
        this(string2, n2, (Function1<? super ByteArraySlice, Unit>)function1);
    }

    public static final /* synthetic */ void access$ThreadProc(ByteBufferAsyncProcessor $this) {
        $this.ThreadProc();
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rider/util/threading/ByteBufferAsyncProcessor$StateKind;", "", "(Ljava/lang/String;I)V", "Initialized", "AsyncProcessing", "Stopping", "Terminating", "Terminated", "rider-util"})
    public static final class StateKind
    extends Enum<StateKind> {
        public static final /* enum */ StateKind Initialized;
        public static final /* enum */ StateKind AsyncProcessing;
        public static final /* enum */ StateKind Stopping;
        public static final /* enum */ StateKind Terminating;
        public static final /* enum */ StateKind Terminated;
        private static final /* synthetic */ StateKind[] $VALUES;

        static {
            StateKind[] stateKindArray = new StateKind[5];
            StateKind[] stateKindArray2 = stateKindArray;
            stateKindArray[0] = Initialized = new StateKind();
            stateKindArray[1] = AsyncProcessing = new StateKind();
            stateKindArray[2] = Stopping = new StateKind();
            stateKindArray[3] = Terminating = new StateKind();
            stateKindArray[4] = Terminated = new StateKind();
            $VALUES = stateKindArray;
        }

        public static StateKind[] values() {
            return (StateKind[])$VALUES.clone();
        }

        public static StateKind valueOf(String string2) {
            return Enum.valueOf(StateKind.class, string2);
        }
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\r\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0000X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0004\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/rider/util/threading/ByteBufferAsyncProcessor$Chunk;", "", "chunkSize", "", "(I)V", "data", "", "getData", "()[B", "next", "getNext", "()Lcom/jetbrains/rider/util/threading/ByteBufferAsyncProcessor$Chunk;", "setNext", "(Lcom/jetbrains/rider/util/threading/ByteBufferAsyncProcessor$Chunk;)V", "ptr", "getPtr", "()I", "setPtr", "Companion", "rider-util"})
    private static final class Chunk {
        @NotNull
        public Chunk next;
        private int ptr;
        @NotNull
        private final byte[] data;
        @NotNull
        private static final Chunk empty;
        public static final Companion Companion;

        @NotNull
        public final Chunk getNext() {
            Chunk chunk = this.next;
            if (chunk == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"next");
            }
            return chunk;
        }

        public final void setNext(@NotNull Chunk chunk) {
            Intrinsics.checkParameterIsNotNull((Object)chunk, (String)"<set-?>");
            this.next = chunk;
        }

        public final int getPtr() {
            return this.ptr;
        }

        public final void setPtr(int n2) {
            this.ptr = n2;
        }

        @NotNull
        public final byte[] getData() {
            return this.data;
        }

        public Chunk(int chunkSize) {
            this.data = new byte[chunkSize];
        }

        static {
            Companion = new Companion(null);
            empty = new Chunk(0);
        }

        @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rider/util/threading/ByteBufferAsyncProcessor$Chunk$Companion;", "", "()V", "empty", "Lcom/jetbrains/rider/util/threading/ByteBufferAsyncProcessor$Chunk;", "getEmpty", "()Lcom/jetbrains/rider/util/threading/ByteBufferAsyncProcessor$Chunk;", "createCycledPair", "chunkSize", "", "rider-util"})
        public static final class Companion {
            @NotNull
            public final Chunk createCycledPair(int chunkSize) {
                Chunk chunk;
                Chunk chunk1 = new Chunk(chunkSize);
                Chunk $receiver = chunk = new Chunk(chunkSize);
                $receiver.setNext(chunk1);
                Chunk chunk2 = chunk;
                chunk1.setNext(chunk2);
                return chunk1;
            }

            @NotNull
            public final Chunk getEmpty() {
                return empty;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rider/util/threading/ByteBufferAsyncProcessor$Companion;", "", "()V", "DefaultChunkSize", "", "DefaultShrinkIntervalMs", "rider-util"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

