/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.util.threading;

import com.jetbrains.rider.util.lifetime.Lifetime;
import com.jetbrains.rider.util.lifetime.LifetimeExKt;
import com.jetbrains.rider.util.threading.SingleThreadSchedulerBase;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rider/util/threading/SingleThreadScheduler;", "Lcom/jetbrains/rider/util/threading/SingleThreadSchedulerBase;", "lifetime", "Lcom/jetbrains/rider/util/lifetime/Lifetime;", "name", "", "(Lcom/jetbrains/rider/util/lifetime/Lifetime;Ljava/lang/String;)V", "getLifetime", "()Lcom/jetbrains/rider/util/lifetime/Lifetime;", "log", "Lorg/apache/commons/logging/Log;", "kotlin.jvm.PlatformType", "onException", "", "ex", "", "rider-util"})
public final class SingleThreadScheduler
extends SingleThreadSchedulerBase {
    private final Log log;
    @NotNull
    private final Lifetime lifetime;

    @Override
    public void onException(@NotNull Throwable ex) {
        Intrinsics.checkParameterIsNotNull((Object)ex, (String)"ex");
        this.log.error((Object)ex);
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    public SingleThreadScheduler(@NotNull Lifetime lifetime, final @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)lifetime, (String)"lifetime");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        super(name);
        this.lifetime = lifetime;
        this.log = LogFactory.getLog(SingleThreadScheduler.class);
        LifetimeExKt.plusAssign(this.lifetime, (Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                try {
                    this.getExecutor().shutdownNow();
                    if (!this.getExecutor().awaitTermination(5L, TimeUnit.SECONDS)) {
                        log.error((Object)("Failed to terminate " + name + "."));
                    }
                }
                catch (Throwable e2) {
                    log.error((Object)e2);
                }
            }
        }));
    }
}

