/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.util.threading;

import com.jetbrains.rider.util.reactive.IScheduler;
import com.jetbrains.rider.util.threading.SynchronousScheduler;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\rH\u0016R2\u0010\u0003\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\t\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rider/util/threading/SynchronousScheduler;", "Lcom/jetbrains/rider/util/reactive/IScheduler;", "()V", "active", "Ljava/lang/ThreadLocal;", "", "kotlin.jvm.PlatformType", "isActive", "", "()Z", "queue", "", "action", "Lkotlin/Function0;", "rider-util"})
public final class SynchronousScheduler
implements IScheduler {
    private static final ThreadLocal<Integer> active;
    public static final SynchronousScheduler INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void queue(@NotNull Function0<Unit> action2) {
        Intrinsics.checkParameterIsNotNull(action2, (String)"action");
        active.set(((Number)active.get()).intValue() + 1);
        try {
            action2.invoke();
        }
        finally {
            active.set(((Number)active.get()).intValue() - 1);
        }
    }

    @Override
    public boolean isActive() {
        return Intrinsics.compare((int)((Number)active.get()).intValue(), (int)0) > 0;
    }

    private SynchronousScheduler() {
        INSTANCE = this;
        active = ThreadLocal.withInitial(active.1.INSTANCE);
    }

    static {
        new SynchronousScheduler();
    }

    @Override
    public void assertThread() {
        IScheduler.DefaultImpls.assertThread(this);
    }

    @Override
    public boolean getOutOfOrderExecution() {
        return IScheduler.DefaultImpls.getOutOfOrderExecution(this);
    }

    @Override
    public void invokeOrQueue(@NotNull Function0<Unit> action2) {
        Intrinsics.checkParameterIsNotNull(action2, (String)"action");
        IScheduler.DefaultImpls.invokeOrQueue(this, action2);
    }
}

