/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cglib.proxy;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import net.sf.cglib.core.CodeGenerationException;
import net.sf.cglib.proxy.AdvancedEnhancer;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.CallbackFilter;
import net.sf.cglib.proxy.Factory;
import net.sf.cglib.proxy.InvocationHandler;
import net.sf.cglib.proxy.NoOp;

public class AdvancedProxy {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.xml.impl.AdvancedProxy");
    public static Method FINALIZE_METHOD;
    public static Method EQUALS_METHOD;
    public static Method HASHCODE_METHOD;
    public static Method TOSTRING_METHOD;
    private static final Map<ProxyDescription, Factory> ourFactories;
    private static final CallbackFilter NO_OBJECT_METHODS_FILTER;
    private static final CallbackFilter WITH_OBJECT_METHODS_FILTER;

    public static InvocationHandler getInvocationHandler(Object proxy) {
        return (InvocationHandler)((Factory)proxy).getCallback(0);
    }

    public static <T> T createProxy(InvocationHandler handler2, Class<T> superClass, Class ... otherInterfaces) {
        return AdvancedProxy.createProxy(superClass, otherInterfaces, handler2, ArrayUtil.EMPTY_OBJECT_ARRAY);
    }

    public static <T> T createProxy(Class<T> superClass, Class ... otherInterfaces) {
        return AdvancedProxy.createProxy(superClass, otherInterfaces, new InvocationHandler(){

            public Object invoke(Object proxy, Method method2, Object[] args) throws Throwable {
                throw new AbstractMethodError(method2.toString());
            }
        }, false, ArrayUtil.EMPTY_OBJECT_ARRAY);
    }

    public static <T> T createProxy(Class<T> superClass, Class[] interfaces, InvocationHandler handler2, Object ... constructorArgs) {
        return AdvancedProxy.createProxy(superClass, interfaces, handler2, true, constructorArgs);
    }

    public static <T> T createProxy(Class<T> superClass, Class[] interfaces, InvocationHandler handler2, boolean interceptObjectMethods, Object ... constructorArgs) {
        try {
            Callback[] callbacks = new Callback[]{handler2, NoOp.INSTANCE};
            ProxyDescription key = new ProxyDescription(superClass, interfaces);
            Factory factory2 = ourFactories.get(key);
            if (factory2 != null) {
                return (T)factory2.newInstance(AdvancedProxy.getConstructorParameterTypes(factory2.getClass(), constructorArgs), constructorArgs, callbacks);
            }
            AdvancedEnhancer e2 = new AdvancedEnhancer();
            e2.setInterfaces(interfaces);
            e2.setCallbacks(callbacks);
            e2.setCallbackFilter(interceptObjectMethods ? WITH_OBJECT_METHODS_FILTER : NO_OBJECT_METHODS_FILTER);
            if (superClass != null) {
                e2.setSuperclass(superClass);
                factory2 = (Factory)e2.create(AdvancedProxy.getConstructorParameterTypes(superClass, constructorArgs), constructorArgs);
            } else {
                assert (constructorArgs.length == 0);
                factory2 = (Factory)e2.create();
            }
            ourFactories.put(key, factory2);
            return (T)factory2;
        }
        catch (CodeGenerationException e3) {
            Throwable throwable = e3.getCause();
            if (throwable instanceof InvocationTargetException) {
                InvocationTargetException targetException = (InvocationTargetException)throwable;
                Throwable cause = targetException.getCause();
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                if (cause instanceof Error) {
                    throw (Error)cause;
                }
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw e3;
        }
        catch (ProcessCanceledException e4) {
            throw e4;
        }
        catch (Exception e5) {
            throw new RuntimeException(e5);
        }
    }

    private static Class[] getConstructorParameterTypes(Class aClass, Object ... constructorArgs) {
        if (constructorArgs.length == 0) {
            return ArrayUtil.EMPTY_CLASS_ARRAY;
        }
        block0: for (Constructor<?> constructor : aClass.getDeclaredConstructors()) {
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            if (parameterTypes.length != constructorArgs.length) continue;
            for (int i2 = 0; i2 < parameterTypes.length; ++i2) {
                Class<?> parameterType = parameterTypes[i2];
                Object constructorArg = constructorArgs[i2];
                if (!parameterType.isInstance(constructorArg) && constructorArg != null) continue block0;
            }
            return constructor.getParameterTypes();
        }
        throw new AssertionError((Object)("Cannot find constructor for arguments: " + Arrays.asList(constructorArgs)));
    }

    static {
        try {
            FINALIZE_METHOD = Object.class.getDeclaredMethod("finalize", new Class[0]);
            EQUALS_METHOD = Object.class.getDeclaredMethod("equals", Object.class);
            HASHCODE_METHOD = Object.class.getDeclaredMethod("hashCode", new Class[0]);
            TOSTRING_METHOD = Object.class.getDeclaredMethod("toString", new Class[0]);
        }
        catch (NoSuchMethodException e2) {
            LOG.error((Throwable)e2);
        }
        ourFactories = ContainerUtil.createConcurrentWeakValueMap();
        NO_OBJECT_METHODS_FILTER = new CallbackFilter(){

            public int accept(Method method2) {
                if (FINALIZE_METHOD.equals(method2)) {
                    return 1;
                }
                if ((method2.getModifiers() & 0x400) != 0) {
                    return 0;
                }
                return 1;
            }
        };
        WITH_OBJECT_METHODS_FILTER = new CallbackFilter(){

            public int accept(Method method2) {
                if (FINALIZE_METHOD.equals(method2)) {
                    return 1;
                }
                if (HASHCODE_METHOD.equals(method2) || TOSTRING_METHOD.equals(method2) || EQUALS_METHOD.equals(method2)) {
                    return 0;
                }
                if ((method2.getModifiers() & 0x400) != 0) {
                    return 0;
                }
                return 1;
            }
        };
    }

    private static class ProxyDescription {
        private final Class mySuperClass;
        private final Class[] myInterfaces;

        public ProxyDescription(Class superClass, Class[] interfaces) {
            this.mySuperClass = superClass;
            this.myInterfaces = interfaces;
        }

        public String toString() {
            return this.mySuperClass + " " + (this.myInterfaces != null ? Arrays.asList(this.myInterfaces) : "");
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (o2 == null || this.getClass() != o2.getClass()) {
                return false;
            }
            ProxyDescription that = (ProxyDescription)o2;
            if (!Arrays.equals(this.myInterfaces, that.myInterfaces)) {
                return false;
            }
            return !(this.mySuperClass != null ? !this.mySuperClass.equals(that.mySuperClass) : that.mySuperClass != null);
        }

        public int hashCode() {
            int result2 = this.mySuperClass != null ? this.mySuperClass.hashCode() : 0;
            return result2;
        }
    }
}

