/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.actions;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.EnvironmentUtil;
import java.io.File;
import java.util.Map;
import org.intellij.images.ImagesBundle;
import org.intellij.images.fileTypes.ImageFileTypeManager;
import org.intellij.images.options.Options;
import org.intellij.images.options.OptionsManager;
import org.intellij.images.options.impl.ImagesConfigurable;

public final class EditExternallyAction
extends AnAction {
    public void actionPerformed(AnActionEvent e2) {
        Project project2 = (Project)e2.getData(CommonDataKeys.PROJECT);
        VirtualFile[] files2 = (VirtualFile[])e2.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        Options options = OptionsManager.getInstance().getOptions();
        String executablePath = options.getExternalEditorOptions().getExecutablePath();
        if (StringUtil.isEmpty((String)executablePath)) {
            Messages.showErrorDialog((Project)project2, (String)ImagesBundle.message("error.empty.external.editor.path", new Object[0]), (String)ImagesBundle.message("error.title.empty.external.editor.path", new Object[0]));
            ImagesConfigurable.show(project2);
        } else if (files2 != null) {
            String path;
            Map env = EnvironmentUtil.getEnvironmentMap();
            for (String varName : env.keySet()) {
                if (SystemInfo.isWindows) {
                    executablePath = StringUtil.replace((String)executablePath, (String)("%" + varName + "%"), (String)((String)env.get(varName)), (boolean)true);
                    continue;
                }
                executablePath = StringUtil.replace((String)executablePath, (String)("${" + varName + "}"), (String)((String)env.get(varName)), (boolean)false);
            }
            executablePath = FileUtil.toSystemDependentName((String)executablePath);
            File executable = new File(executablePath);
            GeneralCommandLine commandLine = new GeneralCommandLine();
            String string2 = path = executable.exists() ? executable.getAbsolutePath() : executablePath;
            if (SystemInfo.isMac) {
                commandLine.setExePath(ExecUtil.getOpenCommandPath());
                commandLine.addParameter("-a");
                commandLine.addParameter(path);
            } else {
                commandLine.setExePath(path);
            }
            ImageFileTypeManager typeManager = ImageFileTypeManager.getInstance();
            for (VirtualFile file2 : files2) {
                if (!file2.isInLocalFileSystem() || !typeManager.isImage(file2)) continue;
                commandLine.addParameter(VfsUtilCore.virtualToIoFile((VirtualFile)file2).getAbsolutePath());
            }
            commandLine.setWorkDirectory(new File(executablePath).getParentFile());
            try {
                commandLine.createProcess();
            }
            catch (ExecutionException ex) {
                Messages.showErrorDialog((Project)project2, (String)ex.getLocalizedMessage(), (String)ImagesBundle.message("error.title.launching.external.editor", new Object[0]));
                ImagesConfigurable.show(project2);
            }
        }
    }

    public void update(AnActionEvent e2) {
        super.update(e2);
        EditExternallyAction.doUpdate(e2);
    }

    static void doUpdate(AnActionEvent e2) {
        VirtualFile[] files2 = (VirtualFile[])e2.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        boolean isEnabled = EditExternallyAction.isImages(files2);
        if (e2.getPlace().equals("ProjectViewPopup")) {
            e2.getPresentation().setVisible(isEnabled);
        } else {
            e2.getPresentation().setEnabled(isEnabled);
        }
    }

    private static boolean isImages(VirtualFile[] files2) {
        boolean isImagesFound = false;
        if (files2 != null) {
            ImageFileTypeManager typeManager = ImageFileTypeManager.getInstance();
            for (VirtualFile file2 : files2) {
                boolean isImage = typeManager.isImage(file2);
                isImagesFound |= isImage;
                if (file2.isInLocalFileSystem() && isImage) continue;
                return false;
            }
        }
        return isImagesFound;
    }
}

