/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.editor.actions;

import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.intellij.images.editor.actions.SetBackgroundImageDialog;
import org.intellij.images.fileTypes.ImageFileTypeManager;

public class SetBackgroundImageAction
extends DumbAwareAction {
    public void update(AnActionEvent e2) {
        Project project2 = e2.getProject();
        VirtualFile file2 = (VirtualFile)e2.getData(CommonDataKeys.VIRTUAL_FILE);
        boolean image = file2 != null && ImageFileTypeManager.getInstance().isImage(file2);
        boolean visible = !ActionPlaces.isPopupPlace((String)e2.getPlace()) || image;
        e2.getPresentation().setEnabled(project2 != null);
        e2.getPresentation().setVisible(visible);
    }

    public void actionPerformed(AnActionEvent e2) {
        Project project2 = e2.getProject();
        if (project2 == null) {
            return;
        }
        VirtualFile file2 = (VirtualFile)e2.getData(CommonDataKeys.VIRTUAL_FILE);
        boolean image = file2 != null && ImageFileTypeManager.getInstance().isImage(file2);
        SetBackgroundImageDialog dialog2 = new SetBackgroundImageDialog(project2, image ? file2.getPath() : null);
        dialog2.showAndGet();
    }
}

