/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.editor.impl;

import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.TransferableFileEditorState;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class ImageFileEditorState
implements TransferableFileEditorState,
Serializable {
    private static final long serialVersionUID = -4470317464706072486L;
    public static final String IMAGE_EDITOR_ID = "ImageEditor";
    public static final String BACKGROUND_VISIBLE_OPTION = "backgroundVisible";
    public static final String GRID_VISIBLE_OPTION = "gridVisible";
    public static final String ZOOM_FACTOR_OPTION = "zoomFactor";
    private boolean backgroundVisible;
    private boolean gridVisible;
    private double zoomFactor;

    ImageFileEditorState(boolean backgroundVisible, boolean gridVisible, double zoomFactor) {
        this.backgroundVisible = backgroundVisible;
        this.gridVisible = gridVisible;
        this.zoomFactor = zoomFactor;
    }

    public boolean canBeMergedWith(FileEditorState otherState, FileEditorStateLevel level) {
        return otherState instanceof ImageFileEditorState;
    }

    public boolean isBackgroundVisible() {
        return this.backgroundVisible;
    }

    public boolean isGridVisible() {
        return this.gridVisible;
    }

    public double getZoomFactor() {
        return this.zoomFactor;
    }

    public String getEditorId() {
        return IMAGE_EDITOR_ID;
    }

    public Map<String, String> getTransferableOptions() {
        HashMap<String, String> map2 = new HashMap<String, String>();
        map2.put(BACKGROUND_VISIBLE_OPTION, String.valueOf(this.backgroundVisible));
        map2.put(GRID_VISIBLE_OPTION, String.valueOf(this.gridVisible));
        map2.put(ZOOM_FACTOR_OPTION, String.valueOf(this.zoomFactor));
        return map2;
    }

    public void setTransferableOptions(Map<String, String> options) {
        String o2 = options.get(BACKGROUND_VISIBLE_OPTION);
        if (o2 != null) {
            this.backgroundVisible = Boolean.valueOf(o2);
        }
        if ((o2 = options.get(GRID_VISIBLE_OPTION)) != null) {
            this.gridVisible = Boolean.valueOf(o2);
        }
        if ((o2 = options.get(ZOOM_FACTOR_OPTION)) != null) {
            this.zoomFactor = Double.parseDouble(o2);
        }
    }
}

