/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.statistics;

import com.intellij.internal.statistic.AbstractApplicationUsagesCollector;
import com.intellij.internal.statistic.CollectUsagesException;
import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.impl.IdeBackgroundUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class BackgroundImagesUsageCollector
extends AbstractApplicationUsagesCollector {
    @Override
    @NotNull
    public GroupDescriptor getGroupId() {
        GroupDescriptor groupDescriptor = GroupDescriptor.create("images.ide.background");
        if (groupDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/images/statistics/BackgroundImagesUsageCollector", "getGroupId"));
        }
        return groupDescriptor;
    }

    @Override
    @NotNull
    public Set<UsageDescriptor> getUsages() throws CollectUsagesException {
        HashMap map2 = ContainerUtil.newHashMap();
        for (UsageDescriptor descriptor2 : super.getUsages()) {
            String key = descriptor2.getKey();
            int idx = key.indexOf(32);
            key = idx > 0 ? key.substring(0, idx) : key;
            UsageDescriptor existing = (UsageDescriptor)map2.get(key);
            if (existing != null && existing.getValue() != 0) continue;
            map2.put(key, new UsageDescriptor(key, descriptor2.getValue()));
        }
        HashSet hashSet = ContainerUtil.newHashSet(map2.values());
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/images/statistics/BackgroundImagesUsageCollector", "getUsages"));
        }
        return hashSet;
    }

    @Override
    @NotNull
    public Set<UsageDescriptor> getProjectUsages(@NotNull Project project2) throws CollectUsagesException {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/intellij/images/statistics/BackgroundImagesUsageCollector", "getProjectUsages"));
        }
        boolean editor = StringUtil.isNotEmpty((String)IdeBackgroundUtil.getBackgroundSpec(project2, "idea.background.editor"));
        boolean frame = StringUtil.isNotEmpty((String)IdeBackgroundUtil.getBackgroundSpec(project2, "idea.background.frame"));
        HashSet hashSet = ContainerUtil.newHashSet((Object[])new UsageDescriptor[]{new UsageDescriptor("editor", editor ? 1 : 0), new UsageDescriptor("frame", frame ? 1 : 0)});
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/images/statistics/BackgroundImagesUsageCollector", "getProjectUsages"));
        }
        return hashSet;
    }
}

